<style>
    <?php
        $settings = \App\Models\GeneralSetting::first();
        $themeConfig = $settings->theme_config ?? [];
        $activeTheme = $settings->theme ?? 'default';
        
        // Helper to get color safely (check if exists to prevent redeclaration)
        if (!function_exists('getThemeColor')) {
            function getThemeColor($config, $key, $default) {
                return $config[$key] ?? $default;
            }
        }

        // Define defaults for each theme (must match Controller)
        $defaultColors = [
            'default' => ['primary' => '#ea580c', 'primary_hover' => '#c2410c', 'primary_light' => '#fff7ed'],
            'classic' => ['primary' => '#2563eb', 'primary_hover' => '#1d4ed8', 'primary_light' => '#eff6ff'],
            'modern'  => ['primary' => '#059669', 'primary_hover' => '#047857', 'primary_light' => '#ecfdf5'],
            'dark'    => ['primary' => '#1f2937', 'primary_hover' => '#000000', 'primary_light' => '#374151'],
        ];

        // Get config for current active theme or fallback to defaults
        $currentThemeConfig = $themeConfig[$activeTheme] ?? $defaultColors[$activeTheme] ?? $defaultColors['default'];
        
        // Also get configs for other themes to support class-based overrides if needed (though we mostly use active theme)
        $defaultConfig = $themeConfig['default'] ?? $defaultColors['default'];
        $classicConfig = $themeConfig['classic'] ?? $defaultColors['classic'];
        $modernConfig = $themeConfig['modern'] ?? $defaultColors['modern'];
        $darkConfig = $themeConfig['dark'] ?? $defaultColors['dark'];
    ?>

    :root {
        /* Default Theme (Dynamic) */
        --theme-primary: <?php echo e(getThemeColor($defaultConfig, 'primary', '#ea580c')); ?>;
        --theme-primary-hover: <?php echo e(getThemeColor($defaultConfig, 'primary_hover', '#c2410c')); ?>;
        --theme-primary-light: <?php echo e(getThemeColor($defaultConfig, 'primary_light', '#fff7ed')); ?>;
        --theme-text-on-primary: #ffffff;
        --theme-bg-body: #f9fafb; /* gray-50 */
        --theme-text-body: #111827; /* gray-900 */
        --theme-border: #f3f4f6; /* gray-100 */
    }
    
    /* Classic Theme */
    .theme-classic {
        --theme-primary: <?php echo e(getThemeColor($classicConfig, 'primary', '#2563eb')); ?>;
        --theme-primary-hover: <?php echo e(getThemeColor($classicConfig, 'primary_hover', '#1d4ed8')); ?>;
        --theme-primary-light: <?php echo e(getThemeColor($classicConfig, 'primary_light', '#eff6ff')); ?>;
    }
    
    /* Modern Theme */
    .theme-modern {
        --theme-primary: <?php echo e(getThemeColor($modernConfig, 'primary', '#059669')); ?>;
        --theme-primary-hover: <?php echo e(getThemeColor($modernConfig, 'primary_hover', '#047857')); ?>;
        --theme-primary-light: <?php echo e(getThemeColor($modernConfig, 'primary_light', '#ecfdf5')); ?>;
    }
    
    /* Dark Theme */
    .theme-dark {
        --theme-primary: <?php echo e(getThemeColor($darkConfig, 'primary', '#1f2937')); ?>;
        --theme-primary-hover: <?php echo e(getThemeColor($darkConfig, 'primary_hover', '#000000')); ?>;
        --theme-primary-light: <?php echo e(getThemeColor($darkConfig, 'primary_light', '#374151')); ?>;
        --theme-bg-body: #111827; /* gray-900 */
        --theme-text-body: #f3f4f6; /* gray-100 */
        --theme-border: #374151; /* gray-700 */
    }

    /* Helper Utility Classes */
    .bg-theme-primary { background-color: var(--theme-primary) !important; }
    .hover\:bg-theme-primary:hover { background-color: var(--theme-primary-hover) !important; }
    .bg-theme-primary-light { background-color: var(--theme-primary-light) !important; }
    .hover\:bg-theme-primary-light:hover { background-color: var(--theme-primary-light) !important; }
    
    .text-theme-primary { color: var(--theme-primary) !important; }
    .hover\:text-theme-primary:hover { color: var(--theme-primary-hover) !important; }
    
    .border-theme-primary { border-color: var(--theme-primary) !important; }
    .hover\:border-theme-primary:hover { border-color: var(--theme-primary-hover) !important; }
    .border-theme-primary-light { border-color: var(--theme-primary-light) !important; }
    .focus\:border-theme-primary:focus { border-color: var(--theme-primary) !important; }
    .focus\:ring-theme-primary:focus { --tw-ring-color: var(--theme-primary) !important; }
    .accent-theme-primary { accent-color: var(--theme-primary) !important; }

    .group-hover\:text-theme-primary:hover .group-hover\:text-theme-primary-target,
    .group:hover .group-hover\:text-theme-primary { color: var(--theme-primary) !important; }
    
    .group-hover\:bg-theme-primary-light:hover .group-hover\:bg-theme-primary-light-target,
    .group:hover .group-hover\:bg-theme-primary-light { background-color: var(--theme-primary-light) !important; }
    
    .group-hover\:border-theme-primary-light:hover .group-hover\:border-theme-primary-light-target,
    .group:hover .group-hover\:border-theme-primary-light { border-color: var(--theme-primary-light) !important; }

    .placeholder-theme-primary::placeholder { color: var(--theme-primary) !important; opacity: 0.6; }

    /* Body Background override for dark mode */
    body.theme-dark {
        background-color: var(--theme-bg-body) !important;
        color: var(--theme-text-body) !important;
    }
    body.theme-dark .bg-white {
        background-color: #1f2937 !important;
        color: #f3f4f6 !important;
    }
    body.theme-dark .text-gray-900 {
        color: #f3f4f6 !important;
    }
    body.theme-dark .text-black {
        color: #ffffff !important;
    }
    body.theme-dark .border-gray-100, body.theme-dark .border-gray-200, body.theme-dark .border-gray-300 {
        border-color: #374151 !important;
    }
    body.theme-dark .bg-gray-50 {
        background-color: #111827 !important; /* gray-900 */
    }
    body.theme-dark .bg-gray-100 {
        background-color: #1f2937 !important; /* gray-800 */
    }
</style><?php /**PATH C:\Users\shoyi\OneDrive\Desktop\ecoomerce\resources\views/partials/theme-style.blade.php ENDPATH**/ ?>