<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\BrandController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\LandingPageController;
use App\Http\Controllers\Admin\ApiController;
use App\Http\Controllers\Admin\PixelController;
use App\Http\Controllers\Admin\BannerController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Frontend\CartController;
use App\Http\Controllers\Frontend\CheckoutController;
use App\Http\Controllers\Frontend\ProductController as FrontendProductController;
use App\Http\Controllers\Frontend\LandingPageController as FrontendLandingPageController;
use App\Http\Controllers\Auth\SocialLoginController;
use App\Http\Controllers\VoiceController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Frontend Routes
Route::get('/fix-storage-link', function () {
    $target = storage_path('app/public');
    $shortcut = public_path('storage');
    
    $output = "Target: $target<br>Shortcut: $shortcut<br><br>";

    // Check if it exists and remove it
    if (file_exists($shortcut) || is_link($shortcut)) {
        $output .= "Shortcut found. Attempting to remove...<br>";
        
        if (is_link($shortcut)) {
            // It's a symlink, just unlink it
            unlink($shortcut);
            $output .= "Existing symlink deleted.<br>";
        } elseif (is_dir($shortcut)) {
            // It's a real directory! This blocks the symlink.
            // Rename it to backup
            $backup = public_path('storage_backup_' . time());
            rename($shortcut, $backup);
            $output .= "Existing directory found! Renamed to: " . basename($backup) . "<br>";
        } else {
            // Some other file
            unlink($shortcut);
            $output .= "Existing file deleted.<br>";
        }
    }
    
    // Create new symlink
    try {
        symlink($target, $shortcut);
        $output .= "<strong style='color:green'>SUCCESS: Storage link created successfully!</strong>";
    } catch (\Exception $e) {
        $output .= "<strong style='color:red'>ERROR: Failed to create storage link: " . $e->getMessage() . "</strong>";
    }
    
    return $output;
});
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/order-tracking', [App\Http\Controllers\Frontend\OrderTrackingController::class, 'index'])->name('order.tracking');
Route::post('/order-tracking', [App\Http\Controllers\Frontend\OrderTrackingController::class, 'track'])->name('order.track');
Route::get('/search-suggestions', [FrontendProductController::class, 'searchSuggestions'])->name('search.suggestions');
Route::get('/shop', [FrontendProductController::class, 'index'])->name('shop');
Route::get('/contact', [HomeController::class, 'contact'])->name('contact.index');
Route::get('/product/{slug}', [FrontendProductController::class, 'show'])->name('product.show');
Route::get('/category/{slug}', [FrontendProductController::class, 'category'])->name('category.show');
Route::get('/brand/{slug}', [FrontendProductController::class, 'brand'])->name('brand.show');
Route::get('/page/{slug}', [HomeController::class, 'page'])->name('page.show');

// Social Login
Route::get('auth/google', [SocialLoginController::class, 'redirectToGoogle'])->name('auth.google');
Route::get('auth/google/callback', [SocialLoginController::class, 'handleGoogleCallback']);
Route::get('auth/facebook', [SocialLoginController::class, 'redirectToFacebook'])->name('auth.facebook');
Route::get('auth/facebook/callback', [SocialLoginController::class, 'handleFacebookCallback']);

// Cart Routes
Route::get('/cart', [CartController::class, 'index'])->name('cart.index');
Route::post('/cart/add', [CartController::class, 'store'])->name('cart.add');
Route::post('/cart/update', [CartController::class, 'update'])->name('cart.update');
Route::delete('/cart/{id}', [CartController::class, 'destroy'])->name('cart.destroy');
Route::post('/cart/apply-coupon', [CartController::class, 'applyCoupon'])->name('cart.coupon');

// Checkout Routes
Route::get('/checkout', [CheckoutController::class, 'index'])->name('checkout.index');
Route::post('/checkout', [CheckoutController::class, 'store'])->name('checkout.store');
Route::post('/checkout/incomplete', [CheckoutController::class, 'storeIncomplete'])->name('checkout.storeIncomplete');
Route::get('/checkout/success/{order}', [CheckoutController::class, 'success'])->name('checkout.success');
Route::post('/checkout/apply-coupon', [CheckoutController::class, 'applyCoupon'])->name('checkout.coupon');
Route::post('/checkout/calculate-shipping', [CheckoutController::class, 'calculateShipping'])->name('checkout.calculate_shipping');

// Admin Routes
Route::middleware(['auth', 'verified'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Admin Profile
    Route::get('/profile', [\App\Http\Controllers\Admin\ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [\App\Http\Controllers\Admin\ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [\App\Http\Controllers\Admin\ProfileController::class, 'destroy'])->name('profile.destroy');

    // Products
    Route::get('products/search', [ProductController::class, 'search'])->name('products.search');
    Route::resource('products', ProductController::class);
    Route::post('products/bulk-action', [ProductController::class, 'bulkAction'])->name('products.bulk_action');
    Route::post('products/{id}/duplicate', [ProductController::class, 'duplicate'])->name('products.duplicate');
    
    // Categories & Brands
    Route::resource('categories', CategoryController::class);
    Route::resource('brands', BrandController::class);

    // Orders
    Route::resource('orders', OrderController::class);
    Route::get('orders/print/{id}', [OrderController::class, 'print'])->name('orders.print');
    Route::get('orders/invoice/{id}', [OrderController::class, 'invoice'])->name('orders.invoice');
    
    // Custom Order Routes
    Route::get('orders/status/{status}', [OrderController::class, 'byStatus'])->name('orders.status');
    Route::post('orders/{id}/status', [OrderController::class, 'updateStatus'])->name('orders.update_status');
    Route::post('orders/{id}/payment-status', [OrderController::class, 'updatePaymentStatus'])->name('orders.update_payment_status');
    Route::get('orders/{id}/send-to-courier', [ApiController::class, 'sendOrderToCourier'])->name('orders.send_to_courier');
    
    Route::get('orders', [OrderController::class, 'index'])->name('orders.index');
    Route::get('orders/{id}', [OrderController::class, 'show'])->name('orders.show');
    Route::put('orders/{id}', [OrderController::class, 'update'])->name('orders.update');
    Route::patch('orders/{id}/status', [OrderController::class, 'updateStatus'])->name('orders.update_status');
    Route::post('orders/{id}/send-to-steadfast', [ApiController::class, 'sendOrderToSteadfast'])->name('orders.send_to_steadfast');
    Route::post('orders/bulk-action', [ApiController::class, 'bulkAction'])->name('orders.bulk_action');
    Route::get('orders/{id}/check-courier-status', [ApiController::class, 'checkCourierStatus'])->name('orders.check_courier_status');
    Route::delete('orders/{id}', [OrderController::class, 'destroy'])->name('orders.destroy');

    // Users
    Route::resource('users', UserController::class);
    Route::get('customers', [UserController::class, 'customers'])->name('users.customers');

    // Roles & Permissions
    Route::resource('roles', RoleController::class);
    Route::get('permissions', [PermissionController::class, 'index'])->name('permissions.index');

    // Settings
    Route::get('settings/general', [SettingController::class, 'general'])->name('settings.general');
    Route::get('settings/shipping', [SettingController::class, 'shipping'])->name('settings.shipping');
    Route::post('settings/shipping', [SettingController::class, 'updateShipping'])->name('settings.shipping.update');
    
    // Shipping Charges
    Route::post('settings/shipping-charges', [\App\Http\Controllers\Admin\ShippingChargeController::class, 'store'])->name('settings.shipping_charge.store');
    Route::put('settings/shipping-charges/{id}', [\App\Http\Controllers\Admin\ShippingChargeController::class, 'update'])->name('settings.shipping_charge.update');
    Route::delete('settings/shipping-charges/{id}', [\App\Http\Controllers\Admin\ShippingChargeController::class, 'destroy'])->name('settings.shipping_charge.destroy');
    Route::post('settings/shipping-charges/{id}/status', [\App\Http\Controllers\Admin\ShippingChargeController::class, 'toggleStatus'])->name('settings.shipping_charge.status');

    Route::get('settings/pixels', [SettingController::class, 'pixels'])->name('settings.pixels');
    Route::get('settings/social', [\App\Http\Controllers\Admin\SocialMediaController::class, 'index'])->name('settings.social');
    Route::post('settings/social', [\App\Http\Controllers\Admin\SocialMediaController::class, 'store'])->name('settings.social.store');
    Route::put('settings/social/{id}', [\App\Http\Controllers\Admin\SocialMediaController::class, 'update'])->name('settings.social.update');
    Route::delete('settings/social/{id}', [\App\Http\Controllers\Admin\SocialMediaController::class, 'destroy'])->name('settings.social.destroy');
    Route::post('settings/social/{id}/status', [\App\Http\Controllers\Admin\SocialMediaController::class, 'toggleStatus'])->name('settings.social.status');

    // Contact Settings
    Route::get('settings/contact', [\App\Http\Controllers\Admin\ContactSettingController::class, 'index'])->name('settings.contact');
    Route::get('settings/contact/create', [\App\Http\Controllers\Admin\ContactSettingController::class, 'create'])->name('settings.contact.create');
    Route::post('settings/contact', [\App\Http\Controllers\Admin\ContactSettingController::class, 'store'])->name('settings.contact.store');
    Route::get('settings/contact/{id}/edit', [\App\Http\Controllers\Admin\ContactSettingController::class, 'edit'])->name('settings.contact.edit');
    Route::put('settings/contact/{id}', [\App\Http\Controllers\Admin\ContactSettingController::class, 'update'])->name('settings.contact.update');
    Route::delete('settings/contact/{id}', [\App\Http\Controllers\Admin\ContactSettingController::class, 'destroy'])->name('settings.contact.destroy');
    Route::post('settings/contact/{id}/status', [\App\Http\Controllers\Admin\ContactSettingController::class, 'toggleStatus'])->name('settings.contact.status');

    Route::get('settings/order-status', [SettingController::class, 'orderStatus'])->name('settings.order_status');
    Route::get('settings/themes', [\App\Http\Controllers\Admin\ThemeController::class, 'index'])->name('settings.themes.index');
    Route::post('settings/themes/activate', [\App\Http\Controllers\Admin\ThemeController::class, 'activate'])->name('settings.themes.activate');
    Route::get('settings/themes/{theme}/edit', [\App\Http\Controllers\Admin\ThemeController::class, 'edit'])->name('settings.themes.edit');
    Route::put('settings/themes/{theme}', [\App\Http\Controllers\Admin\ThemeController::class, 'update'])->name('settings.themes.update');
    Route::post('settings', [SettingController::class, 'update'])->name('settings.update');

    // Create Page
    Route::resource('pages', PageController::class);

    // Landing Pages
    Route::get('landing-pages/create', [LandingPageController::class, 'create'])->name('landing-pages.create');
    Route::get('landing-pages/campaign', [LandingPageController::class, 'campaign'])->name('landing-pages.campaign');
    Route::get('landing-pages/{id}/builder', [LandingPageController::class, 'builder'])->name('landing-pages.builder');
    Route::post('landing-pages/{id}/builder', [LandingPageController::class, 'updateContent'])->name('landing-pages.builder.update');
    Route::resource('landing-pages', LandingPageController::class)->except(['create']);

    // API Integration
    Route::get('api/payment', [ApiController::class, 'payment'])->name('api.payment');
    Route::post('api/payment', [ApiController::class, 'updatePayment'])->name('api.payment.update');
    Route::get('api/sms', [ApiController::class, 'sms'])->name('api.sms');
    Route::post('api/sms', [ApiController::class, 'updateSms'])->name('api.sms.update');
    Route::post('api/sms/test', [ApiController::class, 'testSms'])->name('api.sms.test');
    Route::get('api/sms/balance', [ApiController::class, 'checkSmsBalance'])->name('api.sms.balance');
    Route::get('api/courier', [ApiController::class, 'courier'])->name('api.courier');
    Route::post('api/courier', [ApiController::class, 'updateCourier'])->name('api.courier.update');
    Route::get('api/fraud', [ApiController::class, 'fraud'])->name('api.fraud');
    Route::post('api/fraud', [ApiController::class, 'updateFraud'])->name('api.fraud.update');
    Route::post('api/fraud/check', [ApiController::class, 'checkFraud'])->name('api.fraud.check');
    Route::post('api/fraud/check-json', [ApiController::class, 'checkFraudJson'])->name('api.fraud.check.json');
    Route::get('api/auto-call', [ApiController::class, 'autoCall'])->name('api.auto_call');
    Route::post('api/auto-call', [ApiController::class, 'updateAutoCall'])->name('api.auto_call.update');
    Route::post('api/auto-call/test', [ApiController::class, 'testAutoCall'])->name('api.auto_call.test');

    // G. Pixel and GTM
    Route::get('pixels/tag-manager', [PixelController::class, 'tagManager'])->name('pixels.tag_manager');
    Route::post('pixels/tag-manager', [PixelController::class, 'storeGtm'])->name('pixels.store_gtm');
    Route::delete('pixels/tag-manager', [PixelController::class, 'destroyGtm'])->name('pixels.destroy_gtm');
    
    // TikTok Pixel & CAPI
    Route::get('pixels/tiktok', [PixelController::class, 'tiktok'])->name('pixels.tiktok');
    Route::post('pixels/tiktok', [PixelController::class, 'storeTiktok'])->name('pixels.store_tiktok');
    Route::delete('pixels/tiktok', [PixelController::class, 'destroyTiktok'])->name('pixels.destroy_tiktok');

    Route::get('pixels/verification', [PixelController::class, 'verification'])->name('pixels.verification');
    Route::post('pixels/verification', [PixelController::class, 'storeVerification'])->name('pixels.store_verification');
    Route::get('pixels/manage', [PixelController::class, 'index'])->name('pixels.index');
    Route::get('pixels/logs', [PixelController::class, 'logs'])->name('pixels.logs');
    Route::delete('pixels/logs', [PixelController::class, 'clearLogs'])->name('pixels.logs.clear');
    Route::post('pixels/store', [PixelController::class, 'store'])->name('pixels.store');
    Route::delete('pixels/destroy', [PixelController::class, 'destroy'])->name('pixels.destroy');

    // Banner & Ads
    Route::get('banners/category', [BannerController::class, 'category'])->name('banners.category');
    Route::post('banners/category/store', [BannerController::class, 'storeCategory'])->name('banners.category.store');
    Route::delete('banners/category/destroy', [BannerController::class, 'destroyCategory'])->name('banners.category.destroy');
    Route::resource('banners', BannerController::class);

    // Reports
    Route::get('reports/sales', [ReportController::class, 'sales'])->name('reports.sales');
    Route::get('reports/orders', [ReportController::class, 'orders'])->name('reports.orders');
});

Route::middleware('auth')->group(function () {
    Route::get('/dashboard', [\App\Http\Controllers\Frontend\DashboardController::class, 'index'])->name('dashboard');
    Route::get('/user/orders/{id}', [\App\Http\Controllers\Frontend\DashboardController::class, 'orderDetails'])->name('order.view');
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});


require __DIR__.'/auth.php';


// Frontend Landing Page Routes (Catch-all)
// Voice Call Webhooks (Twilio)
Route::post('/voice/start/{order}', [VoiceController::class, 'start'])->name('voice.start');
Route::post('/voice/input/{order}', [VoiceController::class, 'input'])->name('voice.input');
Route::post('/voice/status', [VoiceController::class, 'status'])->name('voice.status');

Route::get('/{prefix}/{suffix}/{slug}', [\App\Http\Controllers\Frontend\LandingPageController::class, 'showWithPrefixAndSuffix'])
    ->where(['prefix' => '[a-zA-Z0-9-]+', 'suffix' => '[a-zA-Z0-9-]+', 'slug' => '[a-zA-Z0-9-]+'])
    ->name('landing.show.complex');

Route::get('/{prefix}/{slug}', [\App\Http\Controllers\Frontend\LandingPageController::class, 'showWithPrefix'])
    ->where(['prefix' => '[a-zA-Z0-9-]+', 'slug' => '[a-zA-Z0-9-]+'])
    ->name('landing.show.prefix');

Route::get('/{slug}', [\App\Http\Controllers\Frontend\LandingPageController::class, 'show'])
    ->where('slug', '[a-zA-Z0-9-]+')
    ->name('landing.show');
