<x-guest-layout>
    <!-- Logo Section (Optional for Register, but keeping consistent spacing) -->
    <div class="text-center mb-6">
        <a href="/" class="inline-block transform hover:scale-105 transition-transform duration-300">
             @if(isset($generalSetting) && $generalSetting->logo)
                <img src="{{ asset($generalSetting->logo) }}" alt="{{ $generalSetting->site_name }}" class="h-12 mx-auto object-contain drop-shadow-sm">
            @else
                <span class="text-2xl font-heading font-bold text-gray-900">{{ $generalSetting->site_name ?? config('app.name') }}</span>
            @endif
        </a>
    </div>

    <div class="bg-white rounded-3xl shadow-xl shadow-gray-200/50 p-8 sm:p-10 border border-gray-100 backdrop-blur-xl bg-opacity-90">
        <div class="mb-8 text-center">
            <h3 class="text-2xl font-heading font-bold text-gray-900">অ্যাকাউন্ট তৈরি করুন</h3>
            <p class="text-sm text-gray-500 mt-2">আমাদের এক্সক্লুসিভ কমিউনিটিতে যোগ দিন</p>
        </div>

        <form method="POST" action="{{ route('register') }}" class="space-y-5">
            @csrf

            <!-- Name -->
            <div>
                <x-input-label for="name" :value="__('নাম')" class="text-gray-700 font-medium" />
                <x-text-input id="name" class="block mt-1 w-full rounded-xl" type="text" name="name" :value="old('name')" required autofocus autocomplete="name" placeholder="আপনার নাম" />
                <x-input-error :messages="$errors->get('name')" class="mt-2" />
            </div>

            <!-- Email Address -->
            <div>
                <x-input-label for="email" :value="__('ইমেইল')" class="text-gray-700 font-medium" />
                <x-text-input id="email" class="block mt-1 w-full rounded-xl" type="email" name="email" :value="old('email')" required autocomplete="username" placeholder="name@example.com" />
                <x-input-error :messages="$errors->get('email')" class="mt-2" />
            </div>

            <!-- Password -->
            <div>
                <x-input-label for="password" :value="__('পাসওয়ার্ড')" class="text-gray-700 font-medium" />

                <x-text-input id="password" class="block mt-1 w-full rounded-xl"
                                type="password"
                                name="password"
                                required autocomplete="new-password" 
                                placeholder="••••••••" />

                <x-input-error :messages="$errors->get('password')" class="mt-2" />
            </div>

            <!-- Confirm Password -->
            <div>
                <x-input-label for="password_confirmation" :value="__('পাসওয়ার্ড নিশ্চিত করুন')" class="text-gray-700 font-medium" />

                <x-text-input id="password_confirmation" class="block mt-1 w-full rounded-xl"
                                type="password"
                                name="password_confirmation" required autocomplete="new-password" 
                                placeholder="••••••••" />

                <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
            </div>

            <div class="mt-8">
                <x-primary-button class="w-full justify-center py-3.5 rounded-xl text-sm uppercase tracking-wider">
                    {{ __('রেজিস্টার করুন') }}
                </x-primary-button>
                
                <p class="mt-6 text-center text-sm text-gray-500">
                    ইতিমধ্যে অ্যাকাউন্ট আছে? 
                    <a href="{{ route('login') }}" class="text-orange-600 font-bold hover:underline hover:text-orange-700 ml-1 transition-colors">লগইন করুন</a>
                </p>
            </div>
        </form>
    </div>
</x-guest-layout>