<x-guest-layout>
    <!-- Logo Section -->
    <div class="text-center">
        <a href="/" class="inline-block mb-2 transform hover:scale-105 transition-transform duration-300">
            @if($generalSetting->logo)
                <img src="{{ asset($generalSetting->logo) }}" alt="{{ $generalSetting->site_name }}" class="h-16 mx-auto object-contain drop-shadow-sm">
            @else
                <span class="text-3xl font-heading font-bold text-gray-900">{{ $generalSetting->site_name }}</span>
            @endif
        </a>
        <h2 class="mt-6 text-3xl font-heading font-bold text-gray-900 tracking-tight">
            স্বাগতম! 👋
        </h2>
        <p class="mt-2 text-sm text-gray-600 font-sans">
            আপনার অ্যাকাউন্টে লগইন করুন
        </p>
    </div>

    <div class="bg-white rounded-3xl shadow-xl shadow-gray-200/50 p-8 sm:p-10 border border-gray-100 backdrop-blur-xl bg-opacity-90">
        <!-- Session Status -->
        <x-auth-session-status class="mb-6" :status="session('status')" />

        <!-- Validation Errors -->
        <x-auth-validation-errors class="mb-6" :errors="$errors" />

        <form method="POST" action="{{ route('login') }}" class="space-y-6">
            @csrf

            <!-- Email Address -->
            <div class="group">
                <label for="email" class="block text-sm font-bold text-gray-700 mb-2 font-heading">ইমেইল এড্রেস</label>
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                        <svg class="h-5 w-5 text-gray-400 group-focus-within:text-orange-600 transition-colors duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"></path></svg>
                    </div>
                    <input id="email" type="email" name="email" value="{{ old('email') }}" required autofocus 
                        class="block w-full pl-11 pr-4 py-3.5 bg-gray-50 border border-gray-200 text-gray-900 text-sm rounded-xl focus:ring-2 focus:ring-orange-500/20 focus:border-orange-600 transition-all duration-200 hover:bg-white placeholder-gray-400" 
                        placeholder="name@example.com">
                </div>
            </div>

            <!-- Password -->
            <div class="group">
                <label for="password" class="block text-sm font-bold text-gray-700 mb-2 font-heading">পাসওয়ার্ড</label>
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                        <svg class="h-5 w-5 text-gray-400 group-focus-within:text-orange-600 transition-colors duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path></svg>
                    </div>
                    <input id="password" type="password" name="password" required autocomplete="current-password"
                        class="block w-full pl-11 pr-4 py-3.5 bg-gray-50 border border-gray-200 text-gray-900 text-sm rounded-xl focus:ring-2 focus:ring-orange-500/20 focus:border-orange-600 transition-all duration-200 hover:bg-white placeholder-gray-400"
                        placeholder="••••••••">
                </div>
            </div>

            <!-- Remember Me & Forgot Password -->
            <div class="flex items-center justify-between">
                <label for="remember_me" class="flex items-center space-x-2 cursor-pointer group">
                    <input id="remember_me" type="checkbox" name="remember" class="w-4 h-4 rounded border-gray-300 text-orange-600 focus:ring-orange-600 cursor-pointer transition-colors">
                    <span class="text-sm text-gray-600 group-hover:text-gray-900 transition-colors">মনে রাখুন</span>
                </label>

                @if (Route::has('password.request'))
                    <a class="text-sm font-bold text-orange-600 hover:text-orange-700 transition-colors" href="{{ route('password.request') }}">
                        পাসওয়ার্ড ভুলে গেছেন?
                    </a>
                @endif
            </div>

            <!-- Submit Button -->
            <button type="submit" class="w-full bg-gray-900 hover:bg-orange-600 text-white font-bold py-4 rounded-xl shadow-lg shadow-gray-900/10 hover:shadow-orange-600/30 transform transition-all duration-300 hover:-translate-y-1 focus:ring-2 focus:ring-offset-2 focus:ring-orange-600 uppercase tracking-wider text-sm">
                লগইন করুন
            </button>
        </form>
        
        <!-- Register Link -->
        <div class="mt-8 pt-6 border-t border-gray-100 text-center">
            <p class="text-sm text-gray-600">
                কোনো অ্যাকাউন্ট নেই? 
                <a href="{{ route('register') }}" class="font-bold text-orange-600 hover:text-orange-700 transition-colors ml-1">
                    নতুন অ্যাকাউন্ট তৈরি করুন
                </a>
            </p>
        </div>
    </div>

    <!-- Footer Links -->
    <div class="text-center space-x-6 text-sm text-gray-500">
        <a href="#" class="hover:text-gray-900 transition-colors">শর্তাবলী</a>
        <a href="#" class="hover:text-gray-900 transition-colors">প্রাইভেসি পলিসি</a>
        <a href="#" class="hover:text-gray-900 transition-colors">সাহায্য</a>
    </div>
</x-guest-layout>