<x-guest-layout>
    <!-- Logo Section -->
    <div class="text-center mb-6">
        <a href="/" class="inline-block transform hover:scale-105 transition-transform duration-300">
             @if(isset($generalSetting) && $generalSetting->logo)
                <img src="{{ asset($generalSetting->logo) }}" alt="{{ $generalSetting->site_name }}" class="h-12 mx-auto object-contain drop-shadow-sm">
            @else
                <span class="text-2xl font-heading font-bold text-gray-900">{{ $generalSetting->site_name ?? config('app.name') }}</span>
            @endif
        </a>
    </div>

    <div class="bg-white rounded-3xl shadow-xl shadow-gray-200/50 p-8 sm:p-10 border border-gray-100 backdrop-blur-xl bg-opacity-90">
        <div class="mb-8 text-center">
            <h3 class="text-2xl font-heading font-bold text-gray-900">পাসওয়ার্ড ভুলে গেছেন?</h3>
            <p class="text-sm text-gray-500 mt-2">কোন সমস্যা নেই। শুধু আপনার ইমেইল ঠিকানা দিন।</p>
        </div>

        <div class="mb-6 text-sm text-gray-600 bg-gray-50 p-4 rounded-xl border border-gray-100">
            {{ __('আপনার পাসওয়ার্ড ভুলে গেছেন? সমস্যা নেই। শুধু আমাদের আপনার ইমেইল ঠিকানা জানান এবং আমরা আপনাকে একটি পাসওয়ার্ড রিসেট লিঙ্ক ইমেল করব যা আপনাকে একটি নতুন বেছে নেওয়ার অনুমতি দেবে।') }}
        </div>

        <!-- Session Status -->
        <x-auth-session-status class="mb-4" :status="session('status')" />

        <form method="POST" action="{{ route('password.email') }}" class="space-y-5">
            @csrf

            <!-- Email Address -->
            <div>
                <x-input-label for="email" :value="__('ইমেইল')" class="text-gray-700 font-medium" />
                <x-text-input id="email" class="block mt-1 w-full rounded-xl" type="email" name="email" :value="old('email')" required autofocus placeholder="name@example.com" />
                <x-input-error :messages="$errors->get('email')" class="mt-2" />
            </div>

            <div class="mt-6">
                <x-primary-button class="w-full justify-center py-3.5 rounded-xl text-sm uppercase tracking-wider">
                    {{ __('পাসওয়ার্ড রিসেট লিঙ্ক পাঠান') }}
                </x-primary-button>
                
                <p class="mt-6 text-center text-sm text-gray-500">
                    পাসওয়ার্ড মনে আছে? 
                    <a href="{{ route('login') }}" class="text-orange-600 font-bold hover:underline hover:text-orange-700 ml-1 transition-colors">লগইন করুন</a>
                </p>
            </div>
        </form>
    </div>
</x-guest-layout>
