<section>
    <header>
        <h2 class="text-lg font-heading font-bold text-gray-900">
            {{ __('পাসওয়ার্ড আপডেট করুন') }}
        </h2>

        <p class="mt-1 text-sm text-gray-600">
            {{ __('নিরাপদ থাকতে আপনার অ্যাকাউন্টে একটি দীর্ঘ, র্যান্ডম পাসওয়ার্ড ব্যবহার নিশ্চিত করুন।') }}
        </p>
    </header>

    <form method="post" action="{{ route('password.update') }}" class="mt-6 space-y-6">
        @csrf
        @method('put')

        <div>
            <x-input-label for="update_password_current_password" :value="__('বর্তমান পাসওয়ার্ড')" class="font-bold text-gray-700" />
            <x-text-input id="update_password_current_password" name="current_password" type="password" class="mt-1 block w-full rounded-xl border-gray-300 focus:border-theme-primary focus:ring-theme-primary" autocomplete="current-password" />
        <x-input-error :messages="$errors->updatePassword->get('current_password')" class="mt-2" />
    </div>

    <div>
        <x-input-label for="update_password_password" :value="__('নতুন পাসওয়ার্ড')" class="text-gray-700 font-bold" />
        <x-text-input id="update_password_password" name="password" type="password" class="mt-1 block w-full rounded-xl border-gray-300 focus:border-theme-primary focus:ring-theme-primary" autocomplete="new-password" />
        <x-input-error :messages="$errors->updatePassword->get('password')" class="mt-2" />
    </div>

    <div>
        <x-input-label for="update_password_password_confirmation" :value="__('নতুন পাসওয়ার্ড নিশ্চিত করুন')" class="text-gray-700 font-bold" />
        <x-text-input id="update_password_password_confirmation" name="password_confirmation" type="password" class="mt-1 block w-full rounded-xl border-gray-300 focus:border-theme-primary focus:ring-theme-primary" autocomplete="new-password" />
        <x-input-error :messages="$errors->updatePassword->get('password_confirmation')" class="mt-2" />
    </div>

    <div class="flex items-center gap-4">
        <x-primary-button class="bg-theme-primary hover:bg-theme-primary-hover text-white rounded-full px-6 py-2.5 font-bold transition-all duration-300 shadow-lg shadow-theme-primary/20">{{ __('সেভ করুন') }}</x-primary-button>

            @if (session('status') === 'password-updated')
                <p
                    x-data="{ show: true }"
                    x-show="show"
                    x-transition
                    x-init="setTimeout(() => show = false, 2000)"
                    class="text-sm text-gray-600 font-medium"
                >{{ __('Saved.') }}</p>
            @endif
        </div>
    </form>
</section>
