<section class="space-y-6">
    <header>
        <h2 class="text-lg font-heading font-bold text-gray-900">
            {{ __('অ্যাকাউন্ট ডিলিট করুন') }}
        </h2>

        <p class="mt-1 text-sm text-gray-600">
            {{ __('আপনার অ্যাকাউন্ট ডিলিট করা হলে, এর সমস্ত রিসোর্স এবং ডেটা স্থায়ীভাবে মুছে ফেলা হবে। আপনার অ্যাকাউন্ট ডিলিট করার আগে, আপনি যে ডেটা বা তথ্য রাখতে চান তা ডাউনলোড করুন।') }}
        </p>
    </header>

    <x-danger-button
        x-data=""
        x-on:click.prevent="$dispatch('open-modal', 'confirm-user-deletion')"
        class="bg-red-50 text-red-600 hover:bg-red-100 border border-red-200 rounded-full px-6 py-2.5 font-bold transition-all duration-300 shadow-sm"
    >{{ __('অ্যাকাউন্ট ডিলিট করুন') }}</x-danger-button>

    <x-modal name="confirm-user-deletion" :show="$errors->userDeletion->isNotEmpty()" focusable>
        <form method="post" action="{{ route('profile.destroy') }}" class="p-6">
            @csrf
            @method('delete')

            <h2 class="text-lg font-heading font-bold text-gray-900">
                {{ __('আপনি কি নিশ্চিত যে আপনি আপনার অ্যাকাউন্ট ডিলিট করতে চান?') }}
            </h2>

            <p class="mt-2 text-sm text-gray-600">
                {{ __('আপনার অ্যাকাউন্ট ডিলিট করা হলে, এর সমস্ত রিসোর্স এবং ডেটা স্থায়ীভাবে মুছে ফেলা হবে। আপনি আপনার অ্যাকাউন্ট স্থায়ীভাবে ডিলিট করতে চান তা নিশ্চিত করতে দয়া করে আপনার পাসওয়ার্ড দিন।') }}
            </p>

            <div class="mt-6">
                <x-input-label for="password" value="{{ __('Password') }}" class="sr-only" />

                <x-text-input
                    id="password"
                    name="password"
                    type="password"
                    class="mt-1 block w-3/4 rounded-xl border-gray-300 focus:border-red-500 focus:ring-red-500"
                    placeholder="{{ __('পাসওয়ার্ড') }}"
                />

                <x-input-error :messages="$errors->userDeletion->get('password')" class="mt-2" />
            </div>

            <div class="mt-6 flex justify-end gap-3">
                <x-secondary-button x-on:click="$dispatch('close')" class="rounded-full border-gray-300 px-6 py-2.5">
                    {{ __('বাতিল') }}
                </x-secondary-button>

                <x-danger-button class="bg-red-600 hover:bg-red-700 text-white rounded-full px-6 py-2.5 font-bold transition-all duration-300 shadow-lg shadow-red-600/20">
                    {{ __('অ্যাকাউন্ট ডিলিট করুন') }}
                </x-danger-button>
            </div>
        </form>
    </x-modal>
</section>
