<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        @if(isset($gtmContainers) && $gtmContainers->count() > 0)
            @foreach($gtmContainers as $gtm)
            <!-- Google Tag Manager -->
            <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
            new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
            'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
            })(window,document,'script','dataLayer','{{ $gtm->gtm_id }}');</script>
            <!-- End Google Tag Manager -->
            @endforeach
        @elseif(isset($generalSetting) && $generalSetting->gtm_enabled && $generalSetting->gtm_id)
        <!-- Google Tag Manager -->
        <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
        new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
        j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
        'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','{{ $generalSetting->gtm_id }}');</script>
        <!-- End Google Tag Manager -->
        @endif

        @if(isset($tiktokPixels) && $tiktokPixels->count() > 0)
            <!-- TikTok Pixel -->
            <script>
            !function (w, d, t) {
              w.TiktokAnalyticsObject=t;var ttq=w[t]=w[t]||[];ttq.methods=["page","track","identify","instances","debug","on","off","once","ready","alias","group","enableCookie","disableCookie"],ttq.setAndDefer=function(t,e){t[e]=function(){t.push([e].concat(Array.prototype.slice.call(arguments,0)))}};for(var i=0;i<ttq.methods.length;i++)ttq.setAndDefer(ttq,ttq.methods[i]);ttq.instance=function(t){for(var e=ttq.methods[i=0];i<ttq.methods.length;i++)ttq.setAndDefer(e,ttq.methods[i]);return e},ttq.load=function(e,n){var i="https://analytics.tiktok.com/i18n/pixel/events.js";ttq._i=ttq._i||{},ttq._i[e]=[],ttq._i[e]._u=i,ttq._t=ttq._t||{},ttq._t[e]=+new Date,ttq._o=ttq._o||{},ttq._o[e]=n||{};var o=document.createElement("script");o.type="text/javascript",o.async=!0,o.src=i+"?sdkid="+e+"&lib="+t;var a=document.getElementsByTagName("script")[0];a.parentNode.insertBefore(o,a)};
            
              @foreach($tiktokPixels as $pixel)
              ttq.load('{{ $pixel->pixel_id }}');
              @endforeach
              ttq.page();
            }(window, document, 'ttq');
            </script>
            <!-- End TikTok Pixel -->
        @endif

        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        @if(isset($generalSetting) && $generalSetting->favicon)
            <link rel="icon" href="{{ asset('storage/' . $generalSetting->favicon) }}" type="image/x-icon"/>
        @endif

        <title>{{ isset($generalSetting) && $generalSetting->name ? $generalSetting->name : config('app.name', 'Laravel') }}</title>

        @if(isset($generalSetting))
            <meta name="description" content="{{ $generalSetting->meta_description }}">
            <meta name="keywords" content="{{ $generalSetting->meta_keyword }}">
        @endif

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
        
        <style>
            .font-heading { font-family: 'Outfit', sans-serif; }
            body { font-family: 'Plus Jakarta Sans', sans-serif; }
        </style>

        @if(isset($generalSetting) && $generalSetting->facebook_verification_code)
            <meta name="facebook-domain-verification" content="{{ $generalSetting->facebook_verification_code }}" />
        @endif

        @if(isset($facebookPixels) && count($facebookPixels) > 0)
    <!-- Facebook Pixel Code -->
    <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
        n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t,s)}(window, document,'script',
        'https://connect.facebook.net/en_US/fbevents.js');
        
        @php
            $pixelInitData = [];
            if(auth()->check()) {
                $user = auth()->user();
                $pixelInitData = [
                    'em' => $user->email,
                    'ph' => $user->phone,
                    'external_id' => (string)$user->id
                ];
                if($user->name) {
                    $parts = explode(' ', $user->name, 2);
                    $pixelInitData['fn'] = $parts[0];
                    $pixelInitData['ln'] = $parts[1] ?? '';
                }
                $pixelInitData = array_filter($pixelInitData);
            }
        @endphp

        @foreach($facebookPixels as $pixel)
            @if(!empty($pixelInitData))
                fbq('init', '{{ $pixel->pixel_id }}', {!! json_encode($pixelInitData) !!});
            @else
                fbq('init', '{{ $pixel->pixel_id }}');
            @endif
        @endforeach
        
        fbq('track', 'PageView');
    </script>
    <noscript>
        @foreach($facebookPixels as $pixel)
            <img height="1" width="1" style="display:none"
            src="https://www.facebook.com/tr?id={{ $pixel->pixel_id }}&ev=PageView&noscript=1"
            />
        @endforeach
    </noscript>
    <!-- End Facebook Pixel Code -->
    @elseif(isset($generalSetting) && $generalSetting->facebook_pixel_enabled && $generalSetting->facebook_pixel_id)
            <!-- Meta Pixel Code (Legacy) -->
            <script>
            !function(f,b,e,v,n,t,s)
            {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
            n.callMethod.apply(n,arguments):n.queue.push(arguments)};
            if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
            n.queue=[];t=b.createElement(e);t.async=!0;
            t.src=v;s=b.getElementsByTagName(e)[0];
            s.parentNode.insertBefore(t,s)}(window, document,'script',
            'https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '{{ $generalSetting->facebook_pixel_id }}');
            fbq('track', 'PageView');
            </script>
            <noscript><img height="1" width="1" style="display:none"
            src="https://www.facebook.com/tr?id={{ $generalSetting->facebook_pixel_id }}&ev=PageView&noscript=1"
            /></noscript>
            <!-- End Meta Pixel Code -->
        @endif
    </head>
    <body class="font-sans text-gray-900 antialiased">
        @if(isset($gtmContainers) && $gtmContainers->count() > 0)
            @foreach($gtmContainers as $gtm)
            <!-- Google Tag Manager (noscript) -->
            <noscript><iframe src="https://www.googletagmanager.com/ns.html?id={{ $gtm->gtm_id }}"
            height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
            <!-- End Google Tag Manager (noscript) -->
            @endforeach
        @elseif(isset($generalSetting) && $generalSetting->gtm_enabled && $generalSetting->gtm_id)
        <!-- Google Tag Manager (noscript) -->
        <noscript><iframe src="https://www.googletagmanager.com/ns.html?id={{ $generalSetting->gtm_id }}"
        height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
        <!-- End Google Tag Manager (noscript) -->
        @endif
        
        <div class="min-h-screen flex items-center justify-center bg-gray-50 py-12 px-4 sm:px-6 lg:px-8 relative overflow-hidden">
            <!-- Background Elements -->
            <div class="absolute top-0 left-0 w-full h-full overflow-hidden z-0">
                <div class="absolute -top-[20%] -right-[10%] w-[60%] h-[60%] rounded-full bg-orange-500/5 blur-[100px]"></div>
                <div class="absolute -bottom-[20%] -left-[10%] w-[60%] h-[60%] rounded-full bg-blue-500/5 blur-[100px]"></div>
            </div>

            <div class="max-w-md w-full space-y-8 relative z-10">
                {{ $slot }}
            </div>
        </div>
    </body>
                        animation: fadeInUp 0.6s ease-out forwards;
                    }
                    @keyframes float {
                        0%, 100% { transform: translateY(0); }
                        50% { transform: translateY(-10px); }
                    }
                    .animate-float {
                        animation: float 4s ease-in-out infinite;
                    }
                </style>
            </div>
        </div>
    </body>
</html>