<x-frontend-layout>
        <style>
        .custom-scrollbar::-webkit-scrollbar {
            width: 6px;
        }
        .custom-scrollbar::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 4px;
        }
        .custom-scrollbar::-webkit-scrollbar-thumb {
            background: #d1d5db;
            border-radius: 4px;
        }
        .custom-scrollbar::-webkit-scrollbar-thumb:hover {
            background: #9ca3af;
        }
        /* Custom scrollbar for thumbnails */
        .no-scrollbar::-webkit-scrollbar {
            display: none;
        }
        .no-scrollbar {
            -ms-overflow-style: none;
            scrollbar-width: none;
        }

        /* Base Layout (Desktop Default) */
        .product-gallery-wrapper {
            display: flex;
            gap: 16px;
        }
        
        /* Desktop: Thumbnails Left, Main Image Right */
        @media (min-width: 1024px) {
            .product-gallery-wrapper {
                flex-direction: row !important;
                height: 600px !important;
            }
            .thumbnails-wrapper {
                flex-direction: column !important;
                width: 100px !important;
                height: 100% !important;
                order: 1 !important;
                overflow-y: auto !important;
                overflow-x: hidden !important;
            }
            .main-image-wrapper {
                order: 2 !important;
                height: 100% !important;
                width: calc(100% - 116px) !important; /* 100px thumb + 16px gap */
            }
            .thumbnail-item {
                width: 100% !important;
                height: 100px !important;
                margin-bottom: 12px !important;
            }
            .product-details-wrapper {
                height: 600px !important;
                overflow-y: auto !important;
            }
        }

        /* Mobile: Thumbnails Left, Main Image Right (Side by Side) */
        @media (max-width: 1023px) {
            .product-gallery-wrapper {
                flex-direction: row !important;
                height: 350px !important;
                gap: 4px !important;
            }
            .main-image-wrapper {
                order: 2 !important;
                width: calc(100% - 64px) !important; /* 60px thumb + 4px gap */
                height: 100% !important; 
                border: none !important;
                padding: 0 !important;
            }
            .thumbnails-wrapper {
                order: 1 !important;
                flex-direction: column !important;
                width: 60px !important;
                height: 100% !important;
                overflow-x: hidden !important;
                overflow-y: auto !important;
                margin-top: 0 !important;
                margin-right: 0 !important;
            }
            .thumbnail-item {
                width: 60px !important;
                height: 60px !important;
                margin-right: 0 !important;
                margin-bottom: 4px !important;
                flex-shrink: 0 !important;
            }
        }
        /* Large Desktop: Even bigger layout */
        @media (min-width: 1400px) {
            .product-gallery-wrapper {
                height: 700px !important;
            }
            .thumbnails-wrapper {
                width: 120px !important;
            }
            .main-image-wrapper {
                width: calc(100% - 136px) !important; /* 120px thumb + 16px gap */
            }
            .thumbnail-item {
                height: 120px !important;
            }
            .product-details-wrapper {
                height: 700px !important;
            }
        }
    </style>

    <div class="bg-white min-h-screen pb-20">
        <!-- Breadcrumb -->
        <div class="bg-gray-50 border-b border-gray-100">
            <div class="max-w-[1920px] mx-auto px-4 sm:px-6 lg:px-8 py-2">
                <nav class="flex" aria-label="Breadcrumb">
                    <ol class="flex items-center space-x-2">
                        <li><a href="{{ route('home') }}" class="text-gray-400 hover:text-theme-primary transition-colors"><i class="fas fa-home"></i></a></li>
                        <li><span class="text-gray-300">/</span></li>
                        <li><a href="{{ route('shop') }}" class="text-gray-500 hover:text-theme-primary font-medium transition-colors">Shop</a></li>
                        <li><span class="text-gray-300">/</span></li>
                        <li class="text-theme-primary font-bold truncate max-w-[200px]">{{ $product->name }}</li>
                    </ol>
                </nav>
            </div>
        </div>

        <div class="max-w-[1920px] mx-auto px-4 sm:px-6 lg:px-8 py-2 md:py-4">
            @php
                $firstAvailableImage = '';
                if($product->thumbnail){
                    $src = $product->thumbnail;
                    $firstAvailableImage = filter_var($src, FILTER_VALIDATE_URL) ? $src : asset('storage/' . $src);
                } elseif($product->images->count() > 0){
                    $src = $product->images->first()->image_path;
                    $firstAvailableImage = filter_var($src, FILTER_VALIDATE_URL) ? $src : asset('storage/' . $src);
                } elseif(isset($product->gallery) && is_array($product->gallery) && count($product->gallery) > 0){
                    $src = $product->gallery[0];
                    $firstAvailableImage = filter_var($src, FILTER_VALIDATE_URL) ? $src : asset('storage/' . $src);
                }
            @endphp
            <input type="hidden" id="firstAvailableImage" value="{{ $firstAvailableImage }}">
            <div class="grid grid-cols-1 lg:grid-cols-12 gap-4 lg:gap-8" x-data="{ 
                activeImage: '{{ $product->thumbnail ? (filter_var($product->thumbnail, FILTER_VALIDATE_URL) ? $product->thumbnail : asset('storage/' . $product->thumbnail)) : 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxMDAiIGhlaWdodD0iMTAwIiB2aWV3Qm94PSIwIDAgMTAwIDEwMCI+PHJlY3Qgd2lkdGg9IjEwMCIgaGVpZ2h0PSIxMDAiIGZpbGw9IiNmNmY2ZjYiLz48dGV4dCB4PSI1MCIgeT0iNTAiIGRvbWluYW50LWJhc2VsaW5lPSJtaWRkbGUiIHRleHQtYW5jaG9yPSJtaWRkbGUiIGZvbnQtZmFtaWx5PSJzYW5zLXNlcmlmIiBmb250LXNpemU9IjE0IiBmaWxsPSIjOTk5Ij5ObHwgSW1hZ2U8L3RleHQ+PC9zdmc+' }}',
                activeKey: 'main',
                selectedColor: null,
                selectedSize: null,
                quantity: 1,
                price: {{ $product->offer_price ?? $product->price }},
                originalPrice: {{ $product->price }},
                variants: {{ json_encode($product->variants) }},
                switchImage(src, key = null) {
                    if (key) this.activeKey = key;
                    if (!src) return;
                    const img = this.$refs && this.$refs.mainImg ? this.$refs.mainImg : null;
                    if (img) {
                        img.style.transition = 'opacity 200ms ease';
                        img.style.opacity = '0';
                        setTimeout(() => {
                            this.activeImage = src;
                            requestAnimationFrame(() => { img.style.opacity = '1'; });
                        }, 120);
                    } else {
                        this.activeImage = src;
                    }
                },
                init() {
                    // Pre-select first color/size if available
                    @if($product->colors->count() > 0)
                        this.selectedColor = '{{ $product->colors->first()->id }}';
                    @endif
                    @if($product->sizes->count() > 0)
                        this.selectedSize = '{{ $product->sizes->first()->id }}';
                    @endif
                    
                    this.updateVariantInfo();
                    this.$watch('selectedColor', () => this.updateVariantInfo());
                    this.$watch('selectedSize', () => this.updateVariantInfo());
                    
                    const initial = document.getElementById('firstAvailableImage');
                    if (initial && initial.value) {
                        this.activeImage = initial.value;
                    }
                },
                updateVariantInfo() {
                    if (!this.variants || this.variants.length === 0) return;
                    
                    const hasColors = {{ $product->colors->count() > 0 ? 'true' : 'false' }};
                    const hasSizes = {{ $product->sizes->count() > 0 ? 'true' : 'false' }};
                    
                    let variant = this.variants.find(v => {
                        const colorMatch = !hasColors || v.color_id == this.selectedColor;
                        const sizeMatch = !hasSizes || v.size_id == this.selectedSize;
                        return colorMatch && sizeMatch;
                    });

                    if (variant) {
                        this.price = variant.offer_price ? Number(variant.offer_price) : Number(variant.price);
                        this.originalPrice = Number(variant.price);
                        if (variant.image) {
                            // Check if full URL or path
                            if (variant.image.startsWith('http')) {
                                this.switchImage(variant.image, 'variant');
                            } else {
                                this.switchImage('{{ asset('storage') }}/' + variant.image, 'variant');
                            }
                        }
                    }
                },
                addToCart(isBuyNow = false) {
                    // Validation
                    if ({{ $product->colors->count() }} > 0 && !this.selectedColor) {
                        alert('Please select a color');
                        return;
                    }
                    if ({{ $product->sizes->count() }} > 0 && !this.selectedSize) {
                        alert('Please select a size');
                        return;
                    }

                    if(isBuyNow) {
                        let url = '{{ route('checkout.index') }}?product_id={{ $product->id }}&quantity=' + this.quantity;
                        if(this.selectedColor) url += '&color_id=' + this.selectedColor;
                        if(this.selectedSize) url += '&size_id=' + this.selectedSize;
                        window.location.href = url;
                    } else {
                        // AJAX Add to Cart
                        const formData = new FormData();
                        formData.append('_token', '{{ csrf_token() }}');
                        formData.append('product_id', '{{ $product->id }}');
                        formData.append('quantity', this.quantity);
                        
                        if(this.selectedColor) formData.append('color_id', this.selectedColor);
                        if(this.selectedSize) formData.append('size_id', this.selectedSize);
                        
                        // Show loading state if needed
                        const btn = this.$refs.addToCartBtn;
                        const originalText = btn ? btn.innerText : 'Add to cart';
                        if(btn) btn.innerText = 'Adding...';

                        fetch('{{ route('cart.add') }}', {
                            method: 'POST',
                            headers: {
                                'Accept': 'application/json',
                                'X-Requested-With': 'XMLHttpRequest'
                            },
                            body: formData
                        })
                        .then(response => response.json())
                        .then(data => {
                            if(btn) btn.innerText = originalText;
                            
                            if(data.success) {
                                // Fire Facebook Pixel Event with Retry
                                if (data.facebook_event) {
                                    var fbAttempts = 0;
                                    var fbInterval = setInterval(function() {
                                        if (typeof fbq === 'function') {
                                            clearInterval(fbInterval);
                                            fbq('track', data.facebook_event.name, data.facebook_event.params, {eventID: data.facebook_event.event_id});
                                            console.log('Facebook Pixel: AJAX AddToCart Fired');
                                        } else {
                                            fbAttempts++;
                                            if (fbAttempts >= 20) {
                                                clearInterval(fbInterval);
                                                console.error('Facebook Pixel: fbq not defined for AJAX AddToCart');
                                            }
                                        }
                                    }, 500);
                                }
                                
                                // Fire TikTok Pixel Event with Retry
                                if (data.tiktok_event) {
                                    var ttAttempts = 0;
                                    var ttInterval = setInterval(function() {
                                        if (typeof ttq === 'object' && typeof ttq.track === 'function') {
                                            clearInterval(ttInterval);
                                            ttq.track(data.tiktok_event.name, data.tiktok_event.params, {event_id: data.tiktok_event.event_id});
                                            console.log('TikTok Pixel: AJAX AddToCart Fired');
                                        } else {
                                            ttAttempts++;
                                            if (ttAttempts >= 20) {
                                                clearInterval(ttInterval);
                                                console.error('TikTok Pixel: ttq not defined for AJAX AddToCart');
                                            }
                                        }
                                    }, 500);
                                }

                                alert('Product added to cart successfully!');
                                window.dispatchEvent(new CustomEvent('cart-updated', { detail: { count: data.cart_count } }));
                            } else {
                                alert('Something went wrong');
                            }
                        })
                        .catch(error => {
                            if(btn) btn.innerText = originalText;
                            console.error('Error:', error);
                            alert('Something went wrong');
                        });
                    }
                }
            }">
                
                <!-- Left Column: Images -->
                <div class="flex gap-4 items-start product-gallery-wrapper lg:col-span-7">
                    <!-- Thumbnails (Bottom on Mobile, Left on Desktop) -->
                    <div class="flex flex-col overflow-auto no-scrollbar flex-shrink-0 thumbnails-wrapper">
                        <!-- Main Thumbnail -->
                        <button @click="activeImage = '{{ $product->thumbnail ? (filter_var($product->thumbnail, FILTER_VALIDATE_URL) ? $product->thumbnail : asset('storage/' . $product->thumbnail)) : 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxMDAiIGhlaWdodD0iMTAwIiB2aWV3Qm94PSIwIDAgMTAwIDEwMCI+PHJlY3Qgd2lkdGg9IjEwMCIgaGVpZ2h0PSIxMDAiIGZpbGw9IiNmNmY2ZjYiLz48dGV4dCB4PSI1MCIgeT0iNTAiIGRvbWluYW50LWJhc2VsaW5lPSJtaWRkbGUiIHRleHQtYW5jaG9yPSJtaWRkbGUiIGZvbnQtZmFtaWx5PSJzYW5zLXNlcmlmIiBmb250LXNpemU9IjE0IiBmaWxsPSIjOTk5Ij5ObHwgSW1hZ2U8L3RleHQ+PC9zdmc+' }}'; activeKey = 'main'" 
                                class="flex-shrink-0 border-2 overflow-hidden transition-all bg-white thumbnail-item"
                                :class="activeKey === 'main' ? 'border-orange-600 ring-2 ring-orange-600/20' : 'border-transparent hover:border-gray-200'">
                            <img src="{{ $product->thumbnail ? (filter_var($product->thumbnail, FILTER_VALIDATE_URL) ? $product->thumbnail : asset('storage/' . $product->thumbnail)) : 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxMDAiIGhlaWdodD0iMTAwIiB2aWV3Qm94PSIwIDAgMTAwIDEwMCI+PHJlY3Qgd2lkdGg9IjEwMCIgaGVpZ2h0PSIxMDAiIGZpbGw9IiNmNmY2ZjYiLz48dGV4dCB4PSI1MCIgeT0iNTAiIGRvbWluYW50LWJhc2VsaW5lPSJtaWRkbGUiIHRleHQtYW5jaG9yPSJtaWRkbGUiIGZvbnQtZmFtaWx5PSJzYW5zLXNlcmlmIiBmb250LXNpemU9IjE0IiBmaWxsPSIjOTk5Ij5ObHwgSW1hZ2U8L3RleHQ+PC9zdmc+' }}" 
                                 class="w-full h-full object-cover"
                                 onerror="this.src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxMDAiIGhlaWdodD0iMTAwIiB2aWV3Qm94PSIwIDAgMTAwIDEwMCI+PHJlY3Qgd2lkdGg9IjEwMCIgaGVpZ2h0PSIxMDAiIGZpbGw9IiNmNmY2ZjYiLz48dGV4dCB4PSI1MCIgeT0iNTAiIGRvbWluYW50LWJhc2VsaW5lPSJtaWRkbGUiIHRleHQtYW5jaG9yPSJtaWRkbGUiIGZvbnQtZmFtaWx5PSJzYW5zLXNlcmlmIiBmb250LXNpemU9IjE0IiBmaWxsPSIjOTk5Ij5ObHwgSW1hZ2U8L3RleHQ+PC9zdmc+'">
                        </button>
                        
                        @php $thumbCount = 0; @endphp

                        <!-- Gallery Images (if available) -->
                        @if(isset($product->gallery) && is_array($product->gallery) && count($product->gallery) > 0)
                            @foreach($product->gallery as $key => $img)
                            @if(!empty($img) && $thumbCount < 4)
                            <button @click="activeImage = '{{ filter_var($img, FILTER_VALIDATE_URL) ? $img : asset('storage/' . $img) }}'; activeKey = 'gallery_{{ $key }}'" 
                                    class="flex-shrink-0 border-2 overflow-hidden transition-all bg-white thumbnail-item"
                                    :class="activeKey === 'gallery_{{ $key }}' ? 'border-orange-600 ring-2 ring-orange-600/20' : 'border-transparent hover:border-gray-200'">
                                <img src="{{ filter_var($img, FILTER_VALIDATE_URL) ? $img : asset('storage/' . $img) }}" 
                                     class="w-full h-full object-cover"
                                     onerror="this.style.display='none'">
                            </button>
                            @php $thumbCount++; @endphp
                            @endif
                            @endforeach
                        @endif

                        <!-- Product Images Relation (if available) -->
                        @if($product->images->count() > 0)
                            @foreach($product->images as $prodImg)
                            @if(!empty($prodImg->image_path) && $thumbCount < 4)
                            <button @click="activeImage = '{{ filter_var($prodImg->image_path, FILTER_VALIDATE_URL) ? $prodImg->image_path : asset('storage/' . $prodImg->image_path) }}'; activeKey = 'image_{{ $prodImg->id }}'" 
                                    class="flex-shrink-0 border-2 overflow-hidden transition-all bg-white thumbnail-item"
                                    :class="activeKey === 'image_{{ $prodImg->id }}' ? 'border-orange-600 ring-2 ring-orange-600/20' : 'border-transparent hover:border-gray-200'">
                                <img src="{{ filter_var($prodImg->image_path, FILTER_VALIDATE_URL) ? $prodImg->image_path : asset('storage/' . $prodImg->image_path) }}" 
                                     class="w-full h-full object-cover"
                                     onerror="this.style.display='none'">
                            </button>
                            @php $thumbCount++; @endphp
                            @endif
                            @endforeach
                        @endif
                    </div>

                    <!-- Main Image -->
                    <div class="w-full flex-1 relative bg-white group main-image-wrapper">
                        <div class="w-full h-full flex items-center justify-center bg-white">
                            <div class="absolute top-4 left-4 z-10" x-show="originalPrice > price">
                                <span class="bg-red-500 text-white text-xs font-bold px-3 py-1.5 rounded-full shadow-lg animate-pulse" 
                                      x-text="Math.round(((originalPrice - price) / originalPrice) * 100) + '% OFF'">
                                    @if($product->offer_price)
                                    {{ round((($product->price - $product->offer_price) / $product->price) * 100) }}% OFF
                                    @endif
                                </span>
                            </div>
                            
                            <img src="{{ $product->thumbnail ? (filter_var($product->thumbnail, FILTER_VALIDATE_URL) ? $product->thumbnail : asset('storage/' . $product->thumbnail)) : 'data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxMDAiIGhlaWdodD0iMTAwIiB2aWV3Qm94PSIwIDAgMTAwIDEwMCI+PHJlY3Qgd2lkdGg9IjEwMCIgaGVpZ2h0PSIxMDAiIGZpbGw9IiNmNmY2ZjYiLz48dGV4dCB4PSI1MCIgeT0iNTAiIGRvbWluYW50LWJhc2VsaW5lPSJtaWRkbGUiIHRleHQtYW5jaG9yPSJtaWRkbGUiIGZvbnQtZmFtaWx5PSJzYW5zLXNlcmlmIiBmb250LXNpemU9IjE0IiBmaWxsPSIjOTk5Ij5ObHwgSW1hZ2U8L3RleHQ+PC9zdmc+' }}"
                                 x-bind:src="activeImage" 
                                 alt="{{ $product->name }}" 
                                 class="w-full h-full object-contain p-0"
                                 onerror="this.src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxMDAiIGhlaWdodD0iMTAwIiB2aWV3Qm94PSIwIDAgMTAwIDEwMCI+PHJlY3Qgd2lkdGg9IjEwMCIgaGVpZ2h0PSIxMDAiIGZpbGw9IiNmNmY2ZjYiLz48dGV4dCB4PSI1MCIgeT0iNTAiIGRvbWluYW50LWJhc2VsaW5lPSJtaWRkbGUiIHRleHQtYW5jaG9yPSJtaWRkbGUiIGZvbnQtZmFtaWx5PSJzYW5zLXNlcmlmIiBmb250LXNpemU9IjE0IiBmaWxsPSIjOTk5Ij5ObHwgSW1hZ2U8L3RleHQ+PC9zdmc+'">
                        </div>
                    </div>
                </div>

                <!-- Right Column: Details -->
                <div class="flex flex-col pr-2 p-2 md:p-3 rounded-md lg:col-span-5 product-details-wrapper custom-scrollbar">
                    <!-- Title -->
                    <h1 class="text-lg sm:text-3xl font-extrabold text-gray-900 tracking-tight leading-tight mb-0.5">
                        {{ $product->name }}
                    </h1>

                    <!-- Reviews & Stock -->
                    <div class="flex items-center gap-4 mb-1">
                        <div class="flex items-center gap-1 text-orange-400">
                            @for($i=0; $i<5; $i++)
                                <svg class="w-5 h-5 fill-current" viewBox="0 0 24 24"><path d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z"/></svg>
                            @endfor
                            <span class="text-sm font-medium text-gray-500 ml-2">(Review)</span>
                        </div>
                        <div class="h-4 w-px bg-gray-200"></div>
                        <div class="flex items-center gap-2">
                            <span class="relative flex h-3 w-3">
                              <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-green-400 opacity-75"></span>
                              <span class="relative inline-flex rounded-full h-3 w-3 bg-green-500"></span>
                            </span>
                            <span class="text-sm font-bold text-green-600">In Stock</span>
                        </div>
                    </div>

                    <!-- Price -->
                    <div class="flex items-baseline gap-2 mb-1 bg-gray-50 p-1 md:p-1.5 rounded-lg md:rounded-xl border border-gray-100">
                        <span class="text-xl md:text-3xl font-extrabold text-orange-600" x-text="'Tk ' + Number(price).toLocaleString()">
                            Tk {{ number_format($product->offer_price ?? $product->price) }}
                        </span>
                        <span class="text-sm md:text-lg text-gray-400 line-through decoration-2" x-show="originalPrice > price" x-text="'Tk ' + Number(originalPrice).toLocaleString()">
                            @if($product->offer_price)
                            Tk {{ number_format($product->price) }}
                            @endif
                        </span>
                    </div>

                    <!-- Variants Selection -->
                    <div class="space-y-2 mb-2">
                        @if($product->colors->count() > 0)
                            <div>
                                <h3 class="text-xs font-bold text-gray-900 mb-1 flex items-center gap-2">
                                    <span class="w-1.5 h-1.5 bg-orange-600 rounded-full ring-2 ring-orange-100"></span>
                                    কালার সিলেক্ট করুন
                                </h3>
                                <div class="flex flex-wrap gap-4">
                                    @foreach($product->colors as $color)
                                        <label class="cursor-pointer group relative" title="{{ $color->name }}">
                                            <input type="radio" name="color_id" value="{{ $color->id }}" class="hidden peer" x-model="selectedColor">
                                            <span class="block w-11 h-11 md:w-12 md:h-12 rounded-md border-2 border-gray-100 ring-2 ring-gray-200 hover:ring-orange-300/60 peer-checked:ring-orange-600 peer-checked:scale-105 transition-all shadow-md relative overflow-hidden" 
                                                  style="background-color: {{ $color->code }}">
                                                <span class="absolute inset-0 flex items-center justify-center opacity-0 peer-checked:opacity-100 transition-opacity bg-black/10">
                                                    <svg class="w-5 h-5 text-white drop-shadow-md" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M5 13l4 4L19 7"></path></svg>
                                                </span>
                                            </span>
                                            <span class="absolute -top-8 left-1/2 -translate-x-1/2 bg-gray-900 text-white text-[10px] md:text-xs px-2 py-0.5 rounded shadow opacity-0 group-hover:opacity-100 pointer-events-none whitespace-nowrap z-10">
                                                {{ $color->name }}
                                            </span>
                                        </label>
                                    @endforeach
                                </div>
                            </div>
                        @endif

                        @if($product->sizes->count() > 0)
                            <div>
                                <div class="flex flex-wrap gap-1.5">
                                    @foreach($product->sizes as $size)
                                        <label class="cursor-pointer">
                                            <input type="radio" name="size_id" value="{{ $size->id }}" class="hidden peer" x-model="selectedSize">
                                            <span class="px-4 py-2 md:px-5 md:py-2.5 rounded-md border border-gray-200 text-sm md:text-base font-bold text-gray-600 peer-checked:border-orange-600 peer-checked:bg-white peer-checked:text-orange-600 transition-all flex items-center gap-1 shadow-sm">
                                                {{ $size->name }}
                                            </span>
                                        </label>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                        
                        <!-- Quantity & Add to Cart Row -->
                        <div class="space-y-1.5 pt-0 border-t border-gray-100">
                            <div class="flex items-stretch gap-2">
                                <!-- Quantity -->
                                <div class="flex items-center border-2 border-gray-200 rounded-lg md:rounded-xl bg-white w-fit">
                                    <button @click="quantity > 1 ? quantity-- : null" class="w-8 h-8 md:w-10 md:h-10 flex items-center justify-center text-gray-500 hover:text-orange-600 transition-colors">
                                        <svg class="w-3 h-3 md:w-4 md:h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 12H4"></path></svg>
                                    </button>
                                    <input type="number" x-model="quantity" class="w-10 md:w-12 text-center border-none focus:ring-0 text-base md:text-lg font-bold text-gray-900 p-0" readonly>
                                    <button @click="quantity++" class="w-8 h-8 md:w-10 md:h-10 flex items-center justify-center text-gray-500 hover:text-orange-600 transition-colors">
                                        <svg class="w-3 h-3 md:w-4 md:h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path></svg>
                                    </button>
                                </div>
                                
                                <!-- Add to Cart (Black) -->
                                <button x-ref="addToCartBtn" @click="addToCart(false)" 
                                        class="flex-1 bg-black text-white px-3 md:px-4 rounded-lg md:rounded-xl font-bold text-sm md:text-base hover:bg-gray-900 transition-colors shadow-lg shadow-gray-200 flex items-center justify-center gap-1.5 md:gap-2">
                                    Add to cart
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="flex flex-col gap-1.5 mb-1.5 md:mb-2">
                        <!-- Order Now (Orange) -->
                        <button @click="addToCart(true)" 
                                class="w-full bg-orange-600 text-white py-2.5 md:py-3 rounded-lg md:rounded-xl font-bold text-base md:text-lg shadow-lg shadow-orange-200 hover:shadow-xl hover:-translate-y-1 transition-all flex items-center justify-center gap-2 relative overflow-hidden group">
                            <span class="absolute inset-0 bg-white/20 translate-y-full group-hover:translate-y-0 transition-transform duration-300"></span>
                            <svg class="w-5 h-5 md:w-6 md:h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                            ক্যাশ অন ডেলিভারিতে অর্ডার করুন
                        </button>
                        
                        <!-- Social Buttons (Side by Side) -->
                        <div class="flex gap-2">
                            <a href="https://m.me/shoyibhasan.ID" target="_blank" class="flex-1 flex items-center justify-center gap-1.5 md:gap-2 py-2 md:py-2.5 rounded-lg md:rounded-xl bg-black text-white font-bold hover:bg-gray-900 transition-colors text-xs md:text-sm">
                                <i class="fab fa-facebook-messenger text-base md:text-lg text-blue-500"></i> Chat with us
                            </a>
                            <a href="https://wa.me/{{ $contactSetting?->whatsapp_number }}" target="_blank" class="flex-1 flex items-center justify-center gap-1.5 md:gap-2 py-2 md:py-2.5 rounded-lg md:rounded-xl bg-black text-white font-bold hover:bg-gray-900 transition-colors text-xs md:text-sm">
                                <i class="fab fa-whatsapp text-base md:text-lg text-green-500"></i> WhatsApp Us
                            </a>
                        </div>
                    </div>

                    <!-- Trust Badges & Hotline -->
                    <div class="flex flex-col gap-3 pt-2 mt-2 border-t border-gray-100">
                        <!-- Hotline Button -->
                        <a href="tel:{{ $contactSetting?->hotline_number }}" class="w-full flex items-center justify-center gap-2 py-2.5 rounded-xl bg-black text-white font-bold hover:bg-gray-900 transition-colors text-sm">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
                            কল করুন {{ $contactSetting?->hotline_number }}
                        </a>

                        <!-- Product Description -->
                        <div class="mt-2">
                            <h2 class="text-sm font-bold text-gray-900 mb-1">প্রোডাক্ট বিস্তারিত:</h2>
                            <div class="prose prose-sm prose-orange max-w-none text-gray-700 text-sm leading-7 space-y-2">
                                {!! $product->description !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Related Products -->
            @if(isset($relatedProducts) && $relatedProducts->count() > 0)
            <div class="mt-8 border-t border-gray-200 pt-8">
                <h2 class="text-2xl font-bold text-gray-900 mb-8 flex items-center gap-3">
                    <span class="w-1.5 h-8 bg-orange-600 rounded-full"></span>
                    রিলেটেড প্রোডাক্ট
                </h2>
                <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 gap-3 md:gap-4">
                    @foreach($relatedProducts as $related)
                        <div class="bg-white rounded-lg border border-gray-100 overflow-hidden hover:shadow-lg transition-all group flex flex-col">
                            <a href="{{ route('product.show', $related->slug) }}" class="block relative aspect-square overflow-hidden bg-gray-100 shrink-0">
                                <img src="{{ $related->thumbnail ? \Illuminate\Support\Facades\Storage::url($related->thumbnail) : asset('images/no-image.svg') }}" alt="{{ $related->name }}" class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-500">
                                @if($related->offer_price)
                                    <div class="absolute top-2 left-2 bg-red-500 text-white text-[10px] font-bold px-2 py-1 rounded-full shadow-sm z-10">
                                        {{ round((($related->price - $related->offer_price) / $related->price) * 100) }}% OFF
                                    </div>
                                @endif
                            </a>
                            <div class="p-2 md:p-3 flex flex-col flex-1">
                                <h3 class="text-xs md:text-sm font-bold text-gray-900 mb-1 line-clamp-2 min-h-[2.5em] group-hover:text-orange-600 transition-colors">
                                    <a href="{{ route('product.show', $related->slug) }}">
                                        {{ $related->name }}
                                    </a>
                                </h3>
                                <div class="flex flex-wrap items-baseline gap-1 mb-2 mt-auto">
                                    <span class="text-sm md:text-base font-bold text-orange-600">Tk {{ number_format($related->offer_price ?? $related->price) }}</span>
                                    @if($related->offer_price)
                                        <span class="text-[10px] md:text-xs text-gray-400 line-through decoration-2">Tk {{ number_format($related->price) }}</span>
                                    @endif
                                </div>
                                <div class="grid grid-cols-2 gap-1.5 md:gap-2 mt-auto">
                                    <a href="{{ route('product.show', $related->slug) }}" class="flex items-center justify-center w-full py-1.5 md:py-2 bg-black text-white font-bold text-center rounded-md hover:bg-gray-800 transition-colors text-[10px] md:text-xs shadow-sm gap-1">
                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                                        <span class="hidden sm:inline">Add to cart</span>
                                        <span class="sm:hidden">Cart</span>
                                    </a>
                                    <a href="{{ route('product.show', $related->slug) }}" class="flex items-center justify-center w-full py-1.5 md:py-2 bg-orange-600 text-white font-bold text-center rounded-md hover:bg-orange-700 transition-colors text-[10px] md:text-xs shadow-sm shadow-orange-200 gap-1">
                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                                        <span class="hidden sm:inline">Order Now</span>
                                        <span class="sm:hidden">Order</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>

    @push('scripts')
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // ViewContent Event Tracking
            var eventId = "{{ $eventId }}";
            var maxAttempts = 20;

            // Facebook Pixel
            var fbAttempt = 0;
            var fbInterval = setInterval(function() {
                if (typeof fbq === 'function') {
                    fbq('track', 'ViewContent', {
                        content_name: "{{ $product->name }}",
                        content_category: "{{ $product->category ? $product->category->name : '' }}",
                        content_ids: ["{{ $product->id }}"],
                        content_type: 'product',
                        value: {{ $product->offer_price ?? $product->price }},
                        currency: 'BDT'
                    }, { eventID: eventId });
                    clearInterval(fbInterval);
                    console.log('Facebook Pixel: ViewContent Event Fired with ID: ' + eventId);
                } else {
                    fbAttempt++;
                    if (fbAttempt >= maxAttempts) clearInterval(fbInterval);
                }
            }, 500);

            // TikTok Pixel
            var ttAttempt = 0;
            var ttInterval = setInterval(function() {
                if (typeof ttq === 'object' && typeof ttq.track === 'function') {
                    ttq.track('ViewContent', {
                        content_name: "{{ $product->name }}",
                        content_category: "{{ $product->category ? $product->category->name : '' }}",
                        content_id: "{{ $product->id }}",
                        content_type: 'product',
                        value: {{ $product->offer_price ?? $product->price }},
                        currency: 'BDT'
                    }, { event_id: eventId });
                    clearInterval(ttInterval);
                    console.log('TikTok Pixel: ViewContent Event Fired with ID: ' + eventId);
                } else {
                    ttAttempt++;
                    if (ttAttempt >= maxAttempts) clearInterval(ttInterval);
                }
            }, 500);
        });
    </script>
    @endpush
</x-frontend-layout>
