<x-frontend-layout>
    <!-- Page Header -->
    <div class="relative bg-gray-50 py-8 md:py-12 overflow-hidden">
        <div class="absolute inset-0 bg-theme-primary-light opacity-50"></div>
        <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            @php
                $activeCategory = null;
                if(request('category')) {
                    $activeCategory = \App\Models\Category::where('slug', request('category'))->first();
                }
            @endphp
            <h1 class="text-3xl md:text-5xl font-heading font-bold text-gray-900 mb-2 md:mb-4">
                {{ $activeCategory ? $activeCategory->name : 'আমাদের শপ' }}
            </h1>
            <p class="text-gray-500 text-sm md:text-lg font-sans">
                {{ $activeCategory ? 'সেরা মানের পণ্য কিনুন' : 'আপনার পছন্দের পণ্যটি খুঁজে নিন' }}
            </p>
        </div>
    </div>

    <div class="bg-white py-6 md:py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            
            <!-- Mobile Toolbar -->
            <div class="md:hidden flex items-center justify-between mb-6 border-b border-gray-200 pb-4 sticky top-[60px] bg-white z-20 pt-2 transition-all" id="mobileToolbar">
                <button onclick="openMobileFilters()" class="flex items-center gap-2 text-gray-800 font-medium text-sm">
                    <span>Filter</span>
                    <i class="fas fa-chevron-down text-xs"></i>
                </button>
                
                <button onclick="openMobileSort()" class="flex items-center gap-2 text-gray-800 font-medium text-sm">
                    <span>
                        @if(request('sort') == 'newest') Featured
                        @elseif(request('sort') == 'price_asc') Price: Low to High
                        @elseif(request('sort') == 'price_desc') Price: High to Low
                        @else Featured
                        @endif
                    </span>
                    <i class="fas fa-chevron-down text-xs"></i>
                </button>
                
                <div class="flex items-center gap-2">
                    <button class="p-2 text-gray-400 hover:text-gray-900"><i class="fas fa-list"></i></button>
                    <button class="p-2 text-white bg-theme-primary rounded"><i class="fas fa-th-large"></i></button>
                </div>
            </div>

            <div class="flex flex-col md:flex-row gap-8 lg:gap-16">
                
                <!-- Desktop Sidebar Filters -->
                <div class="hidden md:block md:w-1/4 space-y-8">
                    <div class="flex items-center justify-between">
                        <h2 class="text-3xl font-heading font-bold text-gray-900">Filters</h2>
                    </div>

                    <!-- Collections (Categories) -->
                    <div>
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Collections</h3>
                        <ul class="space-y-3">
                            <li>
                                <a href="{{ route('shop', array_merge(request()->except('category', 'page'))) }}" 
                                   class="block text-sm transition-colors {{ !request('category') ? 'text-theme-primary font-bold' : 'text-gray-600 hover:text-theme-primary' }}">
                                    All Collections
                                </a>
                            </li>
                            @foreach($categories as $category)
                                <li>
                                    <a href="{{ route('shop', array_merge(request()->except('page'), ['category' => $category->slug])) }}" 
                                       class="block text-sm transition-colors {{ request('category') == $category->slug ? 'text-theme-primary font-bold' : 'text-gray-600 hover:text-theme-primary' }}">
                                        {{ $category->name }}
                                    </a>
                                    
                                    @if($category->children->count() > 0)
                                        <ul class="pl-4 mt-2 space-y-2 border-l border-gray-100 ml-1">
                                            @foreach($category->children as $child)
                                                <li>
                                                    <a href="{{ route('shop', array_merge(request()->except('page'), ['category' => $child->slug])) }}" 
                                                       class="block text-sm transition-colors {{ request('category') == $child->slug ? 'text-theme-primary font-bold' : 'text-gray-500 hover:text-theme-primary' }}">
                                                        {{ $child->name }}
                                                    </a>
                                                </li>
                                            @endforeach
                                        </ul>
                                    @endif
                                </li>
                            @endforeach
                        </ul>
                    </div>

                    <form action="{{ route('shop') }}" method="GET" id="desktopFilterForm">
                        <!-- Hidden Inputs -->
                        @if(request('category')) <input type="hidden" name="category" value="{{ request('category') }}"> @endif
                        @if(request('brand')) <input type="hidden" name="brand" value="{{ request('brand') }}"> @endif
                        @if(request('search')) <input type="hidden" name="search" value="{{ request('search') }}"> @endif
                        @if(request('sort')) <input type="hidden" name="sort" value="{{ request('sort') }}"> @endif

                        <!-- Availability -->
                        <div class="border-t border-gray-100 pt-6 mt-6">
                            <h3 class="text-lg font-medium text-gray-900 mb-4 flex justify-between items-center cursor-pointer group" onclick="document.getElementById('availability-options').classList.toggle('hidden'); document.getElementById('availability-icon').classList.toggle('rotate-180');">
                                Availability
                                <i id="availability-icon" class="fas fa-chevron-up text-xs text-gray-400 group-hover:text-theme-primary transition-transform duration-300"></i>
                            </h3>
                            <div id="availability-options" class="space-y-3">
                                <label class="flex items-center cursor-pointer group">
                                    <input type="checkbox" name="availability[]" value="in_stock" 
                                           class="w-5 h-5 rounded border-gray-300 text-theme-primary focus:ring-theme-primary transition-all duration-200 cursor-pointer" 
                                           {{ in_array('in_stock', (array)request('availability')) ? 'checked' : '' }} 
                                           onchange="this.form.submit()">
                                    <span class="ml-3 text-gray-600 group-hover:text-theme-primary transition-colors">In stock</span>
                                </label>
                                <label class="flex items-center cursor-pointer group">
                                    <input type="checkbox" name="availability[]" value="out_of_stock" 
                                           class="w-5 h-5 rounded border-gray-300 text-theme-primary focus:ring-theme-primary transition-all duration-200 cursor-pointer" 
                                           {{ in_array('out_of_stock', (array)request('availability')) ? 'checked' : '' }} 
                                           onchange="this.form.submit()">
                                    <span class="ml-3 text-gray-600 group-hover:text-theme-primary transition-colors">Out of stock</span>
                                </label>
                            </div>
                        </div>

                        <!-- Price -->
                        <div class="border-t border-gray-100 pt-6 mt-6">
                            <h3 class="text-lg font-medium text-gray-900 mb-4 flex justify-between items-center cursor-pointer group" onclick="document.getElementById('price-options').classList.toggle('hidden'); document.getElementById('price-icon').classList.toggle('rotate-180');">
                                Price
                                <i id="price-icon" class="fas fa-chevron-up text-xs text-gray-400 group-hover:text-theme-primary transition-transform duration-300"></i>
                            </h3>
                            <div id="price-options">
                                <div class="mb-6 px-1">
                                    <input type="range" min="{{ $minPrice }}" max="{{ $maxPrice }}" step="10"
                                           value="{{ request('max_price', $maxPrice) }}" 
                                           class="w-full h-1 bg-gray-200 rounded-lg appearance-none cursor-pointer accent-theme-primary"
                                           oninput="document.querySelector('#desktopFilterForm input[name=max_price]').value = this.value">
                                </div>
                                
                                <div class="flex items-center gap-4">
                                    <div class="relative flex-1">
                                        <span class="absolute left-3 top-1/2 -translate-y-1/2 text-gray-500 text-sm">৳</span>
                                        <input type="number" name="min_price" value="{{ request('min_price', 0) }}" 
                                               class="w-full pl-7 pr-2 py-2 border border-transparent bg-theme-primary-light rounded text-gray-700 text-sm focus:outline-none focus:bg-white focus:border-theme-primary focus:ring-1 focus:ring-theme-primary transition-all" 
                                               placeholder="0">
                                    </div>
                                    <span class="text-gray-500 text-sm font-medium">To</span>
                                    <div class="relative flex-1">
                                        <span class="absolute left-3 top-1/2 -translate-y-1/2 text-gray-500 text-sm">৳</span>
                                        <input type="number" name="max_price" value="{{ request('max_price', $maxPrice) }}" 
                                               class="w-full pl-7 pr-2 py-2 border border-transparent bg-theme-primary-light rounded text-gray-700 text-sm focus:outline-none focus:bg-white focus:border-theme-primary focus:ring-1 focus:ring-theme-primary transition-all" 
                                               placeholder="{{ $maxPrice }}">
                                    </div>
                                </div>
                                <button type="submit" class="mt-4 w-full bg-theme-primary text-white py-2.5 rounded text-sm font-bold uppercase tracking-wider hover:bg-theme-primary-hover transition-all duration-300 shadow-lg shadow-gray-200">
                                    Apply Filter
                                </button>
                            </div>
                        </div>
                    </form>
                </div>

                <!-- Product Grid -->
                <div class="w-full md:w-3/4">
                    
                    <!-- Desktop Sorting & Results Count -->
                    <div class="hidden md:flex flex-col sm:flex-row justify-between items-center mb-8 bg-gray-50 p-4 rounded-2xl">
                        <p class="text-sm text-gray-600 font-medium mb-4 sm:mb-0">মোট <span class="text-theme-primary font-bold">{{ $products->total() }}</span> টি পণ্যের মধ্যে <span class="text-theme-primary font-bold">{{ $products->firstItem() ?? 0 }}-{{ $products->lastItem() ?? 0 }}</span> দেখানো হচ্ছে</p>
                        
                        <div class="flex items-center">
                            <label for="sort" class="mr-3 text-sm text-gray-600 font-medium">সাজান:</label>
                            <div class="relative">
                                <select onchange="location = this.value;" class="appearance-none bg-white border-0 rounded-xl py-2 pl-4 pr-10 text-sm font-medium text-gray-700 shadow-sm focus:ring-2 focus:ring-theme-primary cursor-pointer outline-none">
                                    <option value="{{ route('shop', array_merge(request()->query(), ['sort' => 'newest'])) }}" {{ request('sort') == 'newest' ? 'selected' : '' }}>নতুন</option>
                                    <option value="{{ route('shop', array_merge(request()->query(), ['sort' => 'price_asc'])) }}" {{ request('sort') == 'price_asc' ? 'selected' : '' }}>দাম: কম থেকে বেশি</option>
                                    <option value="{{ route('shop', array_merge(request()->query(), ['sort' => 'price_desc'])) }}" {{ request('sort') == 'price_desc' ? 'selected' : '' }}>দাম: বেশি থেকে কম</option>
                                </select>
                                <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-500">
                                    <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path></svg>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="grid grid-cols-2 lg:grid-cols-3 gap-3 md:gap-6">
                        @forelse($products as $product)
                            <div class="bg-white rounded-lg border border-gray-100 p-2 md:p-3 hover:shadow-lg transition-all duration-300 flex flex-col h-full relative group">
                                <!-- Badge -->
                                @if($product->offer_price)
                                    <div class="absolute top-2 right-2 z-10">
                                        <span class="bg-red-500 text-white text-[10px] font-bold px-2 py-1 rounded-full shadow-sm">
                                            -{{ round((($product->price - $product->offer_price) / $product->price) * 100) }}%
                                        </span>
                                    </div>
                                    <div class="absolute top-2 left-2 z-10">
                                        <span class="bg-theme-primary text-white text-[10px] font-bold px-2 py-1 rounded-sm shadow-sm">ছাড়</span>
                                    </div>
                                @endif

                                <!-- Image -->
                                <div class="relative aspect-square overflow-hidden mb-2 md:mb-3">
                                    <a href="{{ route('product.show', $product->slug) }}" class="block w-full h-full flex items-center justify-center">
                                        @if($product->thumbnail)
                                            <img src="{{ Storage::url($product->thumbnail) }}" alt="{{ $product->name }}" class="max-w-full max-h-full object-contain transform group-hover:scale-105 transition-transform duration-500">
                                        @else
                                            <div class="w-full h-full flex items-center justify-center text-gray-200 bg-gray-50">
                                                <i class="fas fa-image text-3xl"></i>
                                            </div>
                                        @endif
                                    </a>
                                </div>
                                
                                <!-- Content -->
                                <div class="flex flex-col flex-grow text-center">
                                    <h3 class="text-xs md:text-sm font-medium text-gray-800 mb-1 md:mb-2 line-clamp-2 hover:text-theme-primary transition-colors">
                                        <a href="{{ route('product.show', $product->slug) }}">{{ $product->name }}</a>
                                    </h3>
                                    
                                    <div class="mt-auto mb-2 md:mb-3">
                                        @if($product->offer_price)
                                            <div class="flex items-center justify-center gap-2">
                                                <span class="text-sm font-bold text-gray-900">৳{{ number_format($product->offer_price, 0) }}</span>
                                                <span class="text-xs text-gray-400 line-through">৳{{ number_format($product->price, 0) }}</span>
                                            </div>
                                        @else
                                            <span class="text-sm font-bold text-gray-900">৳{{ number_format($product->price, 0) }}</span>
                                        @endif
                                    </div>
                                    
                                    <!-- Quick Add Button -->
                                    <form action="{{ route('cart.add') }}" method="POST" class="w-full">
                                        @csrf
                                        <input type="hidden" name="product_id" value="{{ $product->id }}">
                                        <input type="hidden" name="quantity" value="1">
                                        <button type="submit" name="buy_now" value="1" class="w-full bg-theme-primary hover:bg-theme-primary-hover text-white text-xs md:text-sm font-bold py-1.5 md:py-2 rounded transition-colors duration-300">
                                            অর্ডার করুন
                                        </button>
                                    </form>
                                </div>
                            </div>
                        @empty
                            <div class="col-span-full text-center py-24 bg-gray-50 rounded-3xl">
                                <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-gray-200 mb-4">
                                    <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
                                </div>
                                <h3 class="text-lg font-bold text-gray-900 mb-2">কোনো পণ্য পাওয়া যায়নি</h3>
                                <p class="text-gray-500 mb-6">অন্য কোনো কিওয়ার্ড দিয়ে খুঁজুন বা ফিল্টার পরিবর্তন করুন।</p>
                                <a href="{{ route('shop') }}" class="inline-block px-6 py-2.5 bg-theme-primary text-white font-bold rounded-xl hover:bg-theme-primary-hover transition-colors shadow-lg">সব ফিল্টার মুছুন</a>
                            </div>
                        @endforelse
                    </div>

                    <div class="mt-8 md:mt-12">
                        {{ $products->links() }}
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Filter Drawer (Off-canvas) -->
    <div id="mobileFilterDrawer" class="fixed inset-0 z-50 hidden md:hidden">
        <!-- Backdrop -->
        <div class="absolute inset-0 bg-black/50 transition-opacity" onclick="closeMobileFilters()"></div>
        
        <!-- Drawer Content -->
        <div class="absolute left-0 top-0 bottom-0 w-[85%] max-w-sm bg-white shadow-xl transform transition-transform duration-300 -translate-x-full" id="mobileFilterContent">
            <div class="flex items-center justify-between p-4 border-b border-gray-100">
                <h2 class="text-lg font-bold text-gray-900">Filter</h2>
                <button onclick="closeMobileFilters()" class="text-gray-500 hover:text-red-500 transition-colors">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            
            <div class="p-4 overflow-y-auto h-[calc(100%-60px)]">
                <!-- Mobile Filters -->
                <form action="{{ route('shop') }}" method="GET" id="mobileFilterForm">
                    <!-- Same filters as desktop but styled for mobile -->
                    @if(request('category')) <input type="hidden" name="category" value="{{ request('category') }}"> @endif
                    @if(request('brand')) <input type="hidden" name="brand" value="{{ request('brand') }}"> @endif
                    @if(request('search')) <input type="hidden" name="search" value="{{ request('search') }}"> @endif
                    @if(request('sort')) <input type="hidden" name="sort" value="{{ request('sort') }}"> @endif
                    
                    <!-- Availability -->
                    <div class="mb-6">
                        <h3 class="font-medium text-gray-900 mb-3">Availability</h3>
                        <div class="space-y-3">
                            <label class="flex items-center">
                                <input type="checkbox" name="availability[]" value="in_stock" 
                                        class="w-5 h-5 rounded border-gray-300 text-theme-primary focus:ring-theme-primary"
                                        {{ in_array('in_stock', (array)request('availability')) ? 'checked' : '' }}>
                                <span class="ml-3 text-gray-600">In stock</span>
                            </label>
                            <label class="flex items-center">
                                <input type="checkbox" name="availability[]" value="out_of_stock" 
                                        class="w-5 h-5 rounded border-gray-300 text-theme-primary focus:ring-theme-primary"
                                        {{ in_array('out_of_stock', (array)request('availability')) ? 'checked' : '' }}>
                                <span class="ml-3 text-gray-600">Out of stock</span>
                            </label>
                        </div>
                    </div>

                    <!-- Price -->
                    <div class="mb-6">
                        <h3 class="font-medium text-gray-900 mb-3">Price Range</h3>
                        <div class="flex items-center gap-4 mb-4">
                            <div class="relative flex-1">
                                <span class="absolute left-3 top-1/2 -translate-y-1/2 text-gray-500 text-sm">৳</span>
                                <input type="number" name="min_price" value="{{ request('min_price', 0) }}" 
                                        class="w-full pl-7 pr-2 py-2 border border-gray-200 rounded text-sm">
                            </div>
                            <span class="text-gray-500">to</span>
                            <div class="relative flex-1">
                                <span class="absolute left-3 top-1/2 -translate-y-1/2 text-gray-500 text-sm">৳</span>
                                <input type="number" name="max_price" value="{{ request('max_price', $maxPrice) }}" 
                                        class="w-full pl-7 pr-2 py-2 border border-gray-200 rounded text-sm">
                            </div>
                        </div>
                    </div>
                    
                    <button type="submit" class="w-full bg-theme-primary text-white py-3 rounded-lg font-bold shadow-lg">
                        Apply Filters
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Mobile Sort Drawer -->
    <div id="mobileSortDrawer" class="fixed inset-0 z-50 hidden md:hidden">
        <div class="absolute inset-0 bg-black/50 transition-opacity" onclick="closeMobileSort()"></div>
        <div class="absolute left-0 bottom-0 w-full bg-white rounded-t-2xl shadow-xl transform transition-transform duration-300 translate-y-full" id="mobileSortContent">
            <div class="p-4 border-b border-gray-100 flex justify-between items-center">
                <h2 class="text-lg font-bold text-gray-900">Sort By</h2>
                <button onclick="closeMobileSort()" class="text-gray-500"><i class="fas fa-times"></i></button>
            </div>
            <div class="p-4 space-y-2">
                <button onclick="location='{{ route('shop', array_merge(request()->query(), ['sort' => 'newest'])) }}'" class="w-full text-left py-3 px-4 rounded-lg {{ request('sort') == 'newest' ? 'bg-theme-primary/10 text-theme-primary font-bold' : 'text-gray-700' }}">
                    Featured / Newest
                </button>
                <button onclick="location='{{ route('shop', array_merge(request()->query(), ['sort' => 'price_asc'])) }}'" class="w-full text-left py-3 px-4 rounded-lg {{ request('sort') == 'price_asc' ? 'bg-theme-primary/10 text-theme-primary font-bold' : 'text-gray-700' }}">
                    Price: Low to High
                </button>
                <button onclick="location='{{ route('shop', array_merge(request()->query(), ['sort' => 'price_desc'])) }}'" class="w-full text-left py-3 px-4 rounded-lg {{ request('sort') == 'price_desc' ? 'bg-theme-primary/10 text-theme-primary font-bold' : 'text-gray-700' }}">
                    Price: High to Low
                </button>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        // Mobile Filter Drawer
        function openMobileFilters() {
            const drawer = document.getElementById('mobileFilterDrawer');
            const content = document.getElementById('mobileFilterContent');
            drawer.classList.remove('hidden');
            setTimeout(() => {
                content.classList.remove('-translate-x-full');
            }, 10);
        }

        function closeMobileFilters() {
            const drawer = document.getElementById('mobileFilterDrawer');
            const content = document.getElementById('mobileFilterContent');
            content.classList.add('-translate-x-full');
            setTimeout(() => {
                drawer.classList.add('hidden');
            }, 300);
        }

        // Mobile Sort Drawer
        function openMobileSort() {
            const drawer = document.getElementById('mobileSortDrawer');
            const content = document.getElementById('mobileSortContent');
            drawer.classList.remove('hidden');
            setTimeout(() => {
                content.classList.remove('translate-y-full');
            }, 10);
        }

        function closeMobileSort() {
            const drawer = document.getElementById('mobileSortDrawer');
            const content = document.getElementById('mobileSortContent');
            content.classList.add('translate-y-full');
            setTimeout(() => {
                drawer.classList.add('hidden');
            }, 300);
        }
        
        // Search Event Tracking
        document.addEventListener("DOMContentLoaded", function() {
            var searchString = "{{ request('search') }}";
            var eventId = "{{ $searchEventId ?? '' }}";
            
            if(searchString) {
                // Facebook Search Event
                var maxAttempts = 20;
                var attempt = 0;
                var fbInterval = setInterval(function() {
                    if (typeof fbq === 'function') {
                        clearInterval(fbInterval);
                        var params = {
                            search_string: searchString
                        };
                        var eventOptions = eventId ? {eventID: eventId} : {};
                        
                        fbq('track', 'Search', params, eventOptions);
                        console.log('Facebook Pixel: Search Event Fired' + (eventId ? ' with ID: ' + eventId : ''));
                    } else {
                        attempt++;
                        if (attempt >= maxAttempts) clearInterval(fbInterval);
                    }
                }, 500);

                // TikTok Search Event
                var ttAttempt = 0;
                var ttInterval = setInterval(function() {
                    if (typeof ttq !== 'undefined' && typeof ttq.track === 'function') {
                        clearInterval(ttInterval);
                        var params = {
                            query: searchString
                        };
                        var eventOptions = eventId ? {event_id: eventId} : {};
                        
                        ttq.track('Search', params, eventOptions);
                        console.log('TikTok Pixel: Search Event Fired' + (eventId ? ' with ID: ' + eventId : ''));
                    } else {
                        ttAttempt++;
                        if (ttAttempt >= maxAttempts) clearInterval(ttInterval);
                    }
                }, 500);
            }
        });
    </script>
    @endpush
</x-frontend-layout>