<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>bKash Payment Simulator</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; }
        h1, h2, h3, .font-heading { font-family: 'Outfit', sans-serif; }
    </style>
</head>
<body class="bg-gray-50 flex items-center justify-center min-h-screen">
    <div class="bg-white p-8 rounded-2xl shadow-xl max-w-md w-full border-t-8 border-pink-500">
        <div class="text-center mb-8">
            <div class="inline-block p-4 rounded-full bg-pink-50 mb-4 animate-bounce">
                <svg class="w-12 h-12 text-pink-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                </svg>
            </div>
            <h1 class="text-3xl font-heading font-bold text-gray-900">bKash Payment</h1>
            <p class="text-gray-500 mt-2 font-medium">Simulator / Sandbox Mode</p>
        </div>

        <div class="bg-pink-50/50 p-6 rounded-xl border border-pink-100 mb-8">
            <div class="flex justify-between mb-3">
                <span class="text-gray-600 font-medium">মার্চেন্ট</span>
                <span class="font-bold text-gray-900">Ghorer Bazar</span>
            </div>
            <div class="flex justify-between mb-3">
                <span class="text-gray-600 font-medium">ইনভয়েস</span>
                <span class="font-bold text-gray-900">{{ $order->order_number }}</span>
            </div>
            <div class="flex justify-between pt-3 border-t border-pink-200">
                <span class="text-gray-600 font-bold">পরিমাণ</span>
                <span class="font-heading font-bold text-2xl text-pink-600">৳{{ number_format($order->total_amount, 2) }}</span>
            </div>
        </div>

        <div class="space-y-4">
            <form action="{{ route('payment.bkash.callback') }}" method="POST">
                @csrf
                <input type="hidden" name="order_id" value="{{ $order->id }}">
                <input type="hidden" name="status" value="success">
                <button type="submit" class="w-full bg-pink-600 hover:bg-pink-700 text-white font-bold py-3.5 px-4 rounded-xl transition-all duration-300 shadow-lg shadow-pink-600/20 transform active:scale-95 flex items-center justify-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                    পেমেন্ট নিশ্চিত করুন
                </button>
            </form>

            <form action="{{ route('payment.bkash.callback') }}" method="POST">
                @csrf
                <input type="hidden" name="order_id" value="{{ $order->id }}">
                <input type="hidden" name="status" value="failure">
                <button type="submit" class="w-full bg-white border border-gray-200 hover:bg-gray-50 text-gray-700 font-bold py-3.5 px-4 rounded-xl transition-all duration-300 flex items-center justify-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                    ট্রানজেকশন বাতিল করুন
                </button>
            </form>
        </div>

        <div class="mt-8 text-center text-xs text-gray-400 font-medium">
            <p>Secured by bKash | Do not use real credentials</p>
        </div>
    </div>
</body>
</html>
