<x-frontend-layout>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20">
        <!-- Header -->
        <div class="mb-16 border-b border-gray-100 pb-8 flex flex-col md:flex-row justify-between items-start md:items-end gap-6">
            <div>
                <a href="{{ route('dashboard') }}" class="text-xs font-bold text-gray-400 uppercase tracking-widest hover:text-black mb-4 inline-block transition-colors duration-300">
                    &larr; অর্ডার তালিকায় ফিরে যান
                </a>
                <h1 class="text-4xl md:text-5xl font-heading font-bold text-black tracking-tight">
                    অর্ডার <span class="text-gray-400">#{{ $order->order_number }}</span>
                </h1>
                <p class="text-gray-500 text-sm mt-2">অর্ডারের তারিখ: {{ $order->created_at->format('M d, Y h:i A') }}</p>
            </div>
            
            <div>
                <span class="inline-flex items-center px-6 py-2 border border-theme-primary text-theme-primary bg-transparent text-xs font-bold uppercase tracking-widest rounded-full">
                    @php
                        $statusMap = [
                            'pending' => 'অপেক্ষমান',
                            'processing' => 'প্রক্রিয়াধীন',
                            'completed' => 'সম্পন্ন',
                            'cancelled' => 'বাতিল',
                            'shipped' => 'শিপড',
                        ];
                    @endphp
                    {{ $statusMap[$order->status] ?? $order->status }}
                </span>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-16">
            <!-- Left Column: Order Items -->
            <div class="lg:col-span-2">
                <h2 class="text-xl font-heading font-bold mb-8 text-black">অর্ডার করা পণ্যসমূহ</h2>
                <div class="space-y-10">
                    @foreach($order->items as $item)
                        <div class="flex items-start gap-6 group">
                            <!-- Image -->
                            <div class="w-24 h-32 bg-gray-50 flex-shrink-0 overflow-hidden relative">
                                @if($item->product && $item->product->thumbnail)
                                    <img class="w-full h-full object-cover object-center transition-transform duration-700 group-hover:scale-105" src="{{ Storage::url($item->product->thumbnail) }}" alt="{{ $item->product->name }}">
                                @else
                                    <div class="w-full h-full flex items-center justify-center text-gray-300 text-xs uppercase tracking-wider">ছবি নেই</div>
                                @endif
                            </div>
                            
                            <!-- Details -->
                            <div class="flex-1 min-w-0">
                                <div class="flex justify-between items-start">
                                    <div>
                                        <h3 class="font-heading text-lg font-medium text-black truncate pr-4">{{ $item->product ? $item->product->name : 'পণ্য পাওয়া যাচ্ছে না' }}</h3>
                                        <div class="mt-2 space-y-1">
                                            @if($item->color_id) 
                                                <p class="text-xs text-gray-500 uppercase tracking-wide">কালার: <span class="text-black">{{ $item->color->name ?? 'N/A' }}</span></p> 
                                            @endif
                                            @if($item->size_id) 
                                                <p class="text-xs text-gray-500 uppercase tracking-wide">সাইজ: <span class="text-black">{{ $item->size->name ?? 'N/A' }}</span></p> 
                                            @endif
                                            <p class="text-xs text-gray-500 uppercase tracking-wide">পরিমাণ: <span class="text-black">{{ $item->quantity }}</span></p>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <p class="font-medium text-black">৳{{ number_format($item->price * $item->quantity, 0) }}</p>
                                        @if($item->quantity > 1)
                                            <p class="text-xs text-gray-400 mt-1">৳{{ number_format($item->price, 0) }} প্রতিটি</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Right Column: Summary & Info -->
            <div class="lg:col-span-1 space-y-12">
                <!-- Order Summary -->
                <div class="bg-gray-50 p-10">
                    <h3 class="font-heading font-bold text-lg mb-8 text-black border-b border-gray-200 pb-4">সামারি</h3>
                    <div class="space-y-4 text-sm">
                        <div class="flex justify-between text-gray-600">
                            <span>সাবটোটাল</span>
                            <span class="font-medium text-black">৳{{ number_format($order->total_amount, 0) }}</span>
                        </div>
                        <div class="flex justify-between text-gray-600">
                            <span>ডেলিভারি চার্জ</span>
                            <span class="font-medium text-black">ফ্রি</span>
                        </div>
                        <div class="pt-4 border-t border-gray-200 flex justify-between items-center">
                            <span class="font-bold text-black uppercase tracking-wider text-xs">মোট</span>
                            <span class="font-heading text-2xl text-black font-bold">৳{{ number_format($order->total_amount, 0) }}</span>
                        </div>
                    </div>
                </div>

                <!-- Shipping & Payment Info -->
                <div class="grid grid-cols-1 gap-8">
                    <div>
                        <h3 class="font-heading font-bold text-lg mb-4 text-black">ডেলিভারি ঠিকানা</h3>
                        <address class="not-italic text-sm text-gray-600 leading-relaxed">
                            <span class="block text-black font-medium mb-1">{{ $order->first_name }} {{ $order->last_name }}</span>
                            {{ $order->address }}<br>
                            {{ $order->city }}, {{ $order->postal_code }}<br>
                            <span class="block mt-2 text-gray-500">{{ $order->email }}</span>
                            <span class="block text-gray-500">{{ $order->phone }}</span>
                        </address>
                    </div>

                    <div>
                        <h3 class="font-heading font-bold text-lg mb-4 text-black">পেমেন্ট তথ্য</h3>
                        <div class="text-sm text-gray-600 space-y-2">
                            @php
                                $paymentMethodMap = [
                                    'cod' => 'ক্যাশ অন ডেলিভারি',
                                    'bkash' => 'বিকাশ',
                                    'sslcommerz' => 'এসএসএল কমার্স',
                                ];
                                $paymentStatusMap = [
                                    'paid' => 'পরিশোধিত',
                                    'unpaid' => 'অপরিশোধিত',
                                    'pending' => 'অপেক্ষমান',
                                ];
                            @endphp
                            <p>মেথড: <span class="text-black font-medium">{{ $paymentMethodMap[$order->payment_method] ?? ucfirst($order->payment_method) }}</span></p>
                            <p>স্ট্যাটাস: 
                                <span class="inline-flex items-center px-6 py-2 border border-theme-primary text-theme-primary bg-transparent text-xs font-bold uppercase tracking-widest rounded-full">
                                    {{ $paymentStatusMap[$order->payment_status] ?? ucfirst($order->payment_status) }}
                                </span>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-frontend-layout>