<x-frontend-layout>
<div class="bg-gray-50 min-h-screen py-10">
    <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
        
        <!-- Tracking Form Card -->
        <div class="bg-white rounded-2xl shadow-sm p-8 mb-8 border border-gray-100">
            <div class="text-center mb-8">
                <div class="w-16 h-16 bg-orange-50 rounded-full flex items-center justify-center mx-auto mb-4 text-theme-primary">
                    <i class="fas fa-search-location text-2xl text-orange-500"></i>
                </div>
                <h1 class="text-2xl font-bold text-gray-900 mb-2 font-heading">অর্ডার ট্র্যাকিং</h1>
                <p class="text-gray-500">আপনার অর্ডারের বর্তমান অবস্থা জানতে অর্ডার আইডি অথবা ফোন নাম্বার দিন</p>
            </div>

            <form action="{{ route('order.track') }}" method="POST" class="max-w-lg mx-auto">
                @csrf
                <div class="relative">
                    <input type="text" name="track_code" 
                        class="w-full pl-12 pr-4 py-4 rounded-xl border-2 border-gray-100 focus:border-theme-primary focus:ring-0 text-lg transition-all outline-none"
                        placeholder="অর্ডার আইডি / ফোন নাম্বার"
                        value="{{ request('track_code') }}"
                        required>
                    <div class="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400">
                        <i class="fas fa-barcode text-xl"></i>
                    </div>
                </div>
                
                @error('track_code')
                    <p class="text-red-500 text-sm mt-2 text-center">{{ $message }}</p>
                @enderror

                @if(session('error'))
                    <div class="mt-4 p-4 bg-red-50 text-red-600 rounded-xl text-center text-sm font-medium border border-red-100">
                        <i class="fas fa-exclamation-circle mr-2"></i> {{ session('error') }}
                    </div>
                @endif

                <button type="submit" class="w-full mt-6 bg-theme-primary text-white font-bold py-4 rounded-xl hover:bg-orange-600 transition-all shadow-lg shadow-orange-500/30 flex items-center justify-center gap-2 font-heading">
                    <span>ট্র্যাক করুন</span>
                    <i class="fas fa-arrow-right"></i>
                </button>
            </form>
        </div>

        <!-- Order Details Result -->
        @if(isset($order))
            <div class="bg-white rounded-2xl shadow-sm overflow-hidden border border-gray-100 animate-fade-in-up">
                <!-- Header -->
                <div class="bg-orange-50 px-6 py-4 border-b border-orange-100 flex justify-between items-center flex-wrap gap-4">
                    <div>
                        <span class="text-sm text-gray-500 block">অর্ডার আইডি</span>
                        <span class="text-lg font-bold text-gray-900 font-heading">#{{ $order->order_number }}</span>
                    </div>
                    <div class="text-right">
                        <span class="text-sm text-gray-500 block">অর্ডার স্ট্যাটাস</span>
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-bold
                            @if($order->status == 'pending') bg-yellow-100 text-yellow-800
                            @elseif($order->status == 'processing') bg-blue-100 text-blue-800
                            @elseif($order->status == 'completed') bg-green-100 text-green-800
                            @elseif($order->status == 'cancelled') bg-red-100 text-red-800
                            @else bg-gray-100 text-gray-800 @endif">
                            @if($order->status == 'pending') পেন্ডিং
                            @elseif($order->status == 'processing') প্রসেসিং
                            @elseif($order->status == 'on_delivery') অন ডেলিভারি
                            @elseif($order->status == 'completed') সম্পন্ন হয়েছে
                            @elseif($order->status == 'cancelled') বাতিল হয়েছে
                            @else {{ ucfirst($order->status) }} @endif
                        </span>
                    </div>
                </div>

                <!-- Progress Bar -->
                <div class="px-8 py-8">
                    <div class="relative">
                        <!-- Progress Track -->
                        <div class="absolute top-1/2 left-0 w-full h-1 bg-gray-200 -translate-y-1/2 z-0"></div>
                        <div class="absolute top-1/2 left-0 h-1 bg-theme-primary -translate-y-1/2 z-0 transition-all duration-1000"
                            style="width: 
                            @if($order->status == 'pending') 25% 
                            @elseif($order->status == 'processing') 50%
                            @elseif($order->status == 'on_delivery') 75%
                            @elseif($order->status == 'completed') 100%
                            @else 0% @endif">
                        </div>

                        <!-- Steps -->
                        <div class="relative z-10 flex justify-between w-full">
                            <!-- Step 1: Pending -->
                            <div class="flex flex-col items-center gap-2">
                                <div class="w-8 h-8 rounded-full flex items-center justify-center border-2 
                                    {{ in_array($order->status, ['pending', 'processing', 'on_delivery', 'completed']) ? 'bg-theme-primary border-theme-primary text-white' : 'bg-white border-gray-300 text-gray-400' }}">
                                    <i class="fas fa-clipboard-list text-xs"></i>
                                </div>
                                <span class="text-xs font-bold {{ in_array($order->status, ['pending', 'processing', 'on_delivery', 'completed']) ? 'text-theme-primary' : 'text-gray-400' }}">অর্ডার প্লেসড</span>
                            </div>

                            <!-- Step 2: Processing -->
                            <div class="flex flex-col items-center gap-2">
                                <div class="w-8 h-8 rounded-full flex items-center justify-center border-2 
                                    {{ in_array($order->status, ['processing', 'on_delivery', 'completed']) ? 'bg-theme-primary border-theme-primary text-white' : 'bg-white border-gray-300 text-gray-400' }}">
                                    <i class="fas fa-cog text-xs"></i>
                                </div>
                                <span class="text-xs font-bold {{ in_array($order->status, ['processing', 'on_delivery', 'completed']) ? 'text-theme-primary' : 'text-gray-400' }}">প্রসেসিং</span>
                            </div>

                            <!-- Step 3: On Delivery -->
                            <div class="flex flex-col items-center gap-2">
                                <div class="w-8 h-8 rounded-full flex items-center justify-center border-2 
                                    {{ in_array($order->status, ['on_delivery', 'completed']) ? 'bg-theme-primary border-theme-primary text-white' : 'bg-white border-gray-300 text-gray-400' }}">
                                    <i class="fas fa-truck text-xs"></i>
                                </div>
                                <span class="text-xs font-bold {{ in_array($order->status, ['on_delivery', 'completed']) ? 'text-theme-primary' : 'text-gray-400' }}">অন ডেলিভারি</span>
                            </div>

                            <!-- Step 4: Completed -->
                            <div class="flex flex-col items-center gap-2">
                                <div class="w-8 h-8 rounded-full flex items-center justify-center border-2 
                                    {{ in_array($order->status, ['completed']) ? 'bg-theme-primary border-theme-primary text-white' : 'bg-white border-gray-300 text-gray-400' }}">
                                    <i class="fas fa-check text-xs"></i>
                                </div>
                                <span class="text-xs font-bold {{ in_array($order->status, ['completed']) ? 'text-theme-primary' : 'text-gray-400' }}">সম্পন্ন</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Order Items -->
                <div class="px-6 pb-6">
                    <h3 class="font-bold text-gray-900 mb-4 border-b pb-2">অর্ডারের পণ্যসমূহ</h3>
                    <div class="space-y-4">
                        @foreach($order->items as $item)
                        <div class="flex items-center gap-4 py-4 border-b border-gray-100 last:border-0">
                            <div class="w-16 h-16 rounded-lg bg-gray-100 overflow-hidden flex-shrink-0 border border-gray-200">
                                <img src="{{ asset($item->product->thumbnail ?? 'images/no-image.png') }}" 
                                     alt="{{ $item->product->name ?? 'Product' }}" 
                                     class="w-full h-full object-cover">
                            </div>
                            <div class="flex-1">
                                <h4 class="text-sm font-bold text-gray-900 line-clamp-2">{{ $item->product->name ?? 'Unknown Product' }}</h4>
                                <div class="text-xs text-gray-500 mt-1 space-x-2">
                                    @if(optional($item)->size) 
                                        <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-gray-100 text-gray-800">
                                            সাইজ: {{ $item->size }}
                                        </span> 
                                    @endif
                                    @if(optional($item)->color) 
                                        <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-gray-100 text-gray-800">
                                            কালার: {{ $item->color }}
                                        </span> 
                                    @endif
                                </div>
                                <div class="flex justify-between items-center mt-2">
                                    <span class="text-sm font-medium text-gray-500">{{ $item->quantity }} x ৳{{ number_format($item->price, 0) }}</span>
                                    <span class="text-sm font-bold text-gray-900">৳{{ number_format($item->price * $item->quantity, 0) }}</span>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    
                    <!-- Totals -->
                    <div class="mt-6 pt-4 border-t border-gray-100 space-y-3">
                        <div class="flex justify-between text-sm text-gray-600">
                            <span>সাবটোটাল</span>
                            <span class="font-medium">৳{{ number_format($order->total_amount - ($order->delivery_cost ?? 0) + ($order->discount_amount ?? 0), 0) }}</span>
                        </div>
                        <div class="flex justify-between text-sm text-gray-600">
                            <span>ডেলিভারি চার্জ</span>
                            <span class="font-medium">৳{{ number_format($order->delivery_cost ?? 0, 0) }}</span>
                        </div>
                        @if(($order->discount_amount ?? 0) > 0)
                        <div class="flex justify-between text-sm text-theme-primary">
                            <span>ডিসকাউন্ট</span>
                            <span class="font-medium">-৳{{ number_format($order->discount_amount, 0) }}</span>
                        </div>
                        @endif
                        <div class="flex justify-between text-base font-bold text-gray-900 pt-3 border-t border-dashed border-gray-200">
                            <span>সর্বমোট</span>
                            <span>৳{{ number_format($order->total_amount, 0) }}</span>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
</x-frontend-layout>