<footer class="bg-white border-t border-gray-200 font-sans mt-auto">
    <!-- Main Footer -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <!-- Brand Section -->
            <div class="space-y-6">
                <div class="flex items-center space-x-2">
                    @if(isset($generalSetting) && $generalSetting->dark_logo)
                        <img src="{{ Storage::url($generalSetting->dark_logo) }}" alt="{{ $generalSetting->name ?? 'GhorerBazar' }}" class="h-10 w-auto">
                    @else
                        <div class="flex items-center gap-2">
                            <i class="fas fa-leaf text-theme-primary text-2xl"></i>
                            <span class="text-xl font-bold text-gray-800 tracking-tight">{{ $generalSetting->name ?? 'GhorerBazar' }}</span>
                        </div>
                    @endif
                </div>
                <p class="text-gray-500 text-sm leading-relaxed">
                    অর্গানিক এবং নিরাপদ খাবারের বিশ্বস্ত উৎস। আপনার সুস্থ জীবনের জন্য আমরা সেরা মানের পণ্য নিশ্চিত করি।
                </p>
                <div class="flex space-x-3">
                    @if(isset($socialMedias))
                        @foreach($socialMedias as $social)
                            <a href="{{ $social->link }}" target="_blank" class="w-8 h-8 rounded-full flex items-center justify-center text-white hover:opacity-90 transition-colors" style="background-color: {{ $social->color }};">
                                <i class="{{ $social->icon }} text-sm"></i>
                            </a>
                        @endforeach
                    @endif
                </div>
            </div>

            <!-- Quick Help -->
            <div>
                <h3 class="text-gray-900 font-bold text-sm uppercase mb-4 tracking-wide">QUICK HELP</h3>
                <ul class="space-y-2.5">
                    <li><a href="#" class="text-gray-500 hover:text-theme-primary text-sm transition-colors">Help Center</a></li>
                    <li><a href="#" class="text-gray-500 hover:text-theme-primary text-sm transition-colors">Order History</a></li>
                    <li><a href="#" class="text-gray-500 hover:text-theme-primary text-sm transition-colors">Track Order</a></li>
                    <li><a href="#" class="text-gray-500 hover:text-theme-primary text-sm transition-colors">Contact Us</a></li>
                </ul>
            </div>

            <!-- Company -->
            <div>
                <h3 class="text-gray-900 font-bold text-sm uppercase mb-4 tracking-wide">COMPANY</h3>
                <ul class="space-y-2.5">
                    <li><a href="#" class="text-gray-500 hover:text-theme-primary text-sm transition-colors">About Us</a></li>
                    <li><a href="#" class="text-gray-500 hover:text-theme-primary text-sm transition-colors">Terms & Conditions</a></li>
                    <li><a href="#" class="text-gray-500 hover:text-theme-primary text-sm transition-colors">Privacy Policy</a></li>
                    <li><a href="#" class="text-gray-500 hover:text-theme-primary text-sm transition-colors">Return Policy</a></li>
                </ul>
            </div>

            <!-- Contact -->
            <div>
                <h3 class="text-gray-900 font-bold text-sm uppercase mb-4 tracking-wide">CONTACT US</h3>
                <ul class="space-y-3">
                    <li class="flex items-start gap-3 text-sm text-gray-500">
                        <i class="fas fa-map-marker-alt text-theme-primary mt-1"></i>
                        <span>{{ $contactSetting->address ?? 'South Banasree, Dhaka, Bangladesh' }}</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm text-gray-500">
                        <i class="fas fa-phone-alt text-theme-primary"></i>
                        <span>{{ $contactSetting->phone_number ?? '01611-557557' }}</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm text-gray-500">
                        <i class="fas fa-envelope text-theme-primary"></i>
                        <span>{{ $contactSetting->email ?? 'support@ghorerbazar.com' }}</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Bottom Footer -->
    <div class="bg-gray-50 py-4 border-t border-gray-200">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex flex-col md:flex-row justify-between items-center gap-4">
            <p class="text-gray-500 text-xs text-center md:text-left">
                &copy; {{ date('Y') }} {{ $generalSetting->name ?? 'GhorerBazar' }}. সর্বস্বত্ব সংরক্ষিত।
            </p>
            <div class="flex items-center gap-2">
                <span class="text-gray-400 text-xs">DBID ID : 437361334</span>
            </div>
        </div>
    </div>
</footer>