<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    @if(isset($gtmContainers) && $gtmContainers->count() > 0)
        @foreach($gtmContainers as $gtm)
        <!-- Google Tag Manager -->
        <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
        new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
        j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
        'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','{{ $gtm->gtm_id }}');</script>
        <!-- End Google Tag Manager -->
        @endforeach
    @elseif(isset($generalSetting) && $generalSetting->gtm_enabled && $generalSetting->gtm_id)
    <!-- Google Tag Manager -->
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
    j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
    'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
    })(window,document,'script','dataLayer','{{ $generalSetting->gtm_id }}');</script>
    <!-- End Google Tag Manager -->
    @endif

    @if(isset($tiktokPixels) && $tiktokPixels->count() > 0)
        <!-- TikTok Pixel -->
        <script>
        !function (w, d, t) {
          w.TiktokAnalyticsObject=t;var ttq=w[t]=w[t]||[];ttq.methods=["page","track","identify","instances","debug","on","off","once","ready","alias","group","enableCookie","disableCookie"],ttq.setAndDefer=function(t,e){t[e]=function(){t.push([e].concat(Array.prototype.slice.call(arguments,0)))}};for(var i=0;i<ttq.methods.length;i++)ttq.setAndDefer(ttq,ttq.methods[i]);ttq.instance=function(t){for(var e=ttq.methods[i=0];i<ttq.methods.length;i++)ttq.setAndDefer(e,ttq.methods[i]);return e},ttq.load=function(e,n){var i="https://analytics.tiktok.com/i18n/pixel/events.js";ttq._i=ttq._i||{},ttq._i[e]=[],ttq._i[e]._u=i,ttq._t=ttq._t||{},ttq._t[e]=+new Date,ttq._o=ttq._o||{},ttq._o[e]=n||{};var o=document.createElement("script");o.type="text/javascript",o.async=!0,o.src=i+"?sdkid="+e+"&lib="+t;var a=document.getElementsByTagName("script")[0];a.parentNode.insertBefore(o,a)};
        
          @foreach($tiktokPixels as $pixel)
          ttq.load('{{ $pixel->pixel_id }}');
          @endforeach
          ttq.page();
        }(window, document, 'ttq');
        </script>
        
        @if(session('tiktok_event'))
        <script>
            ttq.track('{{ session('tiktok_event')['name'] }}', {!! json_encode(session('tiktok_event')['params']) !!});
        </script>
        @endif
        <!-- End TikTok Pixel -->
    @endif

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ $generalSetting->name ?? config('app.name', 'Laravel') }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        body, .font-sans { font-family: 'Plus Jakarta Sans', sans-serif; }
        .font-heading { font-family: 'Outfit', sans-serif; }
    </style>
    
    <!-- AOS Animation CSS -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    @if(isset($generalSetting) && $generalSetting->facebook_verification_code)
        <meta name="facebook-domain-verification" content="{{ $generalSetting->facebook_verification_code }}" />
    @endif

    @if(isset($generalSetting) && $generalSetting->tiktok_verification_code)
        <meta name="tiktok-developers-site-verification" content="{{ $generalSetting->tiktok_verification_code }}" />
    @endif

    @if(isset($facebookPixels) && count($facebookPixels) > 0)
    <!-- Facebook Pixel Code -->
    <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
        n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t,s)}(window, document,'script',
        'https://connect.facebook.net/en_US/fbevents.js');
        
        @php
            $pixelInitData = [];
            if(auth()->check()) {
                $user = auth()->user();
                $pixelInitData = [
                    'em' => $user->email,
                    'ph' => $user->phone,
                    'external_id' => (string)$user->id
                ];
                if($user->name) {
                    $parts = explode(' ', $user->name, 2);
                    $pixelInitData['fn'] = $parts[0];
                    $pixelInitData['ln'] = $parts[1] ?? '';
                }
                $pixelInitData = array_filter($pixelInitData);
            }
        @endphp

        @foreach($facebookPixels as $pixel)
            @if(!empty($pixelInitData))
                fbq('init', '{{ $pixel->pixel_id }}', {!! json_encode($pixelInitData) !!});
            @else
                fbq('init', '{{ $pixel->pixel_id }}');
            @endif
        @endforeach
        
        fbq('track', 'PageView');
    </script>
    <noscript>
        @foreach($facebookPixels as $pixel)
            <img height="1" width="1" style="display:none"
            src="https://www.facebook.com/tr?id={{ $pixel->pixel_id }}&ev=PageView&noscript=1"
            />
        @endforeach
    </noscript>
    <!-- End Facebook Pixel Code -->
    @elseif(isset($generalSetting) && $generalSetting->facebook_pixel_enabled && $generalSetting->facebook_pixel_id)
        <!-- Meta Pixel Code (Legacy) -->
        <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
        n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t,s)}(window, document,'script',
        'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '{{ $generalSetting->facebook_pixel_id }}');
        fbq('track', 'PageView');
        </script>
        <noscript><img height="1" width="1" style="display:none"
        src="https://www.facebook.com/tr?id={{ $generalSetting->facebook_pixel_id }}&ev=PageView&noscript=1"
        /></noscript>
        <!-- End Meta Pixel Code -->
    @endif
</head>
<body class="font-sans antialiased text-gray-900 bg-white theme-{{ $generalSetting->theme ?? 'default' }}">
    @if(isset($gtmContainers) && $gtmContainers->count() > 0)
        @foreach($gtmContainers as $gtm)
        <!-- Google Tag Manager (noscript) -->
        <noscript><iframe src="https://www.googletagmanager.com/ns.html?id={{ $gtm->gtm_id }}"
        height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
        <!-- End Google Tag Manager (noscript) -->
        @endforeach
    @elseif(isset($generalSetting) && $generalSetting->gtm_enabled && $generalSetting->gtm_id)
    <!-- Google Tag Manager (noscript) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id={{ $generalSetting->gtm_id }}"
    height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->
    @endif
    
    <!-- Top Bar -->
    <div class="bg-theme-primary text-white py-2 text-xs md:text-sm font-medium tracking-wide">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex flex-col md:flex-row justify-center md:justify-between items-center gap-2 text-center">
            <span class="flex items-center gap-2">
                <i class="fas fa-phone-alt"></i>
                আমাদের যে কোন পণ্য অর্ডার করতে কল বা WhatsApp করুন: 
                <a href="tel:01611557557" class="font-bold hover:underline">+8801611-557557</a>
            </span>
            <span class="hidden md:inline font-bold">
                <i class="fas fa-headset mr-1"></i> হট লাইন: 09642-922922
            </span>
        </div>
    </div>

    <!-- Main Header -->
    <header class="bg-white sticky top-0 z-50 shadow-sm border-b border-gray-100" x-data="{ searchOpen: false, mobileMenuOpen: false }">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-20">
                
                <!-- Left: Search Icon (Desktop) & Mobile Menu -->
                <div class="flex items-center gap-4 flex-1">
                    <!-- Mobile Menu Button -->
                    <button @click="mobileMenuOpen = !mobileMenuOpen" class="md:hidden p-2 text-gray-600 hover:text-theme-primary transition-colors">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                    
                    <!-- Search Icon (Desktop) -->
                    <button @click="searchOpen = !searchOpen" class="hidden md:flex p-2 text-theme-primary hover:text-theme-primary transition-colors">
                        <i class="fas fa-search text-lg"></i>
                    </button>
                </div>

                <!-- Center: Logo -->
                <div class="flex-shrink-0 flex items-center justify-center flex-1">
                    <a href="{{ url('/') }}" class="flex flex-col items-center">
                        @if(isset($generalSetting) && $generalSetting->dark_logo)
                            <img src="{{ Storage::url($generalSetting->dark_logo) }}" alt="{{ $generalSetting->name ?? 'GhorerBazar' }}" class="h-20 w-auto object-contain">
                        @else
                            <div class="flex items-center gap-2">
                                <i class="fas fa-leaf text-theme-primary text-3xl"></i>
                                <span class="text-3xl font-bold text-gray-800 tracking-tight">{{ $generalSetting->name ?? 'GhorerBazar' }}</span>
                            </div>
                        @endif
                    </a>
                </div>

                <!-- Right: Icons -->
                <div class="flex items-center justify-end gap-4 md:gap-6 flex-1">
                    <!-- Mobile Search -->
                    <button @click="searchOpen = !searchOpen" class="md:hidden p-2 text-gray-600 hover:text-theme-primary">
                        <i class="fas fa-search text-lg"></i>
                    </button>

                    <!-- User Account -->
                    @auth
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open" class="text-gray-600 hover:text-theme-primary transition-colors">
                                <i class="far fa-user text-xl"></i>
                            </button>
                            <!-- Dropdown -->
                            <div x-show="open" @click.away="open = false" class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-xl border border-gray-100 py-1 z-50" style="display: none;">
                                <a href="{{ route('dashboard') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-theme-primary-light hover:text-theme-primary">আমার অর্ডার</a>
                                <a href="{{ route('profile.edit') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-theme-primary-light hover:text-theme-primary">প্রোফাইল</a>
                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <button type="submit" class="block w-full text-left px-4 py-2 text-sm text-red-600 hover:bg-red-50">লগআউট</button>
                                </form>
                            </div>
                        </div>
                    @else
                        <a href="{{ route('login') }}" class="text-gray-600 hover:text-theme-primary transition-colors">
                            <i class="far fa-user text-xl"></i>
                        </a>
                    @endauth

                    <!-- Cart -->
                    <a href="{{ route('cart.index') }}" class="text-gray-600 hover:text-theme-primary transition-colors relative">
                        <i class="fas fa-shopping-bag text-xl"></i>
                        <span class="absolute -top-2 -right-2 bg-theme-primary text-white text-[10px] font-bold h-5 w-5 flex items-center justify-center rounded-full border-2 border-white">
                            {{ session('cart') ? count(session('cart')) : 0 }}
                        </span>
                    </a>
                </div>
            </div>

            <!-- Search Bar Overlay -->
            <div x-show="searchOpen" 
                 x-transition:enter="transition ease-out duration-200"
                 x-transition:enter-start="opacity-0 -translate-y-2"
                 x-transition:enter-end="opacity-100 translate-y-0"
                 class="absolute top-full left-0 w-full bg-white shadow-md border-t border-gray-100 p-4 z-40"
                 style="display: none;">
                <div class="max-w-3xl mx-auto relative">
                    <form action="{{ route('shop') }}" method="GET" class="relative" autocomplete="off">
                        <input type="text" 
                               name="search" 
                               id="desktopSearchInput"
                               placeholder="পণ্য খুঁজুন..." 
                               class="w-full pl-4 pr-12 py-3 bg-gray-50 border border-gray-200 rounded-lg focus:outline-none focus:border-theme-primary focus:ring-1 focus:ring-theme-primary" 
                               autocomplete="off">
                        
                        <!-- Loading Icon -->
                        <div class="absolute right-3 top-3">
                            <button type="submit" class="text-theme-primary" id="searchSubmitBtn">
                                <i class="fas fa-search text-xl"></i>
                            </button>
                            <span id="searchLoading" class="text-theme-primary hidden">
                                <i class="fas fa-spinner fa-spin text-xl"></i>
                            </span>
                        </div>
                    </form>

                    <!-- Suggestions Dropdown (Mega Menu Style) -->
                    <div id="searchSuggestions" class="absolute top-full left-1/2 transform -translate-x-1/2 w-[120%] bg-white shadow-2xl rounded-xl border border-gray-100 mt-2 z-[100] hidden overflow-hidden">
                        <!-- Content will be injected via JS -->
                    </div>
                </div>
            </div>
        </div>


        </div>

        <!-- Navigation Menu (Desktop) -->
        <div class="hidden md:block bg-gray-100 border-t border-gray-200">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-center space-x-8 py-3">
                    <a href="{{ route('shop', ['offer' => 'true']) }}" class="text-sm font-medium text-gray-700 hover:text-theme-primary uppercase tracking-wide">অফার জোন</a>
                    <a href="{{ route('shop', ['sort' => 'best_selling']) }}" class="text-sm font-medium text-gray-700 hover:text-theme-primary uppercase tracking-wide">বেস্ট সেলার</a>
                    <!-- Dynamic Categories -->
                    @foreach(\App\Models\Category::where('status', true)->take(6)->get() as $category)
                        <a href="{{ route('shop', ['category' => $category->slug]) }}" class="text-sm font-medium text-gray-700 hover:text-theme-primary uppercase tracking-wide">{{ $category->name }}</a>
                    @endforeach
                    <a href="{{ route('shop') }}" class="text-sm font-medium text-gray-700 hover:text-theme-primary uppercase tracking-wide">সব পণ্য</a>
                </div>
            </div>
        </div>

        <!-- Mobile Menu Sidebar -->
        <div x-show="mobileMenuOpen" class="fixed inset-0 z-50 md:hidden" style="display: none;">
            <!-- Backdrop -->
            <div @click="mobileMenuOpen = false" class="absolute inset-0 bg-black bg-opacity-50 transition-opacity"></div>
            
            <!-- Sidebar -->
            <div class="absolute inset-y-0 left-0 max-w-xs w-full bg-white shadow-xl transform transition-transform overflow-y-auto">
                <div class="p-4 border-b border-gray-100 flex justify-between items-center">
                    <span class="text-lg font-bold text-gray-900">মেনু</span>
                    <button @click="mobileMenuOpen = false" class="text-gray-500 hover:text-red-500">
                        <i class="fas fa-times text-xl"></i>
                    </button>
                </div>
                <div class="py-2">
                    <a href="{{ url('/') }}" class="block px-4 py-3 text-gray-800 hover:bg-theme-primary-light hover:text-theme-primary border-b border-gray-50">হোম</a>
                    <a href="{{ route('shop', ['offer' => 'true']) }}" class="block px-4 py-3 text-gray-800 hover:bg-theme-primary-light hover:text-theme-primary border-b border-gray-50 font-bold text-theme-primary">অফার জোন</a>
                    @foreach(\App\Models\Category::where('status', true)->get() as $category)
                        <a href="{{ route('shop', ['category' => $category->slug]) }}" class="block px-4 py-3 text-gray-800 hover:bg-theme-primary-light hover:text-theme-primary border-b border-gray-50">{{ $category->name }}</a>
                    @endforeach
                </div>
            </div>
        </div>
    </header>

    <!-- Page Content -->
    <main>
        @if(isset($slot))
            {{ $slot }}
        @else
            @yield('content')
        @endif
    </main>

    <!-- Mobile Bottom Navigation -->
    <div class="fixed bottom-0 left-0 w-full bg-white shadow-[0_-4px_6px_-1px_rgba(0,0,0,0.1)] z-50 md:hidden border-t border-gray-200">
        <div class="grid grid-cols-4 h-16">
            <a href="{{ url('/') }}" class="flex flex-col items-center justify-center text-gray-600 hover:text-theme-primary {{ request()->is('/') ? 'text-theme-primary' : '' }}">
                <i class="fas fa-home text-xl mb-1"></i>
                <span class="text-[10px] font-medium">হোম</span>
            </a>
            <a href="{{ route('shop') }}" class="flex flex-col items-center justify-center text-gray-600 hover:text-theme-primary {{ request()->routeIs('shop') ? 'text-theme-primary' : '' }}">
                <i class="fas fa-th-large text-xl mb-1"></i>
                <span class="text-[10px] font-medium">শপ</span>
            </a>
            <a href="{{ route('cart.index') }}" class="flex flex-col items-center justify-center text-gray-600 hover:text-theme-primary relative {{ request()->routeIs('cart.index') ? 'text-theme-primary' : '' }}">
                <div class="relative">
                    <i class="fas fa-shopping-bag text-xl mb-1"></i>
                    <span class="absolute -top-2 -right-2 bg-theme-primary text-white text-[10px] font-bold h-4 w-4 flex items-center justify-center rounded-full">
                        {{ session('cart') ? count(session('cart')) : 0 }}
                    </span>
                </div>
                <span class="text-[10px] font-medium">কার্ট</span>
            </a>
            @auth
                <a href="{{ route('dashboard') }}" class="flex flex-col items-center justify-center text-gray-600 hover:text-theme-primary {{ request()->routeIs('dashboard') ? 'text-theme-primary' : '' }}">
                    <i class="fas fa-user text-xl mb-1"></i>
                    <span class="text-[10px] font-medium">অ্যাকাউন্ট</span>
                </a>
            @else
                <a href="{{ route('login') }}" class="flex flex-col items-center justify-center text-gray-600 hover:text-theme-primary {{ request()->routeIs('login') ? 'text-theme-primary' : '' }}">
                    <i class="fas fa-user text-xl mb-1"></i>
                    <span class="text-[10px] font-medium">লগিন</span>
                </a>
            @endauth
        </div>
    </div>

    <!-- Footer -->
    <div class="mb-16 md:mb-0">
        @include('frontend.layouts.footer')
    </div>
    
    <!-- AOS Animation JS -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        AOS.init({
            once: true,
            offset: 50,
            duration: 800,
        });
    </script>
    <script>
        (function() {
            function initSearchSuggestions() {
                const searchInput = document.getElementById('desktopSearchInput');
                const suggestionsContainer = document.getElementById('searchSuggestions');
                const searchLoading = document.getElementById('searchLoading');
                const searchSubmitBtn = document.getElementById('searchSubmitBtn');

                if (!searchInput || !suggestionsContainer) {
                    console.warn('Search elements not found');
                    return;
                }

                let debounceTimer;

                // Helper to show/hide
                const showSuggestions = () => {
                    suggestionsContainer.classList.remove('hidden');
                    suggestionsContainer.style.display = 'block';
                };
                const hideSuggestions = () => {
                    suggestionsContainer.classList.add('hidden');
                    suggestionsContainer.style.display = 'none';
                };

                // Event Listener
                const handleInput = function() {
                    const query = this.value.trim();
                    
                    clearTimeout(debounceTimer);
                    
                    if (query.length < 1) {
                        hideSuggestions();
                        suggestionsContainer.innerHTML = '';
                        return;
                    }

                    // Show loading
                    if(searchSubmitBtn) searchSubmitBtn.style.display = 'none';
                    if(searchLoading) searchLoading.classList.remove('hidden');
                    if(searchLoading) searchLoading.style.display = 'inline-block';

                    debounceTimer = setTimeout(() => {
                        console.log('Fetching suggestions for:', query);
                        fetch(`{{ route('search.suggestions') }}?query=${encodeURIComponent(query)}`)
                            .then(response => {
                                if (!response.ok) throw new Error('Network response was not ok');
                                return response.json();
                            })
                            .then(data => {
                                console.log('Suggestions received:', data);
                                suggestionsContainer.innerHTML = '';
                                
                                if (data.length > 0) {
                                    // Header
                                    const header = document.createElement('div');
                                    header.className = 'px-4 py-3 border-b border-gray-100 bg-gray-50';
                                    header.innerHTML = `<h3 class="text-sm font-semibold text-gray-600">Results for "${query}"</h3>`;
                                    suggestionsContainer.appendChild(header);

                                    // Grid Container
                                    const grid = document.createElement('div');
                                    grid.className = 'grid grid-cols-2 md:grid-cols-4 gap-4 p-4';
                                    
                                    data.forEach(product => {
                                        const priceHtml = product.original_price > product.price
                                            ? `<span class="text-sm font-bold text-orange-600">৳${product.price}</span>
                                               <span class="text-xs text-gray-400 line-through">৳${product.original_price}</span>`
                                            : `<span class="text-sm font-bold text-orange-600">৳${product.price}</span>`;

                                        const imageHtml = (product.thumbnail_url || product.thumbnail)
                                            ? `<img src="${product.thumbnail_url || product.thumbnail}" class="w-24 h-24 object-contain mb-2 group-hover:scale-105 transition-transform duration-300" alt="">`
                                            : `<div class="w-24 h-24 bg-gray-100 flex items-center justify-center text-gray-400 mb-2 rounded"><i class="fas fa-image text-2xl"></i></div>`;

                                        const item = document.createElement('a');
                                        item.href = `/product/${product.slug}`;
                                        item.className = 'flex flex-col items-center text-center p-3 rounded-lg hover:shadow-md border border-transparent hover:border-gray-100 transition-all duration-200 group bg-white';
                                        item.style.textDecoration = 'none';
                                        item.innerHTML = `
                                            ${imageHtml}
                                            <h4 class="text-sm font-medium text-gray-800 line-clamp-2 mb-1 group-hover:text-orange-600">${product.name}</h4>
                                            <div class="flex items-center gap-2">
                                                ${priceHtml}
                                            </div>
                                        `;
                                        grid.appendChild(item);
                                    });
                                    suggestionsContainer.appendChild(grid);

                                    // View All Button
                                    const viewAll = document.createElement('a');
                                    viewAll.href = `/shop?search=${encodeURIComponent(query)}`;
                                    viewAll.className = 'block bg-orange-500 text-white p-3 text-center text-sm font-bold hover:bg-orange-600 transition-colors mx-4 mb-4 rounded-lg';
                                    viewAll.innerHTML = 'More Results';
                                    suggestionsContainer.appendChild(viewAll);

                                    showSuggestions();
                                } else {
                                    // No results found
                                    const noResult = document.createElement('div');
                                    noResult.className = 'p-8 text-center';
                                    noResult.innerHTML = `
                                        <div class="text-gray-300 mb-3">
                                            <i class="fas fa-search text-4xl"></i>
                                        </div>
                                        <p class="text-gray-500 font-medium">No results found for "${query}"</p>
                                    `;
                                    suggestionsContainer.appendChild(noResult);
                                    showSuggestions();
                                }
                            })
                            .catch(error => {
                                console.error('Error fetching suggestions:', error);
                            })
                            .finally(() => {
                                // Hide loading
                                if(searchLoading) searchLoading.classList.add('hidden');
                                if(searchLoading) searchLoading.style.display = 'none';
                                if(searchSubmitBtn) searchSubmitBtn.style.display = 'inline-block';
                            });
                    }, 150);
                };

                // Attach listeners
                searchInput.addEventListener('input', handleInput);
                searchInput.addEventListener('focus', function() {
                    if (this.value.length > 0) {
                        handleInput.call(this);
                    }
                });

                // Close on click outside
                document.addEventListener('click', function(e) {
                    if (!searchInput.contains(e.target) && !suggestionsContainer.contains(e.target)) {
                        hideSuggestions();
                    }
                });
            }

            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', initSearchSuggestions);
            } else {
                initSearchSuggestions();
            }
        })();
    </script>
</body>
</html>
