<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $landingPage->title }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['"Plus Jakarta Sans"', 'sans-serif'],
                        heading: ['"Outfit"', 'sans-serif'],
                    },
                    colors: {
                        orange: {
                            50: '#fff7ed',
                            100: '#ffedd5',
                            200: '#fed7aa',
                            300: '#fdba74',
                            400: '#fb923c',
                            500: '#f97316',
                            600: '#ea580c',
                            700: '#c2410c',
                            800: '#9a3412',
                            900: '#7c2d12',
                            950: '#431407',
                        }
                    }
                }
            }
        }
    </script>
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, var(--theme-primary-light) 0%, #ffffff 100%);
        }
        {!! $landingPage->css !!}
    </style>
    @include('partials.theme-style')
</head>
<body class="bg-gray-50 text-gray-900 font-sans antialiased selection:bg-theme-primary-light selection:text-theme-primary">

    @if($landingPage->css)
        <!-- Builder Content -->
        {!! $landingPage->content !!}
    @else
        <!-- Default Template -->
        <!-- Header -->
        <header class="bg-white/80 backdrop-blur-xl border-b border-gray-100 sticky top-0 z-50">
            <div class="container mx-auto px-4 py-4 flex justify-between items-center">
                <a href="/" class="text-2xl font-heading font-bold text-gray-900 tracking-tight">BrandName</a>
                <a href="#order-form" class="bg-theme-primary text-white px-6 py-2.5 rounded-full text-sm font-bold hover:bg-theme-primary-hover transition shadow-lg">Order Now</a>
            </div>
        </header>

        <!-- Hero Section -->
        <section class="relative overflow-hidden bg-white">
            <div class="absolute inset-0 bg-theme-primary-light opacity-50 pointer-events-none"></div>
            <div class="container mx-auto px-4 py-16 md:py-24 relative z-10">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-12 lg:gap-20 items-center">
                    <div class="space-y-8 text-center md:text-left">
                        <span class="inline-block py-1.5 px-4 rounded-full bg-theme-primary-light text-theme-primary text-sm font-bold mb-2">
                            Limited Time Offer
                        </span>
                        <h1 class="text-5xl md:text-7xl font-heading font-bold text-gray-900 leading-[1.1]">
                            {{ $landingPage->title }}
                        </h1>
                        <p class="text-lg text-gray-600 leading-relaxed max-w-lg mx-auto md:mx-0">
                            {{ $landingPage->content ?? 'Experience the best quality products with our exclusive offer. Limited time only!' }}
                        </p>
                        <div class="flex flex-col sm:flex-row gap-4 justify-center md:justify-start">
                            <a href="#order-form" class="inline-flex justify-center items-center bg-gray-900 text-white text-lg font-bold px-8 py-4 rounded-2xl hover:bg-black transition shadow-xl hover:shadow-2xl hover:-translate-y-1 duration-300">
                                Order Now - {{ $landingPage->product->price }} BDT
                            </a>
                        </div>
                        <div class="flex items-center justify-center md:justify-start gap-2 text-gray-500 font-medium text-sm">
                            <svg class="w-5 h-5 text-theme-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                            Cash on Delivery Available
                        </div>
                    </div>
                    <div class="relative group">
                        <div class="absolute inset-0 bg-theme-primary-light rounded-3xl blur-2xl opacity-0 group-hover:opacity-100 transition-opacity duration-700"></div>
                        <div class="relative rounded-3xl overflow-hidden shadow-2xl border border-gray-100 bg-white">
                            @if($landingPage->hero_image)
                                <img src="{{ asset('storage/' . $landingPage->hero_image) }}" alt="{{ $landingPage->title }}" class="w-full object-cover transform transition duration-700 hover:scale-105">
                            @elseif($landingPage->product && $landingPage->product->thumbnail)
                                <img src="{{ asset($landingPage->product->thumbnail) }}" alt="{{ $landingPage->product->name }}" class="w-full object-cover transform transition duration-700 hover:scale-105">
                            @else
                                <div class="w-full h-96 bg-gray-50 flex items-center justify-center text-gray-400 font-sans font-medium">
                                    No Image Available
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Product Details -->
        <section class="py-24 bg-gray-50">
            <div class="container mx-auto px-4">
                <div class="max-w-3xl mx-auto text-center mb-16">
                    <h2 class="text-3xl md:text-4xl font-heading font-bold mb-4 text-gray-900">Why Choose This Product?</h2>
                    <p class="text-gray-500">Premium quality meets exceptional design.</p>
                </div>
                
                @if($landingPage->product)
                <div class="bg-white rounded-3xl p-8 md:p-12 shadow-xl shadow-gray-200/50 border border-gray-100 max-w-5xl mx-auto">
                    <div class="flex flex-col md:flex-row gap-12 items-center">
                        <div class="w-full md:w-1/3">
                            <div class="rounded-2xl overflow-hidden bg-gray-50 p-4">
                                <img src="{{ asset($landingPage->product->thumbnail) }}" alt="{{ $landingPage->product->name }}" class="w-full mix-blend-multiply hover:scale-105 transition duration-500">
                            </div>
                        </div>
                        <div class="w-full md:w-2/3 space-y-6">
                            <h3 class="text-3xl font-heading font-bold text-gray-900">{{ $landingPage->product->name }}</h3>
                            <div class="prose text-gray-600">
                                {!! $landingPage->product->description ?? 'No description available.' !!}
                            </div>
                            <div class="flex items-baseline gap-3">
                                <span class="text-4xl font-heading font-bold text-theme-primary">{{ $landingPage->product->price }} BDT</span>
                                @if($landingPage->product->old_price)
                                    <span class="text-xl text-gray-400 line-through font-medium">{{ $landingPage->product->old_price }} BDT</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </section>
    @endif

    <!-- Order Form (Always Visible) -->
    <section id="order-form" class="bg-gray-50 py-8 lg:py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-8">
                <h2 class="text-2xl lg:text-3xl font-heading font-bold text-gray-900 mb-4 uppercase tracking-wide">অর্ডার কনফার্ম করুন</h2>
                <p class="text-gray-500">আপনার তথ্য দিয়ে নিচের ফর্মটি পূরণ করুন</p>
            </div>

            <form action="{{ route('checkout.store') }}" method="POST">
                @csrf
                @include('frontend.checkout.partial-checkout-form')
            </form>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-white border-t border-gray-100 text-gray-500 py-12 text-center">
        <p class="text-sm font-medium">&copy; {{ date('Y') }} BrandName. All rights reserved.</p>
    </footer>

</body>
</html>
