<x-frontend-layout>
    <!-- Hero Section -->
    <div class="relative w-full overflow-hidden bg-white">
        @if(isset($banners) && $banners->count() > 0)
            <div class="relative w-full" x-data="{ activeSlide: 0, slides: {{ $banners->count() }} }" x-init="setInterval(() => { activeSlide = activeSlide === slides - 1 ? 0 : activeSlide + 1 }, 5000)">
                <!-- Slides -->
                <div class="relative w-full overflow-hidden group">
                    <!-- Spacer to maintain aspect ratio based on first image -->
                    <img src="{{ Storage::url($banners->first()->image) }}" class="w-full opacity-0 invisible relative -z-10" alt="spacer">
                    
                    @foreach($banners as $index => $banner)
                        <div class="absolute inset-0 w-full h-full transition-opacity duration-700 ease-in-out"
                             x-show="activeSlide === {{ $index }}"
                             x-transition:enter="transition ease-out duration-700"
                             x-transition:enter-start="opacity-0"
                             x-transition:enter-end="opacity-100"
                             x-transition:leave="transition ease-in duration-700"
                             x-transition:leave-start="opacity-100"
                             x-transition:leave-end="opacity-0">
                            @if($banner->url)
                                <a href="{{ $banner->url }}" class="block w-full h-full">
                                    <img src="{{ Storage::url($banner->image) }}" alt="{{ $banner->title }}" class="w-full h-full object-cover">
                                </a>
                            @else
                                <img src="{{ Storage::url($banner->image) }}" alt="{{ $banner->title }}" class="w-full h-full object-cover">
                            @endif
                        </div>
                    @endforeach
                    
                    <!-- Navigation Arrows -->
                    <button @click="activeSlide = activeSlide === 0 ? slides - 1 : activeSlide - 1" class="absolute left-4 top-1/2 -translate-y-1/2 w-10 h-10 bg-white/80 hover:bg-white text-gray-800 rounded-full flex items-center justify-center shadow-md transition-all opacity-0 group-hover:opacity-100 z-10">
                        <i class="fas fa-chevron-left"></i>
                    </button>
                    <button @click="activeSlide = activeSlide === slides - 1 ? 0 : activeSlide + 1" class="absolute right-4 top-1/2 -translate-y-1/2 w-10 h-10 bg-white/80 hover:bg-white text-gray-800 rounded-full flex items-center justify-center shadow-md transition-all opacity-0 group-hover:opacity-100 z-10">
                        <i class="fas fa-chevron-right"></i>
                    </button>
                </div>
                
                <!-- Indicators -->
                <div class="absolute bottom-4 left-1/2 transform -translate-x-1/2 flex space-x-2 z-10">
                    @foreach($banners as $index => $banner)
                        <button @click="activeSlide = {{ $index }}" 
                                :class="{ 'bg-theme-primary w-6': activeSlide === {{ $index }}, 'bg-white w-2': activeSlide !== {{ $index }} }"
                                class="h-2 rounded-full transition-all duration-300 shadow-sm border border-gray-200"></button>
                    @endforeach
                </div>
            </div>
        @else
            <!-- Static Fallback Banner (Ghorer Bazar Style) -->
            <div class="relative w-full bg-gray-100 flex items-center justify-center overflow-hidden" style="aspect-ratio: 3/1;">
                <div class="text-center z-10 px-4">
                    <h1 class="text-3xl md:text-5xl font-heading font-bold text-gray-900 mb-4">শুরু হোক আপনার হেলদি জার্নি</h1>
                    <h2 class="text-2xl md:text-4xl font-heading font-bold text-gray-800 mb-6">সাথে আছে প্রিমিয়াম কোয়ালিটি</h2>
                    <div class="mt-4">
                        <div class="inline-flex items-center bg-white px-6 py-2 rounded-full shadow-lg border border-gray-100">
                            <span class="text-gray-800 font-bold mr-2">অর্ডার করতে যোগাযোগ করুন</span>
                            <span class="bg-gray-800 text-white px-3 py-1 rounded-full font-bold">09642-922922</span>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>

    <!-- Categories Section Removed -->

    <!-- New Arrivals -->
    @if(isset($newArrivals) && $newArrivals->count() > 0)
    <div class="py-12 bg-gray-50/50" x-data="{ visible: 10 }" x-init="(() => { if (window.matchMedia('(max-width: 767px)').matches) { visible = 6 } else { visible = 10 } })()">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-2xl md:text-3xl font-heading font-bold text-gray-900 uppercase tracking-wide">নতুন পণ্য</h2>
                <div class="w-16 h-1 bg-theme-primary mx-auto mt-3"></div>
            </div>

            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-5 gap-4 sm:gap-6">
                @foreach($newArrivals as $product)
                    <div x-show="{{ $loop->index }} < visible" class="group relative bg-white rounded-2xl shadow-sm hover:shadow-xl hover:-translate-y-2 transition-all duration-500 overflow-hidden border border-gray-100" data-aos="fade-up" data-aos-delay="{{ $loop->index * 50 }}">
                        <!-- Badge -->
                        <div class="absolute top-3 left-3 z-10 flex flex-col gap-1">
                            <span class="bg-theme-primary text-white text-[10px] font-bold px-2.5 py-1 rounded-full shadow-md">নতুন</span>
                            @if($product->offer_price)
                                <span class="bg-red-500 text-white text-[10px] font-bold px-2.5 py-1 rounded-full shadow-md animate-pulse">
                                    -{{ round((($product->price - $product->offer_price) / $product->price) * 100) }}%
                                </span>
                            @endif
                        </div>

                        <!-- Image -->
                        <div class="relative aspect-square overflow-hidden bg-gray-50">
                            <a href="{{ route('product.show', $product->slug) }}" class="block w-full h-full">
                                @if($product->thumbnail)
                                    <img src="{{ Storage::url($product->thumbnail) }}" alt="{{ $product->name }}" class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-700 ease-in-out">
                                @else
                                    <div class="w-full h-full flex items-center justify-center text-gray-200 bg-gray-50">
                                        <i class="fas fa-image text-3xl"></i>
                                    </div>
                                @endif
                                <!-- Overlay -->
                                <div class="absolute inset-0 bg-black/0 group-hover:bg-black/5 transition-colors duration-300"></div>
                            </a>
                        </div>
                        
                        <!-- Content -->
                        <div class="p-4 flex flex-col flex-grow">
                            <h3 class="text-sm font-bold text-gray-800 mb-2 line-clamp-2 min-h-[40px] group-hover:text-theme-primary transition-colors">
                                <a href="{{ route('product.show', $product->slug) }}">{{ $product->name }}</a>
                            </h3>
                            
                            <div class="mt-auto">
                                <div class="flex items-center gap-2 mb-3">
                                    @if($product->offer_price)
                                        <span class="text-lg font-extrabold text-theme-primary">৳ {{ number_format($product->offer_price, 0) }}</span>
                                        <span class="text-xs text-gray-400 line-through">৳ {{ number_format($product->price, 0) }}</span>
                                    @else
                                        <span class="text-lg font-extrabold text-theme-primary">৳ {{ number_format($product->price, 0) }}</span>
                                    @endif
                                </div>
                                
                                <!-- Quick Add Buttons -->
                                <form action="{{ route('cart.add') }}" method="POST" class="grid grid-cols-2 gap-2">
                                    @csrf
                                    <input type="hidden" name="product_id" value="{{ $product->id }}">
                                    <input type="hidden" name="quantity" value="1">
                                    
                                    <button type="submit" name="buy_now" value="1" class="col-span-1 bg-theme-primary hover:bg-theme-primary-hover text-white text-xs font-bold py-2.5 rounded-lg transition-all duration-300 shadow-sm hover:shadow-md flex items-center justify-center gap-1">
                                        অর্ডার করুন
                                    </button>
                                    <button type="submit" class="col-span-1 bg-theme-primary-light hover:bg-theme-primary-light text-theme-primary text-xs font-bold py-2.5 rounded-lg transition-all duration-300 border border-theme-primary-light hover:border-theme-primary flex items-center justify-center gap-1">
                                        কার্টে রাখুন
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif

    <!-- Featured Products Section -->
    <div class="py-12 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-2xl md:text-3xl font-heading font-bold text-gray-900 uppercase tracking-wide">আমাদের সব পণ্য</h2>
                <div class="w-16 h-1 bg-theme-primary mx-auto mt-3"></div>
            </div>

            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-5 gap-4 sm:gap-6">
                @foreach($allProducts as $product)
                    <div class="group relative bg-white rounded-2xl shadow-sm hover:shadow-xl hover:-translate-y-2 transition-all duration-500 overflow-hidden border border-gray-100" data-aos="fade-up" data-aos-delay="{{ $loop->index * 50 }}">
                        <!-- Badge -->
                        @if($product->offer_price)
                            <div class="absolute top-3 left-3 z-10 flex flex-col gap-1">
                                <span class="bg-theme-primary text-white text-[10px] font-bold px-2.5 py-1 rounded-full shadow-md">ছাড়</span>
                                <span class="bg-red-500 text-white text-[10px] font-bold px-2.5 py-1 rounded-full shadow-md animate-pulse">
                                    -{{ round((($product->price - $product->offer_price) / $product->price) * 100) }}%
                                </span>
                            </div>
                        @endif

                        <!-- Image -->
                        <div class="relative aspect-square overflow-hidden bg-gray-50">
                            <a href="{{ route('product.show', $product->slug) }}" class="block w-full h-full">
                                @if($product->thumbnail)
                                    <img src="{{ Storage::url($product->thumbnail) }}" alt="{{ $product->name }}" class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-700 ease-in-out">
                                @else
                                    <div class="w-full h-full flex items-center justify-center text-gray-200 bg-gray-50">
                                        <i class="fas fa-image text-3xl"></i>
                                    </div>
                                @endif
                                <!-- Overlay -->
                                <div class="absolute inset-0 bg-black/0 group-hover:bg-black/5 transition-colors duration-300"></div>
                            </a>
                        </div>
                        
                        <!-- Content -->
                        <div class="p-4 flex flex-col flex-grow">
                            <h3 class="text-sm font-bold text-gray-800 mb-2 line-clamp-2 min-h-[40px] group-hover:text-theme-primary transition-colors">
                                <a href="{{ route('product.show', $product->slug) }}">{{ $product->name }}</a>
                            </h3>
                            
                            <div class="mt-auto">
                                <div class="flex items-center gap-2 mb-3">
                                    @if($product->offer_price)
                                        <span class="text-lg font-extrabold text-theme-primary">৳ {{ number_format($product->offer_price, 0) }}</span>
                                        <span class="text-xs text-gray-400 line-through">৳ {{ number_format($product->price, 0) }}</span>
                                    @else
                                        <span class="text-lg font-extrabold text-theme-primary">৳ {{ number_format($product->price, 0) }}</span>
                                    @endif
                                </div>
                                
                                <!-- Quick Add Buttons -->
                                <form action="{{ route('cart.add') }}" method="POST" class="grid grid-cols-2 gap-2">
                                    @csrf
                                    <input type="hidden" name="product_id" value="{{ $product->id }}">
                                    <input type="hidden" name="quantity" value="1">
                                    
                                    <button type="submit" name="buy_now" value="1" class="col-span-1 bg-theme-primary hover:bg-theme-primary-hover text-white text-xs font-bold py-2.5 rounded-lg transition-all duration-300 shadow-sm hover:shadow-md flex items-center justify-center gap-1">
                                        অর্ডার করুন
                                    </button>
                                    <button type="submit" class="col-span-1 bg-theme-primary-light hover:bg-theme-primary-light text-theme-primary text-xs font-bold py-2.5 rounded-lg transition-all duration-300 border border-theme-primary-light hover:border-theme-primary flex items-center justify-center gap-1">
                                        কার্টে রাখুন
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            
            <div class="mt-12 text-center">
                <a href="{{ route('shop') }}" class="inline-flex items-center justify-center px-8 py-2.5 bg-theme-primary text-white font-medium rounded hover:bg-theme-primary-hover transition-all duration-300 shadow-sm">
                    সব পণ্য দেখুন
                    <i class="fas fa-arrow-right ml-2"></i>
                </a>
            </div>
        </div>
    </div>

</x-frontend-layout>
