<x-frontend-layout>
    <div class="bg-gray-50 py-10">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Breadcrumb -->
            <div class="flex items-center space-x-2 text-sm text-gray-500 mb-8">
                <a href="{{ route('home') }}" class="hover:text-theme-primary transition-colors">হোম</a>
                <span>/</span>
                <span class="text-theme-primary font-medium">যোগাযোগ</span>
            </div>

            <div class="text-center mb-12">
                <h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4 font-heading">আমাদের সাথে যোগাযোগ করুন</h1>
                <p class="text-gray-500 max-w-2xl mx-auto">আপনার যেকোনো প্রশ্ন বা মতামতের জন্য আমাদের সাথে যোগাযোগ করতে পারেন। আমরা দ্রুততম সময়ে আপনার উত্তর দেয়ার চেষ্টা করবো।</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-12">
                <!-- Contact Info -->
                <div class="bg-white rounded-2xl shadow-sm p-8 h-full">
                    <h2 class="text-2xl font-bold text-gray-900 mb-6 font-heading">যোগাযোগের তথ্য</h2>
                    
                    <div class="space-y-6">
                        @if($contactSetting)
                            @if($contactSetting->phone_number)
                            <div class="flex items-start gap-4">
                                <div class="w-12 h-12 rounded-full bg-orange-50 flex items-center justify-center text-theme-primary flex-shrink-0">
                                    <i class="fas fa-phone-alt text-xl"></i>
                                </div>
                                <div>
                                    <h3 class="font-bold text-gray-900 mb-1">ফোন নম্বর</h3>
                                    <p class="text-gray-600">{{ $contactSetting->phone_number }}</p>
                                    @if($contactSetting->hotline_number)
                                        <p class="text-gray-600">{{ $contactSetting->hotline_number }} (হটলাইন)</p>
                                    @endif
                                </div>
                            </div>
                            @endif

                            @if($contactSetting->email)
                            <div class="flex items-start gap-4">
                                <div class="w-12 h-12 rounded-full bg-orange-50 flex items-center justify-center text-theme-primary flex-shrink-0">
                                    <i class="fas fa-envelope text-xl"></i>
                                </div>
                                <div>
                                    <h3 class="font-bold text-gray-900 mb-1">ইমেইল</h3>
                                    <p class="text-gray-600">{{ $contactSetting->email }}</p>
                                    @if($contactSetting->hot_mail)
                                        <p class="text-gray-600">{{ $contactSetting->hot_mail }}</p>
                                    @endif
                                </div>
                            </div>
                            @endif

                            @if($contactSetting->address)
                            <div class="flex items-start gap-4">
                                <div class="w-12 h-12 rounded-full bg-orange-50 flex items-center justify-center text-theme-primary flex-shrink-0">
                                    <i class="fas fa-map-marker-alt text-xl"></i>
                                </div>
                                <div>
                                    <h3 class="font-bold text-gray-900 mb-1">ঠিকানা</h3>
                                    <p class="text-gray-600">{{ $contactSetting->address }}</p>
                                </div>
                            </div>
                            @endif
                        @else
                            <div class="text-center py-8 text-gray-500">
                                <p>যোগাযোগের তথ্য শীঘ্রই আপডেট করা হবে।</p>
                            </div>
                        @endif
                    </div>

                    <!-- Social Media -->
                    <div class="mt-8 pt-8 border-t border-gray-100">
                        <h3 class="font-bold text-gray-900 mb-4">সোশ্যাল মিডিয়া</h3>
                        <div class="flex gap-4">
                            @if(isset($socialMedias))
                                @foreach($socialMedias as $social)
                                    <a href="{{ $social->link }}" target="_blank" class="w-10 h-10 rounded-full flex items-center justify-center hover:opacity-90 transition-all transform hover:-translate-y-1 shadow-sm" style="background-color: {{ $social->color }}; color: white;">
                                        <i class="{{ $social->icon }}"></i>
                                    </a>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Contact Form (Placeholder) -->
                <div class="bg-white rounded-2xl shadow-sm p-8 h-full">
                    <h2 class="text-2xl font-bold text-gray-900 mb-6 font-heading">মেসেজ পাঠান</h2>
                    <form onsubmit="event.preventDefault(); alert('ধন্যবাদ! আপনার মেসেজটি আমরা পেয়েছি। শীঘ্রই যোগাযোগ করা হবে।');" class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">আপনার নাম</label>
                            <input type="text" class="w-full px-4 py-3 rounded-lg border border-gray-200 focus:border-theme-primary focus:ring-2 focus:ring-theme-primary/20 transition-all outline-none" placeholder="আপনার পুরো নাম লিখুন" required>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">ফোন নম্বর</label>
                            <input type="tel" class="w-full px-4 py-3 rounded-lg border border-gray-200 focus:border-theme-primary focus:ring-2 focus:ring-theme-primary/20 transition-all outline-none" placeholder="আপনার ফোন নম্বর" required>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">মেসেজ</label>
                            <textarea rows="4" class="w-full px-4 py-3 rounded-lg border border-gray-200 focus:border-theme-primary focus:ring-2 focus:ring-theme-primary/20 transition-all outline-none" placeholder="আপনার প্রশ্ন বা মতামত লিখুন" required></textarea>
                        </div>
                        <button type="submit" class="w-full bg-theme-primary text-white font-bold py-3 rounded-lg hover:bg-theme-primary-hover transition-all shadow-lg shadow-orange-500/30">
                            মেসেজ পাঠান
                        </button>
                    </form>
                </div>
            </div>

            <!-- Map -->
            @if($contactSetting && $contactSetting->google_map)
            <div class="bg-white rounded-2xl shadow-sm p-4 overflow-hidden h-96">
                <iframe src="{{ $contactSetting->google_map }}" width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
            </div>
            @endif
        </div>
    </div>
</x-frontend-layout>