<x-frontend-layout>
    <div class="bg-gray-50 min-h-[60vh] flex items-center justify-center py-16">
        <div class="max-w-3xl w-full mx-auto px-4 sm:px-6 lg:px-8 text-center">
            
            @if(session('error'))
                <div class="mb-8 bg-red-50 border border-red-200 text-red-700 px-6 py-4 rounded-xl text-sm font-medium shadow-sm">
                    {{ session('error') }}
                </div>
            @endif

            @if(session('success'))
                <div class="mb-8 bg-theme-primary-light border border-theme-primary-light text-theme-primary px-6 py-4 rounded-xl text-sm font-medium shadow-sm">
                    {{ session('success') }}
                </div>
            @endif

            <div class="bg-white rounded-3xl shadow-sm border border-gray-100 p-8 md:p-12 mb-8">
                @if($order->payment_status === 'paid' || $order->payment_method === 'cod')
                    <div class="w-20 h-20 bg-theme-primary-light text-theme-primary rounded-full flex items-center justify-center mx-auto mb-6 animate-bounce-slow">
                        <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                    </div>
                    <h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-3">ধন্যবাদ!</h1>
                    <p class="text-gray-500 text-lg">আপনার অর্ডার সফলভাবে গ্রহণ করা হয়েছে।</p>
                @else
                    <div class="w-20 h-20 bg-amber-100 text-amber-600 rounded-full flex items-center justify-center mx-auto mb-6">
                        <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                    </div>
                    <h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-3">পেমেন্ট পেন্ডিং</h1>
                    <p class="text-amber-600 text-lg">আপনার পেমেন্ট সম্পন্ন হয়নি।</p>
                @endif
                
                <div class="mt-10 pt-10 border-t border-gray-100">
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-6 text-center">
                        <div>
                            <span class="block text-xs text-gray-400 font-bold uppercase tracking-wider mb-1">অর্ডার নম্বর</span>
                            <span class="block text-lg font-bold text-gray-900">#{{ $order->order_number }}</span>
                        </div>
                        <div>
                            <span class="block text-xs text-gray-400 font-bold uppercase tracking-wider mb-1">তারিখ</span>
                            <span class="block text-lg font-bold text-gray-900">{{ $order->created_at->format('d M, Y') }}</span>
                        </div>
                        <div>
                            <span class="block text-xs text-gray-400 font-bold uppercase tracking-wider mb-1">মোট</span>
                            <span class="block text-lg font-bold text-theme-primary">৳ {{ number_format($order->total_amount, 0) }}</span>
                        </div>
                        <div>
                            <span class="block text-xs text-gray-400 font-bold uppercase tracking-wider mb-1">পদ্ধতি</span>
                            <span class="block text-lg font-bold text-gray-900">{{ ucfirst($order->payment_method) }}</span>
                        </div>
                    </div>
                </div>
            </div>

            @if($order->payment_status !== 'paid' && ($order->payment_method === 'bkash' || $order->payment_method === 'sslcommerz'))
                <div class="mb-8 max-w-md mx-auto">
                    @if($order->payment_method === 'bkash')
                        <a href="{{ route('payment.bkash.pay', ['order_id' => $order->id]) }}" class="w-full inline-flex justify-center items-center px-8 py-3.5 border border-transparent text-base font-bold text-white bg-pink-600 rounded-xl hover:bg-pink-700 transition-all duration-300 shadow-lg shadow-pink-600/30">
                            বিকাশ পেমেন্ট করুন
                        </a>
                    @elseif($order->payment_method === 'sslcommerz')
                        <a href="{{ route('payment.sslcz.pay', ['order_id' => $order->id]) }}" class="w-full inline-flex justify-center items-center px-8 py-3.5 border border-transparent text-base font-bold text-white bg-gray-900 rounded-xl hover:bg-gray-800 transition-all duration-300 shadow-lg">
                            এসএসএল কমার্স পেমেন্ট
                        </a>
                    @endif
                </div>
            @endif
            
            <div class="flex flex-col sm:flex-row justify-center gap-4">
                <a href="{{ route('shop') }}" class="inline-flex justify-center items-center px-8 py-3.5 border border-gray-200 text-base font-bold text-gray-700 bg-white rounded-xl hover:bg-gray-50 hover:border-gray-300 transition-all duration-300">
                    কেনাকাটা চালিয়ে যান
                </a>
                
                @auth
                    <a href="{{ route('dashboard') }}" class="inline-flex justify-center items-center px-8 py-3.5 border border-transparent text-base font-bold text-white bg-theme-primary rounded-xl hover:bg-theme-primary-hover transition-all duration-300 shadow-lg">
                        অর্ডার দেখুন
                    </a>
                @else
                    <a href="{{ route('login') }}" class="inline-flex justify-center items-center px-8 py-3.5 border border-transparent text-base font-bold text-white bg-theme-primary rounded-xl hover:bg-theme-primary-hover transition-all duration-300 shadow-lg">
                        অ্যাকাউন্ট তৈরি করুন
                    </a>
                @endauth
            </div>
        </div>
    </div>

    @if(isset($eventId) && $eventId)
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var maxAttempts = 20;
            var attempt = 0;
            var interval = setInterval(function() {
                if (typeof fbq === 'function') {
                    clearInterval(interval);
                    fbq('track', 'Purchase', {
                        currency: 'BDT',
                        value: {{ $order->total_amount }},
                        content_type: 'product',
                        contents: [
                            @foreach($order->items as $item)
                            {
                                'id': '{{ $item->product_id }}',
                                'quantity': {{ $item->quantity }},
                                'item_price': {{ $item->price }}
                            }{{ $loop->last ? '' : ',' }}
                            @endforeach
                        ],
                        content_ids: [{{ implode(',', $order->items->pluck('product_id')->map(fn($id) => "'$id'")->toArray()) }}],
                        order_id: '{{ $order->order_number }}'
                    }, {eventID: '{{ $eventId }}'});
                    console.log('Facebook Pixel: Purchase Event Fired with ID: {{ $eventId }}');
                } else {
                    attempt++;
                    if (attempt >= maxAttempts) {
                        clearInterval(interval);
                        console.error('Facebook Pixel: fbq not defined after ' + maxAttempts + ' attempts');
                    }
                }
            }, 500);

            // TikTok Pixel
            var ttAttempts = 0;
            var ttInterval = setInterval(function() {
                if (typeof ttq === 'object' && typeof ttq.track === 'function') {
                    clearInterval(ttInterval);
                    ttq.track('PlaceAnOrder', {
                        contents: [
                            @foreach($order->items as $item)
                            {
                                'content_id': '{{ $item->product_id }}',
                                'quantity': {{ $item->quantity }},
                                'price': {{ $item->price }}
                            },
                            @endforeach
                        ],
                        value: {{ $order->total_amount }},
                        currency: 'BDT'
                    }, {event_id: '{{ $eventId }}'});
                } else {
                    ttAttempts++;
                    if (ttAttempts >= 20) clearInterval(ttInterval);
                }
            }, 500);
        });
    </script>
    @endif
</x-frontend-layout>