<x-frontend-layout>
    <div class="bg-gray-50 py-8 lg:py-12 min-h-screen">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h1 class="text-2xl lg:text-3xl font-heading font-bold text-gray-900 mb-8 text-center uppercase tracking-wide">চেকআউট</h1>

            <form action="{{ route('checkout.store') }}" method="POST">
                @csrf

                @include('frontend.checkout.partial-checkout-form')
            </form>
        </div>
    </div>

    @if(session('duplicate_error'))
    <div id="duplicateOrderModal" class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
            <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true" onclick="document.getElementById('duplicateOrderModal').remove()"></div>
            <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
            <div class="inline-block align-bottom bg-white rounded-lg px-4 pt-5 pb-4 text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full sm:p-6">
                <div class="sm:flex sm:items-start">
                    <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-red-100 sm:mx-0 sm:h-10 sm:w-10">
                        <svg class="h-6 w-6 text-red-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                        </svg>
                    </div>
                    <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left w-full">
                        <h3 class="text-lg leading-6 font-medium text-gray-900" id="modal-title">
                            Order Duplicate Warning
                        </h3>
                        <div class="mt-4">
                            <div class="bg-red-50 p-3 rounded text-red-700 text-sm mb-3">
                                {{ session('duplicate_error')['message_en'] }}
                            </div>
                            <div class="bg-yellow-50 p-3 rounded text-yellow-800 text-sm font-bold mb-4 border border-yellow-200">
                                {{ session('duplicate_error')['message_bn'] }}
                            </div>
                            
                            <div class="mt-4 text-center">
                                <p class="text-sm text-gray-500 mb-2">Need help? Call us:</p>
                                <a href="tel:{{ session('duplicate_error')['phone'] }}" class="inline-flex items-center gap-2 px-6 py-3 bg-theme-primary text-white text-xl font-bold rounded-full hover:bg-opacity-90 transition shadow-lg ring-4 ring-theme-primary/20">
                                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
                                    {{ session('duplicate_error')['phone'] }}
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mt-6 sm:mt-6 sm:flex sm:flex-row-reverse">
                    <button type="button" onclick="document.getElementById('duplicateOrderModal').remove()" class="w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:w-auto sm:text-sm">
                        Close / বন্ধ করুন
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif

    <script>
        (function() {
            var maxAttempts = 20;
            var attempt = 0;
            var interval = setInterval(function() {
                if (typeof fbq === 'function') {
                    clearInterval(interval);
                    
                    @php
                        $fbContents = [];
                        $fbContentIds = [];
                        $ttContents = [];
                        
                        foreach($cart as $key => $item) {
                            $productId = $item['product_id'] ?? $key;
                            if (!isset($item['product_id']) && strpos($key, '_') !== false) {
                               $productId = explode('_', $key)[0];
                            }
                            $productId = (string)$productId;
                            
                            $fbContents[] = [
                                'id' => $productId,
                                'quantity' => $item['quantity'],
                                'item_price' => $item['price']
                            ];
                            $fbContentIds[] = $productId;
                            
                            $ttContents[] = [
                                'content_id' => $productId,
                                'quantity' => $item['quantity'],
                                'price' => $item['price']
                            ];
                        }
                    @endphp

                    fbq('track', 'InitiateCheckout', {
                        content_type: 'product',
                        contents: @json($fbContents),
                        content_ids: @json($fbContentIds),
                        num_items: {{ count($cart) }},
                        value: {{ $total }},
                        currency: 'BDT'
                    }, {eventID: '{{ $eventId }}'});
                    console.log('Facebook Pixel: InitiateCheckout Fired (Attempt ' + attempt + ')');
                } else {
                    attempt++;
                    if (attempt >= maxAttempts) {
                        clearInterval(interval);
                        console.error('Facebook Pixel: fbq not defined after ' + maxAttempts + ' attempts');
                    }
                }
            }, 500);

            // TikTok Pixel
            var ttAttempts = 0;
            var ttInterval = setInterval(function() {
                if (typeof ttq === 'object' && typeof ttq.track === 'function') {
                    clearInterval(ttInterval);
                    ttq.track('InitiateCheckout', {
                        contents: @json($ttContents),
                        value: {{ $total }},
                        currency: 'BDT'
                    }, {event_id: '{{ $eventId }}'});
                    console.log('TikTok Pixel: InitiateCheckout Fired');
                } else {
                    ttAttempts++;
                    if (ttAttempts >= 20) clearInterval(ttInterval);
                }
            }, 500);
        })();
    </script>
</x-frontend-layout>