<x-frontend-layout>
    <div class="bg-gray-50 py-12 lg:py-20 min-h-[60vh]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h1 class="text-3xl lg:text-4xl font-heading font-bold text-gray-900 mb-12 text-center">শপিং ব্যাগ</h1>

            @if(count($cart) > 0)
                <div class="flex flex-col lg:flex-row gap-12 lg:gap-16">
                    <!-- Cart Items -->
                    <div class="w-full lg:w-2/3">
                        <div class="bg-white rounded-3xl shadow-sm border border-gray-100 overflow-hidden">
                            <table class="min-w-full divide-y divide-gray-100">
                                <thead class="bg-gray-50/50">
                                    <tr>
                                        <th scope="col" class="px-6 py-5 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">পণ্য</th>
                                        <th scope="col" class="px-6 py-5 text-left text-xs font-bold text-gray-500 uppercase tracking-wider hidden sm:table-cell">মূল্য</th>
                                        <th scope="col" class="px-6 py-5 text-left text-xs font-bold text-gray-500 uppercase tracking-wider hidden sm:table-cell">পরিমাণ</th>
                                        <th scope="col" class="px-6 py-5 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">মোট</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-100">
                                    @foreach($cart as $id => $details)
                                        <tr class="group hover:bg-gray-50/50 transition-colors">
                                            <td class="px-6 py-6 whitespace-nowrap">
                                                <div class="flex items-center">
                                                    <div class="flex-shrink-0 h-24 w-24 bg-gray-50 rounded-xl overflow-hidden border border-gray-100">
                                                        @if($details['thumbnail'])
                                                            <img class="h-full w-full object-cover group-hover:scale-105 transition-transform duration-500" src="{{ Storage::url($details['thumbnail']) }}" alt="{{ $details['name'] }}">
                                                        @else
                                                            <div class="h-full w-full flex items-center justify-center text-gray-300 bg-gray-50 text-xs">ছবি নেই</div>
                                                        @endif
                                                    </div>
                                                    <div class="ml-6">
                                                        <div class="text-base font-bold text-gray-900 font-heading mb-1">
                                                            <a href="{{ route('product.show', $details['slug']) }}" class="hover:text-theme-primary transition-colors">{{ $details['name'] }}</a>
                                                        </div>
                                                        @if(isset($details['color_name']) || isset($details['size_name']))
                                                            <div class="flex gap-3 text-xs text-gray-500 font-medium mb-3">
                                                                @if(isset($details['color_name']))
                                                                    <span class="bg-gray-100 px-2 py-1 rounded-md">{{ $details['color_name'] }}</span>
                                                                @endif
                                                                @if(isset($details['size_name']))
                                                                    <span class="bg-gray-100 px-2 py-1 rounded-md">{{ $details['size_name'] }}</span>
                                                                @endif
                                                            </div>
                                                        @endif
                                                        
                                                        <!-- Mobile Controls -->
                                                        <div class="sm:hidden flex items-center gap-4 mt-2">
                                                            <span class="text-sm font-bold text-theme-primary">৳{{ number_format($details['price'], 0) }}</span>
                                                            <form action="{{ route('cart.update', $id) }}" method="POST" class="flex items-center bg-gray-50 rounded-lg border border-gray-200">
                                                                @csrf
                                                                <input type="hidden" name="id" value="{{ $id }}">
                                                                <input type="number" name="quantity" value="{{ $details['quantity'] }}" min="1" class="w-12 border-none bg-transparent p-1 text-center text-xs focus:ring-0">
                                                                <button type="submit" class="px-2 text-gray-400 hover:text-theme-primary text-xs transition-colors">↻</button>
                                                            </form>
                                                        </div>
                                                        
                                                        <form action="{{ route('cart.destroy', $id) }}" method="POST" class="mt-2">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" onclick="return confirm('Are you sure you want to remove this item?')" class="text-xs font-medium text-red-500 hover:text-red-700 hover:underline transition-colors flex items-center gap-1">
                                                                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
                                                                মুছে ফেলুন
                                                            </button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="px-6 py-6 whitespace-nowrap hidden sm:table-cell align-middle">
                                                <div class="text-sm text-gray-900 font-bold">৳{{ number_format($details['price'], 0) }}</div>
                                            </td>
                                            <td class="px-6 py-6 whitespace-nowrap hidden sm:table-cell align-middle">
                                                <form action="{{ route('cart.update', $id) }}" method="POST" class="flex items-center">
                                                    @csrf
                                                    <input type="hidden" name="id" value="{{ $id }}">
                                                    <div class="flex items-center bg-gray-50 rounded-xl border border-gray-200 h-10 w-28 overflow-hidden">
                                                        <button type="button" onclick="this.parentNode.querySelector('input').stepDown(); this.form.submit()" class="w-9 h-full text-gray-500 hover:text-theme-primary hover:bg-gray-100 focus:outline-none transition-colors">-</button>
                                                        <input type="number" name="quantity" value="{{ $details['quantity'] }}" min="1" class="w-full h-full border-none bg-transparent text-center text-sm font-medium focus:ring-0 p-0 text-gray-900" onchange="this.form.submit()">
                                                        <button type="button" onclick="this.parentNode.querySelector('input').stepUp(); this.form.submit()" class="w-9 h-full text-gray-500 hover:text-theme-primary hover:bg-gray-100 focus:outline-none transition-colors">+</button>
                                                    </div>
                                                </form>
                                            </td>
                                            <td class="px-6 py-6 whitespace-nowrap text-right text-base font-bold text-theme-primary align-middle">
                                                ৳{{ number_format($details['price'] * $details['quantity'], 0) }}
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Cart Summary -->
                    <div class="w-full lg:w-1/3">
                        <div class="bg-white p-8 lg:p-10 sticky top-24 rounded-3xl shadow-xl shadow-gray-200/50 border border-gray-100">
                            <h2 class="text-xl font-heading font-bold text-gray-900 mb-6">অর্ডার সারাংশ</h2>
                            
                            <div class="space-y-4 mb-8">
                                <div class="flex justify-between items-center text-sm">
                                    <span class="text-gray-600 font-medium">সাবটোটাল</span>
                                    <span class="text-gray-900 font-bold">৳{{ number_format($total, 0) }}</span>
                                </div>
                                <div class="flex justify-between items-center text-sm">
                                    <span class="text-gray-600 font-medium">ডেলিভারি চার্জ</span>
                                    <span class="text-gray-400 text-xs bg-gray-100 px-2 py-1 rounded-full">চেকআউটে যুক্ত হবে</span>
                                </div>
                            </div>
                            
                            <div class="border-t border-dashed border-gray-200 pt-6 mb-8">
                                <div class="flex justify-between items-end">
                                    <span class="text-base font-bold text-gray-900">সর্বমোট</span>
                                    <span class="text-3xl font-heading font-bold text-theme-primary">৳{{ number_format($total, 0) }}</span>
                                </div>
                            </div>
                            
                            <a href="{{ route('checkout.index') }}" class="block w-full bg-theme-primary text-white py-4 text-center text-sm font-bold rounded-xl hover:bg-theme-primary-hover transition-all duration-300 shadow-lg">
                                চেকআউট করুন
                            </a>
                            
                            <div class="mt-6 text-center">
                                <a href="{{ route('shop') }}" class="text-sm text-gray-500 font-medium hover:text-theme-primary transition-colors flex items-center justify-center gap-2">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
                                    আরও কেনাকাটা করুন
                                </a>
                            </div>
                            
                            <!-- Security Icons -->
                            <div class="mt-8 flex justify-center gap-3 opacity-60 grayscale hover:grayscale-0 transition-all duration-500">
                                <div class="h-8 w-12 bg-gray-100 rounded-lg flex items-center justify-center text-[10px] font-bold text-gray-500 border border-gray-200">VISA</div>
                                <div class="h-8 w-12 bg-gray-100 rounded-lg flex items-center justify-center text-[10px] font-bold text-gray-500 border border-gray-200">MC</div>
                                <div class="h-8 w-12 bg-gray-100 rounded-lg flex items-center justify-center text-[10px] font-bold text-gray-500 border border-gray-200">PP</div>
                            </div>
                        </div>
                    </div>
                </div>
            @else
                <div class="text-center py-20 bg-white rounded-3xl shadow-sm border border-gray-100 max-w-2xl mx-auto">
                    <div class="mb-6 text-theme-primary-light">
                        <div class="w-24 h-24 bg-theme-primary-light rounded-full flex items-center justify-center mx-auto">
                            <svg class="h-12 w-12 text-theme-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                            </svg>
                        </div>
                    </div>
                    <h3 class="text-2xl font-heading font-bold text-gray-900 mb-2">আপনার শপিং ব্যাগ খালি</h3>
                    <p class="text-gray-500 mb-8 font-medium">আপনি এখনও কোনো পণ্য যোগ করেননি।</p>
                    <a href="{{ route('shop') }}" class="inline-flex items-center justify-center px-8 py-3.5 bg-theme-primary text-white text-sm font-bold rounded-xl hover:bg-theme-primary-hover transition-all duration-300 shadow-lg">
                        কেনাকাটা শুরু করুন
                    </a>
                </div>
            @endif
        </div>
    </div>
</x-frontend-layout>