<x-frontend-layout>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div class="flex flex-col md:flex-row justify-between items-end mb-10 border-b border-gray-100 pb-6">
            <div>
                <h2 class="text-3xl font-heading font-bold text-gray-900 mb-2">আমার অর্ডার</h2>
                <p class="text-gray-500 text-sm">আপনার সাম্প্রতিক অর্ডারগুলো দেখুন এবং ট্র্যাক করুন</p>
            </div>
            
            @if(Route::has('profile.edit'))
            <a href="{{ route('profile.edit') }}" class="mt-4 md:mt-0 inline-flex items-center text-sm font-bold text-theme-primary hover:text-theme-primary-hover transition-colors group bg-theme-primary-light px-4 py-2 rounded-lg">
                প্রোফাইল ম্যানেজ করুন
                <svg class="w-4 h-4 ml-2 transform group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"></path></svg>
            </a>
            @endif
        </div>

        @if($orders->count() > 0)
            <div class="space-y-4">
                <!-- Header Row (Hidden on mobile) -->
                <div class="hidden md:grid grid-cols-12 gap-4 text-xs font-bold uppercase tracking-wider text-gray-400 border-b border-gray-100 pb-4 px-4">
                    <div class="col-span-2">অর্ডার #</div>
                    <div class="col-span-3">তারিখ</div>
                    <div class="col-span-2">স্ট্যাটাস</div>
                    <div class="col-span-2">মোট</div>
                    <div class="col-span-3 text-right">অ্যাকশন</div>
                </div>

                @foreach($orders as $order)
                    @php
                        $statusClasses = [
                            'delivered' => 'bg-green-100 text-green-700 border-green-200',
                            'cancelled' => 'bg-red-100 text-red-700 border-red-200',
                            'shipped' => 'bg-blue-100 text-blue-700 border-blue-200',
                            'processing' => 'bg-theme-primary-light text-theme-primary border-theme-primary-light',
                            'pending' => 'bg-yellow-100 text-yellow-700 border-yellow-200',
                        ];
                        $statusLabels = [
                            'delivered' => 'ডেলিভারড',
                            'cancelled' => 'বাতিল',
                            'shipped' => 'শিফট',
                            'processing' => 'প্রসেসিং',
                            'pending' => 'পেন্ডিং',
                        ];
                        $currentStatusClass = $statusClasses[$order->status] ?? 'bg-gray-100 text-gray-700 border-gray-200';
                        $currentStatusLabel = $statusLabels[$order->status] ?? ucfirst($order->status);
                    @endphp
                    
                    <div class="grid grid-cols-1 md:grid-cols-12 gap-4 items-center py-5 border border-gray-100 rounded-xl hover:shadow-md transition-all duration-300 bg-white px-5 group">
                        <div class="col-span-1 md:col-span-2 font-heading font-bold text-gray-900">
                            <span class="md:hidden text-xs text-gray-400 uppercase tracking-wider mr-2 font-sans">অর্ডার:</span>
                            #{{ $order->order_number }}
                        </div>
                        <div class="col-span-1 md:col-span-3 text-gray-500 text-sm font-medium">
                             <span class="md:hidden text-xs text-gray-400 uppercase tracking-wider mr-2">তারিখ:</span>
                             {{ $order->created_at->format('M d, Y') }}
                        </div>
                        <div class="col-span-1 md:col-span-2">
                             <span class="inline-flex px-3 py-1 text-[10px] font-bold uppercase tracking-wider rounded-full border {{ $currentStatusClass }}">
                                 {{ $currentStatusLabel }}
                             </span>
                        </div>
                        <div class="col-span-1 md:col-span-2 font-bold text-theme-primary font-heading">
                            <span class="md:hidden text-xs text-gray-400 uppercase tracking-wider mr-2 font-sans">মোট:</span>
                            ৳{{ number_format($order->total_amount, 0) }}
                        </div>
                        <div class="col-span-1 md:col-span-2 flex justify-end">
                            <a href="{{ route('order.view', $order->id) }}" class="inline-flex items-center justify-center px-4 py-2 bg-gray-50 text-gray-700 rounded-lg hover:bg-theme-primary-light hover:text-theme-primary transition-all text-sm font-medium group">
                                বিস্তারিত দেখুন
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="mt-10">
                {{ $orders->links() }}
            </div>
        @else
            <div class="text-center py-24 bg-white rounded-2xl border border-gray-100 shadow-sm">
                <div class="w-20 h-20 mx-auto mb-6 bg-gray-50 rounded-full flex items-center justify-center text-gray-300">
                    <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path></svg>
                </div>
                <h3 class="text-2xl font-heading font-bold text-gray-900 mb-2">এখনও কোনো অর্ডার করেননি</h3>
                <p class="text-gray-500 mb-8">আপনি এখনও কোনো অর্ডার করেননি।</p>
                <a href="{{ route('shop') }}" class="inline-flex items-center px-8 py-3 bg-theme-primary text-white font-bold rounded-full hover:bg-theme-primary-hover transition-all duration-300 shadow-lg shadow-theme-primary/20">
                    কেনাকাটা শুরু করুন
                </a>
            </div>
        @endif
    </div>
</x-frontend-layout>