<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, viewport-fit=cover">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <!-- Mobile App Capable -->
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="{{ $generalSetting->name ?? 'Shop' }}">
    <meta name="theme-color" content="#ffffff">

    <title>{{ $generalSetting->name ?? config('app.name', 'Laravel') }}</title>

    <!-- Domain Verification -->
    {!! $generalSetting->facebook_verification_code ?? '' !!}
    {!! $generalSetting->tiktok_verification_code ?? '' !!}


    <!-- TikTok Pixel Code -->
    @if(isset($tiktokPixels) && count($tiktokPixels) > 0)
    <script>
        !function (w, d, t) {
        w.TiktokAnalyticsObject=t;var ttq=w[t]=w[t]||[];ttq.methods=["page","track","identify","instances","debug","on","off","once","ready","alias","group","enableCookie","disableCookie"],ttq.setAndDefer=function(t,e){t[e]=function(){t.push([e].concat(Array.prototype.slice.call(arguments,0)))}};for(var i=0;i<ttq.methods.length;i++)ttq.setAndDefer(ttq,ttq.methods[i]);ttq.instance=function(t){for(var e=ttq._i[t]||[],n=0;n<ttq.methods.length;n++)ttq.setAndDefer(e,ttq.methods[n]);return e},ttq.load=function(e,n){var i="https://analytics.tiktok.com/i18n/pixel/events.js";ttq._i=ttq._i||{},ttq._i[e]=[],ttq._i[e]._u=i,ttq._t=ttq._t||{},ttq._t[e]=+new Date,ttq._o=ttq._o||{},ttq._o[e]=n||{};var o=document.createElement("script");o.type="text/javascript",o.async=!0,o.src=i+"?sdkid="+e+"&lib="+t;var a=document.getElementsByTagName("script")[0];a.parentNode.insertBefore(o,a)};
        
        @foreach($tiktokPixels as $pixel)
            ttq.load('{{ $pixel->pixel_id }}');
        @endforeach

        @if(auth()->check())
            @php
                $user = auth()->user();
                // Normalize Phone for TikTok
                $phone = preg_replace('/[^0-9]/', '', $user->phone);
                if (strlen($phone) === 11 && substr($phone, 0, 2) === '01') {
                    $phone = '88' . $phone;
                }
                
                $tiktokUserData = [
                    'email' => strtolower(trim($user->email)),
                    'phone_number' => $phone,
                    'external_id' => (string)$user->id
                ];
            @endphp
            ttq.identify({!! json_encode($tiktokUserData) !!});
        @endif
        
        ttq.page();
        }(window, document, 'ttq');
    </script>
    @endif
    <!-- End TikTok Pixel Code -->

    <!-- Theme Configuration -->
    @include('partials.theme-style')

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" />
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

    <style>
        html {
            scroll-behavior: smooth;
            -webkit-tap-highlight-color: transparent;
        }
        body {
            overscroll-behavior-y: none;
        }
        /* Hide Scrollbar but allow scrolling */
        .no-scrollbar::-webkit-scrollbar {
            display: none;
        }
        .no-scrollbar {
            -ms-overflow-style: none;
            scrollbar-width: none;
        }
        /* Glassmorphism for Bottom Nav */
        .glass-nav {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-top: 1px solid rgba(0,0,0,0.05);
        }
        /* Active State Animation */
        .nav-item-active {
            color: var(--theme-primary, #f97316);
            transform: translateY(-5px);
            font-weight: 700;
        }
        .nav-item-active i {
            filter: drop-shadow(0 4px 8px rgba(249, 115, 22, 0.4));
            transform: scale(1.2);
            transition: transform 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }
        .nav-item-active span {
            font-weight: 700;
        }
    </style>

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script src="//unpkg.com/alpinejs" defer></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

    <!-- Facebook Pixel Code (Dynamic) -->
    @if(isset($facebookPixels) && count($facebookPixels) > 0)
    <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
        n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t,s)}(window, document,'script',
        'https://connect.facebook.net/en_US/fbevents.js');
        
        @php
            $pixelInitData = [];
            if(auth()->check()) {
                $user = auth()->user();
                
                // Normalize Phone
                $phone = preg_replace('/[^0-9]/', '', $user->phone);
                if (strlen($phone) === 11 && substr($phone, 0, 2) === '01') {
                    $phone = '88' . $phone;
                }

                $pixelInitData = [
                    'em' => strtolower(trim($user->email)),
                    'ph' => $phone,
                    'external_id' => (string)$user->id
                ];
                if($user->name) {
                    $parts = explode(' ', $user->name, 2);
                    $pixelInitData['fn'] = strtolower(trim($parts[0]));
                    $pixelInitData['ln'] = isset($parts[1]) ? strtolower(trim($parts[1])) : '';
                }
                $pixelInitData = array_filter($pixelInitData);
            }
        @endphp

        @foreach($facebookPixels as $pixel)
            @if(!empty($pixelInitData))
                fbq('init', '{{ $pixel->pixel_id }}', {!! json_encode($pixelInitData) !!});
            @else
                fbq('init', '{{ $pixel->pixel_id }}');
            @endif
        @endforeach
        
        fbq('track', 'PageView');
    </script>
    <noscript>
        @foreach($facebookPixels as $pixel)
            <img height="1" width="1" style="display:none"
            src="https://www.facebook.com/tr?id={{ $pixel->pixel_id }}&ev=PageView&noscript=1"
            />
        @endforeach
    </noscript>
    @endif
    <!-- End Facebook Pixel Code -->

    <!-- Flash Event Handling (Browser Pixel) -->
    @if(session('facebook_event'))
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            var eventData = @json(session('facebook_event'));
            var maxAttempts = 20;
            var attempt = 0;
            
            var interval = setInterval(function() {
                if (typeof fbq === 'function') {
                    clearInterval(interval);
                    // Ensure eventID is passed if present
                    var eventId = eventData.params.event_id || eventData.params.eventID;
                    var params = eventData.params;
                    if(eventId) {
                        delete params.event_id;
                        delete params.eventID;
                    }
                    
                    if(eventId) {
                         fbq('track', eventData.name, params, {eventID: eventId});
                    } else {
                         fbq('track', eventData.name, params);
                    }
                    console.log('Facebook Pixel: Flash Event ' + eventData.name + ' Fired');
                } else {
                    attempt++;
                    if (attempt >= maxAttempts) {
                        clearInterval(interval);
                        console.error('Facebook Pixel: fbq not defined for flash event');
                    }
                }
            }, 500);
        });
    </script>
    @endif

    <!-- Flash Event Handling (TikTok Pixel) -->
    @if(session('tiktok_event'))
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            var eventData = @json(session('tiktok_event'));
            var maxAttempts = 20;
            var attempt = 0;
            
            var interval = setInterval(function() {
                if (typeof ttq === 'object' && typeof ttq.track === 'function') {
                    clearInterval(interval);
                    var eventId = eventData.params.event_id || eventData.params.eventID;
                    var params = eventData.params;
                    
                    if(eventId) {
                        delete params.event_id;
                        delete params.eventID;
                    }

                    if(eventId) {
                         ttq.track(eventData.name, params, {event_id: eventId});
                    } else {
                         ttq.track(eventData.name, params);
                    }
                    console.log('TikTok Pixel: Flash Event ' + eventData.name + ' Fired');
                } else {
                    attempt++;
                    if (attempt >= maxAttempts) {
                        clearInterval(interval);
                        console.error('TikTok Pixel: ttq not defined for flash event');
                    }
                }
            }, 500);
        });
    </script>
    @endif
</head>
<body class="font-sans antialiased text-gray-900 bg-gray-50 pb-16 md:pb-0 theme-{{ $generalSetting->theme ?? 'default' }}" 
      x-data="{ 
          open: false, 
          searchOpen: false, 
          cartCount: {{ count(Session::get('cart', [])) }},
          isHome: {{ request()->is('/') ? 'true' : 'false' }}, 
          isShop: {{ request()->routeIs('shop') ? 'true' : 'false' }}, 
          isTracking: {{ request()->routeIs('order.tracking') ? 'true' : 'false' }},
          init() { AOS.init({ once: true, duration: 800 }); } 
      }"
      @cart-updated.window="cartCount = $event.detail.count">
    
    <!-- Top Bar -->
    <div class="bg-theme-primary text-white py-1.5 block">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex flex-row justify-between items-center text-xs md:text-sm font-medium">
            <div>সারা বাংলাদেশে হোম ডেলিভারি</div>
            
            <div class="flex items-center gap-4">
                <!-- Social Media Icons (hidden on mobile) -->
                <div class="hidden md:flex items-center gap-4">
                    @if(isset($socialMedias))
                        @foreach($socialMedias as $social)
                            <a href="{{ $social->link }}" target="_blank" class="hover:text-orange-200 transition-colors">
                                <i class="{{ $social->icon }} text-lg"></i>
                            </a>
                        @endforeach
                    @endif
                </div>

                <!-- Desktop Contact & Tracking -->
                <div class="hidden md:flex items-center space-x-4 md:space-x-6">
                    <a href="tel:{{ $contactSetting->phone_number ?? '09642922922' }}" class="flex items-center hover:text-orange-100 transition-colors">
                        <i class="fas fa-phone-alt mr-2 text-xs"></i> {{ $contactSetting->phone_number ?? '09642-922922' }}
                    </a>
                    <a href="{{ route('order.tracking') }}" class="hover:text-orange-100 transition-colors">অর্ডার ট্র্যাকিং</a>
                </div>

                <!-- Mobile Tracking Link (Visible only on mobile) -->
                <a href="{{ route('order.tracking') }}" class="md:hidden flex items-center hover:text-orange-100 transition-colors">
                    <i class="fas fa-truck mr-1.5"></i> অর্ডার ট্র্যাকিং
                </a>
            </div>
        </div>
    </div>

    <!-- Main Header -->
    <nav class="bg-white border-b border-gray-100 sticky top-0 z-50 shadow-sm/50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-20 gap-4 lg:gap-8">
                <!-- Left: Logo & Mobile Menu -->
                <div class="flex items-center">
                    <!-- Hamburger (Mobile) - HIDDEN as per request -->
                    <button @click="open = !open" class="hidden items-center justify-center p-2 rounded-md text-gray-500 hover:text-theme-primary hover:bg-theme-primary-light focus:outline-none transition duration-150 ease-in-out md:hidden mr-2">
                        <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                            <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                            <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>

                    <!-- Logo -->
                    <div class="shrink-0 flex items-center">
                        <a href="{{ url('/') }}" class="text-2xl font-bold text-theme-primary flex items-center gap-2">
                            @if(isset($generalSetting) && $generalSetting->dark_logo)
                                <img src="{{ Storage::url($generalSetting->dark_logo) }}" alt="{{ $generalSetting->name ?? 'GhorerBazar' }}" class="h-10">
                            @else
                                <span class="font-heading tracking-tight text-3xl">{{ $generalSetting->name ?? 'GhorerBazar' }}</span>
                            @endif
                        </a>
                    </div>
                </div>

                <!-- Center: Search Bar (Desktop) -->
                <div class="hidden md:flex flex-1 max-w-2xl mx-auto z-50">
                    <form action="{{ route('shop') }}" method="GET" class="w-full relative group">
                        <div class="relative flex items-center w-full">
                            <input type="text" name="search" id="desktopSearchInput" placeholder="পণ্য খুঁজুন..." 
                                class="w-full pl-5 pr-12 py-2.5 rounded-full border-2 border-gray-100 bg-gray-50 text-gray-800 placeholder-gray-400 focus:border-theme-primary focus:bg-white focus:ring-0 transition-all duration-300"
                                value="{{ request('search') }}" autocomplete="off">
                            
                            <!-- Loading Spinner -->
                            <div id="searchLoading" class="absolute right-14 top-1/2 -translate-y-1/2 hidden">
                                <i class="fas fa-spinner fa-spin text-theme-primary"></i>
                            </div>

                            <button type="submit" id="searchSubmitBtn" class="absolute right-0 top-0 bottom-0 bg-theme-primary text-white px-5 rounded-r-full hover:bg-theme-primary-hover transition-colors duration-300 flex items-center justify-center">
                                <i class="fas fa-search"></i>
                            </button>
                        </div>


                        <!-- Suggestions Dropdown (Mega Menu Style) -->
                        <div id="searchSuggestions" class="absolute top-full left-1/2 transform -translate-x-1/2 w-[120%] bg-white shadow-2xl rounded-xl border border-gray-100 mt-2 z-[100] hidden overflow-hidden">
                            <!-- Content will be injected via JS -->
                        </div>
                    </form>
                </div>

                <!-- Right: Actions -->
                <div class="flex items-center gap-3 sm:gap-6">
                    <!-- Search Toggle (Mobile) -->
                    <button @click="searchOpen = !searchOpen" class="md:hidden p-2 text-gray-500 hover:text-theme-primary transition-colors">
                        <i class="fas fa-search text-xl"></i>
                    </button>

                    <!-- Hotline (Desktop) -->
                    <div class="hidden lg:flex flex-col items-end leading-tight">
                        <span class="text-xs text-gray-500 font-medium">অর্ডার করতে কল করুন</span>
                        <a href="tel:{{ $contactSetting->hotline_number ?? '09642922922' }}" class="text-theme-primary font-bold text-lg hover:text-theme-primary-hover">{{ $contactSetting->hotline_number ?? '09642-922922' }}</a>
                    </div>

                    <!-- Cart -->
                    <a href="{{ route('cart.index') }}" class="relative group p-1">
                        <div class="w-10 h-10 rounded-full bg-theme-primary-light text-theme-primary flex items-center justify-center group-hover:bg-theme-primary group-hover:text-white transition-all duration-300">
                            <i class="fas fa-shopping-bag text-lg"></i>
                        </div>
                        <span x-show="cartCount > 0" x-transition 
                              class="absolute -top-1 -right-1 h-5 w-5 bg-red-600 text-white text-[10px] font-bold flex items-center justify-center rounded-full shadow-sm border-2 border-white"
                              style="display: none;">
                            <span x-text="cartCount">{{ count(Session::get('cart', [])) }}</span>
                        </span>
                    </a>

                    <!-- User Account -->
                    @auth
                        <div class="relative" x-data="{ userOpen: false }">
                            <button @click="userOpen = !userOpen" class="flex items-center gap-2 focus:outline-none">
                                <div class="w-10 h-10 rounded-full bg-gray-100 text-gray-600 flex items-center justify-center hover:bg-gray-200 transition-all duration-300 border border-gray-200">
                                    <i class="fas fa-user text-lg"></i>
                                </div>
                            </button>
                            
                            <!-- Dropdown -->
                            <div x-show="userOpen" @click.away="userOpen = false" 
                                x-transition:enter="transition ease-out duration-200"
                                x-transition:enter-start="opacity-0 scale-95"
                                x-transition:enter-end="opacity-100 scale-100"
                                x-transition:leave="transition ease-in duration-75"
                                x-transition:leave-start="opacity-100 scale-100"
                                x-transition:leave-end="opacity-0 scale-95"
                                class="absolute right-0 mt-3 w-56 rounded-xl shadow-xl bg-white ring-1 ring-black ring-opacity-5 py-2 z-50 overflow-hidden transform origin-top-right" 
                                style="display: none;">
                                
                                <div class="px-4 py-3 border-b border-gray-100 bg-gray-50/50">
                                    <p class="text-sm text-gray-500">স্বাগতম,</p>
                                    <p class="text-sm font-bold text-gray-900 truncate">{{ Auth::user()->name }}</p>
                                </div>

                                @role('Super Admin|Admin|Staff')
                                    <a href="{{ route('admin.dashboard') }}" class="flex items-center px-4 py-2.5 text-sm text-gray-700 hover:bg-orange-50 hover:text-orange-600 transition-colors">
                                        <i class="fas fa-tachometer-alt w-5 text-center mr-2 text-gray-400"></i> অ্যাডমিন ড্যাশবোর্ড
                                    </a>
                                @endrole
                                
                                <a href="{{ route('dashboard') }}" class="flex items-center px-4 py-2.5 text-sm text-gray-700 hover:bg-orange-50 hover:text-orange-600 transition-colors">
                                    <i class="fas fa-user-circle w-5 text-center mr-2 text-gray-400"></i> আমার অ্যাকাউন্ট
                                </a>
                                
                                <a href="{{ route('dashboard') }}" class="flex items-center px-4 py-2.5 text-sm text-gray-700 hover:bg-orange-50 hover:text-orange-600 transition-colors">
                                    <i class="fas fa-box w-5 text-center mr-2 text-gray-400"></i> আমার অর্ডার
                                </a>

                                <form method="POST" action="{{ route('logout') }}">
                                    @csrf
                                    <button type="submit" class="w-full text-left flex items-center px-4 py-2.5 text-sm text-red-600 hover:bg-red-50 transition-colors border-t border-gray-100">
                                        <i class="fas fa-sign-out-alt w-5 text-center mr-2"></i> লগআউট
                                    </button>
                                </form>
                            </div>
                        </div>
                    @else
                        <!-- Desktop Login Button -->
                        <a href="{{ route('login') }}" class="hidden md:flex items-center justify-center px-6 py-2 bg-theme-primary text-white text-sm font-bold rounded-full hover:bg-theme-primary-hover transition-all duration-300 shadow-lg hover:shadow-orange-200 transform hover:-translate-y-0.5">
                            লগইন
                        </a>
                        
                        <!-- Mobile Login Icon -->
                        <a href="{{ route('login') }}" class="md:hidden w-10 h-10 rounded-full bg-gray-100 text-gray-600 flex items-center justify-center hover:bg-gray-200 transition-all duration-300 border border-gray-200">
                            <i class="fas fa-user text-lg"></i>
                        </a>
                    @endauth
                </div>
            </div>
        </div>

        <!-- Category Navbar (Desktop) -->
        <div class="hidden md:block bg-theme-primary shadow-md relative z-40">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex items-center justify-center gap-2 py-2 h-14 text-sm font-semibold text-white overflow-x-auto no-scrollbar whitespace-nowrap">
                    @php
                        $activeCategory = request('category');
                        $isShopRoute = request()->routeIs('shop');
                    @endphp
                    <a href="{{ route('shop') }}" title="সব পণ্য"
                       class="group relative inline-flex items-center h-10 px-4 rounded-full border border-white/20 {{ $isShopRoute && !$activeCategory ? 'bg-white text-gray-900 shadow-md' : 'bg-transparent text-white hover:bg-white/10' }} transition-all duration-200 ease-out">
                        <i class="fas fa-th-large mr-2"></i> সব পণ্য
                        <span class="absolute bottom-1 left-3 right-3 h-0.5 bg-white/50 scale-x-0 group-hover:scale-x-100 transition-transform origin-left"></span>
                    </a>
                    @if(isset($globalCategories))
                        @foreach($globalCategories as $category)
                            <div class="relative">
                                <a href="{{ route('shop', ['category' => $category->slug]) }}" title="{{ $category->name }}"
                                   class="group relative inline-flex items-center h-10 px-4 rounded-full border border-white/20 {{ $activeCategory === $category->slug ? 'bg-white text-gray-900 shadow-md' : 'bg-transparent text-white hover:bg-white/10' }} transition-all duration-200 ease-out">
                                    <span>{{ $category->name }}</span>
                                    @if($category->children->count() > 0)
                                        <i class="fas fa-chevron-down text-[10px] opacity-80 ml-2"></i>
                                    @endif
                                    <span class="absolute bottom-1 left-3 right-3 h-0.5 bg-white/50 scale-x-0 group-hover:scale-x-100 transition-transform origin-left"></span>
                                </a>
                                
                                <!-- Dropdown for Subcategories -->
                                @if($category->children->count() > 0)
                                    <div class="absolute top-[44px] left-1/2 -translate-x-1/2 w-64 bg-white/95 backdrop-blur shadow-2xl rounded-xl border border-gray-100 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 transform origin-top z-50">
                                        <div class="py-2">
                                            @foreach($category->children as $child)
                                                <a href="{{ route('shop', ['category' => $child->slug]) }}"
                                                   class="flex items-center gap-2 px-4 py-2.5 text-gray-700 hover:bg-gray-50 hover:text-theme-primary transition-colors border-b border-gray-50 last:border-0">
                                                    <span class="w-2 h-2 rounded-full bg-theme-primary/60"></span>
                                                    <span class="text-sm">{{ $child->name }}</span>
                                                </a>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>

        <!-- Mobile Search Bar (Appears below header) -->
        <div x-show="searchOpen" 
             x-transition:enter="transition ease-out duration-200"
             x-transition:enter-start="opacity-0 -translate-y-2"
             x-transition:enter-end="opacity-100 translate-y-0"
             x-transition:leave="transition ease-in duration-150"
             x-transition:leave-start="opacity-100 translate-y-0"
             x-transition:leave-end="opacity-0 -translate-y-2"
             class="md:hidden bg-white border-b border-gray-100 p-4 absolute top-20 left-0 w-full z-40 shadow-lg"
             style="display: none;">
            <form action="{{ route('shop') }}" method="GET" class="relative">
                <input type="text" name="search" id="mobileSearchInput" placeholder="পণ্য খুঁজুন..." 
                    class="w-full pl-4 pr-10 py-3 rounded-lg border border-gray-200 bg-gray-50 focus:bg-white focus:border-theme-primary focus:ring-0 transition-colors"
                    value="{{ request('search') }}">
                <button type="submit" class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-theme-primary">
                    <i class="fas fa-search text-lg"></i>
                </button>

                <!-- Mobile Suggestions -->
                <div id="mobileSearchSuggestions" class="absolute top-full left-0 w-full bg-white shadow-lg rounded-b-lg border border-t-0 border-gray-100 mt-1 z-50 hidden">
                </div>
            </form>
        </div>
    </nav>

    <!-- Bottom Navigation (Mobile) -->
    <div class="md:hidden fixed bottom-0 left-0 w-full glass-nav z-[100] pb-safe">
        <div class="grid grid-cols-4 h-16 items-center">
            <a href="{{ route('home') }}" class="flex flex-col items-center justify-center gap-1 text-gray-500 hover:text-theme-primary transition-all duration-300 {{ request()->is('/') ? 'nav-item-active' : '' }}">
                <i class="fas fa-home text-xl"></i>
                <span class="text-[10px] font-medium">হোম</span>
            </a>
            <a href="{{ route('shop') }}" class="flex flex-col items-center justify-center gap-1 text-gray-500 hover:text-theme-primary transition-all duration-300 {{ request()->routeIs('shop') ? 'nav-item-active' : '' }}">
                <i class="fas fa-th-large text-xl"></i>
                <span class="text-[10px] font-medium">শপ</span>
            </a>
            <a href="{{ route('cart.index') }}" class="flex flex-col items-center justify-center gap-1 text-gray-500 hover:text-theme-primary transition-all duration-300 relative {{ request()->routeIs('cart.index') ? 'nav-item-active' : '' }}">
                <div class="relative">
                    <i class="fas fa-shopping-bag text-xl"></i>
                    <span x-show="cartCount > 0" x-transition 
                          class="absolute -top-2 -right-2 h-4 w-4 bg-theme-primary text-white text-[9px] font-bold flex items-center justify-center rounded-full shadow-sm"
                          style="display: none;">
                        <span x-text="cartCount">{{ count(Session::get('cart', [])) }}</span>
                    </span>
                </div>
                <span class="text-[10px] font-medium">কার্ট</span>
            </a>
            <a href="{{ route('order.tracking') }}" class="flex flex-col items-center justify-center gap-1 text-gray-500 hover:text-theme-primary transition-all duration-300 {{ request()->routeIs('order.tracking') ? 'nav-item-active' : '' }}">
                <i class="fas fa-truck text-xl"></i>
                <span class="text-[10px] font-medium">ট্র্যাকিং</span>
            </a>
        </div>
    </div>

    <!-- Main Content -->
    <main>
        {{ $slot }}
    </main>

    <!-- Footer -->
    <footer class="bg-gray-900 text-gray-300 pt-16 pb-24 md:pb-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12 mb-12 justify-items-center md:justify-items-start text-center md:text-left">
                <!-- Company Info -->
                <div class="space-y-6">
                    <a href="{{ url('/') }}" class="inline-block">
                        @if(isset($generalSetting) && $generalSetting->white_logo)
                            <img src="{{ Storage::url($generalSetting->white_logo) }}" alt="{{ $generalSetting->name }}" class="h-10 opacity-90 hover:opacity-100 transition-opacity">
                        @else
                            <span class="text-2xl font-heading font-bold text-white">{{ $generalSetting->name ?? 'GhorerBazar' }}</span>
                        @endif
                    </a>
                    <p class="text-gray-400 text-sm leading-relaxed">
                        {{ $generalSetting->description ?? 'সেরা মানের পণ্য, সবচেয়ে কম দামে।' }}
                    </p>
                    <div class="flex gap-4 justify-center md:justify-start">
                        @if(isset($socialMedias))
                            @foreach($socialMedias as $social)
                                <a href="{{ $social->link }}" target="_blank" class="w-10 h-10 rounded-full bg-gray-800 flex items-center justify-center hover:bg-theme-primary hover:text-white transition-all duration-300 transform hover:-translate-y-1">
                                    <i class="{{ $social->icon }}"></i>
                                </a>
                            @endforeach
                        @endif
                    </div>
                </div>

                <!-- Quick Links -->
                <div>
                    <h3 class="text-white font-bold text-lg mb-6 flex items-center gap-2 justify-center md:justify-start">
                        <span class="w-1 h-6 bg-theme-primary rounded-full"></span>
                        গুরুত্বপূর্ণ লিঙ্ক
                    </h3>
                    <ul class="space-y-3">
                        <li><a href="{{ route('shop') }}" class="hover:text-theme-primary transition-colors flex items-center gap-2 justify-center md:justify-start"><i class="fas fa-angle-right text-xs"></i> সব পণ্য</a></li>
                        <li><a href="{{ route('order.tracking') }}" class="hover:text-theme-primary transition-colors flex items-center gap-2 justify-center md:justify-start"><i class="fas fa-angle-right text-xs"></i> অর্ডার ট্র্যাকিং</a></li>
                        <li><a href="{{ route('cart.index') }}" class="hover:text-theme-primary transition-colors flex items-center gap-2 justify-center md:justify-start"><i class="fas fa-angle-right text-xs"></i> শপিং কার্ট</a></li>
                        <li><a href="{{ route('login') }}" class="hover:text-theme-primary transition-colors flex items-center gap-2 justify-center md:justify-start"><i class="fas fa-angle-right text-xs"></i> লগইন / রেজিস্টার</a></li>
                    </ul>
                </div>

                <!-- Customer Service -->
                <div>
                    <h3 class="text-white font-bold text-lg mb-6 flex items-center gap-2 justify-center md:justify-start">
                        <span class="w-1 h-6 bg-theme-primary rounded-full"></span>
                        কাস্টমার সার্ভিস
                    </h3>
                    <ul class="space-y-3">
                        <li>
                            <a href="{{ route('order.tracking') }}" class="hover:text-theme-primary transition-colors flex items-center gap-2 justify-center md:justify-start">
                                <i class="fas fa-angle-right text-xs"></i> অর্ডার ট্র্যাক করুন
                            </a>
                        </li>
                        <li>
                            <a href="#" class="hover:text-theme-primary transition-colors flex items-center gap-2 justify-center md:justify-start">
                                <i class="fas fa-angle-right text-xs"></i> রিটার্ন পলিসি
                            </a>
                        </li>
                        <li>
                            <a href="#" class="hover:text-theme-primary transition-colors flex items-center gap-2 justify-center md:justify-start">
                                <i class="fas fa-angle-right text-xs"></i> সচরাচর জিজ্ঞাসিত প্রশ্ন
                            </a>
                        </li>
                    </ul>
                </div>

                <!-- Contact Info -->
                <div>
                    <h3 class="text-white font-bold text-lg mb-6 flex items-center gap-2 justify-center md:justify-start">
                        <span class="w-1 h-6 bg-theme-primary rounded-full"></span>
                        যোগাযোগ করুন
                    </h3>
                    <ul class="space-y-4">
                        <li class="flex items-start gap-3 justify-center md:justify-start">
                            <div class="w-8 h-8 rounded bg-gray-800 flex items-center justify-center flex-shrink-0 text-theme-primary">
                                <i class="fas fa-map-marker-alt"></i>
                            </div>
                            <span class="text-sm text-gray-400 leading-relaxed">{{ $contactSetting->address ?? 'Dhaka, Bangladesh' }}</span>
                        </li>
                        <li class="flex items-center gap-3 justify-center md:justify-start">
                            <div class="w-8 h-8 rounded bg-gray-800 flex items-center justify-center flex-shrink-0 text-theme-primary">
                                <i class="fas fa-phone-alt"></i>
                            </div>
                            <div class="flex flex-col">
                                <a href="tel:{{ $contactSetting->phone_number ?? '' }}" class="text-sm hover:text-theme-primary transition-colors">{{ $contactSetting->phone_number ?? '' }}</a>
                                @if($contactSetting->hotline_number)
                                <a href="tel:{{ $contactSetting->hotline_number }}" class="text-sm hover:text-theme-primary transition-colors">{{ $contactSetting->hotline_number }}</a>
                                @endif
                            </div>
                        </li>
                        <li class="flex items-center gap-3 justify-center md:justify-start">
                            <div class="w-8 h-8 rounded bg-gray-800 flex items-center justify-center flex-shrink-0 text-theme-primary">
                                <i class="fas fa-envelope"></i>
                            </div>
                            <a href="mailto:{{ $contactSetting->email ?? '' }}" class="text-sm hover:text-theme-primary transition-colors">{{ $contactSetting->email ?? '' }}</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        
        <!-- Copyright -->
        <div class="border-t border-gray-800 bg-gray-950/50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
                <div class="flex flex-col md:flex-row {{ isset($generalSetting) && ($generalSetting->show_developer_credit ?? true) ? 'justify-between' : 'justify-center' }} items-center gap-4">
                    <p class="text-sm text-gray-500 {{ isset($generalSetting) && ($generalSetting->show_developer_credit ?? true) ? 'text-center md:text-left' : 'text-center' }}">
                        &copy; {{ date('Y') }} <span class="text-white font-bold">{{ $generalSetting->name ?? 'GhorerBazar' }}</span>. All rights reserved.
                    </p>
                    @if(isset($generalSetting) && ($generalSetting->show_developer_credit ?? true))
                        <div class="flex items-center gap-2">
                            <span class="text-xs text-gray-600">Design & Developed by</span>
                            <a href="https://www.facebook.com/shoyibhasan.ID" target="_blank" class="text-xs font-bold text-gray-400 hover:text-theme-primary transition-colors flex items-center gap-1">
                                <i class="fab fa-facebook"></i> Shoyib Hasan
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </footer>

    <!-- Search Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Reusable search function
            function setupSearch(inputId, suggestionsId, loadingId = null) {
                const input = document.getElementById(inputId);
                const suggestions = document.getElementById(suggestionsId);
                const loading = loadingId ? document.getElementById(loadingId) : null;
                
                if (!input || !suggestions) return;

                let timeoutId;

                input.addEventListener('input', function() {
                    clearTimeout(timeoutId);
                    const query = this.value.trim();

                    if (query.length < 1) {
                        suggestions.classList.add('hidden');
                        suggestions.innerHTML = '';
                        return;
                    }

                    if (loading) loading.classList.remove('hidden');

                    timeoutId = setTimeout(() => {
                        fetch(`{{ route('search.suggestions') }}?query=${encodeURIComponent(query)}`)
                            .then(response => response.json())
                            .then(data => {
                                if (loading) loading.classList.add('hidden');
                                
                                if (data.length > 0) {
                                    const html = data.map(product => `
                                        <a href="/product/${product.slug}" class="flex items-center gap-3 p-3 hover:bg-gray-50 transition-colors border-b border-gray-50 last:border-0">
                                            <div class="w-10 h-10 rounded overflow-hidden bg-gray-100 flex-shrink-0">
                                                <img src="${product.thumbnail_url || product.thumbnail || '/images/no-image.svg'}" alt="${product.name}" class="w-full h-full object-cover">
                                            </div>
                                            <div class="flex-1 min-w-0">
                                                <h4 class="text-sm font-medium text-gray-900 truncate">${product.name}</h4>
                                                <div class="flex items-center gap-2 mt-0.5">
                                                    <span class="text-xs font-bold text-theme-primary">৳${product.price}</span>
                                                    ${product.original_price > product.price ? 
                                                        `<span class="text-[10px] text-gray-400 line-through">৳${product.original_price}</span>` : ''}
                                                </div>
                                            </div>
                                        </a>
                                    `).join('');
                                    
                                    suggestions.innerHTML = html;
                                    suggestions.classList.remove('hidden');
                                } else {
                                    suggestions.innerHTML = `
                                        <div class="p-4 text-center text-gray-500 text-sm">
                                            কোন পণ্য খুঁজে পাওয়া যায়নি
                                        </div>
                                    `;
                                    suggestions.classList.remove('hidden');
                                }
                            })
                            .catch(error => {
                                console.error('Error:', error);
                                if (loading) loading.classList.add('hidden');
                            });
                    }, 150); // faster debounce
                });

                // Hide on click outside
                document.addEventListener('click', function(e) {
                    if (!input.contains(e.target) && !suggestions.contains(e.target)) {
                        suggestions.classList.add('hidden');
                    }
                });
            }

            // Setup Desktop Search
            setupSearch('desktopSearchInput', 'searchSuggestions', 'searchLoading');

            // Setup Mobile Search
            setupSearch('mobileSearchInput', 'mobileSearchSuggestions');
        });
    </script>

    @stack('scripts')
</body>
</html>
