@props(['startDate' => null, 'endDate' => null, 'formId' => null, 'autoSubmit' => true])

<div class="relative w-full" x-data="{
    picker: null,
    init() {
        const self = this;
        const hasDates = '{{ $startDate }}' && '{{ $endDate }}';
        const start = hasDates ? moment('{{ $startDate }}') : moment();
        const end = hasDates ? moment('{{ $endDate }}') : moment();

        $(this.$refs.picker).daterangepicker({
            startDate: start,
            endDate: end,
            ranges: {
               'Today': [moment(), moment()],
               'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
               'Last 7 Days': [moment().subtract(6, 'days'), moment()],
               'Last 15 Days': [moment().subtract(14, 'days'), moment()],
               'Last 30 Days': [moment().subtract(29, 'days'), moment()],
               'This Month': [moment().startOf('month'), moment().endOf('month')],
               'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
               'Last 3 Month': [moment().subtract(3, 'month').startOf('month'), moment().endOf('month')],
               'This Year': [moment().startOf('year'), moment().endOf('year')],
               'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
               'LifeTime': [moment('2020-01-01'), moment()]
            },
            autoUpdateInput: false,
            opens: 'left',
            locale: {
                format: 'YYYY-MM-DD',
                cancelLabel: 'Clear'
            }
        });

        $(this.$refs.picker).on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('YYYY-MM-DD') + ' - ' + picker.endDate.format('YYYY-MM-DD'));
            self.$refs.start.value = picker.startDate.format('YYYY-MM-DD');
            self.$refs.end.value = picker.endDate.format('YYYY-MM-DD');
            
            @if($formId && $autoSubmit)
                document.getElementById('{{ $formId }}').submit();
            @endif
        });

        $(this.$refs.picker).on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            self.$refs.start.value = '';
            self.$refs.end.value = '';
             @if($formId && $autoSubmit)
                document.getElementById('{{ $formId }}').submit();
            @endif
        });
        
        // Set initial value if dates exist
        if (hasDates) {
            $(this.$refs.picker).val(start.format('YYYY-MM-DD') + ' - ' + end.format('YYYY-MM-DD'));
        }
    }
}">
    <div class="relative group">
        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
            <svg class="w-5 h-5 text-slate-400 group-focus-within:text-blue-500 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
        </div>
        <input type="text" x-ref="picker" class="cursor-pointer bg-white border border-slate-200 text-slate-700 text-sm rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 block w-full pl-10 pr-4 py-2.5 shadow-sm hover:bg-slate-50 transition-all placeholder-slate-400 font-medium" placeholder="Select Date Range" readonly>
    </div>
    
    <input type="hidden" name="start_date" x-ref="start" value="{{ $startDate }}" @if($formId) form="{{ $formId }}" @endif>
    <input type="hidden" name="end_date" x-ref="end" value="{{ $endDate }}" @if($formId) form="{{ $formId }}" @endif>
</div>
