<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        @if(isset($gtmContainers) && $gtmContainers->count() > 0)
            @foreach($gtmContainers as $gtm)
            <!-- Google Tag Manager -->
            <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
            new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
            'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
            })(window,document,'script','dataLayer','{{ $gtm->gtm_id }}');</script>
            <!-- End Google Tag Manager -->
            @endforeach
        @elseif(isset($generalSetting) && $generalSetting->gtm_enabled && $generalSetting->gtm_id)
        <!-- Google Tag Manager -->
        <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
        new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
        j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
        'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','{{ $generalSetting->gtm_id }}');</script>
        <!-- End Google Tag Manager -->
        @endif

        @if(isset($tiktokPixels) && $tiktokPixels->count() > 0)
            <!-- TikTok Pixel -->
            <script>
            !function (w, d, t) {
              w.TiktokAnalyticsObject=t;var ttq=w[t]=w[t]||[];ttq.methods=["page","track","identify","instances","debug","on","off","once","ready","alias","group","enableCookie","disableCookie"],ttq.setAndDefer=function(t,e){t[e]=function(){t.push([e].concat(Array.prototype.slice.call(arguments,0)))}};for(var i=0;i<ttq.methods.length;i++)ttq.setAndDefer(ttq,ttq.methods[i]);ttq.instance=function(t){for(var e=ttq.methods[i=0];i<ttq.methods.length;i++)ttq.setAndDefer(e,ttq.methods[i]);return e},ttq.load=function(e,n){var i="https://analytics.tiktok.com/i18n/pixel/events.js";ttq._i=ttq._i||{},ttq._i[e]=[],ttq._i[e]._u=i,ttq._t=ttq._t||{},ttq._t[e]=+new Date,ttq._o=ttq._o||{},ttq._o[e]=n||{};var o=document.createElement("script");o.type="text/javascript",o.async=!0,o.src=i+"?sdkid="+e+"&lib="+t;var a=document.getElementsByTagName("script")[0];a.parentNode.insertBefore(o,a)};
            
              @foreach($tiktokPixels as $pixel)
              ttq.load('{{ $pixel->pixel_id }}');
              @endforeach
              ttq.page();
            }(window, document, 'ttq');
            </script>
            <!-- End TikTok Pixel -->
        @endif

        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        @if(isset($generalSetting) && $generalSetting->favicon)
            <link rel="icon" href="{{ asset('storage/' . $generalSetting->favicon) }}" type="image/x-icon"/>
        @endif

        <title>{{ isset($generalSetting) && $generalSetting->name ? $generalSetting->name : config('app.name', 'Laravel') }}</title>

        @if(isset($generalSetting))
            <meta name="description" content="{{ $generalSetting->meta_description }}">
            <meta name="keywords" content="{{ $generalSetting->meta_keyword }}">
        @endif

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
        
        <style>
            .font-heading { font-family: 'Outfit', sans-serif; }
            body { font-family: 'Plus Jakarta Sans', sans-serif; }
        </style>

        @if(isset($generalSetting) && $generalSetting->facebook_verification_code)
            <meta name="facebook-domain-verification" content="{{ $generalSetting->facebook_verification_code }}" />
        @endif

        @if(isset($facebookPixels) && $facebookPixels->count() > 0)
            <!-- Meta Pixel Code -->
            <script>
            !function(f,b,e,v,n,t,s)
            {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
            n.callMethod.apply(n,arguments):n.queue.push(arguments)};
            if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
            n.queue=[];t=b.createElement(e);t.async=!0;
            t.src=v;s=b.getElementsByTagName(e)[0];
            s.parentNode.insertBefore(t,s)}(window, document,'script',
            'https://connect.facebook.net/en_US/fbevents.js');
            @foreach($facebookPixels as $pixel)
            fbq('init', '{{ $pixel->pixel_id }}');
            @endforeach
            fbq('track', 'PageView');
            </script>
            @foreach($facebookPixels as $pixel)
            <noscript><img height="1" width="1" style="display:none"
            src="https://www.facebook.com/tr?id={{ $pixel->pixel_id }}&ev=PageView&noscript=1"
            /></noscript>
            @endforeach
            <!-- End Meta Pixel Code -->
        @elseif(isset($generalSetting) && $generalSetting->facebook_pixel_enabled && $generalSetting->facebook_pixel_id)
            <!-- Meta Pixel Code (Legacy) -->
            <script>
            !function(f,b,e,v,n,t,s)
            {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
            n.callMethod.apply(n,arguments):n.queue.push(arguments)};
            if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
            n.queue=[];t=b.createElement(e);t.async=!0;
            t.src=v;s=b.getElementsByTagName(e)[0];
            s.parentNode.insertBefore(t,s)}(window, document,'script',
            'https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '{{ $generalSetting->facebook_pixel_id }}');
            fbq('track', 'PageView');
            </script>
            <noscript><img height="1" width="1" style="display:none"
            src="https://www.facebook.com/tr?id={{ $generalSetting->facebook_pixel_id }}&ev=PageView&noscript=1"
            /></noscript>
            <!-- End Meta Pixel Code -->
        @endif
    </head>
    <body class="font-sans text-gray-900 antialiased">
        @if(isset($gtmContainers) && $gtmContainers->count() > 0)
            @foreach($gtmContainers as $gtm)
            <!-- Google Tag Manager (noscript) -->
            <noscript><iframe src="https://www.googletagmanager.com/ns.html?id={{ $gtm->gtm_id }}"
            height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
            <!-- End Google Tag Manager (noscript) -->
            @endforeach
        @elseif(isset($generalSetting) && $generalSetting->gtm_enabled && $generalSetting->gtm_id)
        <!-- Google Tag Manager (noscript) -->
        <noscript><iframe src="https://www.googletagmanager.com/ns.html?id={{ $generalSetting->gtm_id }}"
        height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
        <!-- End Google Tag Manager (noscript) -->
        @endif
        
        <div class="min-h-screen grid grid-cols-1 lg:grid-cols-2 bg-white">
            
            <!-- Left Side: Branding (Desktop Only) -->
            <div class="hidden lg:flex flex-col justify-between bg-gray-900 relative overflow-hidden p-12 text-white">
                <!-- Background Gradient/Pattern -->
                <div class="absolute inset-0 bg-gradient-to-br from-gray-900 via-gray-800 to-gray-900 z-0"></div>
                <div class="absolute inset-0 bg-[url('https://images.unsplash.com/photo-1557683316-973673baf926?q=80&w=2029&auto=format&fit=crop')] bg-cover bg-center opacity-20 mix-blend-overlay z-0"></div>
                
                <!-- Decorative Blobs -->
                <div class="absolute top-0 right-0 -mr-20 -mt-20 w-80 h-80 rounded-full bg-orange-500/20 blur-[100px] z-0"></div>
                <div class="absolute bottom-0 left-0 -ml-20 -mb-20 w-80 h-80 rounded-full bg-blue-500/20 blur-[100px] z-0"></div>

                <!-- Logo (Centered, Large, Round Badge with Glow) -->
                <div class="relative z-10 flex justify-center">
                    <a href="/" class="relative block">
                        <div class="inline-flex items-center justify-center rounded-full p-[6px] bg-[conic-gradient(at_top_right,_#fb7185,_#a78bfa,_#60a5fa,_#fb7185)] shadow-2xl">
                            <div class="rounded-full bg-white p-[6px]">
                                <div class="w-20 h-20 md:w-24 md:h-24 rounded-full bg-white flex items-center justify-center">
                                    @if(isset($generalSetting) && $generalSetting->dark_logo)
                                        <img src="{{ asset('storage/' . $generalSetting->dark_logo) }}" alt="{{ $generalSetting->name }}" class="max-h-10 md:max-h-12 object-contain">
                                    @elseif(isset($generalSetting) && $generalSetting->white_logo)
                                        <img src="{{ asset('storage/' . $generalSetting->white_logo) }}" alt="{{ $generalSetting->name }}" class="max-h-10 md:max-h-12 object-contain">
                                    @else
                                        <span class="text-base md:text-lg font-heading font-bold text-gray-900">{{ $generalSetting->name ?? config('app.name') }}</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </a>
                </div>

                <!-- Quote/Welcome Text -->
                <div class="relative z-10 space-y-6 max-w-lg">
                    <h2 class="text-4xl font-heading font-bold leading-tight">
                        {{ $generalSetting->top_headline ?? 'আপনার শপিং অভিজ্ঞতাকে আরও সহজ ও সুন্দর করুন' }}
                    </h2>
                    @if(isset($generalSetting) && $generalSetting->meta_description)
                        <p class="text-gray-400 text-lg">{{ $generalSetting->meta_description }}</p>
                    @else
                        <p class="text-gray-400 text-lg">সেরা মানের পণ্য, দ্রুত ডেলিভারি এবং নিরাপদ পেমেন্ট - সব এক জায়গায়।</p>
                    @endif
                    
                    <!-- Feature Points (Refined Cards) -->
                    <div class="grid grid-cols-2 gap-6 pt-10">
                        <div class="p-4 rounded-xl border border-white/10 bg-white/5 hover:bg-white/10 transition">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 rounded-full bg-gradient-to-br from-orange-500/30 to-pink-500/30 text-white flex items-center justify-center ring-1 ring-white/20">
                                    <i class="fas fa-truck"></i>
                                </div>
                                <div>
                                    <h4 class="font-bold">দ্রুত ডেলিভারি</h4>
                                    <p class="text-xs text-gray-400">সারা বাংলাদেশে</p>
                                </div>
                            </div>
                        </div>
                        <div class="p-4 rounded-xl border border-white/10 bg-white/5 hover:bg-white/10 transition">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 rounded-full bg-gradient-to-br from-blue-500/30 to-cyan-500/30 text-white flex items-center justify-center ring-1 ring-white/20">
                                    <i class="fas fa-shield-alt"></i>
                                </div>
                                <div>
                                    <h4 class="font-bold">নিরাপদ পেমেন্ট</h4>
                                    <p class="text-xs text-gray-400">এন্ড-টু-এন্ড সিকিউর</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Copyright -->
                <div class="relative z-10 text-sm text-gray-500">
                    &copy; {{ date('Y') }} {{ $generalSetting->name ?? config('app.name') }}. All rights reserved.
                </div>
            </div>

            <!-- Right Side: Form -->
            <div class="flex flex-col justify-center items-center p-6 sm:p-12 lg:p-24 relative bg-gray-50 lg:bg-white">
                <!-- Mobile Background Elements -->
                <div class="absolute inset-0 overflow-hidden lg:hidden z-0 pointer-events-none">
                    <div class="absolute -top-[20%] -right-[10%] w-[60%] h-[60%] rounded-full bg-orange-500/5 blur-[80px]"></div>
                    <div class="absolute -bottom-[20%] -left-[10%] w-[60%] h-[60%] rounded-full bg-blue-500/5 blur-[80px]"></div>
                </div>

                <div class="w-full max-w-md space-y-8 relative z-10">
                    <!-- Mobile Logo (Gradient Ring Badge) -->
                    <div class="lg:hidden text-center mb-8">
                        <a href="/" class="inline-block">
                            <div class="inline-flex items-center justify-center rounded-full p-[5px] bg-[conic-gradient(at_top_right,_#fb7185,_#a78bfa,_#60a5fa,_#fb7185)] shadow-xl">
                                <div class="rounded-full bg-white p-[5px]">
                                    <div class="w-16 h-16 rounded-full bg-white flex items-center justify-center">
                                        @if(isset($generalSetting) && $generalSetting->dark_logo)
                                            <img src="{{ asset('storage/' . $generalSetting->dark_logo) }}" alt="{{ $generalSetting->name }}" class="max-h-9 object-contain">
                                        @elseif(isset($generalSetting) && $generalSetting->white_logo)
                                            <img src="{{ asset('storage/' . $generalSetting->white_logo) }}" alt="{{ $generalSetting->name }}" class="max-h-9 object-contain">
                                        @else
                                            <span class="text-lg font-heading font-bold text-gray-900">{{ $generalSetting->name ?? config('app.name') }}</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>

                    {{ $slot }}
                </div>
            </div>
        </div>
    </body>
</html>
