<x-guest-layout>
    <div class="mb-8 text-center">
        <h3 class="text-2xl font-heading font-bold text-gray-900">পাসওয়ার্ড রিসেট করুন</h3>
        <p class="text-sm text-gray-500 mt-2">আপনার অ্যাকাউন্টের জন্য একটি নতুন পাসওয়ার্ড তৈরি করুন</p>
    </div>

    <form method="POST" action="{{ route('password.store') }}">
        @csrf

        <!-- Password Reset Token -->
        <input type="hidden" name="token" value="{{ $request->route('token') }}">

        <!-- Email Address -->
        <div>
            <label for="email" class="block text-sm font-medium text-gray-700 mb-1">ইমেইল</label>
            <div class="relative">
                <input id="email" class="block w-full px-4 py-3 rounded-xl border-gray-200 focus:border-orange-500 focus:ring focus:ring-orange-200 transition-all duration-200 bg-gray-50 focus:bg-white"
                       type="email" name="email" :value="old('email', $request->email)" required autofocus autocomplete="username" placeholder="name@example.com" />
            </div>
            <x-input-error :messages="$errors->get('email')" class="mt-2" />
        </div>

        <!-- Password -->
        <div class="mt-4">
            <label for="password" class="block text-sm font-medium text-gray-700 mb-1">নতুন পাসওয়ার্ড</label>
            <div class="relative">
                <input id="password" class="block w-full px-4 py-3 rounded-xl border-gray-200 focus:border-orange-500 focus:ring focus:ring-orange-200 transition-all duration-200 bg-gray-50 focus:bg-white"
                       type="password" name="password" required autocomplete="new-password" placeholder="কমপক্ষে ৮ অক্ষর" />
            </div>
            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <!-- Confirm Password -->
        <div class="mt-4">
            <label for="password_confirmation" class="block text-sm font-medium text-gray-700 mb-1">পাসওয়ার্ড নিশ্চিত করুন</label>
            <div class="relative">
                <input id="password_confirmation" class="block w-full px-4 py-3 rounded-xl border-gray-200 focus:border-orange-500 focus:ring focus:ring-orange-200 transition-all duration-200 bg-gray-50 focus:bg-white"
                       type="password" name="password_confirmation" required autocomplete="new-password" placeholder="পাসওয়ার্ড পুনরায় লিখুন" />
            </div>
            <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
        </div>

        <div class="flex items-center justify-end mt-6">
            <button type="submit" class="w-full bg-gray-900 text-white py-3.5 px-4 rounded-xl font-bold hover:bg-orange-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-orange-500 shadow-lg hover:shadow-orange-500/30 transition-all duration-300 transform hover:-translate-y-0.5">
                {{ __('পাসওয়ার্ড রিসেট করুন') }}
            </button>
        </div>
    </form>
</x-guest-layout>
