<x-auth-split-layout>
    <!-- Header -->
    <div class="mb-8">
        <h2 class="text-3xl font-heading font-bold text-gray-900">অ্যাকাউন্ট তৈরি করুন</h2>
        <p class="mt-2 text-sm text-gray-600">আমাদের এক্সক্লুসিভ কমিউনিটিতে যোগ দিন</p>
    </div>

    <!-- Validation Errors -->
    <x-auth-validation-errors class="mb-4" :errors="$errors" />

    <form method="POST" action="{{ route('register') }}" class="space-y-5">
        @csrf

        <!-- Name -->
        <div class="group">
            <label for="name" class="block text-sm font-bold text-gray-700 mb-2 font-heading">নাম</label>
            <div class="relative">
                <input id="name" type="text" name="name" :value="old('name')" required autofocus autocomplete="name"
                    class="block w-full px-4 py-3.5 bg-gray-50 border border-gray-200 text-gray-900 text-sm rounded-xl focus:ring-2 focus:ring-orange-500/20 focus:border-orange-600 transition-all duration-200 hover:bg-white placeholder-gray-400"
                    placeholder="আপনার নাম">
            </div>
            <x-input-error :messages="$errors->get('name')" class="mt-2" />
        </div>

        <!-- Email Address -->
        <div class="group">
            <label for="email" class="block text-sm font-bold text-gray-700 mb-2 font-heading">ইমেইল এড্রেস</label>
            <div class="relative">
                <input id="email" type="email" name="email" :value="old('email')" required autocomplete="username"
                    class="block w-full px-4 py-3.5 bg-gray-50 border border-gray-200 text-gray-900 text-sm rounded-xl focus:ring-2 focus:ring-orange-500/20 focus:border-orange-600 transition-all duration-200 hover:bg-white placeholder-gray-400"
                    placeholder="name@example.com">
            </div>
            <x-input-error :messages="$errors->get('email')" class="mt-2" />
        </div>

        <!-- Password -->
        <div class="group">
            <label for="password" class="block text-sm font-bold text-gray-700 mb-2 font-heading">পাসওয়ার্ড</label>
            <div class="relative">
                <input id="password" type="password" name="password" required autocomplete="new-password"
                    class="block w-full px-4 py-3.5 bg-gray-50 border border-gray-200 text-gray-900 text-sm rounded-xl focus:ring-2 focus:ring-orange-500/20 focus:border-orange-600 transition-all duration-200 hover:bg-white placeholder-gray-400"
                    placeholder="••••••••">
            </div>
            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <!-- Confirm Password -->
        <div class="group">
            <label for="password_confirmation" class="block text-sm font-bold text-gray-700 mb-2 font-heading">পাসওয়ার্ড নিশ্চিত করুন</label>
            <div class="relative">
                <input id="password_confirmation" type="password" name="password_confirmation" required autocomplete="new-password"
                    class="block w-full px-4 py-3.5 bg-gray-50 border border-gray-200 text-gray-900 text-sm rounded-xl focus:ring-2 focus:ring-orange-500/20 focus:border-orange-600 transition-all duration-200 hover:bg-white placeholder-gray-400"
                    placeholder="••••••••">
            </div>
            <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
        </div>

        <div class="mt-8">
            <button type="submit" class="w-full bg-gray-900 hover:bg-orange-600 text-white font-bold py-4 rounded-xl shadow-lg shadow-gray-900/10 hover:shadow-orange-600/30 transform transition-all duration-300 hover:-translate-y-1 focus:ring-2 focus:ring-offset-2 focus:ring-orange-600 uppercase tracking-wider text-sm">
                রেজিস্টার করুন
            </button>
            
            <p class="mt-6 text-center text-sm text-gray-600">
                ইতিমধ্যে অ্যাকাউন্ট আছে? 
                <a href="{{ route('login') }}" class="font-bold text-orange-600 hover:text-orange-700 transition-colors ml-1">
                    লগইন করুন
                </a>
            </p>
        </div>
    </form>
</x-auth-split-layout>