<x-auth-split-layout>
    <div class="mb-8 text-center">
        <h2 class="text-3xl font-heading font-bold text-gray-900">স্বাগতম! 👋</h2>
        <p class="mt-1 text-sm text-gray-500">আপনার অ্যাকাউন্টে লগইন করুন</p>
    </div>

    <!-- Session Status -->
    <x-auth-session-status class="mb-4" :status="session('status')" />

    <!-- Validation Errors -->
    <x-auth-validation-errors class="mb-4" :errors="$errors" />

    <form method="POST" action="{{ route('login') }}" class="space-y-5">
        @csrf

        <div>
            <label for="email" class="block text-sm font-medium text-gray-700 mb-2">ইমেইল এড্রেস</label>
            <input id="email" type="email" name="email" value="{{ old('email') }}" required autofocus
                   class="block w-full px-4 py-3.5 bg-white border border-gray-200 text-gray-900 text-sm rounded-xl focus:ring-2 focus:ring-orange-500/20 focus:border-orange-600 transition-colors placeholder-gray-400"
                   placeholder="name@example.com">
        </div>

        <div x-data="{ show: false }">
            <div class="flex items-center justify-between mb-2">
                <label for="password" class="block text-sm font-medium text-gray-700">পাসওয়ার্ড</label>
                @if (Route::has('password.request'))
                    <a class="text-xs font-semibold text-orange-600 hover:text-orange-700" href="{{ route('password.request') }}">পাসওয়ার্ড ভুলে গেছেন?</a>
                @endif
            </div>
            <div class="relative">
                <input :type="show ? 'text' : 'password'" id="password" name="password" required autocomplete="current-password"
                       class="block w-full pr-24 px-4 py-3.5 bg-white border border-gray-200 text-gray-900 text-sm rounded-xl focus:ring-2 focus:ring-orange-500/20 focus:border-orange-600 transition-colors placeholder-gray-400"
                       placeholder="••••••••">
                <button type="button"
                        @click="show = !show"
                        class="absolute inset-y-0 right-2 my-1.5 px-3 rounded-lg text-sm font-semibold text-gray-600 hover:text-gray-900 hover:bg-gray-100 transition">
                    <span x-show="!show">দেখুন</span>
                    <span x-show="show">লুকান</span>
                </button>
            </div>
        </div>

        <div class="flex items-center">
            <label for="remember_me" class="flex items-center gap-2 cursor-pointer">
                <input id="remember_me" type="checkbox" name="remember" class="w-4 h-4 rounded border-gray-300 text-orange-600 focus:ring-orange-600 cursor-pointer">
                <span class="text-sm text-gray-600">মনে রাখুন</span>
            </label>
        </div>

        <button type="submit" class="w-full bg-gray-900 hover:bg-gray-800 text-white font-semibold py-3.5 rounded-xl shadow-md focus:ring-2 focus:ring-offset-2 focus:ring-gray-900 transition">
            লগইন করুন
        </button>

        <div class="relative my-6">
            <div class="absolute inset-0 flex items-center">
                <div class="w-full border-t border-gray-200"></div>
            </div>
            <div class="relative flex justify-center text-sm">
                <span class="bg-gray-50 lg:bg-white px-4 text-gray-500">অথবা</span>
            </div>
        </div>

        <div class="grid grid-cols-2 gap-4">
            <a href="{{ route('auth.google') }}" class="flex items-center justify-center px-4 py-3 border border-gray-200 rounded-xl hover:bg-gray-50 transition-colors gap-2">
                <img src="https://www.svgrepo.com/show/475656/google-color.svg" class="w-5 h-5" alt="Google">
                <span class="text-sm font-semibold text-gray-700">Google</span>
            </a>
            <a href="{{ route('auth.facebook') }}" class="flex items-center justify-center px-4 py-3 border border-gray-200 rounded-xl hover:bg-gray-50 transition-colors gap-2">
                <img src="https://www.svgrepo.com/show/475647/facebook-color.svg" class="w-5 h-5" alt="Facebook">
                <span class="text-sm font-semibold text-gray-700">Facebook</span>
            </a>
        </div>
    </form>

    <div class="mt-8 text-center">
        <p class="text-sm text-gray-600">
            কোনো অ্যাকাউন্ট নেই? 
            <a href="{{ route('register') }}" class="font-semibold text-orange-600 hover:text-orange-700 transition-colors">
                নতুন অ্যাকাউন্ট তৈরি করুন
            </a>
        </p>
    </div>

    <div class="mt-8 text-center space-x-6 text-xs text-gray-400">
        <a href="#" class="hover:text-gray-600 transition-colors">শর্তাবলী</a>
        <a href="#" class="hover:text-gray-600 transition-colors">প্রাইভেসি পলিসি</a>
        <a href="#" class="hover:text-gray-600 transition-colors">সাহায্য</a>
    </div>
</x-auth-split-layout>
