<x-guest-layout>
    <div class="mb-8 text-center">
        <h3 class="text-2xl font-heading font-bold text-gray-900">সুরক্ষিত এলাকা</h3>
        <p class="text-sm text-gray-500 mt-2">চালিয়ে যাওয়ার আগে আপনার পাসওয়ার্ড নিশ্চিত করুন</p>
    </div>

    <div class="mb-6 text-sm text-gray-600 bg-gray-50 p-4 rounded-xl border border-gray-100">
        {{ __('এটি অ্যাপ্লিকেশনের একটি সুরক্ষিত এলাকা। চালিয়ে যাওয়ার আগে আপনার পাসওয়ার্ড নিশ্চিত করুন।') }}
    </div>

    <form method="POST" action="{{ route('password.confirm') }}">
        @csrf

        <!-- Password -->
        <div>
            <label for="password" class="block text-sm font-medium text-gray-700 mb-1">পাসওয়ার্ড</label>
            <div class="relative">
                <input id="password" class="block w-full px-4 py-3 rounded-xl border-gray-200 focus:border-orange-500 focus:ring focus:ring-orange-200 transition-all duration-200 bg-gray-50 focus:bg-white"
                                type="password"
                                name="password"
                                required autocomplete="current-password"
                                placeholder="আপনার পাসওয়ার্ড লিখুন" />
            </div>
            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <div class="flex justify-end mt-6">
            <button type="submit" class="w-full bg-gray-900 text-white py-3.5 px-4 rounded-xl font-bold hover:bg-orange-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-orange-500 shadow-lg hover:shadow-orange-500/30 transition-all duration-300 transform hover:-translate-y-0.5">
                {{ __('নিশ্চিত করুন') }}
            </button>
        </div>
    </form>
</x-guest-layout>
