<x-admin-layout>
    <div class="p-6 bg-slate-50 min-h-screen">
        <form action="{{ route('admin.suppliers.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            
            <div class="max-w-7xl mx-auto">
                <!-- Toolbar -->
                <div class="bg-white p-4 rounded-2xl shadow-lg border border-slate-100 mb-6 flex items-center justify-between gap-4">
                    <h2 class="text-xl font-bold text-slate-800 tracking-tight ml-2">
                        Add Supplier
                    </h2>
                    <div class="flex items-center gap-3">
                        <a href="{{ route('admin.suppliers.index') }}" 
                           class="inline-flex items-center gap-2 px-5 py-2.5 rounded-xl text-sm font-semibold text-slate-600 hover:text-slate-800 bg-slate-100 hover:bg-slate-200 transition-all">
                            Cancel
                        </a>
                        <button type="submit" 
                                class="inline-flex items-center gap-2 px-6 py-2.5 rounded-xl text-sm font-semibold text-white bg-gradient-to-r from-emerald-500 to-teal-500 hover:from-emerald-600 hover:to-teal-600 shadow-md hover:shadow-lg transform hover:-translate-y-0.5 transition-all">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                            Publish
                        </button>
                    </div>
                </div>

                <!-- Main Form Card -->
                <div class="bg-white rounded-2xl shadow-lg border border-slate-100 overflow-hidden">
                    <div class="p-8">
                        <div class="space-y-8">
                            
                            <!-- Name -->
                            <div class="grid grid-cols-1 md:grid-cols-12 gap-6 items-center border-b border-slate-100 pb-8">
                                <label for="name" class="md:col-span-3 text-slate-700 font-semibold text-sm">
                                    Name <span class="text-red-500">*</span>
                                </label>
                                <div class="md:col-span-9">
                                    <input type="text" name="name" id="name" 
                                           class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl text-slate-700 text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500 focus:bg-white outline-none transition-all placeholder-slate-400" 
                                           placeholder="Enter supplier name" required>
                                    @error('name')
                                        <p class="text-red-500 text-xs mt-1.5 font-medium flex items-center gap-1">
                                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>
                            </div>

                            <!-- Phone -->
                            <div class="grid grid-cols-1 md:grid-cols-12 gap-6 items-center border-b border-slate-100 pb-8">
                                <label for="phone" class="md:col-span-3 text-slate-700 font-semibold text-sm">
                                    Phone <span class="text-red-500">*</span>
                                </label>
                                <div class="md:col-span-9">
                                    <input type="text" name="phone" id="phone" 
                                           class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl text-slate-700 text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500 focus:bg-white outline-none transition-all placeholder-slate-400" 
                                           placeholder="Enter phone number">
                                    @error('phone')
                                        <p class="text-red-500 text-xs mt-1.5 font-medium flex items-center gap-1">
                                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>
                            </div>

                            <!-- Image -->
                            <div class="grid grid-cols-1 md:grid-cols-12 gap-6 items-start border-b border-slate-100 pb-8">
                                <label class="md:col-span-3 text-slate-700 font-semibold text-sm pt-2">
                                    Image
                                </label>
                                <div class="md:col-span-9 flex items-start gap-6">
                                    <div class="flex-1 relative group cursor-pointer" onclick="document.getElementById('logo').click()">
                                        <div class="border-2 border-dashed border-slate-300 rounded-2xl p-8 text-center bg-slate-50 group-hover:bg-blue-50 group-hover:border-blue-300 transition-all duration-300">
                                            <input type="file" name="logo" id="logo" class="hidden" accept="image/*" onchange="previewImage(this, 'logo-preview')">
                                            <div class="space-y-3">
                                                <div class="w-12 h-12 mx-auto bg-white rounded-full shadow-sm flex items-center justify-center text-blue-500 group-hover:scale-110 transition-transform">
                                                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12"></path></svg>
                                                </div>
                                                <div class="text-slate-600 font-medium text-sm group-hover:text-blue-600">Click to upload or drag & drop</div>
                                                <p class="text-xs text-slate-400">SVG, PNG, JPG or GIF</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="w-32 h-32 flex-shrink-0 bg-slate-100 rounded-2xl border border-slate-200 overflow-hidden flex items-center justify-center relative">
                                        <img id="logo-preview" src="#" alt="Preview" class="hidden w-full h-full object-cover">
                                        <div id="logo-placeholder" class="text-center p-2">
                                            <svg class="w-8 h-8 text-slate-300 mx-auto mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                                            <span class="text-xs text-slate-400 block">No image</span>
                                        </div>
                                    </div>
                                    @error('logo')
                                        <p class="text-red-500 text-xs mt-1.5">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>

                            <!-- Address -->
                            <div class="grid grid-cols-1 md:grid-cols-12 gap-6 items-center border-b border-slate-100 pb-8">
                                <label for="address" class="md:col-span-3 text-slate-700 font-semibold text-sm">
                                    Address
                                </label>
                                <div class="md:col-span-9">
                                    <input type="text" name="address" id="address" 
                                           class="w-full px-4 py-3 bg-slate-50 border border-slate-200 rounded-xl text-slate-700 text-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500 focus:bg-white outline-none transition-all placeholder-slate-400" 
                                           placeholder="Location, District, Division">
                                    @error('address')
                                        <p class="text-red-500 text-xs mt-1.5 font-medium flex items-center gap-1">
                                            <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>
                            </div>

                            <!-- Status -->
                            <div class="grid grid-cols-1 md:grid-cols-12 gap-6 items-center">
                                <label for="status" class="md:col-span-3 text-slate-700 font-semibold text-sm">
                                    Status
                                </label>
                                <div class="md:col-span-9">
                                    <label class="inline-flex items-center cursor-pointer">
                                        <input type="checkbox" name="status" value="1" class="sr-only peer" checked>
                                        <div class="w-14 h-7 bg-slate-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-0.5 after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-6 after:w-6 after:transition-all peer-checked:bg-blue-600 relative"></div>
                                        <span class="ml-3 text-sm font-medium text-slate-700">Active</span>
                                    </label>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>

    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            const placeholder = document.getElementById('logo-placeholder');
            
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                
                reader.onload = function(e) {
                    preview.src = e.target.result;
                    preview.classList.remove('hidden');
                    placeholder.classList.add('hidden');
                }
                
                reader.readAsDataURL(input.files[0]);
            } else {
                preview.src = '#';
                preview.classList.add('hidden');
                placeholder.classList.remove('hidden');
            }
        }

        // Drag and drop support
        const dropZone = document.querySelector('.group');
        const fileInput = document.getElementById('logo');

        ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
            dropZone.addEventListener(eventName, preventDefaults, false);
        });

        function preventDefaults(e) {
            e.preventDefault();
            e.stopPropagation();
        }

        ['dragenter', 'dragover'].forEach(eventName => {
            dropZone.addEventListener(eventName, highlight, false);
        });

        ['dragleave', 'drop'].forEach(eventName => {
            dropZone.addEventListener(eventName, unhighlight, false);
        });

        function highlight(e) {
            dropZone.querySelector('div').classList.add('bg-blue-50', 'border-blue-300');
        }

        function unhighlight(e) {
            dropZone.querySelector('div').classList.remove('bg-blue-50', 'border-blue-300');
        }

        dropZone.addEventListener('drop', handleDrop, false);

        function handleDrop(e) {
            const dt = e.dataTransfer;
            const files = dt.files;
            fileInput.files = files;
            previewImage(fileInput, 'logo-preview');
        }
    </script>
</x-admin-layout>
