<x-admin-layout>
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-bold text-gray-800">Theme Settings</h2>
        </div>

        @if (session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
                <span class="block sm:inline">{{ session('success') }}</span>
            </div>
        @endif

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            @foreach($themes as $key => $theme)
                <div class="bg-white rounded-lg shadow-md overflow-hidden flex flex-col h-full border-2 {{ $activeTheme === $key ? 'border-blue-500 ring-2 ring-blue-500 ring-opacity-50' : 'border-gray-200 hover:border-blue-300' }} transition-all">
                    <!-- Theme Preview/Icon -->
                    <div class="aspect-[3/2] w-full flex items-center justify-center p-6" 
                         style="background-color: {{ $theme['colors']['primary_light'] }}">
                        <div class="w-16 h-16 rounded-full shadow-md flex items-center justify-center text-3xl"
                             style="background-color: {{ $theme['colors']['primary'] }}; color: white;">
                            @if($key === 'default') 🎨 @elseif($key === 'classic') 🏛️ @elseif($key === 'modern') ✨ @else 🌙 @endif
                        </div>
                    </div>
                    
                    <!-- Theme Info -->
                    <div class="p-5 flex-grow flex flex-col">
                        <div class="flex justify-between items-start mb-2">
                            <h3 class="font-bold text-lg text-gray-900">{{ $theme['name'] }}</h3>
                            @if($activeTheme === $key)
                                <span class="bg-blue-100 text-blue-800 text-xs font-semibold px-2.5 py-0.5 rounded border border-blue-400">Active</span>
                            @endif
                        </div>
                        <p class="text-sm text-gray-500 mb-4">{{ $theme['description'] }}</p>
                        
                        <!-- Actions -->
                        <div class="mt-auto flex gap-3">
                            @if($activeTheme !== $key)
                                <form action="{{ route('admin.settings.themes.activate') }}" method="POST" class="flex-1">
                                    @csrf
                                    <input type="hidden" name="theme" value="{{ $key }}">
                                    <button type="submit" class="w-full bg-gray-900 hover:bg-gray-800 text-white font-medium py-2 px-4 rounded transition-colors text-sm">
                                        Activate
                                    </button>
                                </form>
                            @else
                                <button disabled class="flex-1 bg-green-600 text-white font-medium py-2 px-4 rounded cursor-default text-sm flex items-center justify-center gap-1">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                                    Selected
                                </button>
                            @endif
                            
                            <a href="{{ route('admin.settings.themes.edit', $key) }}" class="bg-white border border-gray-300 hover:bg-gray-50 text-gray-700 font-medium py-2 px-3 rounded transition-colors" title="Edit Colors">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z"></path></svg>
                            </a>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</x-admin-layout>