<x-admin-layout>
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <div class="flex items-center gap-4 mb-6">
            <a href="{{ route('admin.settings.themes.index') }}" class="text-gray-500 hover:text-gray-700 transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
            </a>
            <h2 class="text-2xl font-bold text-gray-800">Customize {{ $themeDetails['name'] }}</h2>
        </div>

        @if (session('success'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
                <span class="block sm:inline">{{ session('success') }}</span>
            </div>
        @endif

        <div class="bg-white rounded-lg shadow-md overflow-hidden">
            <div class="p-6 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-900">Color Configuration</h3>
                <p class="text-sm text-gray-500 mt-1">Adjust the color palette for this theme.</p>
            </div>
            
            <form action="{{ route('admin.settings.themes.update', $theme) }}" method="POST" class="p-6 space-y-6">
                @csrf
                @method('PUT')
                
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <!-- Primary Color -->
                    <div class="space-y-2">
                        <label for="primary" class="block text-sm font-medium text-gray-700">Primary Color</label>
                        <div class="flex items-center gap-3">
                            <input type="color" id="primary" name="primary" value="{{ $currentConfig['primary'] }}" class="h-10 w-14 rounded border border-gray-300 p-1 cursor-pointer">
                            <input type="text" value="{{ $currentConfig['primary'] }}" class="flex-1 rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm" readonly>
                        </div>
                        <p class="text-xs text-gray-500">Main brand color (Buttons, Highlights)</p>
                    </div>

                    <!-- Primary Hover -->
                    <div class="space-y-2">
                        <label for="primary_hover" class="block text-sm font-medium text-gray-700">Primary Hover</label>
                        <div class="flex items-center gap-3">
                            <input type="color" id="primary_hover" name="primary_hover" value="{{ $currentConfig['primary_hover'] }}" class="h-10 w-14 rounded border border-gray-300 p-1 cursor-pointer">
                            <input type="text" value="{{ $currentConfig['primary_hover'] }}" class="flex-1 rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm" readonly>
                        </div>
                        <p class="text-xs text-gray-500">Darker shade for hover states</p>
                    </div>

                    <!-- Primary Light -->
                    <div class="space-y-2">
                        <label for="primary_light" class="block text-sm font-medium text-gray-700">Primary Light</label>
                        <div class="flex items-center gap-3">
                            <input type="color" id="primary_light" name="primary_light" value="{{ $currentConfig['primary_light'] }}" class="h-10 w-14 rounded border border-gray-300 p-1 cursor-pointer">
                            <input type="text" value="{{ $currentConfig['primary_light'] }}" class="flex-1 rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm" readonly>
                        </div>
                        <p class="text-xs text-gray-500">Very light shade for backgrounds</p>
                    </div>
                </div>

                <div class="pt-6 border-t border-gray-200 flex justify-end gap-3">
                    <a href="{{ route('admin.settings.themes.index') }}" class="bg-white border border-gray-300 hover:bg-gray-50 text-gray-700 font-medium py-2 px-4 rounded-lg transition-colors">
                        Cancel
                    </a>
                    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-6 rounded-lg transition-colors">
                        Save Changes
                    </button>
                </div>
            </form>
            
            <div class="bg-gray-50 p-6 border-t border-gray-200">
                <h4 class="text-sm font-semibold text-gray-900 mb-4">Live Preview</h4>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <!-- Button Preview -->
                    <div class="space-y-4">
                        <h5 class="text-xs font-medium text-gray-500 uppercase tracking-wider">Buttons</h5>
                        <div class="flex flex-wrap gap-4">
                            <button class="px-4 py-2 rounded text-white font-medium transition-colors" style="background-color: {{ $currentConfig['primary'] }}">Primary Button</button>
                            <button class="px-4 py-2 rounded text-white font-medium transition-colors" style="background-color: {{ $currentConfig['primary_hover'] }}">Hover State</button>
                        </div>
                    </div>
                    
                    <!-- Alert Preview -->
                    <div class="space-y-4">
                        <h5 class="text-xs font-medium text-gray-500 uppercase tracking-wider">Backgrounds</h5>
                        <div class="p-4 rounded-lg border border-dashed border-gray-300" style="background-color: {{ $currentConfig['primary_light'] }}">
                            <p class="font-medium" style="color: {{ $currentConfig['primary'] }}">This is a light background alert box.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Simple script to update text inputs when color pickers change
        document.querySelectorAll('input[type="color"]').forEach(input => {
            input.addEventListener('input', (e) => {
                e.target.nextElementSibling.value = e.target.value;
            });
        });
    </script>
</x-admin-layout>