<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Shipping Settings') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
            
            @if(session('success'))
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
                    <span class="block sm:inline">{{ session('success') }}</span>
                </div>
            @endif

            @if ($errors->any())
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                    <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('admin.settings.shipping.update') }}" method="POST">
                @csrf
                
                <div class="flex justify-between items-center mb-6">
                    <h3 class="text-2xl font-semibold text-center w-full text-gray-700">Delivery Charge</h3>
                    <div class="absolute right-0 mr-8">
                         <button type="submit" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-6 rounded shadow">
                            Update
                        </button>
                    </div>
                </div>

                <!-- General Settings -->
                <div class="bg-white p-6 rounded-lg shadow mb-6">
                    <div class="flex items-center justify-between mb-4">
                         <label class="font-medium text-gray-700 text-lg">Free Shipping</label>
                         
                         <!-- Toggle Switch -->
                         <div class="relative inline-block w-10 mr-2 align-middle select-none transition duration-200 ease-in">
                            <input type="checkbox" name="free_shipping" id="free_shipping" value="1" {{ $setting->free_shipping ? 'checked' : '' }} class="toggle-checkbox absolute block w-6 h-6 rounded-full bg-white border-4 appearance-none cursor-pointer"/>
                            <label for="free_shipping" class="toggle-label block overflow-hidden h-6 rounded-full bg-green-400 cursor-pointer"></label>
                        </div>
                    </div>
                    
                    <div class="flex items-center justify-between">
                         <label class="font-medium text-gray-700 text-lg">Flat Rate</label>
                         <input type="number" name="flat_rate_cost" value="{{ $setting->flat_rate_cost }}" class="w-2/3 border-gray-300 rounded-md shadow-sm focus:ring-purple-500 focus:border-purple-500">
                         <input type="hidden" name="flat_rate_enabled" value="1"> 
                    </div>
                </div>

                <!-- Dynamic Shipping Charges -->
                <div x-data="shippingChargesHandler()" class="space-y-6">
                    <div class="mb-6 text-center">
                         <button type="button" @click="addCharge()" class="bg-indigo-600 text-white px-6 py-2 rounded shadow hover:bg-indigo-700 font-semibold flex items-center justify-center mx-auto">
                            <span class="mr-2">+</span> Add Charge by weight
                         </button>
                    </div>

                    <template x-for="(charge, index) in charges" :key="charge.temp_id || charge.id">
                        <div class="bg-white p-6 rounded-lg shadow border border-gray-200">
                            <div class="flex justify-between items-start mb-6">
                                 <input type="hidden" :name="`charges[${index}][id]`" :value="charge.id">
                                 <input type="text" :name="`charges[${index}][area_name]`" x-model="charge.area_name" placeholder="Area Name (e.g. inside dhaka)" class="w-1/2 border-gray-300 rounded-md shadow-sm focus:ring-purple-500 focus:border-purple-500">
                                 
                                 <div class="flex space-x-2">
                                     <button type="button" class="bg-blue-600 text-white p-2 rounded shadow hover:bg-blue-700">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                                          <path fill-rule="evenodd" d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" clip-rule="evenodd" />
                                        </svg>
                                     </button>
                                     <button type="button" class="bg-blue-400 text-white px-3 py-2 rounded shadow hover:bg-blue-500">Select Area +</button>
                                     <button type="button" @click="removeCharge(index)" class="bg-red-500 text-white p-2 rounded shadow hover:bg-red-600">
                                         <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                             <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                         </svg>
                                     </button>
                                 </div>
                            </div>
                            
                            <div class="grid grid-cols-1 gap-4">
                                <div class="flex items-center justify-between">
                                    <label class="w-1/3 text-gray-700 font-medium">0(kg) To 0.5(kg):</label>
                                    <input type="number" step="0.01" :name="`charges[${index}][charge_0_0_5]`" x-model="charge.charge_0_0_5" class="w-1/2 border-gray-300 rounded-md shadow-sm focus:ring-purple-500 focus:border-purple-500">
                                </div>
                                 <div class="flex items-center justify-between">
                                    <label class="w-1/3 text-gray-700 font-medium">0.5(kg) To 1(kg):</label>
                                    <input type="number" step="0.01" :name="`charges[${index}][charge_0_5_1]`" x-model="charge.charge_0_5_1" class="w-1/2 border-gray-300 rounded-md shadow-sm focus:ring-purple-500 focus:border-purple-500">
                                </div>
                                 <div class="flex items-center justify-between">
                                    <label class="w-1/3 text-gray-700 font-medium">1(kg) To 2(kg):</label>
                                    <input type="number" step="0.01" :name="`charges[${index}][charge_1_2]`" x-model="charge.charge_1_2" class="w-1/2 border-gray-300 rounded-md shadow-sm focus:ring-purple-500 focus:border-purple-500">
                                </div>
                                 <div class="flex items-center justify-between">
                                    <label class="w-1/3 text-gray-700 font-medium">Over 2 kg (extra charge for per kg):</label>
                                    <input type="number" step="0.01" :name="`charges[${index}][charge_over_2]`" x-model="charge.charge_over_2" class="w-1/2 border-gray-300 rounded-md shadow-sm focus:ring-purple-500 focus:border-purple-500">
                                </div>
                            </div>
                        </div>
                    </template>
                </div>
            </form>
        </div>
    </div>

    <style>
        .toggle-checkbox:checked {
            right: 0;
            border-color: #68D391;
        }
        .toggle-checkbox:checked + .toggle-label {
            background-color: #68D391;
        }
    </style>

    <script>
        function shippingChargesHandler() {
            return {
                charges: @json($shippingCharges),
                addCharge() {
                    this.charges.push({
                        temp_id: Date.now(),
                        id: null,
                        area_name: '',
                        charge_0_0_5: 0,
                        charge_0_5_1: 0,
                        charge_1_2: 0,
                        charge_over_2: 0
                    });
                },
                removeCharge(index) {
                    if (confirm('Are you sure you want to remove this charge?')) {
                        this.charges.splice(index, 1);
                    }
                }
            }
        }
    </script>
</x-admin-layout>
