<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('General Setting Update') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="w-full mx-auto sm:px-6 lg:px-8">
            
            @if ($errors->any())
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
                    <strong class="font-bold">Whoops!</strong>
                    <span class="block sm:inline">There were some problems with your input.</span>
                    <ul class="mt-3 list-disc list-inside text-sm text-red-600">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @if(session('success'))
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
                    <span class="block sm:inline">{{ session('success') }}</span>
                </div>
            @endif

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form action="{{ route('admin.settings.update') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="grid grid-cols-1 gap-6">
                            
                            <!-- Name -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Name *</label>
                                <input type="text" name="name" value="{{ old('name', $setting->name ?? '') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            </div>

                            <!-- Verification Codes -->
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Facebook Verification Code *</label>
                                    <input type="text" name="facebook_verification_code" value="{{ old('facebook_verification_code', $setting->facebook_verification_code ?? '') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Google Verification Code *</label>
                                    <input type="text" name="google_verification_code" value="{{ old('google_verification_code', $setting->google_verification_code ?? '') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                            </div>

                            <!-- Logos -->
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <!-- White Logo -->
                                <div x-data="{ preview: '{{ $setting->white_logo ? asset('storage/'.$setting->white_logo) : '' }}' }">
                                    <label class="block text-sm font-medium text-gray-700">White Logo *</label>
                                    <div class="flex items-center space-x-4 mt-1">
                                        <input type="file" name="white_logo" @change="preview = URL.createObjectURL($event.target.files[0])" class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                                    </div>
                                    <div x-show="preview" class="mt-2">
                                        <img :src="preview" class="h-12 object-contain bg-gray-100 p-1 rounded">
                                    </div>
                                </div>

                                <!-- Dark Logo -->
                                <div x-data="{ preview: '{{ $setting->dark_logo ? asset('storage/'.$setting->dark_logo) : '' }}' }">
                                    <label class="block text-sm font-medium text-gray-700">Dark Logo *</label>
                                    <div class="flex items-center space-x-4 mt-1">
                                        <input type="file" name="dark_logo" @change="preview = URL.createObjectURL($event.target.files[0])" class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                                    </div>
                                    <div x-show="preview" class="mt-2">
                                        <img :src="preview" class="h-12 object-contain bg-gray-100 p-1 rounded">
                                    </div>
                                </div>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <!-- Favicon -->
                                <div x-data="{ preview: '{{ $setting->favicon ? asset('storage/'.$setting->favicon) : '' }}' }">
                                    <label class="block text-sm font-medium text-gray-700">Favicon Logo *</label>
                                    <div class="flex items-center space-x-4 mt-1">
                                        <input type="file" name="favicon" @change="preview = URL.createObjectURL($event.target.files[0])" class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                                    </div>
                                    <div x-show="preview" class="mt-2">
                                        <img :src="preview" class="h-12 object-contain bg-gray-100 p-1 rounded">
                                    </div>
                                </div>

                                <!-- OG Banner -->
                                <div x-data="{ preview: '{{ $setting->og_banner_image ? asset('storage/'.$setting->og_banner_image) : '' }}' }">
                                    <label class="block text-sm font-medium text-gray-700">OG Banner Images *</label>
                                    <div class="flex items-center space-x-4 mt-1">
                                        <input type="file" name="og_banner_image" @change="preview = URL.createObjectURL($event.target.files[0])" class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 file:text-indigo-700 hover:file:bg-indigo-100">
                                    </div>
                                    <div x-show="preview" class="mt-2">
                                        <img :src="preview" class="h-12 object-contain bg-gray-100 p-1 rounded">
                                    </div>
                                </div>
                            </div>

                            <!-- Dates -->
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Hot Deal End Date *</label>
                                    <input type="date" name="hot_deal_end_date" value="{{ old('hot_deal_end_date', optional($setting->hot_deal_end_date)->format('Y-m-d') ?? '') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Flash Sale End Date *</label>
                                    <input type="date" name="flash_sale_end_date" value="{{ old('flash_sale_end_date', optional($setting->flash_sale_end_date)->format('Y-m-d') ?? '') }}" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                </div>
                            </div>

                            <!-- Header Code -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Header Code</label>
                                <textarea name="header_code" rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('header_code', $setting->header_code ?? '') }}</textarea>
                            </div>

                            <!-- Meta Description -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Meta Description</label>
                                <textarea name="meta_description" rows="3" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('meta_description', $setting->meta_description ?? '') }}</textarea>
                            </div>

                            <!-- Meta Keyword -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Meta Keyword</label>
                                <textarea name="meta_keyword" rows="2" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('meta_keyword', $setting->meta_keyword ?? '') }}</textarea>
                            </div>

                            <!-- Top Headline -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Top Headline</label>
                                <textarea name="top_headline" rows="2" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('top_headline', $setting->top_headline ?? '') }}</textarea>
                            </div>

                            <!-- Rich Text Editors -->
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Checkout Note</label>
                                <textarea id="checkout_note" name="checkout_note">{{ old('checkout_note', $setting->checkout_note ?? '') }}</textarea>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Order Policy</label>
                                <textarea id="order_policy" name="order_policy">{{ old('order_policy', $setting->order_policy ?? '') }}</textarea>
                            </div>

                            <!-- Toggles -->
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div class="flex items-center justify-between bg-gray-50 p-4 rounded-lg">
                                    <span class="text-sm font-medium text-gray-700">All Products at Home</span>
                                    <label class="relative inline-flex items-center cursor-pointer">
                                        <input type="checkbox" name="all_products_at_home" value="1" class="sr-only peer" {{ old('all_products_at_home', $setting->all_products_at_home ?? false) ? 'checked' : '' }}>
                                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                                    </label>
                                </div>

                                <div class="flex items-center justify-between bg-gray-50 p-4 rounded-lg">
                                    <span class="text-sm font-medium text-gray-700">Categories Wise Products at Home</span>
                                    <label class="relative inline-flex items-center cursor-pointer">
                                        <input type="checkbox" name="categories_wise_products_at_home" value="1" class="sr-only peer" {{ old('categories_wise_products_at_home', $setting->categories_wise_products_at_home ?? false) ? 'checked' : '' }}>
                                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                                    </label>
                                </div>

                                <div class="flex items-center justify-between bg-gray-50 p-4 rounded-lg">
                                    <span class="text-sm font-medium text-gray-700">Show Developer Credit in Footer</span>
                                    <label class="relative inline-flex items-center cursor-pointer">
                                        <input type="checkbox" name="show_developer_credit" value="1" class="sr-only peer" {{ old('show_developer_credit', $setting->show_developer_credit ?? true) ? 'checked' : '' }}>
                                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                                    </label>
                                </div>
                            </div>

                            <!-- Status -->
                            <div class="flex items-center justify-between bg-gray-50 p-4 rounded-lg">
                                <span class="text-sm font-medium text-gray-700">Status</span>
                                <label class="relative inline-flex items-center cursor-pointer">
                                    <input type="checkbox" name="status" value="1" class="sr-only peer" {{ old('status', $setting->status ?? true) ? 'checked' : '' }}>
                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                                </label>
                            </div>

                            <div class="flex justify-end mt-6">
                                <button type="submit" class="bg-blue-600 text-white px-6 py-2.5 rounded-lg hover:bg-blue-700 transition duration-200 font-medium">Save Changes</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Summernote -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#checkout_note').summernote({
                placeholder: 'Checkout Note...',
                tabsize: 2,
                height: 120,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
            $('#order_policy').summernote({
                placeholder: 'Order Policy...',
                tabsize: 2,
                height: 120,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
        });
    </script>
</x-admin-layout>
