<x-admin-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Contact Edit') }}
            </h2>
            <a href="{{ route('admin.settings.contact') }}" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                Manage
            </a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="w-full mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form action="{{ route('admin.settings.contact.update', $contact->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Hotline Number -->
                            <div>
                                <label for="hotline_number" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Hotline Number</label>
                                <input type="text" name="hotline_number" id="hotline_number" value="{{ old('hotline_number', $contact->hotline_number) }}" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" placeholder="+8801858357205">
                                <x-input-error :messages="$errors->get('hotline_number')" class="mt-1" />
                            </div>

                            <!-- Hot Mail -->
                            <div>
                                <label for="hot_mail" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Hot Mail</label>
                                <input type="email" name="hot_mail" id="hot_mail" value="{{ old('hot_mail', $contact->hot_mail) }}" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" placeholder="primestep999@gmail.com">
                                <x-input-error :messages="$errors->get('hot_mail')" class="mt-1" />
                            </div>

                            <!-- Phone Number -->
                            <div>
                                <label for="phone_number" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Phone Number <span class="text-red-500">*</span></label>
                                <input type="text" name="phone_number" id="phone_number" value="{{ old('phone_number', $contact->phone_number) }}" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" placeholder="+8801858357205" required>
                                <x-input-error :messages="$errors->get('phone_number')" class="mt-1" />
                            </div>

                            <!-- Whats App Number -->
                            <div>
                                <label for="whatsapp_number" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Whats App Number <span class="text-red-500">*</span></label>
                                <input type="text" name="whatsapp_number" id="whatsapp_number" value="{{ old('whatsapp_number', $contact->whatsapp_number) }}" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" placeholder="+8801858357205" required>
                                <x-input-error :messages="$errors->get('whatsapp_number')" class="mt-1" />
                            </div>

                            <!-- Email -->
                            <div class="md:col-span-2">
                                <label for="email" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Email</label>
                                <input type="email" name="email" id="email" value="{{ old('email', $contact->email) }}" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" placeholder="primestep999@gmail.com">
                                <x-input-error :messages="$errors->get('email')" class="mt-1" />
                            </div>

                            <!-- Address -->
                            <div class="md:col-span-2">
                                <label for="address" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Address<span class="text-red-500">*</span></label>
                                <input type="text" name="address" id="address" value="{{ old('address', $contact->address) }}" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" placeholder="Nimaikasari Bazar , siddhirganj Narayanganj ." required>
                                <x-input-error :messages="$errors->get('address')" class="mt-1" />
                            </div>

                            <!-- Google Map -->
                            <div class="md:col-span-2">
                                <label for="google_map" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Google Map</label>
                                <input type="text" name="google_map" id="google_map" value="{{ old('google_map', $contact->google_map) }}" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5" placeholder="#">
                                <x-input-error :messages="$errors->get('google_map')" class="mt-1" />
                            </div>

                            <!-- Status -->
                            <div class="md:col-span-2">
                                <label for="status" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Status</label>
                                <label class="relative inline-flex items-center cursor-pointer">
                                    <input type="checkbox" name="status" value="1" class="sr-only peer" {{ $contact->status ? 'checked' : '' }}>
                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600"></div>
                                </label>
                            </div>
                        </div>

                        <div class="mt-6">
                            <button type="submit" class="bg-teal-500 hover:bg-teal-600 text-white font-bold py-2 px-4 rounded">
                                Submit
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
