<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Orders by Status') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                        @foreach($orderCounts as $status)
                            <div class="bg-white p-6 rounded-lg shadow border border-gray-200">
                                <h4 class="text-lg font-semibold text-gray-700 capitalize">{{ $status->status }}</h4>
                                <p class="text-3xl font-bold text-blue-600 mt-2">{{ $status->total }}</p>
                                <p class="text-sm text-gray-500">Total Orders</p>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
