<x-admin-layout>
    <div x-data="purchaseForm()" class="p-6 bg-slate-50 min-h-screen">
        <!-- Header -->
        <div class="flex items-center justify-between mb-6">
            <h2 class="text-2xl font-bold text-slate-800">Add Purchase Details</h2>
            <a href="{{ route('admin.purchases.index') }}" 
               class="inline-flex items-center gap-2 px-5 py-2 rounded-lg text-sm font-semibold text-white bg-cyan-400 hover:bg-cyan-500 transition-all shadow-sm">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
                Back
            </a>
        </div>

        <form action="{{ route('admin.purchases.store') }}" method="POST">
            @csrf
            
            <div class="bg-white rounded-xl shadow-sm border border-slate-100 p-6 space-y-6">
                
                <!-- Supplier & Date -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-semibold text-slate-700 mb-2">
                            Supplier <span class="text-red-500">*</span>
                        </label>
                        <select name="supplier_id" class="w-full px-4 py-2.5 bg-white border border-slate-200 rounded-lg text-slate-700 focus:ring-2 focus:ring-blue-500 outline-none transition-all" required>
                            <option value="">Select</option>
                            @foreach($suppliers as $supplier)
                                <option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-slate-700 mb-2">
                            Purchase Date <span class="text-red-500">*</span>
                        </label>
                        <input type="date" name="purchase_date" value="{{ date('Y-m-d') }}" class="w-full px-4 py-2.5 bg-white border border-slate-200 rounded-lg text-slate-700 focus:ring-2 focus:ring-blue-500 outline-none transition-all" required>
                    </div>
                </div>

                <!-- Product Selection Banner -->
                <div class="bg-blue-50 border-l-4 border-blue-500 p-4 rounded-r-lg">
                    <div class="flex flex-col items-center justify-center text-center space-y-2">
                        <p class="text-blue-600 font-semibold">{{ count($products) }} products available</p>
                        <p class="text-blue-400 text-sm">Click "Add More Products" button below to view and select products</p>
                    </div>
                </div>

                <!-- Add Product Button -->
                <div class="flex justify-center">
                    <button type="button" @click="openModal = true" class="inline-flex items-center gap-2 px-6 py-2.5 rounded-lg text-sm font-semibold text-white bg-blue-600 hover:bg-blue-700 shadow-md transition-all">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path></svg>
                        Add More Products
                    </button>
                </div>

                <!-- Product Table -->
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-slate-50 border-b border-slate-200 text-xs uppercase text-slate-500 font-semibold">
                                <th class="px-4 py-3">SKU</th>
                                <th class="px-4 py-3">Image</th>
                                <th class="px-4 py-3">Title</th>
                                <th class="px-4 py-3">Variation Name</th>
                                <th class="px-4 py-3">Stock</th>
                                <th class="px-4 py-3">Price <span class="text-red-500">*</span></th>
                                <th class="px-4 py-3">Quantity <span class="text-red-500">*</span></th>
                                <th class="px-4 py-3">Subtotal</th>
                                <th class="px-4 py-3 text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody class="text-sm text-slate-600">
                            <template x-if="items.length === 0">
                                <tr>
                                    <td colspan="9" class="px-4 py-8 text-center text-red-500 font-medium bg-red-50/50">
                                        No Products has been selected!
                                    </td>
                                </tr>
                            </template>
                            <template x-for="(item, index) in items" :key="item.id">
                                <tr class="border-b border-slate-100 hover:bg-slate-50 transition-colors">
                                    <td class="px-4 py-3" x-text="item.sku || 'N/A'"></td>
                                    <td class="px-4 py-3">
                                        <img :src="item.image" class="w-10 h-10 rounded object-cover border border-slate-200">
                                    </td>
                                    <td class="px-4 py-3 font-medium text-slate-800" x-text="item.name"></td>
                                    <td class="px-4 py-3 text-slate-400 italic">N/A</td>
                                    <td class="px-4 py-3">
                                        <span class="px-2 py-1 rounded-full text-xs font-semibold" 
                                              :class="item.stock > 0 ? 'bg-emerald-100 text-emerald-600' : 'bg-red-100 text-red-600'"
                                              x-text="item.stock"></span>
                                    </td>
                                    <td class="px-4 py-3">
                                        <input type="number" x-model="item.price" @input="calculateSubtotal(index)" 
                                               class="w-24 px-2 py-1 border border-slate-200 rounded focus:ring-1 focus:ring-blue-500 outline-none" min="0" step="0.01" required>
                                    </td>
                                    <td class="px-4 py-3">
                                        <input type="number" x-model="item.quantity" @input="calculateSubtotal(index)" 
                                               class="w-20 px-2 py-1 border border-slate-200 rounded focus:ring-1 focus:ring-blue-500 outline-none" min="1" required>
                                    </td>
                                    <td class="px-4 py-3 font-semibold text-slate-800" x-text="'$' + item.subtotal.toFixed(2)"></td>
                                    <td class="px-4 py-3 text-center">
                                        <button type="button" @click="removeItem(index)" class="text-red-500 hover:text-red-700 transition-colors">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
                                        </button>
                                        
                                        <!-- Hidden Inputs for Form Submission -->
                                        <input type="hidden" :name="'products[' + index + '][id]'" :value="item.id">
                                        <input type="hidden" :name="'products[' + index + '][unit_cost]'" :value="item.price">
                                        <input type="hidden" :name="'products[' + index + '][quantity]'" :value="item.quantity">
                                    </td>
                                </tr>
                            </template>
                        </tbody>
                    </table>
                </div>

                <!-- Note -->
                <div>
                    <label class="block text-sm font-semibold text-slate-700 mb-2">Note</label>
                    <textarea name="note" rows="4" class="w-full px-4 py-3 bg-white border border-slate-200 rounded-lg text-slate-700 focus:ring-2 focus:ring-blue-500 outline-none transition-all resize-none"></textarea>
                </div>

                <!-- Submit Button -->
                <div class="flex justify-center pt-4">
                    <button type="submit" class="inline-flex items-center gap-2 px-8 py-3 rounded-lg text-base font-semibold text-white bg-emerald-500 hover:bg-emerald-600 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 transition-all">
                        Add Purchase
                    </button>
                </div>
            </div>
        </form>

        <!-- Product Selection Modal -->
        <div x-show="openModal" class="fixed inset-0 z-50 overflow-y-auto" style="display: none;">
            <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 transition-opacity" aria-hidden="true" @click="openModal = false">
                    <div class="absolute inset-0 bg-gray-900 opacity-75"></div>
                </div>

                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <div class="inline-block align-bottom bg-white rounded-2xl text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-4xl sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="flex justify-between items-center mb-4">
                            <h3 class="text-lg leading-6 font-medium text-slate-900">Select Products</h3>
                            <button @click="openModal = false" class="text-slate-400 hover:text-slate-500">
                                <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                            </button>
                        </div>
                        
                        <!-- Search -->
                        <div class="mb-4">
                            <input type="text" x-model="search" placeholder="Search products..." class="w-full px-4 py-2 border border-slate-200 rounded-lg focus:ring-2 focus:ring-blue-500 outline-none">
                        </div>

                        <!-- Product List -->
                        <div class="max-h-96 overflow-y-auto border border-slate-200 rounded-lg">
                            <table class="min-w-full divide-y divide-slate-200">
                                <thead class="bg-slate-50">
                                    <tr>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Product</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">SKU</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-slate-500 uppercase tracking-wider">Stock</th>
                                        <th class="px-6 py-3 text-right text-xs font-medium text-slate-500 uppercase tracking-wider">Action</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-slate-200">
                                    <template x-for="product in filteredProducts" :key="product.id">
                                        <tr>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="flex items-center">
                                                    <div class="h-10 w-10 flex-shrink-0">
                                                        <img class="h-10 w-10 rounded-full object-cover" :src="product.thumbnail ? '/storage/' + product.thumbnail : 'https://via.placeholder.com/40'" alt="">
                                                    </div>
                                                    <div class="ml-4">
                                                        <div class="text-sm font-medium text-slate-900" x-text="product.name"></div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-500" x-text="product.sku || 'N/A'"></td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-slate-500" x-text="product.stock_quantity"></td>
                                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                                <button @click="addToCart(product)" 
                                                        :disabled="isAdded(product.id)"
                                                        :class="isAdded(product.id) ? 'bg-gray-300 cursor-not-allowed' : 'bg-blue-600 hover:bg-blue-700'"
                                                        class="inline-flex items-center px-3 py-1.5 border border-transparent text-xs font-medium rounded text-white focus:outline-none transition-colors">
                                                    <span x-text="isAdded(product.id) ? 'Added' : 'Add'"></span>
                                                </button>
                                            </td>
                                        </tr>
                                    </template>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="bg-slate-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                        <button type="button" @click="openModal = false" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                            Done
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function purchaseForm() {
            return {
                openModal: false,
                search: '',
                products: @json($products),
                items: [],
                
                get filteredProducts() {
                    if (this.search === '') return this.products;
                    return this.products.filter(product => {
                        return product.name.toLowerCase().includes(this.search.toLowerCase()) || 
                               (product.sku && product.sku.toLowerCase().includes(this.search.toLowerCase()));
                    });
                },

                addToCart(product) {
                    if (this.isAdded(product.id)) return;
                    
                    this.items.push({
                        id: product.id,
                        name: product.name,
                        sku: product.sku,
                        image: product.thumbnail ? '/storage/' + product.thumbnail : 'https://via.placeholder.com/40',
                        stock: product.stock_quantity,
                        price: product.price,
                        quantity: 1,
                        subtotal: parseFloat(product.price)
                    });
                },

                removeItem(index) {
                    this.items.splice(index, 1);
                },

                isAdded(productId) {
                    return this.items.some(item => item.id === productId);
                },

                calculateSubtotal(index) {
                    let item = this.items[index];
                    item.subtotal = (parseFloat(item.price) || 0) * (parseInt(item.quantity) || 0);
                }
            }
        }
    </script>
</x-admin-layout>
