<x-admin-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Edit Product') }}
            </h2>
            <div class="flex space-x-2">
                <a href="{{ route('admin.products.index') }}" class="px-4 py-2 border border-red-400 text-red-400 rounded hover:bg-red-50 transition">
                    <span class="mr-1">✕</span> Cancel
                </a>
                <button type="submit" form="product-form" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700 transition flex items-center shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 duration-200">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12"></path></svg>
                    Update
                </button>
            </div>
        </div>
    </x-slot>

    <div class="py-12 bg-gray-50">
        <div class="w-full mx-auto sm:px-6 lg:px-8">
            
            <form id="product-form" action="{{ route('admin.products.update', $product->id) }}" method="POST" enctype="multipart/form-data" class="space-y-6 animate-fade-in-up">
                @csrf
                @method('PUT')

                <!-- Product Information -->
                <div x-data="{
                    price: '{{ $product->price }}',
                    discountType: '{{ $product->discount_type ?? 'flat' }}',
                    discountValue: {{ $product->discount_value ?? 0 }},
                    salePrice: '{{ $product->offer_price }}',
                    calculateSalePrice() {
                        let p = parseFloat(this.price) || 0;
                        let d = parseFloat(this.discountValue) || 0;
                        if (this.discountType === 'flat') {
                            this.salePrice = (p - d > 0) ? (p - d).toFixed(2) : '';
                        } else {
                            this.salePrice = (p - (p * d / 100) > 0) ? (p - (p * d / 100)).toFixed(2) : '';
                        }
                    }
                }" x-init="$watch('price', () => calculateSalePrice()); $watch('discountType', () => calculateSalePrice()); $watch('discountValue', () => calculateSalePrice())" class="bg-white overflow-hidden shadow-sm sm:rounded-lg hover:shadow-md transition-shadow duration-300">
                    <div class="bg-blue-600 px-4 py-3 border-b border-blue-500">
                        <h3 class="text-white font-semibold text-lg flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                            Product Information
                        </h3>
                    </div>
                    <div class="p-6">
                        <!-- Row 1: Name -->
                        <div class="grid grid-cols-1 mb-4">
                            <label for="name" class="block text-gray-700 text-sm font-bold mb-2">Product Name / Title <span class="text-red-500">*</span></label>
                            <input type="text" name="name" id="name" value="{{ old('name', $product->name) }}" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200" placeholder="Enter title" required>
                        </div>

                        <!-- Row 2: SKU -->
                        <div class="grid grid-cols-1 mb-4">
                            <label for="sku" class="block text-gray-700 text-sm font-bold mb-2">Product SKU ID:</label>
                            <input type="text" name="sku" id="sku" value="{{ old('sku', $product->sku) }}" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200" placeholder="SKU-00037">
                        </div>

                        <!-- Row 3: Slug -->
                        <div class="grid grid-cols-1 mb-4">
                            <label for="slug" class="block text-gray-700 text-sm font-bold mb-2">Slug / Url</label>
                            <input type="text" name="slug" id="slug" value="{{ old('slug', $product->slug) }}" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200" placeholder="Enter slug">
                        </div>

                        <!-- Row 4: Category -->
                        <div class="grid grid-cols-1 mb-4">
                            <label for="category_id" class="block text-gray-700 text-sm font-bold mb-2">Category <span class="text-red-500">*</span></label>
                            <select name="category_id" id="category_id" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200" required>
                                <option value="">Select Categories</option>
                                @foreach($categories as $category)
                                    <option value="{{ $category->id }}" {{ old('category_id', $product->category_id) == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                @endforeach
                            </select>
                            @error('category_id') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                        </div>

                        <!-- Row 5: Brand -->
                        <div class="grid grid-cols-1 mb-4">
                            <label for="brand_id" class="block text-gray-700 text-sm font-bold mb-2">Brand</label>
                            <select name="brand_id" id="brand_id" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200">
                                <option value="">Select Brand</option>
                                @foreach($brands as $brand)
                                    <option value="{{ $brand->id }}" {{ old('brand_id', $product->brand_id) == $brand->id ? 'selected' : '' }}>{{ $brand->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Row 6: Unit -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                            <div>
                                <label class="block text-gray-700 text-sm font-bold mb-2">Unit</label>
                                <select name="unit" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200">
                                    <option value="Piece" {{ old('unit', $product->unit) == 'Piece' ? 'selected' : '' }}>Piece</option>
                                    <option value="Kg" {{ old('unit', $product->unit) == 'Kg' ? 'selected' : '' }}>Kg</option>
                                    <option value="Litre" {{ old('unit', $product->unit) == 'Litre' ? 'selected' : '' }}>Litre</option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-gray-700 text-sm font-bold mb-2">&nbsp;</label>
                                <input type="number" name="unit_value" value="{{ old('unit_value', $product->unit_value) }}" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200">
                            </div>
                        </div>

                        <!-- Row 7: Weight -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                            <div>
                                <label class="block text-gray-700 text-sm font-bold mb-2">Weight <span class="text-red-500">*</span></label>
                                <select name="weight_unit" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200">
                                    <option value="Gram" {{ old('weight_unit', $product->weight_unit) == 'Gram' ? 'selected' : '' }}>Gram</option>
                                    <option value="Kg" {{ old('weight_unit', $product->weight_unit) == 'Kg' ? 'selected' : '' }}>Kg</option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-gray-700 text-sm font-bold mb-2">&nbsp;</label>
                                <input type="number" step="0.01" name="weight" value="{{ old('weight', $product->weight) }}" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200" placeholder="Weight value">
                                @error('weight') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                            </div>
                        </div>

                        <!-- Row: Delivery Type -->
                        <div class="grid grid-cols-1 mb-4">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Delivery Type <span class="text-red-500">*</span></label>
                            <select name="delivery_type" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200">
                                <option value="flat_rate" {{ old('delivery_type', $product->delivery_type) == 'flat_rate' ? 'selected' : '' }}>Flat Rate</option>
                                <option value="free" {{ old('delivery_type', $product->delivery_type) == 'free' ? 'selected' : '' }}>Free Shipping</option>
                                <option value="pickup" {{ old('delivery_type', $product->delivery_type) == 'pickup' ? 'selected' : '' }}>Local Pickup</option>
                            </select>
                            @error('delivery_type') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                        </div>

                        <!-- Row 8: Toggles -->
                        <div class="grid grid-cols-1 gap-4 mb-4">
                            <div class="flex items-center justify-between border-b border-gray-100 pb-3 hover:bg-gray-50 p-2 rounded transition-colors">
                                <span class="text-gray-700 font-medium">Publish Status</span>
                                <label class="relative inline-flex items-center cursor-pointer">
                                    <input type="checkbox" name="status" value="1" class="sr-only peer" {{ $product->status ? 'checked' : '' }}>
                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                                    <span class="ml-3 text-sm font-medium text-gray-900">Published</span>
                                </label>
                            </div>
                            <div class="flex items-center justify-between border-b border-gray-100 pb-3 hover:bg-gray-50 p-2 rounded transition-colors">
                                <span class="text-gray-700 font-medium">Pre Order</span>
                                <label class="relative inline-flex items-center cursor-pointer">
                                    <input type="checkbox" name="pre_order" value="1" class="sr-only peer" {{ $product->pre_order ? 'checked' : '' }}>
                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                                    <span class="ml-3 text-sm font-medium text-gray-900">Pre-Order Disabled</span>
                                </label>
                            </div>
                        </div>

                        <!-- Row 9: Condition & Availability -->
                        <div class="grid grid-cols-1 mb-4">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Product Condition</label>
                            <select name="condition" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200">
                                <option value="New" {{ old('condition', $product->condition) == 'New' ? 'selected' : '' }}>New</option>
                                <option value="Used" {{ old('condition', $product->condition) == 'Used' ? 'selected' : '' }}>Used</option>
                                <option value="Refurbished" {{ old('condition', $product->condition) == 'Refurbished' ? 'selected' : '' }}>Refurbished</option>
                            </select>
                        </div>
                        <div class="grid grid-cols-1 mb-4">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Product Availability</label>
                            <select name="availability" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200">
                                <option value="In Stock" {{ old('availability', $product->availability) == 'In Stock' ? 'selected' : '' }}>In Stock</option>
                                <option value="Out of Stock" {{ old('availability', $product->availability) == 'Out of Stock' ? 'selected' : '' }}>Out of Stock</option>
                                <option value="Pre Order" {{ old('availability', $product->availability) == 'Pre Order' ? 'selected' : '' }}>Pre Order</option>
                            </select>
                        </div>

                        <!-- Row 9.5: Purchase Price -->
                        <div class="grid grid-cols-1 mb-4">
                            <label for="purchase_price" class="block text-gray-700 text-sm font-bold mb-2">Purchase Cost</label>
                            <input type="number" step="0.01" name="purchase_price" id="purchase_price" value="{{ old('purchase_price', $product->purchase_price) }}" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200" placeholder="Cost price (optional)">
                        </div>

                        <!-- Row 10: Price -->
                        <div class="grid grid-cols-1 mb-4">
                            <label for="price" class="block text-gray-700 text-sm font-bold mb-2">Regular Price <span class="text-red-500">*</span></label>
                            <input type="number" step="0.01" name="price" id="price" x-model="price" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200" placeholder="Regular price" required>
                        </div>

                        <!-- Row 11: Discount -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                            <div>
                                <label class="block text-gray-700 text-sm font-bold mb-2">Discount</label>
                                <select name="discount_type" x-model="discountType" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200">
                                    <option value="flat">Flat</option>
                                    <option value="percent">Percent</option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-gray-700 text-sm font-bold mb-2">&nbsp;</label>
                                <input type="number" step="0.01" name="discount_value" x-model="discountValue" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200">
                            </div>
                        </div>

                        <!-- Row 12: Sale Price -->
                        <div class="grid grid-cols-1 mb-4">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Sale Price</label>
                            <input type="number" step="0.01" name="offer_price" x-model="salePrice" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200" placeholder="Sale price" readonly>
                        </div>

                        <!-- Row 13: Add Variant (Alpine.js) -->
                        @php
                            $listItems = $product->sizes->isEmpty() 
                                ? [['id' => time(), 'value' => '']] 
                                : $product->sizes->map(fn($s) => ['id' => $s->id, 'value' => $s->name])->values()->all();
                            
                            $colorItems = $product->colors->isEmpty() 
                                ? [['id' => time(), 'code' => '#3B82F6', 'name' => '']] 
                                : $product->colors->map(fn($c) => ['id' => $c->id, 'code' => $c->code, 'name' => $c->name])->values()->all();

                            $existingVariants = $product->variants->map(function($v) {
                                $name = '';
                                if($v->size) $name .= $v->size->name;
                                if($v->size && $v->color) $name .= ' - ';
                                if($v->color) $name .= $v->color->name;
                                return [
                                    'name' => $name,
                                    'size' => $v->size ? $v->size->name : '',
                                    'color' => $v->color ? $v->color->name : '',
                                    'price' => $v->price,
                                    'offer_price' => $v->offer_price,
                                    'stock' => $v->stock_quantity,
                                    'discount_type' => $v->discount_type ?? 'flat',
                                    'discount_value' => $v->discount_value ?? 0,
                                    'sale_price' => $v->offer_price, // Assuming offer_price is the calculated sale price
                                    'inventory_status' => $v->inventory_status ?? 'in_stock',
                                    'weight' => $v->weight ?? 0,
                                    'weight_unit' => $v->weight_unit ?? 'kg',
                                    'shipping_cost' => $v->shipping_cost ?? 0,
                                    'description' => $v->description ?? '',
                                    'visibility' => (bool)$v->visibility,
                                    'existing_image' => $v->image,
                                    'image_preview' => $v->image ? asset('storage/' . $v->image) : null
                                ];
                            })->values()->all();
                        @endphp
                        <script>
                            document.addEventListener('alpine:init', () => {
                                Alpine.data('productEditVariants', () => ({
                                    hasVariant: {{ $product->variants->count() > 0 ? 'true' : 'false' }},
                                    activeTab: 'list',
                                    listItems: {!! json_encode($listItems) !!},
                                    colorItems: {!! json_encode($colorItems) !!},
                                    generatedVariants: {!! json_encode($existingVariants) !!},
                                    addList() { this.listItems.push({id: Date.now(), value: ''}); },
                                    removeList(index) { this.listItems.splice(index, 1); },
                                    addColor() { this.colorItems.push({id: Date.now(), code: '#3B82F6', name: ''}); },
                                    removeColor(index) { this.colorItems.splice(index, 1); },
                                    
                                    createVariantObj(name, size, color, existing = null) {
                                        return {
                                            name: name,
                                            size: size,
                                            color: color,
                                            price: existing ? existing.price : '',
                                            discount_type: existing ? (existing.discount_type || 'flat') : 'flat',
                                            discount_value: existing ? (existing.discount_value || 0) : 0,
                                            sale_price: existing ? existing.sale_price : '', 
                                            stock: existing ? existing.stock : '',
                                            inventory_status: existing ? (existing.inventory_status || 'in_stock') : 'in_stock',
                                            weight: existing ? (existing.weight || 0) : 0,
                                            weight_unit: existing ? (existing.weight_unit || 'kg') : 'kg',
                                            shipping_cost: existing ? (existing.shipping_cost || 0) : 0,
                                            delivery_type: existing ? (existing.delivery_type || 'flat_rate') : 'flat_rate',
                                            description: existing ? (existing.description || '') : '',
                                            visibility: existing ? (existing.visibility !== undefined ? existing.visibility : true) : true,
                                            image_preview: existing ? existing.image_preview : null,
                                            existing_image: existing ? existing.existing_image : null
                                        };
                                    },

                                    calculateVariantSalePrice(variant) {
                                        let price = parseFloat(variant.price) || 0;
                                        let discount = parseFloat(variant.discount_value) || 0;
                                        let type = variant.discount_type;
                                        
                                        if (price > 0 && discount > 0) {
                                            if (type === 'percent') {
                                                variant.sale_price = (price - (price * (discount / 100))).toFixed(2);
                                            } else {
                                                variant.sale_price = (price - discount).toFixed(2);
                                            }
                                        } else {
                                            variant.sale_price = price.toFixed(2);
                                        }
                                    },

                                    generateVariants() {
                                        // Preserve existing values
                                        const currentData = {};
                                        this.generatedVariants.forEach(v => {
                                            currentData[v.name] = v;
                                        });

                                        let newVariants = [];
                                        let sizes = this.listItems.filter(i => i.value);
                                        let colors = this.colorItems.filter(i => i.name);
                                        
                                        if (sizes.length === 0 && colors.length === 0) {
                                            this.generatedVariants = [];
                                            return;
                                        }

                                        if (sizes.length > 0 && colors.length > 0) {
                                            sizes.forEach(s => {
                                                colors.forEach(c => {
                                                    let name = s.value + ' - ' + c.name;
                                                    let existing = currentData[name];
                                                    newVariants.push(this.createVariantObj(name, s.value, c.name, existing));
                                                });
                                            });
                                        } else if (sizes.length > 0) {
                                            sizes.forEach(s => {
                                                 let name = s.value;
                                                 let existing = currentData[name];
                                                 newVariants.push(this.createVariantObj(name, s.value, '', existing));
                                            });
                                        } else if (colors.length > 0) {
                                             colors.forEach(c => {
                                                 let name = c.name;
                                                 let existing = currentData[name];
                                                 newVariants.push(this.createVariantObj(name, '', c.name, existing));
                                            });
                                        }
                                        this.generatedVariants = newVariants;
                                    }
                                }));
                            });
                        </script>
                        <div x-data="productEditVariants" class="border border-gray-200 rounded-lg p-4 mb-4 hover:shadow-sm transition-shadow bg-white">
                            <div class="flex items-center justify-between">
                                <span class="text-gray-700 font-medium">Add Variant</span>
                                <label class="relative inline-flex items-center cursor-pointer">
                                    <input type="checkbox" name="has_variant" class="sr-only peer" x-model="hasVariant">
                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                                </label>
                            </div>

                            <!-- Variant Section -->
                            <div x-show="hasVariant" x-transition class="mt-4 border-t border-gray-100 pt-4" style="display: none;">
                                <p class="text-gray-500 text-sm mb-4">
                                    Does your product come in different options, like size, color, or material? Click on the “Add Options” button to add variations for this product.
                                </p>

                                <div class="flex space-x-4 mb-6">
                                    <button type="button" @click="activeTab = 'list'" :class="{'text-blue-600 border-blue-600 bg-blue-50': activeTab === 'list', 'text-gray-600 border-gray-300 hover:bg-gray-50': activeTab !== 'list'}" class="flex items-center px-4 py-2 border rounded-lg font-medium transition-colors">
                                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path></svg>
                                        List
                                    </button>
                                    <button type="button" @click="activeTab = 'colors'" :class="{'text-blue-600 border-blue-600 bg-blue-50': activeTab === 'colors', 'text-gray-600 border-gray-300 hover:bg-gray-50': activeTab !== 'colors'}" class="flex items-center px-4 py-2 border rounded-lg transition-colors">
                                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zm0 0h12a2 2 0 002-2v-4a2 2 0 00-2-2h-2.343M11 7.343l1.657-1.657a2 2 0 012.828 0l2.829 2.829a2 2 0 010 2.828l-8.486 8.485M7 17h.01"></path></svg>
                                        Colors
                                    </button>
                                </div>

                                <div class="grid grid-cols-1 gap-8">
                                    <!-- List View -->
                                    <div x-show="activeTab === 'list'">
                                        <div class="mb-4">
                                            <label class="block text-gray-700 text-sm font-bold mb-2">Enter list title</label>
                                            <input type="text" name="variant_title_list" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent" placeholder="e.g. Size, Material">
                                        </div>
                                        
                                        <div class="space-y-3">
                                            <template x-for="(item, index) in listItems" :key="item.id">
                                                <div class="flex items-center gap-2">
                                                    <label class="w-16 text-sm text-gray-600" x-text="'List ' + (index + 1).toString().padStart(2, '0')"></label>
                                                    <input type="text" name="variant_options_list[]" x-model="item.value" class="flex-1 shadow-sm appearance-none border border-gray-300 rounded-lg py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent" placeholder="Value">
                                                    <button type="button" @click="removeList(index)" class="text-red-400 hover:text-red-600 p-2 rounded hover:bg-red-50 transition"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg></button>
                                                </div>
                                            </template>
                                        </div>
                                        <div class="mt-3 text-right">
                                            <button type="button" @click="addList()" class="text-blue-600 hover:text-blue-800 text-sm font-medium flex items-center justify-end ml-auto">
                                                Add Item <svg class="w-5 h-5 ml-1 bg-blue-600 text-white rounded-full p-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path></svg>
                                            </button>
                                        </div>
                                    </div>

                                    <!-- Colors View -->
                                    <div x-show="activeTab === 'colors'">
                                        <div class="mb-4">
                                            <label class="block text-gray-700 text-sm font-bold mb-2">Enter color title</label>
                                            <input type="text" name="variant_title_color" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent" placeholder="e.g. Color">
                                        </div>
                                        
                                        <div class="space-y-3">
                                            <template x-for="(item, index) in colorItems" :key="item.id">
                                                <div class="flex items-center gap-2">
                                                    <label class="w-16 text-sm text-gray-600" x-text="'Color ' + (index + 1).toString().padStart(2, '0')"></label>
                                                    <div class="flex-1 flex items-center gap-2">
                                                        <input type="text" name="variant_options_color_name[]" x-model="item.name" class="flex-1 shadow-sm appearance-none border border-gray-300 rounded-lg py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent" placeholder="Color Name">
                                                        <input type="color" name="variant_options_color_code[]" class="h-10 w-10 p-1 rounded border border-gray-300 cursor-pointer" x-model="item.code">
                                                    </div>
                                                    <button type="button" @click="removeColor(index)" class="text-red-400 hover:text-red-600 p-2 rounded hover:bg-red-50 transition"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg></button>
                                                </div>
                                            </template>
                                        </div>
                                        <div class="mt-3 text-right">
                                            <button type="button" @click="addColor()" class="text-blue-600 hover:text-blue-800 text-sm font-medium flex items-center justify-end ml-auto">
                                                Add Item <svg class="w-5 h-5 ml-1 bg-blue-600 text-white rounded-full p-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path></svg>
                                            </button>
                                        </div>
                                    </div>
                                    
                                    <!-- Actions -->
                                    <div class="flex justify-end space-x-3 border-t border-gray-100 pt-4">
                                        <button type="button" @click="hasVariant = false" class="px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition">Cancel</button>
                                        <button type="button" @click="generateVariants()" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors shadow-sm">Apply</button>
                                    </div>

                                    <!-- Generated Variants Table -->
                                    <div x-show="generatedVariants.length > 0" class="mt-6">
                                        <div class="overflow-x-auto border rounded-lg">
                                            <table class="w-full text-left text-sm text-gray-600 min-w-[1200px]">
                                                <thead class="bg-gray-50 border-b">
                                                    <tr>
                                                        <th class="px-4 py-3 font-medium w-48">Variant</th>
                                                        <th class="px-4 py-3 font-medium w-32">Price</th>
                                                        <th class="px-4 py-3 font-medium w-40">Discount</th>
                                                        <th class="px-4 py-3 font-medium w-24">Sale Price</th>
                                                        <th class="px-4 py-3 font-medium w-24">Stock</th>
                                                        <th class="px-4 py-3 font-medium w-32">Inventory</th>
                                                        <th class="px-4 py-3 font-medium w-32">Weight</th>
                                                        <th class="px-4 py-3 font-medium w-24">Shipping</th>
                                                        <th class="px-4 py-3 font-medium w-48">Description</th>
                                                        <th class="px-4 py-3 font-medium w-32">Image</th>
                                                        <th class="px-4 py-3 font-medium w-20">Visible</th>
                                                        <th class="px-4 py-3 font-medium text-right w-16">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody class="divide-y divide-gray-100">
                                                    <template x-for="(variant, index) in generatedVariants" :key="index">
                                                        <tr class="hover:bg-gray-50 transition-colors">
                                                            <td class="px-4 py-3 align-top">
                                                                <input type="text" :name="'variations['+index+'][name]'" x-model="variant.name" readonly class="bg-transparent border-none w-full focus:ring-0 p-0 text-gray-900 font-medium">
                                                                <input type="hidden" :name="'variations['+index+'][size]'" x-model="variant.size">
                                                                <input type="hidden" :name="'variations['+index+'][color]'" x-model="variant.color">
                                                            </td>
                                                            <td class="px-4 py-3 align-top">
                                                                <input type="number" step="0.01" :name="'variations['+index+'][price]'" x-model="variant.price" @input="calculateVariantSalePrice(variant)" class="w-full border border-gray-300 rounded px-2 py-1 text-sm focus:ring-blue-500 focus:border-blue-500" placeholder="0.00">
                                                            </td>
                                                            <td class="px-4 py-3 align-top space-y-2">
                                                                <select :name="'variations['+index+'][discount_type]'" x-model="variant.discount_type" @change="calculateVariantSalePrice(variant)" class="w-full border border-gray-300 rounded px-2 py-1 text-sm focus:ring-blue-500 focus:border-blue-500">
                                                                    <option value="flat">Flat</option>
                                                                    <option value="percent">Percent</option>
                                                                </select>
                                                                <input type="number" step="0.01" :name="'variations['+index+'][discount_value]'" x-model="variant.discount_value" @input="calculateVariantSalePrice(variant)" class="w-full border border-gray-300 rounded px-2 py-1 text-sm focus:ring-blue-500 focus:border-blue-500" placeholder="0">
                                                            </td>
                                                            <td class="px-4 py-3 align-top">
                                                                <input type="number" step="0.01" :name="'variations['+index+'][offer_price]'" x-model="variant.sale_price" readonly class="w-full bg-gray-100 border border-gray-300 rounded px-2 py-1 text-sm text-gray-500 cursor-not-allowed">
                                                            </td>
                                                            <td class="px-4 py-3 align-top">
                                                                <input type="number" :name="'variations['+index+'][stock]'" x-model="variant.stock" class="w-full border border-gray-300 rounded px-2 py-1 text-sm focus:ring-blue-500 focus:border-blue-500" placeholder="0">
                                                            </td>
                                                            <td class="px-4 py-3 align-top">
                                                                <select :name="'variations['+index+'][inventory_status]'" x-model="variant.inventory_status" class="w-full border border-gray-300 rounded px-2 py-1 text-sm focus:ring-blue-500 focus:border-blue-500">
                                                                    <option value="in_stock">In Stock</option>
                                                                    <option value="out_of_stock">Out of Stock</option>
                                                                    <option value="pre_order">Pre Order</option>
                                                                </select>
                                                            </td>
                                                            <td class="px-4 py-3 align-top space-y-2">
                                                                <input type="number" step="0.01" :name="'variations['+index+'][weight]'" x-model="variant.weight" class="w-full border border-gray-300 rounded px-2 py-1 text-sm focus:ring-blue-500 focus:border-blue-500" placeholder="0">
                                                                <select :name="'variations['+index+'][weight_unit]'" x-model="variant.weight_unit" class="w-full border border-gray-300 rounded px-2 py-1 text-sm focus:ring-blue-500 focus:border-blue-500">
                                                                    <option value="kg">Kg</option>
                                                                    <option value="g">Gram</option>
                                                                    <option value="lbs">Lbs</option>
                                                                </select>
                                                            </td>
                                                            <td class="px-4 py-3 align-top">
                                                                <div class="space-y-2">
                                                                    <select :name="'variations['+index+'][delivery_type]'" x-model="variant.delivery_type" class="w-full border border-gray-300 rounded px-2 py-1 text-sm focus:ring-blue-500 focus:border-blue-500">
                                                                        <option value="flat_rate">Flat Rate</option>
                                                                        <option value="free">Free Shipping</option>
                                                                        <option value="pickup">Local Pickup</option>
                                                                    </select>
                                                                </div>
                                                            </td>
                                                            <td class="px-4 py-3 align-top">
                                                                <textarea :name="'variations['+index+'][description]'" x-model="variant.description" rows="2" class="w-full border border-gray-300 rounded px-2 py-1 text-sm focus:ring-blue-500 focus:border-blue-500" placeholder="Desc..."></textarea>
                                                            </td>
                                                            <td class="px-4 py-3 align-top">
                                                                <div class="relative">
                                                                    <input type="hidden" :name="'variations['+index+'][existing_image]'" x-model="variant.existing_image">
                                                                    <input type="file" :name="'variations['+index+'][image]'" class="hidden" :id="'variant_image_'+index" @change="
                                                                        const file = $event.target.files[0];
                                                                        if (file) {
                                                                            variant.image_preview = URL.createObjectURL(file);
                                                                        }
                                                                    ">
                                                                    <label :for="'variant_image_'+index" class="cursor-pointer block w-full h-16 border-2 border-dashed border-gray-300 rounded flex items-center justify-center hover:border-blue-500 transition-colors bg-gray-50 overflow-hidden">
                                                                        <template x-if="variant.image_preview">
                                                                            <img :src="variant.image_preview" class="w-full h-full object-cover">
                                                                        </template>
                                                                        <template x-if="!variant.image_preview">
                                                                            <span class="text-xs text-gray-400 text-center">Upload<br>Image</span>
                                                                        </template>
                                                                    </label>
                                                                </div>
                                                            </td>
                                                            <td class="px-4 py-3 align-top text-center">
                                                                <input type="checkbox" :name="'variations['+index+'][visibility]'" x-model="variant.visibility" class="rounded border-gray-300 text-blue-600 shadow-sm focus:border-blue-300 focus:ring focus:ring-blue-200 focus:ring-opacity-50">
                                                            </td>
                                                            <td class="px-4 py-3 align-top text-right">
                                                                <button type="button" @click="generatedVariants.splice(index, 1)" class="text-red-500 hover:text-red-700 p-1 hover:bg-red-50 rounded transition">
                                                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
                                                                </button>
                                                            </td>
                                                        </tr>
                                                    </template>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Row 14: Stock Alert -->
                        <div class="grid grid-cols-1 mb-4">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Stock Alert</label>
                            <input type="number" name="stock_alert" value="{{ old('stock_alert', $product->stock_alert) }}" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200" placeholder="Stock alert number">
                        </div>
                        
                         <!-- Stock Quantity -->
                         <div class="grid grid-cols-1 mb-4">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Initial Stock Quantity</label>
                            <input type="number" name="stock_quantity" value="{{ old('stock_quantity', $product->stock_quantity) }}" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200">
                        </div>

                    </div>
                </div>

                <!-- Media -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg hover:shadow-md transition-shadow duration-300">
                    <div class="bg-blue-600 px-4 py-3 border-b border-blue-500">
                        <h3 class="text-white font-semibold text-lg flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path></svg>
                            Product Media
                        </h3>
                    </div>
                    <div class="p-6">
                        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
                            <!-- Cover Image -->
                            <div class="col-span-1 md:col-span-2 row-span-2 border-2 border-dashed border-gray-300 rounded-xl p-4 flex flex-col items-center justify-center text-center cursor-pointer hover:bg-gray-50 hover:border-blue-500 transition-all duration-200 relative group" onclick="document.getElementById('thumbnail').click()">
                                <input type="file" name="thumbnail" id="thumbnail" class="hidden" onchange="previewImage(this, 'cover-preview')">
                                <div id="cover-preview" class="w-full h-64 flex flex-col items-center justify-center bg-gray-50 rounded-lg text-gray-400 group-hover:text-blue-500 transition-colors">
                                    @if($product->thumbnail)
                                        <img src="{{ asset('storage/' . $product->thumbnail) }}" class="w-full h-full object-cover rounded-lg shadow-sm">
                                    @else
                                        <div class="text-center">
                                            <div class="text-5xl mb-3">📷</div>
                                            <span class="font-bold text-lg">Cover Image</span><br>
                                            <span class="text-xs">Size (800 x 800)</span>
                                        </div>
                                    @endif
                                </div>
                                <div class="absolute top-3 right-3 bg-blue-600 text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold shadow-md">1</div>
                            </div>

                            <!-- Gallery Images (10 slots) -->
                            @php
                                $existingImages = $product->images;
                                $maxImages = 4;
                            @endphp
                            
                            @for ($i = 0; $i < $maxImages; $i++)
                                @php 
                                    $currentImage = $existingImages[$i] ?? null; 
                                    $slotIndex = $i + 2;
                                @endphp
                                <div class="border-2 border-dashed border-gray-300 rounded-xl p-2 flex flex-col items-center justify-center text-center cursor-pointer hover:bg-gray-50 hover:border-blue-500 transition-all duration-200 relative h-32 group" onclick="document.getElementById('image_{{ $slotIndex }}').click()">
                                    <input type="file" name="images[]" id="image_{{ $slotIndex }}" class="hidden" onchange="previewImage(this, 'preview-{{ $slotIndex }}')">
                                    <div id="preview-{{ $slotIndex }}" class="w-full h-full flex items-center justify-center bg-gray-50 rounded-lg text-gray-400 group-hover:text-blue-500 transition-colors">
                                        @if($currentImage)
                                            <img src="{{ asset('storage/' . $currentImage->image_path) }}" class="w-full h-full object-cover rounded-lg shadow-sm">
                                        @else
                                            <div class="text-center">
                                                <span class="text-xs font-medium">Size<br>(800 x 800)</span>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="absolute top-1 right-1 bg-blue-500 text-white rounded-full w-5 h-5 flex items-center justify-center text-[10px] font-bold shadow-sm">{{ $slotIndex }}</div>
                                </div>
                            @endfor
                        </div>

                        <!-- Video Embed -->
                        <div class="mb-4">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Insert Video Embed (Youtube/Facebook/Vimeo)</label>
                            <textarea name="video_embed" rows="3" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200">{{ old('video_embed', $product->video_embed) }}</textarea>
                        </div>
                        
                        <!-- Video Position -->
                        <div class="mb-4">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Video Position</label>
                            <select name="video_position" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200">
                                <option value="">Select video position</option>
                                <option value="last" {{ old('video_position', $product->video_position) == 'last' ? 'selected' : '' }}>Last in Gallery</option>
                                <option value="first" {{ old('video_position', $product->video_position) == 'first' ? 'selected' : '' }}>First in Gallery</option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Product Description -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg hover:shadow-md transition-shadow duration-300">
                    <div class="bg-blue-600 px-4 py-3 border-b border-blue-500">
                        <h3 class="text-white font-semibold text-lg flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h7"></path></svg>
                            Product Description
                        </h3>
                    </div>
                    <div class="p-6">
                        <div class="mb-6">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Short Description</label>
                            <textarea id="short_description_editor" name="short_description" rows="5" class="w-full border border-gray-300 rounded-lg p-3 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200" placeholder="Short Description">{{ old('short_description', $product->short_description) }}</textarea>
                        </div>

                        <div class="mb-4">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Full Description</label>
                            <textarea id="description_editor" name="description" rows="8" class="w-full border border-gray-300 rounded-lg p-3 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200" placeholder="Full Description">{{ old('description', $product->description) }}</textarea>
                        </div>
                    </div>
                </div>
                
                <!-- Special Offers -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg hover:shadow-md transition-shadow duration-300">
                    <div class="bg-blue-600 px-4 py-3 border-b border-blue-500">
                        <h3 class="text-white font-semibold text-lg flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v13m0-13V6a2 2 0 112 2h-2zm0 0V5.5A2.5 2.5 0 109.5 8H12zm-7 4h14M5 12a2 2 0 110-4h14a2 2 0 110 4M5 12v7a2 2 0 002 2h10a2 2 0 002-2v-7"></path></svg>
                            Special Offers
                        </h3>
                    </div>
                    <div class="p-6">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                            <div class="flex items-center justify-between p-4 bg-red-50 rounded-lg border border-red-100 hover:shadow-sm transition-shadow">
                                <span class="font-bold text-red-700">Offer 01 (Flash)</span>
                                <label class="relative inline-flex items-center cursor-pointer">
                                    <input type="checkbox" name="offer_1" value="1" class="sr-only peer" {{ $product->offer_1 ? 'checked' : '' }}>
                                    <div class="w-11 h-6 bg-red-200 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-red-500"></div>
                                </label>
                            </div>
                            <div class="flex items-center justify-between p-4 bg-orange-50 rounded-lg border border-orange-100 hover:shadow-sm transition-shadow">
                                <span class="font-bold text-orange-700">Offer 02 (Daily)</span>
                                <label class="relative inline-flex items-center cursor-pointer">
                                    <input type="checkbox" name="offer_2" value="1" class="sr-only peer" {{ $product->offer_2 ? 'checked' : '' }}>
                                    <div class="w-11 h-6 bg-orange-200 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-orange-500"></div>
                                </label>
                            </div>
                            <div class="flex items-center justify-between p-4 bg-yellow-50 rounded-lg border border-yellow-100 hover:shadow-sm transition-shadow">
                                <span class="font-bold text-yellow-700">Offer 03 (Weekly)</span>
                                <label class="relative inline-flex items-center cursor-pointer">
                                    <input type="checkbox" name="offer_3" value="1" class="sr-only peer" {{ $product->offer_3 ? 'checked' : '' }}>
                                    <div class="w-11 h-6 bg-yellow-200 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-yellow-500"></div>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Digital Product -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg hover:shadow-md transition-shadow duration-300">
                     <div class="p-4 border-b border-gray-200 flex justify-between items-center bg-gray-50">
                        <h3 class="font-bold text-gray-700">Digital Product</h3>
                         <label class="relative inline-flex items-center cursor-pointer">
                            <input type="checkbox" name="is_digital" value="1" class="sr-only peer" {{ $product->is_digital ? 'checked' : '' }}>
                            <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                        </label>
                    </div>
                </div>

                <!-- SEO (Alpine.js) -->
                <div x-data="{ showSeo: {{ $product->has_seo ? 'true' : 'false' }} }" class="bg-white overflow-hidden shadow-sm sm:rounded-lg hover:shadow-md transition-shadow duration-300">
                    <div class="bg-blue-600 px-4 py-3 border-b border-blue-500 flex justify-between items-center">
                        <h3 class="text-white font-semibold text-lg flex items-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
                            SEO Information
                        </h3>
                        <label class="relative inline-flex items-center cursor-pointer">
                            <input type="checkbox" name="has_seo" class="sr-only peer" x-model="showSeo">
                            <div class="w-11 h-6 bg-blue-400 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-white peer-checked:after:bg-blue-600"></div>
                        </label>
                    </div>
                    <div x-show="showSeo" x-transition class="p-6 animate-fade-in" style="display: none;">
                        <div class="mb-4">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Meta Title</label>
                            <input type="text" name="meta_title" value="{{ old('meta_title', $product->meta_title) }}" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200" placeholder="Meta Title">
                        </div>
                        <div class="mb-4">
                            <label class="block text-gray-700 text-sm font-bold mb-2">Meta Description</label>
                            <textarea name="meta_description" rows="3" class="shadow-sm appearance-none border border-gray-300 rounded-lg w-full py-2.5 px-3 text-gray-700 leading-tight focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200" placeholder="Meta Description">{{ old('meta_description', $product->meta_description) }}</textarea>
                        </div>
                    </div>
                </div>

                <!-- Save Button Bottom -->
                <div class="flex justify-end">
                    <button type="submit" class="px-8 py-3 bg-gradient-to-r from-blue-600 to-blue-700 text-white rounded-lg hover:from-blue-700 hover:to-blue-800 transition-all duration-300 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 font-bold text-lg flex items-center">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3 3m0 0l-3-3m3 3V4"></path></svg>
                        Update Product
                    </button>
                </div>

            </form>
        </div>
    </div>

    <style>
        .animate-fade-in-up {
            animation: fadeInUp 0.5s ease-out;
        }
        .animate-fade-in {
            animation: fadeIn 0.3s ease-out;
        }
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
    </style>

    <script>
        function previewImage(input, previewId) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    var preview = document.getElementById(previewId);
                    preview.innerHTML = '<img src="' + e.target.result + '" class="w-full h-full object-cover rounded-lg shadow-sm">';
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
    <script>
        $(function () {
            $('#short_description_editor').summernote({
                placeholder: 'Short Description...',
                height: 140,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'italic', 'underline', 'clear']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['insert', ['link']],
                    ['view', ['codeview']]
                ]
            });
            $('#description_editor').summernote({
                placeholder: 'Full Description...',
                height: 260,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'italic', 'underline', 'strikethrough', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['insert', ['link', 'table', 'hr']],
                    ['view', ['codeview']]
                ]
            });
        });
    </script>

</x-admin-layout>
