<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Domain Verification') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            
            <!-- Notifications -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4" role="alert">
                    <p class="text-sm font-medium text-green-800">{{ session('success') }}</p>
                </div>
            @endif
            @if ($errors->any())
                <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4" role="alert">
                    <ul class="list-disc list-inside text-sm text-red-700">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form action="{{ route('admin.pixels.store_verification') }}" method="POST">
                        @csrf
                        
                        <div class="mb-6">
                            <label for="facebook_verification_code" class="block text-sm font-medium text-gray-700 mb-2">Facebook Domain Verification Meta-Tag</label>
                            <p class="text-sm text-gray-500 mb-4">
                                Paste the meta-tag provided by Facebook Business Manager to verify your domain. 
                                <br>Example: <code>&lt;meta name="facebook-domain-verification" content="your_verification_code" /&gt;</code>
                            </p>
                            <input type="text" name="facebook_verification_code" id="facebook_verification_code" 
                                value="{{ $setting->facebook_verification_code ?? '' }}" 
                                class="shadow-sm focus:ring-blue-500 focus:border-blue-500 block w-full sm:text-sm border-gray-300 rounded-md"
                                placeholder="Paste your verification code here">
                        </div>

                        <div class="mb-6">
                            <label for="tiktok_verification_code" class="block text-sm font-medium text-gray-700 mb-2">TikTok Domain Verification Meta-Tag</label>
                            <p class="text-sm text-gray-500 mb-4">
                                Paste the meta-tag provided by TikTok Business Manager to verify your domain. 
                                <br>Example: <code>&lt;meta name="tiktok-developers-site-verification" content="your_verification_code" /&gt;</code>
                            </p>
                            <input type="text" name="tiktok_verification_code" id="tiktok_verification_code" 
                                value="{{ $setting->tiktok_verification_code ?? '' }}" 
                                class="shadow-sm focus:ring-blue-500 focus:border-blue-500 block w-full sm:text-sm border-gray-300 rounded-md"
                                placeholder="Paste your verification code here">
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-900 focus:outline-none focus:border-blue-900 focus:ring ring-blue-300 disabled:opacity-25 transition ease-in-out duration-150">
                                Save Verification Code
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
