<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('TikTok Pixel & API Settings') }}
        </h2>
    </x-slot>

    <div class="py-12" x-data="tiktokHandler()">
        <div class="max-w-full mx-auto sm:px-6 lg:px-8">
            
            <!-- Notifications -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4" role="alert">
                    <p class="text-sm font-medium text-green-800">{{ session('success') }}</p>
                </div>
            @endif
            @if ($errors->any())
                <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4" role="alert">
                    <ul class="list-disc list-inside text-sm text-red-700">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="bg-white rounded-lg shadow-sm p-6">
                <!-- Top Actions -->
                <div class="flex justify-center items-center mb-6">
                    <div class="flex space-x-4">
                        <button @click="openModal('add')" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded shadow transition duration-150 ease-in-out flex items-center">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path></svg>
                            Add TikTok Pixel
                        </button>
                        <a href="https://ads.tiktok.com/i18n/events_manager/" target="_blank" class="bg-black hover:bg-gray-800 text-white font-bold py-2 px-4 rounded shadow transition duration-150 ease-in-out flex items-center">
                            <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 448 512"><path d="M448,209.91a210.06,210.06,0,0,1-122.77-39.25V349.38A162.55,162.55,0,1,1,185,188.31V278.2a74.62,74.62,0,1,0,52.23,71.18V0l88,0a121.18,121.18,0,0,0,1.86,22.17h0A122.18,122.18,0,0,0,381,102.39a121.43,121.43,0,0,0,67,20.14Z"/></svg>
                            Go to TikTok Events Manager
                        </a>
                        <a href="{{ route('admin.pixels.verification') }}" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded shadow transition duration-150 ease-in-out flex items-center">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                            Domain Verification
                        </a>
                    </div>
                </div>

                <!-- Data Table -->
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Pixel ID</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Access Token (API)</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Test Code</th>
                                <th scope="col" class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th scope="col" class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @if($tiktokPixels->count() > 0)
                            @foreach($tiktokPixels as $pixel)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 font-medium">
                                    {{ $pixel->pixel_id }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ Str::limit($pixel->access_token, 20) ?? 'Not Set' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $pixel->test_event_code ?? 'Not Set' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center">
                                    @if($pixel->is_active)
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">Active</span>
                                    @else
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-100 text-gray-800">Inactive</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center text-sm font-medium">
                                    <div class="flex justify-center space-x-2">
                                        <button @click="openModal('edit', {{ $pixel }})" class="bg-green-500 hover:bg-green-600 text-white p-2 rounded shadow transition">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z"></path></svg>
                                        </button>
                                        <form action="{{ route('admin.pixels.destroy_tiktok') }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this pixel?');">
                                            @csrf
                                            @method('DELETE')
                                            <input type="hidden" name="id" value="{{ $pixel->id }}">
                                            <button type="submit" class="bg-red-500 hover:bg-red-600 text-white p-2 rounded shadow transition">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="5" class="px-6 py-10 text-center text-gray-500">
                                    No TikTok Pixel found. Click "Add TikTok Pixel" to setup.
                                </td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Modal -->
        <div x-show="showModal" class="fixed inset-0 z-50 overflow-y-auto" style="display: none;">
            <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:block sm:p-0">
                <!-- Backdrop -->
                <div x-show="showModal" 
                     x-transition:enter="ease-out duration-300" 
                     x-transition:enter-start="opacity-0" 
                     x-transition:enter-end="opacity-100" 
                     x-transition:leave="ease-in duration-200" 
                     x-transition:leave-start="opacity-100" 
                     x-transition:leave-end="opacity-0" 
                     class="fixed inset-0 transition-opacity" aria-hidden="true">
                    <div class="absolute inset-0 bg-gray-900 bg-opacity-60 backdrop-blur-sm"></div>
                </div>

                <!-- Center Trick -->
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <!-- Modal Content -->
                <div x-show="showModal" 
                     x-transition:enter="ease-out duration-300" 
                     x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" 
                     x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100" 
                     x-transition:leave="ease-in duration-200" 
                     x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100" 
                     x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" 
                     class="inline-block align-bottom bg-white rounded-2xl text-left overflow-hidden shadow-2xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full border border-gray-100">
                    
                    <form action="{{ route('admin.pixels.store_tiktok') }}" method="POST">
                        @csrf
                        <input type="hidden" name="id" x-model="formData.id">
                        
                        <!-- Header -->
                        <div class="bg-gradient-to-r from-black to-gray-800 px-6 py-4 flex justify-between items-center">
                            <h3 class="text-xl font-bold text-white flex items-center gap-2">
                                <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 448 512"><path d="M448,209.91a210.06,210.06,0,0,1-122.77-39.25V349.38A162.55,162.55,0,1,1,185,188.31V278.2a74.62,74.62,0,1,0,52.23,71.18V0l88,0a121.18,121.18,0,0,0,1.86,22.17h0A122.18,122.18,0,0,0,381,102.39a121.43,121.43,0,0,0,67,20.14Z"/></svg>
                                <span x-text="editMode ? 'Edit TikTok Pixel' : 'Add TikTok Pixel'"></span>
                            </h3>
                            <button @click="showModal = false" type="button" class="text-white hover:text-gray-200 transition-colors focus:outline-none">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                            </button>
                        </div>

                        <!-- Body -->
                        <div class="px-6 py-6 space-y-6 bg-white">
                            
                            <!-- Enable/Disable Switch -->
                            <div class="flex items-center justify-between bg-gray-50 p-4 rounded-xl border border-gray-100">
                                <div>
                                    <label for="is_active" class="block text-sm font-bold text-gray-800">Active Status</label>
                                    <p class="text-xs text-gray-500 mt-1">Enable or disable this pixel.</p>
                                </div>
                                <div class="relative inline-block w-12 mr-2 align-middle select-none transition duration-200 ease-in">
                                    <input type="checkbox" name="is_active" id="is_active" x-model="formData.is_active" class="toggle-checkbox absolute block w-6 h-6 rounded-full bg-white border-4 appearance-none cursor-pointer transition-transform duration-200 ease-in-out" :class="formData.is_active ? 'translate-x-6 border-black' : 'translate-x-0 border-gray-300'"/>
                                    <label for="is_active" class="toggle-label block overflow-hidden h-6 rounded-full cursor-pointer transition-colors duration-200" :class="formData.is_active ? 'bg-black' : 'bg-gray-300'"></label>
                                </div>
                            </div>

                            <!-- Pixel ID -->
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Pixel ID <span class="text-red-500">*</span></label>
                                <input type="text" name="pixel_id" x-model="formData.pixel_id" placeholder="e.g. CXXXXXXXXXXXX" class="focus:ring-black focus:border-black block w-full shadow-sm sm:text-sm border-gray-300 rounded-lg py-2.5 transition-shadow hover:shadow-md">
                                <p class="text-xs text-gray-500 mt-1">Found in TikTok Ads Manager > Assets > Events > Web Events.</p>
                            </div>

                            <!-- Access Token -->
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Access Token (Optional)</label>
                                <textarea name="access_token" x-model="formData.access_token" rows="3" placeholder="Paste your API Access Token here..." class="focus:ring-black focus:border-black block w-full shadow-sm sm:text-sm border-gray-300 rounded-lg py-2.5 transition-shadow hover:shadow-md"></textarea>
                                <p class="text-xs text-gray-500 mt-1">Required for Server-Side Events (CAPI). Generate in Settings > Events API.</p>
                            </div>

                            <!-- Test Event Code -->
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Test Event Code (Optional)</label>
                                <input type="text" name="test_event_code" x-model="formData.test_event_code" placeholder="e.g. TEST12345" class="focus:ring-black focus:border-black block w-full shadow-sm sm:text-sm border-gray-300 rounded-lg py-2.5 transition-shadow hover:shadow-md">
                                <p class="text-xs text-gray-500 mt-1">Use this to test server-side events in "Test Events" tab.</p>
                            </div>

                        </div>

                        <!-- Footer -->
                        <div class="bg-gray-50 px-6 py-4 flex flex-row-reverse rounded-b-2xl border-t border-gray-100">
                            <button type="submit" class="w-full inline-flex justify-center items-center rounded-lg border border-transparent shadow-lg px-6 py-2.5 bg-black text-base font-medium text-white hover:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-black sm:ml-3 sm:w-auto sm:text-sm transform transition hover:-translate-y-0.5">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                                Save Pixel
                            </button>
                            <button @click="showModal = false" type="button" class="mt-3 w-full inline-flex justify-center items-center rounded-lg border border-gray-300 shadow-sm px-6 py-2.5 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm transition hover:text-gray-900">
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>

    <script>
        function tiktokHandler() {
            return {
                showModal: false,
                editMode: false,
                formData: {
                    id: '',
                    pixel_id: '',
                    access_token: '',
                    test_event_code: '',
                    is_active: true
                },
                openModal(mode, pixel = null) {
                    this.showModal = true;
                    if (mode === 'edit' && pixel) {
                        this.editMode = true;
                        this.formData = {
                            id: pixel.id,
                            pixel_id: pixel.pixel_id,
                            access_token: pixel.access_token,
                            test_event_code: pixel.test_event_code,
                            is_active: Boolean(pixel.is_active)
                        };
                    } else {
                        this.editMode = false;
                        this.formData = {
                            id: '',
                            pixel_id: '',
                            access_token: '',
                            test_event_code: '',
                            is_active: true
                        };
                    }
                }
            }
        }
    </script>
</x-admin-layout>