<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Facebook Pixel & CAPI Settings') }}
        </h2>
    </x-slot>

    <div class="py-12" x-data="pixelHandler()">
        <div class="max-w-full mx-auto sm:px-6 lg:px-8">
            
            <!-- Notifications -->
            @if(session('success'))
                <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4" role="alert">
                    <p class="text-sm font-medium text-green-800">{{ session('success') }}</p>
                </div>
            @endif
            @if ($errors->any())
                <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4" role="alert">
                    <ul class="list-disc list-inside text-sm text-red-700">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="bg-white rounded-lg shadow-sm p-6">
                <!-- Top Actions -->
                <div class="flex justify-center items-center mb-6">
                    <div class="flex space-x-4">
                        <button @click="openModal('add')" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded shadow transition duration-150 ease-in-out flex items-center">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path></svg>
                            Add Facebook Conversion API
                        </button>
                        <a href="{{ route('admin.pixels.logs') }}" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded shadow transition duration-150 ease-in-out flex items-center">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path></svg>
                            View CAPI Logs
                        </a>
                        <a href="https://business.facebook.com/commerce_manager/" target="_blank" class="bg-orange-500 hover:bg-orange-600 text-white font-bold py-2 px-4 rounded shadow transition duration-150 ease-in-out flex items-center">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path></svg>
                            Generate Facebook Catalog ID
                        </a>
                    </div>
                </div>

                <!-- Data Table -->
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Dataset Id (Pixel Id)</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Pixel Access Token</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">FB Catalog ID</th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Test event code</th>
                                <th scope="col" class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Browser Tracking</th>
                                <th scope="col" class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Server Tracking</th>
                                <th scope="col" class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Edit / Delete</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @if($pixels->count() > 0)
                            @foreach($pixels as $pixel)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 font-medium">
                                    {{ $pixel->pixel_id }}
                                </td>
                                @php
                                    $rawAccessToken = $pixel->getRawOriginal('access_token');
                                @endphp
                                <td class="px-6 py-4 text-sm text-gray-500 max-w-xs truncate" title="{{ $rawAccessToken }}">
                                    {{ Str::limit($rawAccessToken, 30) }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $pixel->catalog_id ?? '-' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $pixel->test_event_code ?? '-' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center">
                                    @if($pixel->is_active)
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">Active</span>
                                    @else
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">Inactive</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center">
                                    @if($pixel->server_side_enabled && !empty($rawAccessToken))
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">Active</span>
                                    @else
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-100 text-gray-800">Inactive</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center text-sm font-medium">
                                    <div class="flex justify-center space-x-2">
                                        @php
                                            $pixelPayload = [
                                                'id' => $pixel->id,
                                                'pixel_id' => $pixel->pixel_id,
                                                'catalog_id' => $pixel->catalog_id,
                                                'test_event_code' => $pixel->test_event_code,
                                                'is_active' => $pixel->is_active,
                                                'server_side_enabled' => $pixel->server_side_enabled,
                                                'access_token' => $rawAccessToken,
                                                'api_version' => $pixel->api_version,
                                            ];
                                        @endphp
                                        <button @click='openModal("edit", {{ json_encode($pixelPayload) }})' class="bg-green-500 hover:bg-green-600 text-white p-2 rounded shadow transition">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z"></path></svg>
                                        </button>
                                        <form action="{{ route('admin.pixels.destroy') }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this configuration?');">
                                            @csrf
                                            @method('DELETE')
                                            <input type="hidden" name="id" value="{{ $pixel->id }}">
                                            <button type="submit" class="bg-red-500 hover:bg-red-600 text-white p-2 rounded shadow transition">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="7" class="px-6 py-10 text-center text-gray-500">
                                    No configuration found. Click "Add Facebook Conversion API" to setup.
                                </td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Modal -->
        <div x-show="showModal" class="fixed inset-0 z-50 overflow-y-auto" style="display: none;">
            <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:block sm:p-0">
                <!-- Backdrop -->
                <div x-show="showModal" 
                     x-transition:enter="ease-out duration-300" 
                     x-transition:enter-start="opacity-0" 
                     x-transition:enter-end="opacity-100" 
                     x-transition:leave="ease-in duration-200" 
                     x-transition:leave-start="opacity-100" 
                     x-transition:leave-end="opacity-0" 
                     class="fixed inset-0 transition-opacity" aria-hidden="true">
                    <div class="absolute inset-0 bg-gray-900 bg-opacity-60 backdrop-blur-sm"></div>
                </div>

                <!-- Center Trick -->
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <!-- Modal Content -->
                <div x-show="showModal" 
                     x-transition:enter="ease-out duration-300" 
                     x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" 
                     x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100" 
                     x-transition:leave="ease-in duration-200" 
                     x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100" 
                     x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" 
                     class="inline-block align-bottom bg-white rounded-2xl text-left overflow-hidden shadow-2xl transform transition-all sm:my-8 sm:align-middle sm:max-w-2xl sm:w-full border border-gray-100">
                    
                    <form action="{{ route('admin.pixels.store') }}" method="POST">
                        @csrf
                        <input type="hidden" name="id" x-model="formData.id">
                        
                        <!-- Header -->
                        <div class="bg-gradient-to-r from-blue-600 to-indigo-700 px-6 py-4 flex justify-between items-center">
                            <h3 class="text-xl font-bold text-white flex items-center gap-2">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                                <span x-text="editMode ? 'Edit Pixel Configuration' : 'New Pixel Configuration'"></span>
                            </h3>
                            <button @click="showModal = false" type="button" class="text-white hover:text-gray-200 transition-colors focus:outline-none">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                            </button>
                        </div>

                        <!-- Body -->
                        <div class="px-6 py-6 space-y-6 bg-white">
                            
                            <!-- Enable/Disable Switch -->
                            <div class="flex items-center justify-between bg-blue-50 p-4 rounded-xl border border-blue-100">
                                <div>
                                    <label for="is_active" class="block text-sm font-bold text-gray-800">Active Status</label>
                                    <p class="text-xs text-gray-500 mt-1">Enable or disable this pixel integration instantly.</p>
                                </div>
                                <div class="relative inline-block w-12 mr-2 align-middle select-none transition duration-200 ease-in">
                                    <input type="checkbox" name="is_active" id="is_active" x-model="formData.is_active" class="toggle-checkbox absolute block w-6 h-6 rounded-full bg-white border-4 appearance-none cursor-pointer transition-transform duration-200 ease-in-out" :class="formData.is_active ? 'translate-x-6 border-blue-600' : 'translate-x-0 border-gray-300'"/>
                                    <label for="is_active" class="toggle-label block overflow-hidden h-6 rounded-full cursor-pointer transition-colors duration-200" :class="formData.is_active ? 'bg-blue-600' : 'bg-gray-300'"></label>
                                </div>
                            </div>

                            <!-- Server Side Enabled Switch -->
                            <div class="flex items-center justify-between bg-purple-50 p-4 rounded-xl border border-purple-100">
                                <div>
                                    <label for="server_side_enabled" class="block text-sm font-bold text-gray-800">Server-Side Tracking (CAPI)</label>
                                    <p class="text-xs text-gray-500 mt-1">Enable conversions API for better data accuracy.</p>
                                </div>
                                <div class="relative inline-block w-12 mr-2 align-middle select-none transition duration-200 ease-in">
                                    <input type="checkbox" name="server_side_enabled" id="server_side_enabled" x-model="formData.server_side_enabled" class="toggle-checkbox absolute block w-6 h-6 rounded-full bg-white border-4 appearance-none cursor-pointer transition-transform duration-200 ease-in-out" :class="formData.server_side_enabled ? 'translate-x-6 border-purple-600' : 'translate-x-0 border-gray-300'"/>
                                    <label for="server_side_enabled" class="toggle-label block overflow-hidden h-6 rounded-full cursor-pointer transition-colors duration-200" :class="formData.server_side_enabled ? 'bg-purple-600' : 'bg-gray-300'"></label>
                                </div>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <!-- Pixel ID -->
                                <div>
                                    <label class="block text-sm font-semibold text-gray-700 mb-2">Facebook Pixel ID <span class="text-red-500">*</span></label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V8a2 2 0 00-2-2h-5m-4 0V5a2 2 0 114 0v1m-4 0c0 .884-.896 1.75-2.129 2.25M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                                        </div>
                                        <input type="text" name="pixel_id" x-model="formData.pixel_id" placeholder="e.g. 1234567890" class="pl-10 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-lg py-2.5 transition-shadow hover:shadow-md">
                                    </div>
                                </div>

                                <!-- Catalog ID -->
                                <div>
                                    <label class="block text-sm font-semibold text-gray-700 mb-2">Facebook Catalog ID</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path></svg>
                                        </div>
                                        <input type="text" name="catalog_id" x-model="formData.catalog_id" placeholder="Optional" class="pl-10 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-lg py-2.5 transition-shadow hover:shadow-md">
                                    </div>
                                </div>
                            </div>

                            <!-- Access Token -->
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Conversions API Access Token</label>
                                <div class="relative">
                                    <textarea name="access_token" x-model="formData.access_token" rows="3" placeholder="Paste your long access token here..." class="focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-lg py-2.5 transition-shadow hover:shadow-md"></textarea>
                                </div>
                                <p class="text-xs text-gray-500 mt-1">Required for server-side event tracking (CAPI).</p>
                            </div>

                            <!-- Test Code -->
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-semibold text-gray-700 mb-2">Test Event Code (Optional)</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.384-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"></path></svg>
                                        </div>
                                        <input type="text" name="test_event_code" x-model="formData.test_event_code" placeholder="e.g. TEST12345" class="pl-10 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-lg py-2.5 transition-shadow hover:shadow-md">
                                    </div>
                                </div>
                                <div>
                                    <label class="block text-sm font-semibold text-gray-700 mb-2">API Version</label>
                                    <div class="relative">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path></svg>
                                        </div>
                                        <input type="text" name="api_version" x-model="formData.api_version" placeholder="e.g. v19.0" class="pl-10 focus:ring-blue-500 focus:border-blue-500 block w-full shadow-sm sm:text-sm border-gray-300 rounded-lg py-2.5 transition-shadow hover:shadow-md">
                                    </div>
                                </div>
                            </div>

                        </div>

                        <!-- Footer -->
                        <div class="bg-gray-50 px-6 py-4 flex flex-row-reverse rounded-b-2xl border-t border-gray-100">
                            <button type="submit" class="w-full inline-flex justify-center items-center rounded-lg border border-transparent shadow-lg px-6 py-2.5 bg-gradient-to-r from-blue-600 to-indigo-600 text-base font-medium text-white hover:from-blue-700 hover:to-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 sm:ml-3 sm:w-auto sm:text-sm transform transition hover:-translate-y-0.5">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                                Save Configuration
                            </button>
                            <button @click="showModal = false" type="button" class="mt-3 w-full inline-flex justify-center items-center rounded-lg border border-gray-300 shadow-sm px-6 py-2.5 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm transition hover:text-gray-900">
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>

    <script>
        function pixelHandler() {
            return {
                showModal: false,
                editMode: false,
                formData: {
                    id: '',
                    pixel_id: '',
                    catalog_id: '',
                    access_token: '',
                    test_event_code: '',
                    is_active: true
                },
                openModal(mode, pixel = null) {
                    this.showModal = true;
                    if (mode === 'edit' && pixel) {
                        this.editMode = true;
                        this.formData = {
                            id: pixel.id,
                            pixel_id: pixel.pixel_id,
                            catalog_id: pixel.catalog_id,
                            access_token: pixel.access_token,
                            test_event_code: pixel.test_event_code,
                            is_active: pixel.is_active,
                            server_side_enabled: pixel.server_side_enabled,
                            api_version: pixel.api_version
                        };
                    } else {
                        this.editMode = false;
                        this.formData = {
                            id: '',
                            pixel_id: '',
                            catalog_id: '',
                            access_token: '',
                            test_event_code: '',
                            is_active: true,
                            server_side_enabled: false,
                            api_version: 'v19.0'
                        };
                    }
                }
            }
        }
    </script>
</x-admin-layout>
