<x-admin-layout>
    <div x-data="{ 
        activeOrderItems: [], 
        showItemsModal: false, 
        openItemsModal(items) { 
            this.activeOrderItems = items; 
            this.showItemsModal = true; 
        } 
    }">
    @if(request('status') === 'incomplete')
        <div class="p-2 md:p-6 bg-slate-50 min-h-screen font-sans">
            <!-- Top Header Section -->
            <div class="bg-white p-4 rounded-2xl shadow-lg border border-slate-100 mb-4 md:mb-6 flex flex-col md:flex-row items-center justify-between gap-4">
                
                <!-- Left: Title & Search -->
                <div class="flex items-center gap-4 w-full md:w-auto flex-1">
                    <!-- Back Button (Mobile) -->
                    <a href="{{ route('admin.orders.index') }}" class="md:hidden bg-slate-100 hover:bg-slate-200 text-slate-600 p-2.5 rounded-xl transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
                    </a>

                    <div class="hidden md:block">
                        <h2 class="text-xl font-bold text-slate-800">Incomplete Orders</h2>
                        <p class="text-xs text-slate-500">Manage your incomplete orders</p>
                    </div>

                    <div class="h-8 w-px bg-slate-200 hidden md:block"></div>

                    <!-- Search Form -->
                    <form id="incomplete-search-form" action="{{ route('admin.orders.index') }}" method="GET" class="flex items-center gap-2 w-full md:w-auto">
                        <input type="hidden" name="status" value="incomplete">
                        
                        <div class="relative group flex-1 md:w-64">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <svg class="w-5 h-5 text-slate-400 group-focus-within:text-blue-500 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
                            </div>
                            <input type="text" name="search" value="{{ request('search') }}" placeholder="Search ID, Phone..." 
                                   class="w-full pl-10 pr-4 py-2.5 bg-slate-50 border border-slate-200 text-slate-700 text-sm rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none transition-all shadow-sm hover:bg-white">
                        </div>

                        <!-- Date Display -->
                        <div class="hidden md:flex items-center bg-slate-50 border border-slate-200 rounded-xl p-1 shadow-sm hover:bg-white transition-colors">
                            <input type="date" name="start_date" form="incomplete-search-form" value="{{ $startDate }}" class="bg-transparent border-0 text-sm text-slate-600 focus:ring-0 p-1.5 cursor-pointer hover:text-blue-600 transition-colors w-32">
                            <span class="text-slate-400 mx-1 font-medium">to</span>
                            <input type="date" name="end_date" form="incomplete-search-form" value="{{ $endDate }}" class="bg-transparent border-0 text-sm text-slate-600 focus:ring-0 p-1.5 cursor-pointer hover:text-blue-600 transition-colors w-32">
                        </div>
                        
                        <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white p-2.5 rounded-xl shadow-md hover:shadow-lg transition-all">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
                        </button>
                    </form>
                </div>

                <!-- Right: Actions -->
                <div class="flex items-center gap-3">
                    <a href="{{ route('admin.orders.index') }}" class="hidden md:flex items-center gap-2 bg-slate-100 hover:bg-slate-200 text-slate-700 px-5 py-2.5 rounded-xl font-semibold text-sm transition-all hover:shadow-sm">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
                        Back to Orders
                    </a>
                    <a href="{{ request()->fullUrl() }}" class="bg-blue-50 hover:bg-blue-100 text-blue-600 p-2.5 rounded-xl shadow-sm transition-colors" title="Refresh">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path></svg>
                    </a>
                </div>
            </div>

            <!-- Stats / Tabs Row -->
            @php
                $activeTab = request('tab', 'all');
                $tab = $activeTab; // Ensure $tab is available if not passed
                $tabClasses = [
                    'active' => 'bg-gradient-to-r from-blue-600 to-indigo-600 text-white shadow-md transform scale-105',
                    'inactive' => 'bg-white text-slate-600 border border-slate-200 hover:bg-slate-50 hover:border-blue-300'
                ];
            @endphp
            <div class="flex flex-wrap items-center gap-3 mb-6">
                <!-- All (Total Incomplete History) -->
                <a href="{{ route('admin.orders.index', ['status' => 'incomplete', 'tab' => 'all']) }}" 
                   class="px-4 py-2 rounded-xl text-sm font-semibold transition-all duration-200 {{ $tab === 'all' ? $tabClasses['active'] : $tabClasses['inactive'] }}">
                    All <span class="ml-1 opacity-80 text-xs {{ $tab === 'all' ? 'bg-white/20 text-white' : 'bg-blue-100 text-blue-600' }} px-1.5 py-0.5 rounded-full">{{ $counts['incomplete_all'] ?? 0 }}</span>
                </a>

                <!-- New Orders -->
                <a href="{{ route('admin.orders.index', ['status' => 'incomplete', 'tab' => 'pending']) }}" 
                   class="px-4 py-2 rounded-xl text-sm font-semibold transition-all duration-200 {{ $tab === 'pending' ? $tabClasses['active'] : $tabClasses['inactive'] }}">
                    New Orders <span class="ml-1 opacity-80 text-xs {{ $tab === 'pending' ? 'bg-white/20 text-white' : 'bg-blue-100 text-blue-600' }} px-1.5 py-0.5 rounded-full">{{ $counts['incomplete_pending'] ?? 0 }}</span>
                </a>
                
                <a href="{{ route('admin.orders.index', ['status' => 'incomplete', 'tab' => 'processing']) }}" 
                   class="px-4 py-2 rounded-xl text-sm font-semibold transition-all duration-200 {{ $tab === 'processing' ? $tabClasses['active'] : $tabClasses['inactive'] }}">
                    Confirmed <span class="ml-1 opacity-80 text-xs {{ $tab === 'processing' ? 'bg-white/20 text-white' : 'bg-blue-100 text-blue-600' }} px-1.5 py-0.5 rounded-full">{{ $counts['incomplete_processing'] ?? 0 }}</span>
                </a>

                <a href="{{ route('admin.orders.index', ['status' => 'incomplete', 'tab' => 'cancelled']) }}" 
                   class="px-4 py-2 rounded-xl text-sm font-semibold transition-all duration-200 {{ $tab === 'cancelled' ? $tabClasses['active'] : $tabClasses['inactive'] }}">
                    Cancelled <span class="ml-1 opacity-80 text-xs {{ $tab === 'cancelled' ? 'bg-white/20 text-white' : 'bg-blue-100 text-blue-600' }} px-1.5 py-0.5 rounded-full">{{ $counts['incomplete_cancelled'] ?? 0 }}</span>
                </a>

                <a href="{{ route('admin.orders.index', ['status' => 'incomplete', 'tab' => 'deleted']) }}" 
                   class="px-4 py-2 rounded-xl text-sm font-semibold transition-all duration-200 {{ $tab === 'deleted' ? 'bg-red-600 text-white shadow-md' : 'bg-white text-red-600 border border-red-200 hover:bg-red-50 hover:border-red-300' }}">
                    Deleted <span class="ml-1 opacity-80 text-xs {{ $tab === 'deleted' ? 'bg-white/20 text-white' : 'bg-red-100 text-red-600' }} px-1.5 py-0.5 rounded-full">{{ $counts['incomplete_deleted'] ?? 0 }}</span>
                </a>
                

            </div>

            <!-- Table Section -->
            <div class="bg-white border border-slate-100 rounded-2xl shadow-sm overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-slate-100 text-sm">
                        <thead class="bg-blue-50 text-slate-700">
                            <tr>
                                <th scope="col" class="px-3 py-3 text-left w-4">
                                    <input type="checkbox" class="rounded border-slate-300 text-blue-600 focus:ring-blue-500 transition-colors cursor-pointer">
                                </th>
                                <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Order ID</th>
                                <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Customer Info</th>
                                <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Product</th>
                                <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Total Bill</th>
                                <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Payment Info <span class="text-slate-400 font-normal ml-0.5" title="Payment Details">ⓘ</span></th>
                                <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Collectable</th>
                                <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Status</th>
                                <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Courier</th>
                                <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Note <span class="text-slate-400 font-normal ml-0.5" title="Internal Notes">ⓘ</span></th>
                                <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Employee</th>
                                <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Blocklist</th>
                                <th scope="col" class="px-3 py-3 text-right text-xs font-bold uppercase tracking-wider">Action</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-slate-100">
                            @forelse($orders as $order)
                            <tr class="hover:bg-slate-50 transition-colors group">
                                <td class="px-3 py-4 whitespace-nowrap">
                                    <input type="checkbox" class="rounded border-slate-300 text-blue-600 focus:ring-blue-500 transition-colors cursor-pointer">
                                </td>
                                
                                <!-- Order ID -->
                                <td class="px-3 py-4 whitespace-nowrap">
                                    <div class="font-bold text-slate-800">{{ $order->order_number }}</div>
                                    <div class="text-xs text-slate-500 mt-0.5">{{ $order->created_at->format('d M Y') }} • {{ $order->created_at->format('h:i A') }}</div>
                                    
                                    @if($order->is_from_incomplete || \Illuminate\Support\Str::startsWith($order->order_number, 'INC-'))
                                        <div class="mt-1">
                                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-[10px] font-medium bg-amber-500 text-white">
                                                From Incomplete
                                            </span>
                                        </div>
                                    @endif


    </div>

                                    @if($order->source === 'manual')
                                        <div class="mt-1">
                                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-[10px] font-medium bg-pink-500 text-white">
                                                Manual Order
                                            </span>
                                        </div>
                                    @elseif($order->source === 'landing_page')
                                        <div class="mt-1">
                                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-[10px] font-medium bg-blue-600 text-white">
                                                Landing page
                                            </span>
                                        </div>
                                    @endif
                                </td>

                                <!-- Customer Info -->
                                <td class="px-3 py-4 max-w-[240px]">
                                    <div class="space-y-1.5">
                                        <div class="flex items-center gap-1.5 group">
                                            <svg class="w-3.5 h-3.5 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
                                            <a href="tel:{{ $order->phone }}" class="text-slate-800 font-semibold hover:text-blue-600 transition-colors">{{ $order->phone }}</a>
                                            <span x-data='fraudCheck({{ json_encode($order->phone, JSON_HEX_APOS) }}, {{ $order->fraud_score !== null ? $order->fraud_score : "null" }}, {{ $order->fraud_data !== null ? json_encode($order->fraud_data, JSON_HEX_APOS) : "null" }})' class="inline-flex items-center opacity-60 group-hover:opacity-100 transition-opacity">
                                                <template x-if="!checked && !percentage">
                                                    <button @click.prevent="check()" class="ml-1 text-[10px] bg-slate-100 hover:bg-slate-200 text-slate-600 px-1.5 py-0.5 rounded cursor-pointer transition-colors" title="Check Fraud Status">
                                                        <span x-show="!loading">Check</span>
                                                        <svg x-show="loading" class="animate-spin h-3 w-3 text-slate-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                                        </svg>
                                                    </button>
                                                </template>
                                                <template x-if="checked || percentage !== null">
                                                    <button @click.prevent="showDetails()" class="ml-1 text-[10px] px-1.5 py-0.5 rounded font-bold cursor-pointer transition-colors" :class="getBadgeClass()">
                                                        <span x-text="percentage + '%'"></span>
                                                    </button>
                                                </template>
                                            </span>
                                        </div>
                                        <div class="flex items-center gap-1.5 text-slate-600 text-xs">
                                            <svg class="w-3.5 h-3.5 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
                                            <span class="truncate">{{ $order->first_name }} {{ $order->last_name }}</span>
                                        </div>
                                        <div class="flex items-start gap-1.5 text-slate-500 text-xs max-w-[240px]">
                                            <svg class="w-3.5 h-3.5 text-slate-400 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                                            <span title="{{ $order->address }}" style="display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;overflow:hidden;line-height:1.25">{{ $order->address }}</span>
                                        </div>
                                    </div>
                                </td>

                                <!-- Product -->
                                <td class="px-3 py-4 cursor-pointer hover:bg-slate-100 transition-colors rounded-lg" @click="openItemsModal({{ json_encode($order->items->map(function($item) {
                                    return [
                                        'name' => $item->product_name,
                                        'image' => $item->product && $item->product->thumbnail ? Storage::url($item->product->thumbnail) : null,
                                        'quantity' => $item->quantity,
                                        'price' => $item->price,
                                        'total' => $item->quantity * $item->price,
                                        'variation' => trim(($item->color ? $item->color->name : '') . ' ' . ($item->size ? $item->size->name : ''))
                                    ];
                                })) }})">
                                    <div class="flex -space-x-3 hover:space-x-1 transition-all duration-300">
                                        @foreach($order->items->take(3) as $item)
                                            @if($item->product && $item->product->thumbnail)
                                                <div class="relative group/img">
                                                    <img class="inline-block h-10 w-10 rounded-full ring-2 ring-white object-cover shadow-sm" src="{{ Storage::url($item->product->thumbnail) }}" alt="{{ $item->product_name }}">
                                                    <div class="absolute bottom-full left-1/2 transform -translate-x-1/2 mb-2 px-2 py-1 text-xs text-white bg-slate-800 rounded opacity-0 group-hover/img:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">{{ $item->product_name }}</div>
                                                </div>
                                            @else
                                                <div class="inline-block h-10 w-10 rounded-full ring-2 ring-white bg-slate-100 flex items-center justify-center text-xs text-slate-500 shadow-sm" title="{{ $item->product_name }}">{{ substr($item->product_name, 0, 1) }}</div>
                                            @endif
                                        @endforeach
                                        @if($order->items->count() > 3)
                                            <div class="inline-block h-10 w-10 rounded-full ring-2 ring-white bg-slate-50 flex items-center justify-center text-xs font-bold text-slate-500 shadow-sm">+{{ $order->items->count() - 3 }}</div>
                                        @endif
                                    </div>
                                </td>

                                <!-- Total Bill -->
                                <td class="px-3 py-4 whitespace-nowrap">
                                    <span class="font-bold text-slate-800">TK {{ number_format($order->total_amount, 0) }}</span>
                                </td>

                                <!-- Payment Info -->
                                <td class="px-3 py-4 whitespace-nowrap">
                                    <div class="font-bold text-slate-800">Paid: {{ $order->payment_status === 'paid' ? number_format($order->total_amount, 0) : '0' }} TK</div>
                                    <div class="text-xs text-slate-500 uppercase font-medium mt-0.5">{{ $order->payment_method }}</div>
                                </td>

                                <!-- Collectable -->
                                <td class="px-3 py-4 whitespace-nowrap">
                                    <span class="font-medium text-slate-800">TK {{ $order->payment_status === 'paid' ? '0' : number_format($order->total_amount, 0) }}</span>
                                </td>

                                <!-- Status -->
                                <td class="px-3 py-4 whitespace-nowrap">
                                    <span class="px-3 py-1.5 rounded text-white text-xs font-bold shadow-sm inline-block min-w-[80px] text-center
                                        {{ match($order->status) {
                                            'pending' => 'bg-blue-500 hover:bg-blue-600',
                                            'processing' => 'bg-indigo-500 hover:bg-indigo-600',
                                            'on_delivery' => 'bg-purple-500 hover:bg-purple-600',
                                            'delivered' => 'bg-emerald-500 hover:bg-emerald-600',
                                            'cancelled' => 'bg-red-500 hover:bg-red-600',
                                            'hold' => 'bg-orange-400 hover:bg-orange-500',
                                            default => 'bg-slate-400'
                                        } }}">
                                        {{ $order->status === 'processing' ? 'Confirm' : ucfirst(str_replace('_', ' ', $order->status)) }}
                                    </span>
                                </td>

                                <!-- Courier -->
                                <td class="px-3 py-4 whitespace-nowrap">
                                    @if($order->courier_tracking_id)
                                        <div class="flex flex-col gap-1">
                                            <div class="flex items-center gap-2">
                                                <span class="text-xs font-bold text-slate-700">{{ $order->courier_name }}</span>
                                                <a href="{{ route('admin.orders.check_courier_status', $order->id) }}" class="text-blue-500 hover:text-blue-700 transition-colors" title="Check Status">
                                                    <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path></svg>
                                                </a>
                                            </div>
                                            @if($order->courier_consignment_id)
                    <span class="text-xs font-bold text-teal-600" title="Consignment ID">#{{ $order->courier_consignment_id }}</span>
                @elseif($order->courier_tracking_id && is_numeric($order->courier_tracking_id))
                    <span class="text-xs font-bold text-teal-600" title="Consignment ID">#{{ $order->courier_tracking_id }}</span>
                @endif
                                            <span class="text-[10px] px-1.5 py-0.5 rounded-full bg-slate-100 text-slate-600 w-fit">{{ ucfirst($order->courier_status) }}</span>
                                        </div>
                                    @else
                                        <span class="text-slate-300 text-xs">--</span>
                                    @endif
                                </td>

                                <!-- Note -->
                                <td class="px-3 py-4 whitespace-nowrap">
                                    <div class="flex flex-col gap-1.5">
                                        <div class="text-xs text-slate-700 font-medium">CN: <span class="text-slate-500 font-normal">--</span></div>
                                        <button class="text-xs text-blue-600 hover:text-blue-800 hover:underline text-left">Add Office Note</button>
                                        <span class="px-2 py-0.5 bg-slate-100 text-slate-500 rounded text-[10px] w-fit border border-slate-200">No Logs</span>
                                    </div>
                                </td>

                                <!-- Employee -->
                                <td class="px-3 py-4 whitespace-nowrap text-center">
                                    <div class="flex flex-col items-center gap-1">
                                        <div class="w-8 h-8 rounded-full bg-blue-50 flex items-center justify-center text-blue-600 border border-blue-100">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
                                        </div>
                                        <span class="text-[10px] text-slate-500 font-medium">Admin</span>
                                    </div>
                                </td>

                                <!-- Blocklist -->
                                <td class="px-3 py-4 whitespace-nowrap">
                                    <button class="px-2.5 py-1 bg-red-50 text-red-500 rounded border border-red-100 hover:bg-red-100 transition-colors text-xs flex items-center gap-1 font-medium">
                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"></path></svg>
                                        Block
                                    </button>
                                </td>

                                <!-- Action -->
                                <td class="px-3 py-4 whitespace-nowrap text-right">
                                    <div class="flex justify-end gap-2">
                                        <a href="{{ route('admin.orders.show', ['order' => $order->id, 'origin' => 'incomplete']) }}" class="p-1.5 text-blue-600 hover:bg-blue-50 rounded transition-colors" title="Edit/View">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg>
                                        </a>
                                        <form action="{{ route('admin.orders.destroy', $order->id) }}" method="POST" onsubmit="return confirm('Delete order?');" class="inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="p-1.5 text-red-500 hover:bg-red-50 rounded transition-colors" title="Delete">
                                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="13" class="px-6 py-12 text-center text-slate-500">
                                    <div class="flex flex-col items-center justify-center">
                                        <div class="w-20 h-20 bg-slate-50 rounded-full flex items-center justify-center mb-4">
                                            <svg class="w-10 h-10 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"></path></svg>
                                        </div>
                                        <p class="text-base font-medium text-slate-600">No incomplete orders found!</p>
                                        <p class="text-sm text-slate-400 mt-1">Try adjusting your filters or search terms.</p>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                @if($orders->hasPages())
                <div class="px-6 py-4 border-t border-slate-100 bg-slate-50">
                    {{ $orders->appends(request()->query())->links() }}
                </div>
                @endif
            </div>
            
            <div class="mt-8 text-center text-slate-400 text-sm">
                Showing {{ $orders->count() }} of {{ $orders->total() }} results
            </div>
        </div>
    @else
    <div class="p-2 md:p-6 bg-slate-50 min-h-screen">
        
        <!-- Toolbar -->
        <div class="bg-white p-3 rounded-2xl shadow-lg border border-slate-100 mb-4 md:mb-8 flex flex-col xl:flex-row items-center justify-between gap-3 transition-all duration-300 hover:shadow-xl">
            
            <!-- Left: Search Form -->
            <div class="flex items-center gap-2 w-full xl:w-auto">
                <form action="{{ route('admin.orders.index') }}" method="GET" class="flex items-center w-full relative" id="search-form">
                    @if(request('status')) <input type="hidden" name="status" value="{{ request('status') }}"> @endif
                    
                    <div class="relative w-full xl:w-64 group">
                        <div class="absolute inset-y-0 left-0 pl-2.5 flex items-center pointer-events-none">
                            <svg class="w-4 h-4 text-gray-400 group-focus-within:text-blue-500 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
                        </div>
                        <input type="text" name="search" value="{{ request('search') }}" placeholder="Search ID, Name..." class="bg-slate-50 border border-slate-200 text-slate-700 text-xs rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 block w-full pl-8 p-2 transition-all duration-200 shadow-sm hover:bg-white">
                    </div>
                </form>
            </div>

            <!-- Middle: Filters -->
            <div class="flex flex-col sm:flex-row flex-wrap items-center gap-2 w-full xl:w-auto justify-center bg-slate-50 p-1.5 rounded-lg border border-slate-100">
                <select class="w-full sm:w-auto bg-white border border-slate-200 text-slate-700 text-xs rounded-md focus:ring-blue-500 focus:border-blue-500 block p-2 min-w-[120px] shadow-sm hover:border-blue-300 transition-colors cursor-pointer">
                    <option>ALL Employees</option>
                </select>

                <!-- Date Filter -->
                <div class="w-full sm:w-64">
                    <x-date-range-picker 
                        startDate="{{ $startDate }}" 
                        endDate="{{ $endDate }}" 
                        formId="search-form"
                    />
                </div>
            </div>

            <!-- Right: Actions & Icons -->
            <div class="flex flex-col sm:flex-row flex-wrap items-center justify-end gap-3 w-full xl:w-auto">
                <!-- Actions -->
                <div class="flex flex-wrap justify-center sm:justify-end items-center gap-2 w-full sm:w-auto">
                    <select id="bulk-status" class="w-full sm:w-auto bg-white border border-slate-200 text-slate-700 text-xs rounded-md focus:ring-indigo-500 focus:border-indigo-500 block p-2 min-w-[120px] shadow-sm hover:border-indigo-300 transition-colors cursor-pointer">
                        <option value="">Change Status</option>
                        <option value="pending">Pending</option>
                        <option value="processing">Confirm</option>
                        <option value="shipped">Ready to Delivery</option>
                        <option value="on_delivery">On Delivery</option>
                        <option value="delivered">Delivered</option>
                        <option value="cancelled">Cancelled</option>
                        <option value="hold">On Hold</option>
                        <option value="returned">Returned</option>
                    </select>
                    
                    <select class="w-full sm:w-auto bg-white border border-slate-200 text-slate-700 text-xs rounded-md focus:ring-indigo-500 focus:border-indigo-500 block p-2 shadow-sm hover:border-indigo-300 transition-colors cursor-pointer">
                        <option>Employee</option>
                    </select>

                    <select id="bulk-courier" class="w-full sm:w-auto bg-white border border-slate-200 text-slate-700 text-xs rounded-md focus:ring-indigo-500 focus:border-indigo-500 block p-2 shadow-sm hover:border-indigo-300 transition-colors cursor-pointer">
                        <option value="">Courier</option>
                        <option value="steadfast">Steadfast</option>
                        <option value="check_status">Check Status</option>
                    </select>

                    <button type="button" id="bulk-update-btn" class="w-full sm:w-auto bg-gradient-to-r from-indigo-500 to-purple-600 hover:from-indigo-600 hover:to-purple-700 text-white text-xs font-medium py-2 px-4 rounded-md transition-all duration-200 shadow-md hover:shadow-lg transform hover:-translate-y-0.5 active:translate-y-0">
                        Update
                    </button>

                    <div class="flex gap-1.5 w-full sm:w-auto justify-center">
                        <button type="button" class="flex-1 sm:flex-none justify-center text-slate-400 hover:text-blue-600 bg-white p-1.5 rounded-md border border-slate-200 shadow-sm hover:shadow-md transition-all flex items-center">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                        </button>
                        
                        <button type="button" class="flex-1 sm:flex-none justify-center text-slate-400 hover:text-blue-600 bg-white p-1.5 rounded-md border border-slate-200 shadow-sm hover:shadow-md transition-all flex items-center">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path></svg>
                        </button>
                    </div>
                </div>

                <!-- Icons -->
                <div class="flex items-center justify-center gap-2 pl-0 sm:pl-3 border-l-0 sm:border-l border-slate-200 w-full sm:w-auto mt-2 sm:mt-0">
                    <a href="{{ route('admin.orders.index', array_merge(request()->query(), ['status' => 'incomplete'])) }}" class="relative bg-emerald-500 hover:bg-emerald-600 text-white p-2 rounded-lg shadow-md hover:shadow-lg transition-all cursor-pointer group">
                        <svg class="w-5 h-5 transform group-hover:scale-110 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                        <span class="absolute -top-1.5 -right-1.5 bg-red-500 text-white text-[9px] font-bold px-1 py-0.5 rounded-full border border-white shadow-sm">{{ $incompleteCount ?? 0 }}</span>
                    </a>
                    <div class="bg-amber-400 hover:bg-amber-500 text-white p-2 rounded-lg shadow-md hover:shadow-lg transition-all cursor-pointer group">
                        <svg class="w-5 h-5 transform group-hover:scale-110 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path></svg>
                    </div>
                    <a href="{{ route('admin.orders.index') }}" class="bg-blue-500 hover:bg-blue-600 text-white p-2 rounded-lg shadow-md hover:shadow-lg transition-all cursor-pointer group">
                        <svg class="w-5 h-5 transform group-hover:rotate-180 transition-transform duration-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path></svg>
                    </a>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-2xl shadow-xl border border-slate-100 overflow-hidden">
            <!-- Tabs -->
            <div class="border-b border-slate-100 bg-white p-2">
                <div class="flex items-center gap-3 overflow-x-auto pb-2 scrollbar-hide flex-nowrap">
                    @php
                        $tabs = [
                            'all' => ['label' => 'All Orders', 'color' => 'blue'],
                            'pending' => ['label' => 'Pending', 'color' => 'amber'],
                            'processing' => ['label' => 'Confirm', 'color' => 'indigo'],
                            'shipped' => ['label' => 'Ready to Delivery', 'color' => 'cyan'],
                            'delivered' => ['label' => 'Delivered', 'color' => 'emerald'],
                            'cancelled' => ['label' => 'Cancelled', 'color' => 'red'],
                            'hold' => ['label' => 'On Hold', 'color' => 'orange'],
                            'unpaid' => ['label' => 'Unpaid', 'color' => 'slate'],
                            'ship_later' => ['label' => 'Ship Later', 'color' => 'cyan'],
                            'returned' => ['label' => 'Returned', 'color' => 'pink'],
                            'lost' => ['label' => 'Lost', 'color' => 'rose']
                        ];
                    @endphp
                    
                    @foreach($tabs as $key => $tab)
                        @php
                            $styleMap = [
                                'blue' => [
                                    'active' => 'bg-blue-600 border-blue-700 text-white shadow-md shadow-blue-200',
                                    'inactive' => 'bg-blue-50 border-blue-100 text-slate-700 hover:bg-blue-100 hover:border-blue-200',
                                    'badge_active' => 'bg-white text-blue-700',
                                    'badge_inactive' => 'bg-blue-100 text-blue-700 group-hover:bg-blue-200'
                                ],
                                'amber' => [
                                    'active' => 'bg-amber-500 border-amber-600 text-white shadow-md shadow-amber-200',
                                    'inactive' => 'bg-amber-50 border-amber-100 text-slate-700 hover:bg-amber-100 hover:border-amber-200',
                                    'badge_active' => 'bg-white text-amber-600',
                                    'badge_inactive' => 'bg-amber-100 text-amber-700 group-hover:bg-amber-200'
                                ],
                                'indigo' => [
                                    'active' => 'bg-indigo-600 border-indigo-700 text-white shadow-md shadow-indigo-200',
                                    'inactive' => 'bg-indigo-50 border-indigo-100 text-slate-700 hover:bg-indigo-100 hover:border-indigo-200',
                                    'badge_active' => 'bg-white text-indigo-700',
                                    'badge_inactive' => 'bg-indigo-100 text-indigo-700 group-hover:bg-indigo-200'
                                ],
                                'purple' => [
                                    'active' => 'bg-purple-600 border-purple-700 text-white shadow-md shadow-purple-200',
                                    'inactive' => 'bg-purple-50 border-purple-100 text-slate-700 hover:bg-purple-100 hover:border-purple-200',
                                    'badge_active' => 'bg-white text-purple-700',
                                    'badge_inactive' => 'bg-purple-100 text-purple-700 group-hover:bg-purple-200'
                                ],
                                'emerald' => [
                                    'active' => 'bg-emerald-600 border-emerald-700 text-white shadow-md shadow-emerald-200',
                                    'inactive' => 'bg-emerald-50 border-emerald-100 text-slate-700 hover:bg-emerald-100 hover:border-emerald-200',
                                    'badge_active' => 'bg-white text-emerald-700',
                                    'badge_inactive' => 'bg-emerald-100 text-emerald-700 group-hover:bg-emerald-200'
                                ],
                                'red' => [
                                    'active' => 'bg-red-600 border-red-700 text-white shadow-md shadow-red-200',
                                    'inactive' => 'bg-red-50 border-red-100 text-slate-700 hover:bg-red-100 hover:border-red-200',
                                    'badge_active' => 'bg-white text-red-700',
                                    'badge_inactive' => 'bg-red-100 text-red-700 group-hover:bg-red-200'
                                ],
                                'orange' => [
                                    'active' => 'bg-orange-600 border-orange-700 text-white shadow-md shadow-orange-200',
                                    'inactive' => 'bg-orange-50 border-orange-100 text-slate-700 hover:bg-orange-100 hover:border-orange-200',
                                    'badge_active' => 'bg-white text-orange-700',
                                    'badge_inactive' => 'bg-orange-100 text-orange-700 group-hover:bg-orange-200'
                                ],
                                'slate' => [
                                    'active' => 'bg-slate-600 border-slate-700 text-white shadow-md shadow-slate-200',
                                    'inactive' => 'bg-slate-50 border-slate-100 text-slate-700 hover:bg-slate-100 hover:border-slate-200',
                                    'badge_active' => 'bg-white text-slate-700',
                                    'badge_inactive' => 'bg-slate-200 text-slate-700 group-hover:bg-slate-300'
                                ],
                                'cyan' => [
                                    'active' => 'bg-cyan-600 border-cyan-700 text-white shadow-md shadow-cyan-200',
                                    'inactive' => 'bg-cyan-50 border-cyan-100 text-slate-700 hover:bg-cyan-100 hover:border-cyan-200',
                                    'badge_active' => 'bg-white text-cyan-700',
                                    'badge_inactive' => 'bg-cyan-100 text-cyan-700 group-hover:bg-cyan-200'
                                ],
                                'pink' => [
                                    'active' => 'bg-pink-600 border-pink-700 text-white shadow-md shadow-pink-200',
                                    'inactive' => 'bg-pink-50 border-pink-100 text-slate-700 hover:bg-pink-100 hover:border-pink-200',
                                    'badge_active' => 'bg-white text-pink-700',
                                    'badge_inactive' => 'bg-pink-100 text-pink-700 group-hover:bg-pink-200'
                                ],
                                'rose' => [
                                    'active' => 'bg-rose-600 border-rose-700 text-white shadow-md shadow-rose-200',
                                    'inactive' => 'bg-rose-50 border-rose-100 text-slate-700 hover:bg-rose-100 hover:border-rose-200',
                                    'badge_active' => 'bg-white text-rose-700',
                                    'badge_inactive' => 'bg-rose-100 text-rose-700 group-hover:bg-rose-200'
                                ],
                            ];

                            $isActive = (request('status') === $key || (request('status') === null && $key === 'all'));
                            $color = $tab['color'];
                            $styles = $styleMap[$color];
                            
                            // Card Styles
                            $baseClasses = "flex items-center justify-between px-3 py-2 rounded-lg border transition-all duration-200 group relative flex-shrink-0 cursor-pointer select-none";
                            // Active
                            $activeClasses = $styles['active'] . " min-w-[180px] ring-0"; 
                            // Inactive
                            $inactiveClasses = $styles['inactive'] . " min-w-[140px]";
                        @endphp
                        <a href="{{ route('admin.orders.index', array_merge(request()->query(), ['status' => $key === 'all' ? null : $key])) }}" 
                           class="{{ $baseClasses }} {{ $isActive ? $activeClasses : $inactiveClasses }}">
                            
                            <!-- Status Label -->
                            <span class="text-xs font-bold uppercase tracking-wide z-10 truncate mr-3">{{ $tab['label'] }}</span>
                            
                            <div class="flex items-center gap-2 z-10">
                                <!-- Count Badge -->
                                <span class="px-2 py-0.5 rounded-md text-[10px] font-bold
                                             {{ $isActive ? $styles['badge_active'] : $styles['badge_inactive'] }}">
                                    {{ $counts[$key] ?? 0 }}
                                </span>
    
                                <!-- Amount (Active Only) -->
                                @if($isActive)
                                    <span class="text-[10px] font-bold opacity-90 whitespace-nowrap">
                                        {{ number_format($amounts[$key] ?? 0, 0) }}
                                    </span>
                                @endif
                            </div>
                        </a>
                    @endforeach
                </div>
            </div>

            <!-- Table -->
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-slate-100 text-sm">
                    <thead class="bg-blue-50 text-slate-700">
                        <tr>
                            <th scope="col" class="px-3 py-3 text-left w-4">
                                <input type="checkbox" id="select-all" class="rounded border-slate-300 text-blue-600 focus:ring-blue-500 transition-colors cursor-pointer">
                            </th>
                            <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Order ID</th>
                            <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Customer Info</th>
                            <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Product</th>
                            <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Total Bill</th>
                            <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Payment Info <span class="text-slate-400 font-normal ml-0.5" title="Payment Details">ⓘ</span></th>
                            <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Collectable</th>
                            <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Status</th>
                            <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Courier</th>
                            <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Note <span class="text-slate-400 font-normal ml-0.5" title="Internal Notes">ⓘ</span></th>
                            <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Employee</th>
                            <th scope="col" class="px-3 py-3 text-left text-xs font-bold uppercase tracking-wider">Blocklist</th>
                            <th scope="col" class="px-3 py-3 text-right text-xs font-bold uppercase tracking-wider">Action</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-slate-100">
                        @forelse($orders as $order)
                        <tr class="hover:bg-slate-50 transition-colors group">
                            <td class="px-3 py-4 whitespace-nowrap">
                                <input type="checkbox" name="ids[]" value="{{ $order->id }}" data-status="{{ $order->status }}" class="order-checkbox rounded border-slate-300 text-blue-600 focus:ring-blue-500 transition-colors cursor-pointer">
                            </td>
                            
                            <!-- Order ID -->
                            <td class="px-3 py-4 whitespace-nowrap">
                                <div class="font-bold text-slate-800">{{ $order->order_number }}</div>
                                <div class="text-xs text-slate-500 mt-0.5">{{ $order->created_at->format('d M Y') }} • {{ $order->created_at->format('h:i A') }}</div>

                                @if($order->is_from_incomplete || \Illuminate\Support\Str::startsWith($order->order_number, 'INC-'))
                                    <div class="mt-1">
                                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-[10px] font-medium bg-amber-500 text-white">
                                            From Incomplete
                                        </span>
                                    </div>
                                @endif

                                @if($order->source === 'manual')
                                    <div class="mt-1">
                                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-[10px] font-medium bg-pink-500 text-white">
                                            Manual Order
                                        </span>
                                    </div>
                                @elseif($order->source === 'landing_page')
                                    <div class="mt-1">
                                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-[10px] font-medium bg-blue-600 text-white">
                                            Landing page
                                        </span>
                                    </div>
                                @endif
                            </td>

                            <!-- Customer Info -->
                            <td class="px-3 py-4 max-w-[240px]">
                                <div class="space-y-1.5">
                                    <div class="flex items-center gap-1.5 group">
                                        <svg class="w-3.5 h-3.5 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
                                        <a href="tel:{{ $order->phone }}" class="text-slate-800 font-semibold hover:text-blue-600 transition-colors">{{ $order->phone }}</a>
                                        <span x-data='fraudCheck({{ json_encode($order->phone, JSON_HEX_APOS) }}, {{ $order->fraud_score !== null ? $order->fraud_score : "null" }}, {{ $order->fraud_data !== null ? json_encode($order->fraud_data, JSON_HEX_APOS) : "null" }})' class="inline-flex items-center opacity-60 group-hover:opacity-100 transition-opacity">
                                            <template x-if="!checked && !percentage">
                                                <button @click.prevent="check()" class="ml-1 text-[10px] bg-slate-100 hover:bg-slate-200 text-slate-600 px-1.5 py-0.5 rounded cursor-pointer transition-colors" title="Check Fraud Status">
                                                    <span x-show="!loading">Check</span>
                                                    <svg x-show="loading" class="animate-spin h-3 w-3 text-slate-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                                    </svg>
                                                </button>
                                            </template>
                                            <template x-if="checked || percentage !== null">
                                                <button @click.prevent="showDetails()" class="ml-1 text-[10px] px-1.5 py-0.5 rounded font-bold cursor-pointer transition-colors" :class="getBadgeClass()">
                                                    <span x-text="percentage + '%'"></span>
                                                </button>
                                            </template>
                                        </span>
                                    </div>
                                    <div class="flex items-center gap-1.5 text-slate-600 text-xs">
                                        <svg class="w-3.5 h-3.5 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
                                        <span class="truncate">{{ $order->first_name }} {{ $order->last_name }}</span>
                                    </div>
                                    <div class="flex items-start gap-1.5 text-slate-500 text-xs max-w-[240px]">
                                        <svg class="w-3.5 h-3.5 text-slate-400 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                                        <span title="{{ $order->address }}" style="display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;overflow:hidden;line-height:1.25">{{ $order->address }}</span>
                                    </div>
                                </div>
                            </td>

                            <!-- Product -->
                            <td class="px-3 py-4 cursor-pointer hover:bg-slate-100 transition-colors rounded-lg" @click="openItemsModal({{ json_encode($order->items->map(function($item) {
                                return [
                                    'name' => $item->product_name,
                                    'image' => $item->product && $item->product->thumbnail ? Storage::url($item->product->thumbnail) : null,
                                    'quantity' => $item->quantity,
                                    'price' => $item->price,
                                    'total' => $item->quantity * $item->price,
                                    'variation' => trim(($item->color ? $item->color->name : '') . ' ' . ($item->size ? $item->size->name : ''))
                                ];
                            })) }})">
                                <div class="flex -space-x-3 hover:space-x-1 transition-all duration-300">
                                    @foreach($order->items->take(3) as $item)
                                        @if($item->product && $item->product->thumbnail)
                                            <div class="relative group/img">
                                                <img class="inline-block h-10 w-10 rounded-full ring-2 ring-white object-cover shadow-sm" src="{{ Storage::url($item->product->thumbnail) }}" alt="{{ $item->product_name }}">
                                                <div class="absolute bottom-full left-1/2 transform -translate-x-1/2 mb-2 px-2 py-1 text-xs text-white bg-slate-800 rounded opacity-0 group-hover/img:opacity-100 transition-opacity whitespace-nowrap pointer-events-none z-20">{{ $item->product_name }}</div>
                                            </div>
                                        @else
                                            <div class="inline-block h-10 w-10 rounded-full ring-2 ring-white bg-slate-100 flex items-center justify-center text-xs text-slate-500 shadow-sm" title="{{ $item->product_name }}">{{ substr($item->product_name, 0, 1) }}</div>
                                        @endif
                                    @endforeach
                                    @if($order->items->count() > 3)
                                        <div class="inline-block h-10 w-10 rounded-full ring-2 ring-white bg-slate-50 flex items-center justify-center text-xs font-bold text-slate-500 shadow-sm">+{{ $order->items->count() - 3 }}</div>
                                    @endif
                                </div>
                            </td>

                            <!-- Total Bill -->
                            <td class="px-3 py-4 whitespace-nowrap">
                                <span class="font-bold text-slate-800">TK {{ number_format($order->total_amount, 0) }}</span>
                            </td>

                            <!-- Payment Info -->
                            <td class="px-3 py-4 whitespace-nowrap">
                                <div class="font-bold text-slate-800">Paid: {{ $order->payment_status === 'paid' ? number_format($order->total_amount, 0) : '0' }} TK</div>
                                <div class="text-xs text-slate-500 uppercase font-medium mt-0.5">{{ $order->payment_method }}</div>
                            </td>

                            <!-- Collectable -->
                            <td class="px-3 py-4 whitespace-nowrap">
                                <span class="font-medium text-slate-800">TK {{ $order->payment_status === 'paid' ? '0' : number_format($order->total_amount, 0) }}</span>
                            </td>

                            <!-- Status -->
                            <td class="px-3 py-4 whitespace-nowrap">
                                <span class="px-3 py-1.5 rounded text-white text-xs font-bold shadow-sm inline-block min-w-[80px] text-center
                                    {{ match($order->status) {
                                        'pending' => 'bg-blue-500 hover:bg-blue-600',
                                        'processing' => 'bg-indigo-500 hover:bg-indigo-600',
                                        'on_delivery' => 'bg-purple-500 hover:bg-purple-600',
                                        'delivered' => 'bg-emerald-500 hover:bg-emerald-600',
                                        'cancelled' => 'bg-red-500 hover:bg-red-600',
                                        'hold' => 'bg-orange-400 hover:bg-orange-500',
                                        default => 'bg-slate-400'
                                    } }}">
                                    {{ $order->status === 'processing' ? 'Confirm' : ucfirst(str_replace('_', ' ', $order->status)) }}
                                </span>
                            </td>

                            <!-- Courier -->
                            <td class="px-3 py-4 whitespace-nowrap">
                                @if($order->courier_tracking_id || $order->courier_consignment_id)
                                    <div class="flex flex-col gap-1">
                                        <div class="flex items-center gap-2">
                                            <span class="text-xs font-bold text-slate-700">{{ $order->courier_name }}</span>
                                            <a href="{{ route('admin.orders.check_courier_status', $order->id) }}" class="text-blue-500 hover:text-blue-700 transition-colors" title="Check Status">
                                                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path></svg>
                                            </a>
                                        </div>
                                        @if($order->courier_consignment_id)
                                            <span class="text-xs font-bold text-teal-600" title="Consignment ID">#{{ $order->courier_consignment_id }}</span>
                                        @elseif($order->courier_tracking_id && is_numeric($order->courier_tracking_id))
                                            <span class="text-xs font-bold text-teal-600" title="Consignment ID">#{{ $order->courier_tracking_id }}</span>
                                        @endif
                                        <span class="text-[10px] px-1.5 py-0.5 rounded-full bg-slate-100 text-slate-600 w-fit">{{ ucfirst($order->courier_status) }}</span>
                                    </div>
                                @else
                                    <span class="text-slate-300 text-xs">--</span>
                                @endif
                            </td>

                            <!-- Note -->
                            <td class="px-3 py-4 whitespace-nowrap">
                                <div class="flex flex-col gap-1.5">
                                    <div class="text-xs text-slate-700 font-medium">CN: <span class="text-slate-500 font-normal">--</span></div>
                                    <button class="text-xs text-blue-600 hover:text-blue-800 hover:underline text-left">Add Office Note</button>
                                    <span class="px-2 py-0.5 bg-slate-100 text-slate-500 rounded text-[10px] w-fit border border-slate-200">No Logs</span>
                                </div>
                            </td>

                            <!-- Employee -->
                            <td class="px-3 py-4 whitespace-nowrap text-center">
                                <div class="flex flex-col items-center gap-1">
                                    <div class="w-8 h-8 rounded-full bg-blue-50 flex items-center justify-center text-blue-600 border border-blue-100">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
                                    </div>
                                    <span class="text-[10px] text-slate-500 font-medium">Admin</span>
                                </div>
                            </td>

                            <!-- Blocklist -->
                            <td class="px-3 py-4 whitespace-nowrap">
                                <button class="px-2.5 py-1 bg-red-50 text-red-500 rounded border border-red-100 hover:bg-red-100 transition-colors text-xs flex items-center gap-1 font-medium">
                                    <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"></path></svg>
                                    Block
                                </button>
                            </td>

                            <!-- Action -->
                            <td class="px-3 py-4 whitespace-nowrap text-right">
                                <div class="flex justify-end gap-2">
                                    <a href="{{ route('admin.orders.show', ['order' => $order->id, 'origin' => 'complete']) }}" class="p-1.5 text-blue-600 hover:bg-blue-50 rounded transition-colors" title="Edit/View">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg>
                                    </a>
                                    <form action="{{ route('admin.orders.destroy', $order->id) }}" method="POST" onsubmit="return confirm('Delete order?');" class="inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="p-1.5 text-red-500 hover:bg-red-50 rounded transition-colors" title="Delete">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="13" class="px-6 py-12 text-center text-slate-500">
                                <div class="flex flex-col items-center justify-center">
                                    <div class="bg-slate-100 p-6 rounded-full mb-4 shadow-inner">
                                        <svg class="w-12 h-12 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path></svg>
                                    </div>
                                    <p class="text-xl font-bold text-slate-800">No orders found</p>
                                    <p class="text-sm text-slate-500 mt-2 max-w-sm">No orders matched your search criteria. Try adjusting your filters or search term.</p>
                                    @if(request()->anyFilled(['search', 'start_date', 'end_date', 'status']))
                                    <a href="{{ route('admin.orders.index') }}" class="mt-6 inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-all">
                                        Clear all filters
                                    </a>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            @if($orders->hasPages())
            <div class="px-6 py-4 border-t border-slate-100 bg-slate-50/50">
                {{ $orders->appends(request()->query())->links() }}
            </div>
            @endif
        </div>
    
    @endif

    <!-- Product Details Modal (New Design) -->
    <div x-show="showItemsModal" 
         class="fixed inset-0 z-50 overflow-y-auto" 
         style="display: none;"
         x-transition:enter="ease-out duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="ease-in duration-200"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0">
        
        <!-- Blurred Backdrop -->
        <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity backdrop-blur-sm" @click="showItemsModal = false"></div>

        <!-- Modal Panel -->
        <div class="flex min-h-screen items-center justify-center p-4 text-center sm:p-0">
            <div class="relative transform overflow-hidden rounded-2xl bg-white text-left shadow-2xl transition-all sm:my-8 sm:w-full sm:max-w-4xl"
                 @click.stop>
                 
                 <!-- Close Button -->
                 <div class="absolute right-4 top-4 z-20">
                     <button @click="showItemsModal = false" class="rounded-full bg-white/80 p-2 text-gray-500 hover:bg-red-50 hover:text-red-600 shadow-sm transition-colors border border-transparent hover:border-red-100">
                         <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor">
                             <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                         </svg>
                     </button>
                 </div>

                 <!-- Carousel Content -->
                 <div x-data="{ activeIndex: 0 }" class="flex flex-col md:flex-row min-h-[650px]">
                     <!-- Left: Image Slider -->
                     <div class="relative w-full md:w-1/2 bg-slate-50 flex flex-col border-b md:border-b-0 md:border-r border-slate-100">
                         <!-- Main Image Area -->
                         <div class="relative flex-1 flex items-center justify-center overflow-hidden p-8">
                             <template x-for="(item, index) in activeOrderItems" :key="index">
                                 <div x-show="activeIndex === index" 
                                      class="absolute inset-0 flex items-center justify-center p-8 transition-opacity duration-300"
                                      x-transition:enter="transition ease-out duration-300"
                                      x-transition:enter-start="opacity-0 transform scale-95"
                                      x-transition:enter-end="opacity-100 transform scale-100"
                                      x-transition:leave="transition ease-in duration-200"
                                      x-transition:leave-start="opacity-100 transform scale-100"
                                      x-transition:leave-end="opacity-0 transform scale-95">
                                     <img :src="item.image || 'https://via.placeholder.com/400?text=No+Image'" 
                                          :alt="item.name" 
                                          class="max-h-full max-w-full object-contain drop-shadow-xl rounded-lg">
                                 </div>
                             </template>
                             
                             <!-- Navigation Arrows -->
                             <div x-show="activeOrderItems.length > 1" class="absolute inset-x-0 top-1/2 -translate-y-1/2 flex justify-between px-4 pointer-events-none">
                                 <button @click="activeIndex = (activeIndex === 0) ? activeOrderItems.length - 1 : activeIndex - 1"
                                         class="pointer-events-auto rounded-full bg-white/90 p-3 text-slate-700 hover:bg-blue-600 hover:text-white shadow-lg transition-all transform hover:scale-110 border border-slate-100">
                                     <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="2.5" stroke="currentColor">
                                         <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5L8.25 12l7.5-7.5" />
                                     </svg>
                                 </button>
                                 <button @click="activeIndex = (activeIndex === activeOrderItems.length - 1) ? 0 : activeIndex + 1"
                                         class="pointer-events-auto rounded-full bg-white/90 p-3 text-slate-700 hover:bg-blue-600 hover:text-white shadow-lg transition-all transform hover:scale-110 border border-slate-100">
                                     <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="2.5" stroke="currentColor">
                                         <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 4.5l7.5 7.5-7.5 7.5" />
                                     </svg>
                                 </button>
                             </div>
                         </div>

                         <!-- Thumbnails Strip (New) -->
                         <div x-show="activeOrderItems.length > 1" class="h-24 bg-white border-t border-slate-200 p-4 flex items-center gap-3 overflow-x-auto justify-center">
                             <template x-for="(item, idx) in activeOrderItems" :key="idx">
                                 <button @click="activeIndex = idx" 
                                         class="relative h-16 w-16 rounded-lg overflow-hidden border-2 transition-all flex-shrink-0"
                                         :class="activeIndex === idx ? 'border-blue-600 ring-2 ring-blue-100' : 'border-slate-200 opacity-60 hover:opacity-100'">
                                     <img :src="item.image || 'https://via.placeholder.com/100?text=No+Img'" 
                                          class="h-full w-full object-cover">
                                 </button>
                             </template>
                         </div>
                     </div>

                     <!-- Right: Product Info -->
                     <div class="w-full md:w-1/2 p-8 md:p-10 flex flex-col justify-center bg-white relative">
                         <template x-for="(item, index) in activeOrderItems" :key="index">
                             <div x-show="activeIndex === index" class="flex flex-col h-full justify-center">
                                 <div class="mb-auto pt-4">
                                     <div class="flex items-center justify-between mb-4">
                                         <span class="inline-flex items-center px-3 py-1 rounded-full bg-blue-50 text-blue-600 text-xs font-bold uppercase tracking-wide">
                                             Product Details
                                         </span>
                                         <span class="text-xs font-medium text-slate-400" x-show="activeOrderItems.length > 1" x-text="'Item ' + (index + 1) + ' of ' + activeOrderItems.length"></span>
                                     </div>
                                     
                                     <h2 class="text-2xl md:text-3xl font-bold text-slate-800 leading-tight mb-3" x-text="item.name"></h2>
                                     
                                     <div x-show="item.variation" class="inline-block px-3 py-1.5 bg-slate-100 rounded-lg text-sm text-slate-600 font-medium mb-2 border border-slate-200">
                                         <span class="text-slate-400 mr-1">Variation:</span> <span x-text="item.variation"></span>
                                     </div>
                                 </div>

                                 <div class="space-y-6 my-8">
                                     <!-- Price Card -->
                                     <div class="bg-slate-50 rounded-2xl p-6 border border-slate-100 shadow-sm">
                                         <div class="flex items-center justify-between mb-4">
                                             <div class="flex flex-col">
                                                 <span class="text-xs text-slate-500 font-bold uppercase tracking-wider mb-1">Unit Price</span>
                                                 <span class="text-xl font-bold text-slate-700 font-mono" x-text="'TK ' + item.price"></span>
                                             </div>
                                             <div class="text-right">
                                                 <span class="text-xs text-slate-500 font-bold uppercase tracking-wider mb-1">Quantity</span>
                                                 <span class="text-xl font-bold text-slate-700 font-mono" x-text="'x' + item.quantity"></span>
                                             </div>
                                         </div>
                                         
                                         <div class="border-t border-slate-200 my-4 border-dashed"></div>
                                         
                                         <div class="flex justify-between items-end">
                                             <span class="text-sm font-bold text-slate-600 uppercase">Total Amount</span>
                                             <span class="text-3xl font-bold text-blue-600 font-mono" x-text="'TK ' + item.total"></span>
                                         </div>
                                     </div>
                                 </div>

                                 <!-- Pagination Dots (Fallback) -->
                                 <div class="mt-auto flex justify-center gap-2 md:hidden" x-show="activeOrderItems.length > 1">
                                     <template x-for="(item, idx) in activeOrderItems" :key="idx">
                                         <button @click="activeIndex = idx" 
                                                 class="h-2 rounded-full transition-all duration-300"
                                                 :class="activeIndex === idx ? 'w-8 bg-blue-600' : 'w-2 bg-slate-200 hover:bg-slate-300'">
                                         </button>
                                     </template>
                                 </div>
                             </div>
                         </template>
                     </div>
                 </div>
            </div>
        </div>
    </div>
    
    <!-- End Main x-data Scope -->
    </div>
    <!-- Fraud Check Modal -->
    <div x-data="{ 
        open: false, 
        data: null,
        localOrders: [],
        phone: '',
        percentage: 0,
        init() {
            // Modal Initialized
        }
    }" 
    @open-fraud-modal.window="
        data = $event.detail.data;
        localOrders = $event.detail.local_orders || [];
        phone = $event.detail.phone || '';
        percentage = $event.detail.percentage || 0;
        open = true;
    "
    x-show="open" 
    style="display: none;"
    class="fixed inset-0 z-50 overflow-y-auto" 
    aria-labelledby="modal-title" 
    role="dialog" 
    aria-modal="true">
        <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
            <div x-show="open" 
                 x-transition:enter="ease-out duration-300" 
                 x-transition:enter-start="opacity-0" 
                 x-transition:enter-end="opacity-100" 
                 x-transition:leave="ease-in duration-200" 
                 x-transition:leave-start="opacity-100" 
                 x-transition:leave-end="opacity-0" 
                 class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" 
                 @click="open = false"
                 aria-hidden="true"></div>

            <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

            <div x-show="open" 
                 x-transition:enter="ease-out duration-300" 
                 x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" 
                 x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100" 
                 x-transition:leave="ease-in duration-200" 
                 x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100" 
                 x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" 
                 class="inline-block align-bottom bg-white rounded-xl text-left overflow-hidden shadow-2xl transform transition-all sm:my-8 sm:align-middle sm:max-w-4xl sm:w-full">
                
                <div class="bg-white px-4 pb-4 pt-5 sm:p-6 sm:pb-4 relative">
                    <!-- Header -->
                    <div class="text-center mb-6">
                        <h3 class="text-2xl font-bold text-gray-900" id="modal-title">Fraud Tracker Report</h3>
                        <p class="text-lg text-green-600 font-medium mt-1">[ <span x-text="data?.mobile_number || phone"></span> ]</p>
                        <button @click="open = false" class="absolute top-4 right-4 text-green-600 hover:text-green-700 flex items-center gap-1 border border-green-200 rounded px-3 py-1 text-sm font-medium hover:bg-green-50 transition-colors">
                            <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                            Close
                        </button>
                    </div>

                    <!-- Status Banner -->
                    <div class="mb-8 text-center">
                        <div class="mb-2 text-sm font-medium text-gray-600" x-text="percentage >= 90 ? 'Customer is awesome' : (percentage >= 50 ? 'Average Customer' : 'High Risk Customer')"></div>
                        <div class="w-full bg-gray-100 rounded-full h-8 overflow-hidden relative max-w-2xl mx-auto shadow-inner border border-gray-200">
                            <div class="h-full flex items-center justify-center text-white font-bold text-sm transition-all duration-500 shadow-sm"
                                 :class="percentage >= 90 ? 'bg-green-600' : (percentage >= 50 ? 'bg-yellow-500' : 'bg-red-500')"
                                 :style="'width: ' + (percentage > 0 ? percentage : 100) + '%'">
                                 <span x-text="'Success Rate - ' + (percentage || 0) + '%'"></span>
                            </div>
                        </div>
                    </div>

                    <!-- Stats Cards -->
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8 max-w-4xl mx-auto">
                        <div class="bg-blue-100 p-6 rounded-lg text-center shadow-sm border border-blue-200">
                            <div class="text-3xl font-bold text-gray-800" x-text="data?.total_parcels || 0"></div>
                            <div class="text-sm font-semibold text-gray-600 mt-1">Total</div>
                        </div>
                        <div class="bg-green-100 p-6 rounded-lg text-center shadow-sm border border-green-200">
                            <div class="text-3xl font-bold text-gray-800" x-text="data?.total_delivered || 0"></div>
                            <div class="text-sm font-semibold text-gray-600 mt-1">Delivered</div>
                        </div>
                        <div class="bg-red-100 p-6 rounded-lg text-center shadow-sm border border-red-200">
                            <div class="text-3xl font-bold text-gray-800" x-text="data?.total_cancel || 0"></div>
                            <div class="text-sm font-semibold text-gray-600 mt-1">Returned</div>
                        </div>
                    </div>

                    <!-- Courier Table -->
                    <div class="mb-8 max-w-4xl mx-auto bg-gray-50 rounded-lg overflow-hidden border border-gray-200 shadow-sm">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th scope="col" class="px-6 py-3 text-center text-xs font-bold text-gray-700 uppercase tracking-wider">Courier</th>
                                    <th scope="col" class="px-6 py-3 text-center text-xs font-bold text-gray-700 uppercase tracking-wider">Total</th>
                                    <th scope="col" class="px-6 py-3 text-center text-xs font-bold text-gray-700 uppercase tracking-wider">Delivered</th>
                                    <th scope="col" class="px-6 py-3 text-center text-xs font-bold text-gray-700 uppercase tracking-wider">Returned</th>
                                    <th scope="col" class="px-6 py-3 text-center text-xs font-bold text-gray-700 uppercase tracking-wider">Success Ratio</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <template x-for="(courierData, courierName) in data?.apis" :key="courierName">
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-bold text-gray-800 uppercase text-center">
                                            <span x-text="courierName"></span>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600 text-center" x-text="courierData.total_parcels"></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600 text-center" x-text="courierData.total_delivered_parcels"></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600 text-center" x-text="courierData.total_cancelled_parcels"></td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600 text-center">
                                            <span x-text="Math.round((courierData.total_delivered_parcels / courierData.total_parcels) * 100) + '%'"></span>
                                        </td>
                                    </tr>
                                </template>
                                <tr x-show="!data?.apis || Object.keys(data.apis).length === 0">
                                    <td colspan="5" class="px-6 py-4 text-center text-sm text-gray-500">No external courier data available</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- Customer Order History Title -->
                    <div class="text-center mb-4">
                        <h4 class="text-lg font-medium text-gray-800">Customer Order History</h4>
                    </div>

                    <!-- Order History Table -->
                    <div class="max-w-4xl mx-auto bg-white rounded-lg border border-gray-200 overflow-hidden mb-6 shadow-sm">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-100">
                                <tr>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-bold text-gray-700 uppercase tracking-wider">Product Id</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-bold text-gray-700 uppercase tracking-wider">Product Info</th>
                                    <th scope="col" class="px-6 py-3 text-right text-xs font-bold text-gray-700 uppercase tracking-wider">Status</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <template x-for="order in localOrders" :key="order.id">
                                    <tr class="hover:bg-gray-50 border-b last:border-0 border-gray-100">
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600 align-middle" x-text="order.order_number"></td>
                                        <td class="px-6 py-4 align-middle">
                                            <div class="flex flex-col gap-3">
                                                <template x-for="item in order.items">
                                                    <div class="flex items-center gap-4">
                                                        <div class="h-14 w-14 flex-shrink-0 overflow-hidden rounded-md border border-gray-200">
                                                            <template x-if="item.image">
                                                                <img :src="item.image" :alt="item.product_name" class="h-full w-full object-cover object-center">
                                                            </template>
                                                            <template x-if="!item.image">
                                                                <div class="h-full w-full bg-gray-100 flex items-center justify-center text-gray-400 text-xs">No Img</div>
                                                            </template>
                                                        </div>
                                                        <div>
                                                            <h5 class="text-sm font-medium text-gray-900" x-text="item.product_name"></h5>
                                                            <div class="flex gap-4 mt-0.5">
                                                                <p class="text-sm text-gray-500" x-text="item.price + 'TK'"></p>
                                                                <p class="text-sm text-gray-500" x-text="'Qty: ' + item.quantity"></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </template>
                                            </div>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium align-middle" x-text="order.status"></td>
                                    </tr>
                                </template>
                                <tr x-show="!localOrders || localOrders.length === 0">
                                    <td colspan="3" class="px-6 py-10 text-center text-sm text-gray-500">No previous orders found</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function fraudCheck(phone, storedScore = null, storedData = null) {
            return {
                loading: false,
                checked: storedScore !== null,
                data: storedData,
                localOrders: [],
                percentage: storedScore,
                
                check() {
                    this.loading = true;
                    // Use POST request as defined in routes
                    axios.post('{{ route("admin.api.fraud.check.json") }}', { phone: phone })
                        .then(res => {
                            if(res.data.success) {
                                this.data = res.data.data;
                                this.localOrders = res.data.local_orders || [];
                                this.percentage = res.data.percentage;
                                this.checked = true;
                                this.showDetails();
                            } else {
                                alert('Error: ' + (res.data.message || 'Failed to check'));
                            }
                        })
                        .catch(err => {
                            console.error(err);
                            alert('Failed to connect to server');
                        })
                        .finally(() => {
                            this.loading = false;
                        });
                },

                showDetails() {
                    // If we have stored data but no local orders, fetch them first
                    if (this.checked && (!this.localOrders || this.localOrders.length === 0)) {
                        this.loading = true;
                        // Use skip_external: true to avoid hitting API limit if we already have data
                        axios.post('{{ route("admin.api.fraud.check.json") }}', { 
                            phone: phone,
                            skip_external: true 
                        })
                        .then(res => {
                            if(res.data.success) {
                                this.data = res.data.data;
                                this.localOrders = res.data.local_orders || [];
                                this.percentage = res.data.percentage;
                                
                                window.dispatchEvent(new CustomEvent('open-fraud-modal', { 
                                    detail: { 
                                        data: this.data,
                                        local_orders: this.localOrders,
                                        phone: phone,
                                        percentage: this.percentage
                                    } 
                                }));
                            } else {
                                alert('Error: ' + (res.data.message || 'Failed to fetch details'));
                            }
                        })
                        .catch(err => {
                            console.error(err);
                            // If we fail to fetch local orders, still try to show what we have?
                            // But showDetails expects localOrders.
                            alert('Failed to fetch details');
                        })
                        .finally(() => {
                            this.loading = false;
                        });
                    } else {
                        // We already have everything, just open modal
                        window.dispatchEvent(new CustomEvent('open-fraud-modal', { 
                            detail: { 
                                data: this.data,
                                local_orders: this.localOrders,
                                phone: phone,
                                percentage: this.percentage
                            } 
                        }));
                    }
                },

                getBadgeClass() {
                    if (this.percentage >= 90) return 'bg-green-100 text-green-700 hover:bg-green-200';
                    if (this.percentage >= 70) return 'bg-blue-100 text-blue-700 hover:bg-blue-200';
                    if (this.percentage >= 50) return 'bg-yellow-100 text-yellow-700 hover:bg-yellow-200';
                    return 'bg-red-100 text-red-700 hover:bg-red-200';
                }
            }
        }
    </script>

    @if(session('bulk_results'))
    <div x-data="{ open: true }" x-show="open" style="display: none;" class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
            <div x-show="open" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="ease-in duration-200" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" @click="open = false" aria-hidden="true"></div>

            <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

            <div x-show="open" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100" x-transition:leave="ease-in duration-200" x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100" x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-2xl sm:w-full">
                <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                    <div class="sm:flex sm:items-start">
                        <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left w-full">
                            <h3 class="text-lg leading-6 font-medium text-gray-900" id="modal-title">Bulk Action Results</h3>
                            <div class="mt-4 max-h-[60vh] overflow-y-auto">
                                <ul class="space-y-2">
                                    @foreach(session('bulk_results') as $result)
                                        <li class="flex items-start p-3 rounded-lg border {{ $result['status'] === 'success' ? 'bg-green-50 border-green-200' : 'bg-red-50 border-red-200' }}">
                                            <div class="flex-shrink-0">
                                                @if($result['status'] === 'success')
                                                    <svg class="h-5 w-5 text-green-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                                                    </svg>
                                                @else
                                                    <svg class="h-5 w-5 text-red-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                                                    </svg>
                                                @endif
                                            </div>
                                            <div class="ml-3 w-full">
                                                <div class="flex justify-between">
                                                    <h3 class="text-sm font-medium {{ $result['status'] === 'success' ? 'text-green-800' : 'text-red-800' }}">
                                                        Order: {{ $result['order_number'] }}
                                                    </h3>
                                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $result['status'] === 'success' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                                        {{ ucfirst($result['status']) }}
                                                    </span>
                                                </div>
                                                <div class="mt-1 text-sm {{ $result['status'] === 'success' ? 'text-green-700' : 'text-red-700' }}">
                                                    {{ $result['message'] }}
                                                </div>
                                            </div>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                    <button type="button" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-blue-600 text-base font-medium text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 sm:ml-3 sm:w-auto sm:text-sm" @click="open = false">
                        Close
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Confirmation Modal -->
    <div x-data="{ open: false, count: 0, courier: '' }" 
         @open-bulk-confirm.window="open = true; count = $event.detail.count; courier = $event.detail.courier"
         x-show="open" 
         style="display: none;" 
         class="fixed inset-0 z-50 overflow-y-auto" 
         aria-labelledby="modal-title" 
         role="dialog" 
         aria-modal="true">
        <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
            <div x-show="open" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100" x-transition:leave="ease-in duration-200" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" @click="open = false" aria-hidden="true"></div>

            <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

            <div x-show="open" x-transition:enter="ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100" x-transition:leave="ease-in duration-200" x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100" x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95" class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                    <div class="sm:flex sm:items-start">
                        <div class="mx-auto flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-blue-100 sm:mx-0 sm:h-10 sm:w-10">
                            <svg class="h-6 w-6 text-blue-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                            </svg>
                        </div>
                        <div class="mt-3 text-center sm:mt-0 sm:ml-4 sm:text-left">
                            <h3 class="text-lg leading-6 font-medium text-gray-900" id="modal-title">Confirm Bulk Action</h3>
                            <div class="mt-2">
                                <p class="text-sm text-gray-500">
                                    <span x-show="courier !== 'check_status'">Are you sure you want to send <span x-text="count" class="font-bold text-gray-800"></span> orders to <span x-text="courier === 'steadfast' ? 'Steadfast Courier' : courier" class="font-bold text-gray-800"></span>?</span>
                                    <span x-show="courier === 'check_status'">Are you sure you want to check status for <span x-text="count" class="font-bold text-gray-800"></span> orders?</span>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="bg-gray-50 px-4 py-3 sm:px-6 sm:flex sm:flex-row-reverse">
                    <button type="button" @click="document.getElementById('bulk-action-form').submit(); open = false;" class="w-full inline-flex justify-center rounded-md border border-transparent shadow-sm px-4 py-2 bg-blue-600 text-base font-medium text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 sm:ml-3 sm:w-auto sm:text-sm">
                        Confirm
                    </button>
                    <button type="button" class="mt-3 w-full inline-flex justify-center rounded-md border border-gray-300 shadow-sm px-4 py-2 bg-white text-base font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm" @click="open = false">
                        Cancel
                    </button>
                </div>
            </div>
        </div>
    </div>

    <form id="bulk-action-form" action="{{ route('admin.orders.bulk_action') }}" method="POST" style="display:none;">
        @csrf
        <input type="hidden" name="courier" id="form-courier">
        <input type="hidden" name="status" id="form-status">
        <!-- IDs will be appended here -->
    </form>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Select All
            const selectAll = document.getElementById('select-all');
            
            if(selectAll) {
                selectAll.addEventListener('change', function() {
                    const checkboxes = document.querySelectorAll('.order-checkbox');
                    checkboxes.forEach(cb => cb.checked = this.checked);
                });
            }

            // Bulk Update
            const updateBtn = document.getElementById('bulk-update-btn');
            const courierSelect = document.getElementById('bulk-courier');
            const statusSelect = document.getElementById('bulk-status');
            const form = document.getElementById('bulk-action-form');
            const formCourier = document.getElementById('form-courier');
            const formStatus = document.getElementById('form-status');

            if(updateBtn) {
                updateBtn.addEventListener('click', function() {
                    const selectedCheckboxes = Array.from(document.querySelectorAll('.order-checkbox:checked'));
                    const selectedIds = selectedCheckboxes.map(cb => cb.value);

                    if (selectedIds.length === 0) {
                        alert('Please select at least one order.');
                        return;
                    }

                    const courier = courierSelect.value;
                    const status = statusSelect ? statusSelect.value : '';
                    
                    if (status) {
                        // Validate same status
                        const firstStatus = selectedCheckboxes[0].getAttribute('data-status');
                        const allSame = selectedCheckboxes.every(cb => cb.getAttribute('data-status') === firstStatus);

                        if (!allSame) {
                            alert('All selected orders must be in the same status to perform a bulk status update.');
                            return;
                        }

                        // Prepare form for status update
                        formStatus.value = status;
                        formCourier.value = ''; // Clear courier
                        
                        // Clear previous hidden inputs
                        const oldInputs = form.querySelectorAll('input[name="ids[]"]');
                        oldInputs.forEach(input => input.remove());

                        // Add IDs
                        selectedIds.forEach(id => {
                            const input = document.createElement('input');
                            input.type = 'hidden';
                            input.name = 'ids[]';
                            input.value = id;
                            form.appendChild(input);
                        });

                        if (confirm('Are you sure you want to update status to ' + status + ' for ' + selectedIds.length + ' orders?')) {
                            form.submit();
                        }
                    }
                    // If courier is selected
                    else if (courier) {
                         formCourier.value = courier;
                         
                         // Clear previous hidden inputs
                         const oldInputs = form.querySelectorAll('input[name="ids[]"]');
                         oldInputs.forEach(input => input.remove());

                         // Add IDs
                         selectedIds.forEach(id => {
                             const input = document.createElement('input');
                             input.type = 'hidden';
                             input.name = 'ids[]';
                             input.value = id;
                             form.appendChild(input);
                         });

                         // Dispatch event to open custom modal instead of native confirm
                         window.dispatchEvent(new CustomEvent('open-bulk-confirm', { 
                             detail: { 
                                 count: selectedIds.length,
                                 courier: courier
                             } 
                         }));
                    } else {
                        alert('Please select an action (e.g., Courier).');
                    }
                });
            }
        });
    </script>
</x-admin-layout>
