<aside :class="sidebarOpen ? 'translate-x-0 ease-out' : '-translate-x-full ease-in'" class="fixed inset-y-0 left-0 z-30 w-64 bg-slate-900 border-r border-slate-800 transition-transform duration-300 lg:translate-x-0 lg:static lg:inset-0 flex flex-col h-full">
    <!-- Sidebar Header -->
    <div class="h-40 flex items-center justify-center border-b border-slate-800 bg-slate-950 flex-shrink-0">
        <a href="{{ route('admin.dashboard') }}" class="transition-transform hover:scale-105 duration-200">
            @if(isset($generalSetting) && $generalSetting->white_logo)
                <!-- Outer Ring (Different Color/Gradient) -->
                <div class="h-28 w-28 rounded-full bg-gradient-to-br from-orange-500 via-purple-500 to-blue-500 p-1.5 shadow-2xl shadow-blue-500/20">
                    <!-- Inner Circle (White Background) -->
                    <div class="h-full w-full rounded-full bg-white flex items-center justify-center p-3 border-4 border-slate-900/10">
                        <img src="{{ Storage::url($generalSetting->white_logo) }}" alt="{{ $generalSetting->name ?? 'ECOMMERCE' }}" class="h-full w-full object-contain rounded-full">
                    </div>
                </div>
            @else
                <h1 class="text-xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-purple-500 tracking-wider">
                    {{ $generalSetting->name ?? 'ECOMMERCE' }}
                </h1>
            @endif
        </a>
    </div>

    <!-- Sidebar Navigation -->
    <nav class="flex-1 overflow-y-auto p-2 pb-20 pt-6">
        <ul class="space-y-1">
            
            <!-- 1) Dashboard -->
            <li>
                <a href="{{ route('admin.dashboard') }}" 
                   class="flex items-center p-3 rounded-lg transition-colors duration-200 group
                          {{ request()->routeIs('admin.dashboard') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/30' : 'text-slate-400 hover:bg-slate-800 hover:text-white' }}">
                    <svg class="w-5 h-5 mr-3 transition-colors duration-200 {{ request()->routeIs('admin.dashboard') ? 'text-white' : 'text-slate-500 group-hover:text-white' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path>
                    </svg>
                    <span class="font-medium">Dashboard</span>
                </a>
            </li>

            <!-- 2) Orders -->
            <li>
                <a href="{{ route('admin.orders.index') }}" 
                   class="flex items-center p-3 rounded-lg transition-colors duration-200 group
                          {{ request()->routeIs('admin.orders.*') ? 'bg-slate-800 text-white' : 'text-slate-400 hover:bg-slate-800 hover:text-white' }}">
                    <svg class="w-5 h-5 mr-3 transition-colors duration-200 {{ request()->routeIs('admin.orders.*') ? 'text-white' : 'text-slate-500 group-hover:text-white' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                    </svg>
                    <span class="font-medium">Orders</span>
                </a>
            </li>

            <!-- 3) Manage Products -->
            <li x-data="{ open: {{ request()->routeIs('admin.products.*') || request()->routeIs('admin.categories.*') || request()->routeIs('admin.brands.*') || request()->routeIs('admin.suppliers.*') || request()->routeIs('admin.purchases.*') || request()->routeIs('admin.inventory.*') ? 'true' : 'false' }} }">
                <button @click="open = !open" 
                        class="w-full flex items-center justify-between p-3 rounded-lg transition-colors duration-200 group text-slate-400 hover:bg-slate-800 hover:text-white
                               {{ request()->routeIs('admin.products.*') || request()->routeIs('admin.categories.*') || request()->routeIs('admin.brands.*') || request()->routeIs('admin.suppliers.*') || request()->routeIs('admin.purchases.*') || request()->routeIs('admin.inventory.*') ? 'bg-slate-800 text-white' : '' }}">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-3 transition-colors duration-200 text-slate-500 group-hover:text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                        </svg>
                        <span class="font-medium">Manage Products</span>
                    </div>
                    <svg :class="{'rotate-180': open}" class="w-4 h-4 transform transition-transform duration-200 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <ul x-show="open" x-collapse class="pl-4 mt-1 space-y-1">
                    <li><a href="{{ route('admin.products.index') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.products.index') ? 'text-white bg-slate-700' : '' }}">Products</a></li>
                    <li><a href="{{ route('admin.categories.index') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.categories.index') ? 'text-white bg-slate-700' : '' }}">Categories</a></li>
                    <li><a href="{{ route('admin.brands.index') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.brands.index') ? 'text-white bg-slate-700' : '' }}">Brands</a></li>
                    {{-- <li><a href="{{ route('admin.suppliers.index') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.suppliers.index') ? 'text-white bg-slate-700' : '' }}">Suppliers</a></li> --}}
                    {{-- <li><a href="{{ route('admin.purchases.index') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.purchases.index') ? 'text-white bg-slate-700' : '' }}">Purchases</a></li> --}}
                    {{-- <li><a href="{{ route('admin.inventory.index') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.inventory.index') ? 'text-white bg-slate-700' : '' }}">Inventory</a></li> --}}
                </ul>
            </li>

            <!-- 4) Reviews -->
            {{--
            <li x-data="{ open: {{ request()->routeIs('admin.reviews.*') ? 'true' : 'false' }} }">
                <button @click="open = !open" 
                        class="w-full flex items-center justify-between p-3 rounded-lg transition-colors duration-200 group text-slate-400 hover:bg-slate-800 hover:text-white
                               {{ request()->routeIs('admin.reviews.*') ? 'bg-slate-800 text-white' : '' }}">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-3 transition-colors duration-200 text-slate-500 group-hover:text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"></path>
                        </svg>
                        <span class="font-medium">Reviews</span>
                    </div>
                    <svg :class="{'rotate-180': open}" class="w-4 h-4 transform transition-transform duration-200 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <ul x-show="open" x-collapse class="pl-4 mt-1 space-y-1">
                    <li><a href="{{ route('admin.reviews.index', ['status' => 'pending']) }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->fullUrlIs(route('admin.reviews.index', ['status' => 'pending'])) ? 'text-white bg-slate-700' : '' }}">Pending Reviews</a></li>
                    <li><a href="{{ route('admin.reviews.create') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.reviews.create') ? 'text-white bg-slate-700' : '' }}">Create</a></li>
                    <li><a href="{{ route('admin.reviews.index') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->fullUrlIs(route('admin.reviews.index')) ? 'text-white bg-slate-700' : '' }}">All Reviews</a></li>
                </ul>
            </li>
            --}}

            <!-- 5) Landing Page -->
            <li x-data="{ open: {{ request()->routeIs('admin.landing-pages.*') ? 'true' : 'false' }} }">
                <button @click="open = !open" 
                        class="w-full flex items-center justify-between p-3 rounded-lg transition-colors duration-200 group text-slate-400 hover:bg-slate-800 hover:text-white
                               {{ request()->routeIs('admin.landing-pages.*') ? 'bg-slate-800 text-white' : '' }}">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-3 transition-colors duration-200 text-slate-500 group-hover:text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <span class="font-medium">Landing Page</span>
                    </div>
                    <svg :class="{'rotate-180': open}" class="w-4 h-4 transform transition-transform duration-200 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <ul x-show="open" x-collapse class="pl-4 mt-1 space-y-1">
                    <li><a href="{{ route('admin.landing-pages.create') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.landing-pages.create') ? 'text-white bg-slate-700' : '' }}">Create</a></li>
                    <li><a href="{{ route('admin.landing-pages.campaign') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.landing-pages.campaign') ? 'text-white bg-slate-700' : '' }}">Campaign</a></li>
                </ul>
            </li>

            <!-- 6) Users -->
            <li x-data="{ open: {{ request()->routeIs('admin.users.*') || request()->routeIs('admin.roles.*') || request()->routeIs('admin.permissions.*') ? 'true' : 'false' }} }">
                <button @click="open = !open" 
                        class="w-full flex items-center justify-between p-3 rounded-lg transition-colors duration-200 group text-slate-400 hover:bg-slate-800 hover:text-white
                               {{ request()->routeIs('admin.users.*') || request()->routeIs('admin.roles.*') ? 'bg-slate-800 text-white' : '' }}">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-3 transition-colors duration-200 text-slate-500 group-hover:text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                        </svg>
                        <span class="font-medium">Users</span>
                    </div>
                    <svg :class="{'rotate-180': open}" class="w-4 h-4 transform transition-transform duration-200 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <ul x-show="open" x-collapse class="pl-4 mt-1 space-y-1">
                    <li><a href="{{ route('admin.users.index') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.users.index') ? 'text-white bg-slate-700' : '' }}">User</a></li>
                    <li><a href="{{ route('admin.roles.index') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.roles.*') ? 'text-white bg-slate-700' : '' }}">Roles</a></li>
                    <li><a href="{{ route('admin.permissions.index') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.permissions.*') ? 'text-white bg-slate-700' : '' }}">Permissions</a></li>
                    <li><a href="{{ route('admin.users.customers') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.users.customers') ? 'text-white bg-slate-700' : '' }}">Customers</a></li>
                </ul>
            </li>

            <!-- 7) Site Setting -->
            <li x-data="{ open: {{ request()->routeIs('admin.settings.*') || request()->routeIs('admin.pages.*') ? 'true' : 'false' }} }">
                <button @click="open = !open" 
                        class="w-full flex items-center justify-between p-3 rounded-lg transition-colors duration-200 group text-slate-400 hover:bg-slate-800 hover:text-white
                               {{ request()->routeIs('admin.settings.*') || request()->routeIs('admin.pages.*') ? 'bg-slate-800 text-white' : '' }}">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-3 transition-colors duration-200 text-slate-500 group-hover:text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                        <span class="font-medium">Site Setting</span>
                    </div>
                    <svg :class="{'rotate-180': open}" class="w-4 h-4 transform transition-transform duration-200 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <ul x-show="open" x-collapse class="pl-4 mt-1 space-y-1">
                    <li><a href="{{ route('admin.settings.general') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.settings.general') ? 'text-white bg-slate-700' : '' }}">General Setting</a></li>
                    <li><a href="{{ route('admin.settings.social') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.settings.social') ? 'text-white bg-slate-700' : '' }}">Social Media</a></li>
                    <li><a href="{{ route('admin.settings.contact') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.settings.contact') ? 'text-white bg-slate-700' : '' }}">Contact</a></li>
                    <li><a href="{{ route('admin.pages.create') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.pages.create') ? 'text-white bg-slate-700' : '' }}">Create Page</a></li>
                    <li><a href="{{ route('admin.settings.shipping') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.settings.shipping') ? 'text-white bg-slate-700' : '' }}">Shipping Charge</a></li>
                    <li><a href="{{ route('admin.settings.order_status') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.settings.order_status') ? 'text-white bg-slate-700' : '' }}">Order Status</a></li>
                    <li><a href="{{ route('admin.settings.themes.index') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.settings.themes.index') ? 'text-white bg-slate-700' : '' }}">Themes</a></li>
                </ul>
            </li>

            <!-- 8) API Integration -->
            <li x-data="{ open: {{ request()->routeIs('admin.api.*') ? 'true' : 'false' }} }">
                <button @click="open = !open" 
                        class="w-full flex items-center justify-between p-3 rounded-lg transition-colors duration-200 group text-slate-400 hover:bg-slate-800 hover:text-white
                               {{ request()->routeIs('admin.api.*') ? 'bg-slate-800 text-white' : '' }}">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-3 transition-colors duration-200 text-slate-500 group-hover:text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                        </svg>
                        <span class="font-medium">API Integration</span>
                    </div>
                    <svg :class="{'rotate-180': open}" class="w-4 h-4 transform transition-transform duration-200 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <ul x-show="open" x-collapse class="pl-4 mt-1 space-y-1">
                    <li><a href="{{ route('admin.api.payment') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.api.payment') ? 'text-white bg-slate-700' : '' }}">Payment Gateway</a></li>
                    <li><a href="{{ route('admin.api.sms') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.api.sms') ? 'text-white bg-slate-700' : '' }}">SMS Gateway</a></li>
                    <li><a href="{{ route('admin.api.courier') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.api.courier') ? 'text-white bg-slate-700' : '' }}">Courier API</a></li>
                    <li><a href="{{ route('admin.api.fraud') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.api.fraud') ? 'text-white bg-slate-700' : '' }}">Fraud Checker API</a></li>
                    <li><a href="{{ route('admin.api.auto_call') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.api.auto_call') ? 'text-white bg-slate-700' : '' }}">Auto Call API</a></li>
                </ul>
            </li>

            <!-- Marketing -->
            <li x-data="{ open: {{ request()->routeIs('admin.pixels.*') ? 'true' : 'false' }} }">
                <button @click="open = !open" 
                        class="w-full flex items-center justify-between p-3 rounded-lg transition-colors duration-200 group text-slate-400 hover:bg-slate-800 hover:text-white
                               {{ request()->routeIs('admin.pixels.*') ? 'bg-slate-800 text-white' : '' }}">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-3 transition-colors duration-200 text-slate-500 group-hover:text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 3.055A9.001 9.001 0 1020.945 13H11V3.055z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.488 9H15V3.512A9.025 9.025 0 0120.488 9z"></path>
                        </svg>
                        <span class="font-medium">Marketing</span>
                    </div>
                    <svg :class="{'rotate-180': open}" class="w-4 h-4 transform transition-transform duration-200 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <ul x-show="open" x-collapse class="pl-4 mt-1 space-y-1">
                    <li><a href="{{ route('admin.pixels.index') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.pixels.index') ? 'text-white bg-slate-700' : '' }}">Facebook Pixel & CAPI</a></li>
                    <li><a href="{{ route('admin.pixels.verification') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.pixels.verification') ? 'text-white bg-slate-700' : '' }}">Domain Verification</a></li>
                    <li><a href="{{ route('admin.pixels.tiktok') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.pixels.tiktok') ? 'text-white bg-slate-700' : '' }}">Tiktok</a></li>
                    
                    <!-- Google Submenu -->
                    <li x-data="{ googleOpen: {{ request()->routeIs('admin.pixels.tag_manager') ? 'true' : 'false' }} }">
                        <button @click="googleOpen = !googleOpen" class="w-full flex items-center justify-between p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors">
                            <span>Google</span>
                            <svg :class="{'rotate-180': googleOpen}" class="w-3 h-3 transform transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                        <ul x-show="googleOpen" x-collapse class="pl-4 mt-1 space-y-1 border-l border-slate-700 ml-2">
                             <li><a href="{{ route('admin.pixels.tag_manager') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.pixels.tag_manager') ? 'text-white bg-slate-700' : '' }}">Tag Manager</a></li>
                        </ul>
                    </li>
                </ul>
            </li>

            <!-- 10) Banner & Ads -->
            <li x-data="{ open: {{ request()->routeIs('admin.banners.*') ? 'true' : 'false' }} }">
                <button @click="open = !open" 
                        class="w-full flex items-center justify-between p-3 rounded-lg transition-colors duration-200 group text-slate-400 hover:bg-slate-800 hover:text-white
                               {{ request()->routeIs('admin.banners.*') ? 'bg-slate-800 text-white' : '' }}">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-3 transition-colors duration-200 text-slate-500 group-hover:text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                        </svg>
                        <span class="font-medium">Banner & Ads</span>
                    </div>
                    <svg :class="{'rotate-180': open}" class="w-4 h-4 transform transition-transform duration-200 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>
                <ul x-show="open" x-collapse class="pl-4 mt-1 space-y-1">
                    <li><a href="{{ route('admin.banners.category') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.banners.category') ? 'text-white bg-slate-700' : '' }}">Banner Category</a></li>
                    <li><a href="{{ route('admin.banners.index') }}" class="block p-2 rounded-md text-sm text-slate-400 hover:text-white hover:bg-slate-700 transition-colors {{ request()->routeIs('admin.banners.index') ? 'text-white bg-slate-700' : '' }}">Banner & Ads</a></li>
                </ul>
            </li>

            <!-- 11) Reports -->
            <li>
                <a href="{{ route('admin.reports.sales') }}" 
                   class="flex items-center p-3 rounded-lg transition-colors duration-200 group
                          {{ request()->routeIs('admin.reports.*') ? 'bg-blue-600 text-white shadow-lg shadow-blue-500/30' : 'text-slate-400 hover:bg-slate-800 hover:text-white' }}">
                    <svg class="w-5 h-5 mr-3 transition-colors duration-200 {{ request()->routeIs('admin.reports.*') ? 'text-white' : 'text-slate-500 group-hover:text-white' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <span class="font-medium">Reports</span>
                </a>
            </li>

            <!-- 12) Log Out -->
            <li class="mt-4 pt-4 border-t border-slate-800">
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" class="w-full flex items-center p-3 rounded-lg transition-colors duration-200 group text-slate-400 hover:bg-red-600 hover:text-white">
                        <svg class="w-5 h-5 mr-3 transition-colors duration-200 text-slate-500 group-hover:text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                        </svg>
                        <span class="font-medium">Log Out</span>
                    </button>
                </form>
            </li>

        </ul>
        
        <div class="px-6 py-6 mt-4">
             <div class="bg-gradient-to-r from-blue-600 to-indigo-600 rounded-lg p-4 text-center">
                 <p class="text-white text-xs font-semibold mb-2">Need Help?</p>
                 <button class="bg-white text-blue-600 text-xs font-bold py-2 px-4 rounded shadow hover:bg-blue-50 transition-colors">Contact Support</button>
             </div>
        </div>
    </nav>
</aside>
