    <!-- Header -->
    <header class="bg-white shadow-sm sticky top-0 z-50">
        <div class="container mx-auto px-4 py-4 flex justify-between items-center">
            <a href="/" class="text-2xl font-bold text-blue-600">BrandName</a>
            <a href="#order-form" class="bg-blue-600 text-white px-6 py-2 rounded-full hover:bg-blue-700 transition shadow-lg animate-pulse">Order Now</a>
        </div>
    </header>

    <!-- Hero Section -->
    <section class="relative bg-white overflow-hidden">
        <div class="container mx-auto px-4 py-12 md:py-24">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-center">
                <div class="space-y-6">
                    <h1 class="text-4xl md:text-6xl font-extrabold text-gray-900 leading-tight">
                        {{ $landingPage->title }}
                    </h1>
                    <p class="text-lg text-gray-600">
                        {{ $landingPage->content ?? 'Experience the best quality products with our exclusive offer. Limited time only!' }}
                    </p>
                    <div class="flex flex-col sm:flex-row gap-4">
                        <a href="#order-form" class="inline-block bg-blue-600 text-white text-xl font-bold px-8 py-4 rounded-lg shadow-xl hover:bg-blue-700 transition text-center">
                            Order Now - {{ $landingPage->product->price }} BDT
                        </a>
                    </div>
                    <div class="flex items-center gap-2 text-green-600 font-medium">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                        Cash on Delivery Available
                    </div>
                </div>
                <div class="relative">
                    @if($landingPage->hero_image)
                        <img src="{{ asset('storage/' . $landingPage->hero_image) }}" alt="{{ $landingPage->title }}" class="w-full rounded-2xl shadow-2xl transform hover:scale-105 transition duration-500">
                    @elseif($landingPage->product && $landingPage->product->thumbnail)
                        <img src="{{ asset($landingPage->product->thumbnail) }}" alt="{{ $landingPage->product->name }}" class="w-full rounded-2xl shadow-2xl transform hover:scale-105 transition duration-500">
                    @else
                        <div class="w-full h-96 bg-gray-200 rounded-2xl flex items-center justify-center text-gray-400">
                            No Image Available
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </section>

    <!-- Product Details -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto text-center mb-12">
                <h2 class="text-3xl font-bold mb-4">Why Choose This Product?</h2>
                <div class="w-24 h-1 bg-blue-600 mx-auto rounded"></div>
            </div>
            
            @if($landingPage->product)
            <div class="bg-blue-50 rounded-3xl p-8 md:p-12 shadow-inner">
                <div class="flex flex-col md:flex-row gap-8 items-center">
                    <div class="w-full md:w-1/3">
                        <img src="{{ asset($landingPage->product->thumbnail) }}" alt="{{ $landingPage->product->name }}" class="w-full rounded-xl shadow-md mix-blend-multiply">
                    </div>
                    <div class="w-full md:w-2/3 space-y-4">
                        <h3 class="text-2xl font-bold text-gray-900">{{ $landingPage->product->name }}</h3>
                        <div class="prose text-gray-600">
                            {!! $landingPage->product->description ?? 'No description available.' !!}
                        </div>
                        <div class="text-3xl font-bold text-blue-600">
                            {{ $landingPage->product->price }} BDT
                            @if($landingPage->product->old_price)
                                <span class="text-lg text-gray-400 line-through ml-2">{{ $landingPage->product->old_price }} BDT</span>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </section>