<x-admin-layout>
    <x-slot name="header">
        <div class="relative flex items-center justify-center">
            <h2 class="absolute left-0 font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Edit Landing Page') }}
            </h2>
            <div class="flex space-x-3">
                <a href="{{ route('admin.landing-pages.index') }}" class="px-4 py-2 bg-cyan-500 text-white font-medium rounded hover:bg-cyan-600 transition">
                    Back
                </a>
                <a href="{{ route('landing.show', $landingPage->slug) }}" target="_blank" class="px-4 py-2 bg-cyan-500 text-white font-medium rounded hover:bg-cyan-600 transition">
                    Preview
                </a>
                <a href="{{ route('admin.landing-pages.builder', $landingPage->id) }}" class="px-4 py-2 bg-cyan-500 text-white font-medium rounded hover:bg-cyan-600 transition">
                    Edit with builder
                </a>
                <button type="submit" form="edit-landing-page-form" class="px-4 py-2 bg-green-500 text-white font-medium rounded hover:bg-green-600 transition">
                    Update
                </button>
            </div>
        </div>
    </x-slot>

    <div class="py-12 bg-gray-100 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-lg sm:rounded-xl border-t-4 border-cyan-500">
                <div class="p-8 bg-white border-b border-gray-100">
                    <form id="edit-landing-page-form" action="{{ route('admin.landing-pages.update', $landingPage->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="status" value="{{ $landingPage->status }}">

                        <div class="space-y-6">
                            <!-- Set as Home Page -->
                            <div class="flex items-center justify-between border-b pb-4" x-data="{ isHome: {{ $landingPage->is_home ? 'true' : 'false' }} }">
                                <label for="is_home" class="block text-sm font-medium text-gray-700">Set as Home Page</label>
                                
                                <div class="flex items-center">
                                    <input type="hidden" name="is_home" :value="isHome ? 1 : 0">
                                    <button type="button" 
                                        @click="isHome = !isHome"
                                        :class="isHome ? 'bg-cyan-500' : 'bg-gray-200'"
                                        class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:ring-offset-2">
                                        <span class="sr-only">Use setting</span>
                                        <span aria-hidden="true" 
                                            :class="isHome ? 'translate-x-5' : 'translate-x-0'"
                                            class="pointer-events-none inline-block h-5 w-5 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"></span>
                                    </button>
                                    <span class="ml-3 text-sm font-medium text-gray-900" x-text="isHome ? 'Yes' : 'No'"></span>
                                </div>
                            </div>

                            <!-- Title -->
                            <div>
                                <label for="title" class="block text-sm font-medium text-gray-700 mb-1">Title</label>
                                <input type="text" name="title" id="title" value="{{ old('title', $landingPage->title) }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-cyan-500 focus:ring-cyan-500 sm:text-sm px-4 py-2 border transition duration-150 ease-in-out" placeholder="Enter page title">
                            </div>

                            <!-- Slug -->
                            <div>
                                <label for="slug" class="block text-sm font-medium text-gray-700 mb-1">Slug</label>
                                <input type="text" name="slug" id="slug" value="{{ old('slug', $landingPage->slug) }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-cyan-500 focus:ring-cyan-500 sm:text-sm px-4 py-2 border transition duration-150 ease-in-out" placeholder="Enter slug">
                                <p class="mt-1 text-xs text-gray-500">Enter a slug for your landing page. Examples: If you enter <strong>landing-page-01</strong>, your URL will be: {{ url('/') }}/landing-page-01</p>
                            </div>

                            <!-- Custom URL Prefix -->
                            <div>
                                <label for="custom_url_prefix" class="block text-sm font-medium text-gray-700 mb-1">Custom URL Prefix <span class="text-gray-400 text-xs">(Optional)</span></label>
                                <input type="text" name="custom_url_prefix" id="custom_url_prefix" value="{{ old('custom_url_prefix', $landingPage->custom_url_prefix) }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-cyan-500 focus:ring-cyan-500 sm:text-sm px-4 py-2 border transition duration-150 ease-in-out" placeholder="e.g. step">
                                <p class="mt-1 text-xs text-gray-500">Enter a prefix for your landing page. Examples: If you enter <strong>black-friday</strong>, your URL will be: {{ url('/') }}/black-friday/landing-page-01</p>
                            </div>

                            <!-- Custom URL Suffix -->
                            <div>
                                <label for="custom_url_suffix" class="block text-sm font-medium text-gray-700 mb-1">Custom URL Suffix <span class="text-gray-400 text-xs">(Optional)</span></label>
                                <input type="text" name="custom_url_suffix" id="custom_url_suffix" value="{{ old('custom_url_suffix', $landingPage->custom_url_suffix) }}" class="w-full rounded-md border-gray-300 shadow-sm focus:border-cyan-500 focus:ring-cyan-500 sm:text-sm px-4 py-2 border transition duration-150 ease-in-out" placeholder="e.g. confirm">
                                <p class="mt-1 text-xs text-gray-500">Enter a suffix for your landing page. Examples: If you enter <strong>confirm</strong>, your URL will be: {{ url('/') }}/black-friday/confirm/landing-page-01</p>
                            </div>

                            <!-- Choose Product -->
                            <div>
                                <label for="product_id" class="block text-sm font-medium text-gray-700 mb-1">Choose Product</label>
                                <select name="product_id" id="product_id" class="w-full rounded-md border-gray-300 shadow-sm focus:border-cyan-500 focus:ring-cyan-500 sm:text-sm px-4 py-2 border transition duration-150 ease-in-out bg-white">
                                    <option value="">Select a product</option>
                                    @foreach($products as $product)
                                        <option value="{{ $product->id }}" {{ old('product_id', $landingPage->product_id) == $product->id ? 'selected' : '' }}>
                                            {{ $product->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
