<x-admin-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-2xl text-gray-800 leading-tight">
                {{ __('Create Landing Page') }}
            </h2>
            <div class="flex space-x-3">
                <a href="{{ route('admin.landing-pages.index') }}" class="px-5 py-2.5 bg-gray-600 text-white font-medium rounded-lg shadow-sm hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500 transition-all duration-200">
                    Back
                </a>
                <button type="submit" form="landing-page-form" class="px-5 py-2.5 bg-gradient-to-r from-blue-600 to-indigo-600 text-white font-medium rounded-lg shadow-md hover:from-blue-700 hover:to-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 transform hover:scale-105 transition-all duration-200">
                    Publish Page
                </button>
            </div>
        </div>
    </x-slot>

    <div class="py-8 w-full px-4 sm:px-6 lg:px-8">
        <form id="landing-page-form" action="{{ route('admin.landing-pages.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            
            <div class="grid grid-cols-1 gap-8">
                <!-- Main Content Card -->
                <div class="bg-white rounded-2xl shadow-xl overflow-hidden border border-gray-100">
                    <!-- Decorative Header -->
                    <div class="bg-gradient-to-r from-indigo-500 via-purple-500 to-pink-500 h-2"></div>
                    
                    <div class="p-8">
                        <div class="flex justify-between items-start mb-8 border-b border-gray-100 pb-6">
                            <div>
                                <h3 class="text-xl font-bold text-gray-800">Page Information</h3>
                                <p class="text-sm text-gray-500 mt-1">Fill in the details to create your new landing page.</p>
                            </div>
                            
                            <!-- Status Toggle -->
                            <div class="flex items-center bg-gray-50 rounded-lg p-3 border border-gray-200" x-data="{ status: 'active' }">
                                <span class="mr-3 text-sm font-semibold text-gray-700">Status:</span>
                                <input type="hidden" name="status" :value="status">
                                <button type="button" 
                                    @click="status = status === 'active' ? 'inactive' : 'active'"
                                    :class="status === 'active' ? 'bg-green-500' : 'bg-gray-300'"
                                    class="relative inline-flex h-7 w-12 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-green-500 focus:ring-offset-2">
                                    <span class="sr-only">Use setting</span>
                                    <span aria-hidden="true" 
                                        :class="status === 'active' ? 'translate-x-5' : 'translate-x-0'"
                                        class="pointer-events-none inline-block h-6 w-6 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out flex items-center justify-center">
                                        <svg x-show="status === 'active'" class="w-3 h-3 text-green-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7" />
                                        </svg>
                                        <svg x-show="status !== 'active'" class="w-3 h-3 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M6 18L18 6M6 6l12 12" />
                                        </svg>
                                    </span>
                                </button>
                                <span class="ml-3 text-sm font-bold" :class="status === 'active' ? 'text-green-600' : 'text-gray-500'" x-text="status === 'active' ? 'Active' : 'Inactive'"></span>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                            <!-- Left Column -->
                            <div class="space-y-6">
                                <!-- Title -->
                                <div>
                                    <label for="title" class="block text-sm font-semibold text-gray-700 mb-2">Page Title <span class="text-red-500">*</span></label>
                                    <div class="relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                            </svg>
                                        </div>
                                        <input type="text" name="title" id="title" class="pl-10 block w-full rounded-lg border-gray-300 bg-gray-50 focus:bg-white focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm py-3 transition duration-200 ease-in-out" placeholder="Enter page title" required>
                                    </div>
                                </div>

                                <!-- Slug -->
                                <div>
                                    <label for="slug" class="block text-sm font-semibold text-gray-700 mb-2">URL Slug <span class="text-red-500">*</span></label>
                                    <div class="relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <span class="text-gray-500 sm:text-sm">/</span>
                                        </div>
                                        <input type="text" name="slug" id="slug" class="pl-7 block w-full rounded-lg border-gray-300 bg-gray-50 focus:bg-white focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm py-3 transition duration-200 ease-in-out" placeholder="page-url-slug" required>
                                    </div>
                                    <p class="text-xs text-gray-500 mt-2 flex items-center">
                                        <svg class="w-4 h-4 mr-1 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                                        Preview: {{ url('/') }}/<span id="url-preview" class="text-indigo-600 font-medium">...</span>
                                    </p>
                                </div>

                                <!-- Choose Product -->
                                <div>
                                    <label for="product_id" class="block text-sm font-semibold text-gray-700 mb-2">Select Product <span class="text-red-500">*</span></label>
                                    <div class="relative rounded-md shadow-sm">
                                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                            <svg class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                                            </svg>
                                        </div>
                                        <select name="product_id" id="product_id" class="pl-10 block w-full rounded-lg border-gray-300 bg-gray-50 focus:bg-white focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm py-3 transition duration-200 ease-in-out" required>
                                            <option value="">Choose a product to feature...</option>
                                            @foreach($products as $product)
                                                <option value="{{ $product->id }}">{{ $product->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <!-- Right Column -->
                            <div class="space-y-6">
                                <!-- URL Customization Card -->
                                <div class="bg-indigo-50 rounded-xl p-5 border border-indigo-100">
                                    <h4 class="text-indigo-800 font-semibold mb-4 flex items-center">
                                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"></path></svg>
                                        Advanced URL Settings
                                    </h4>
                                    
                                    <!-- Custom URL Prefix -->
                                    <div class="mb-4">
                                        <label for="custom_url_prefix" class="block text-sm font-medium text-indigo-700 mb-1">URL Prefix (Optional)</label>
                                        <input type="text" name="custom_url_prefix" id="custom_url_prefix" class="block w-full rounded-md border-indigo-200 focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm py-2" placeholder="e.g. special-offer">
                                    </div>

                                    <!-- Custom URL Suffix -->
                                    <div>
                                        <label for="custom_url_suffix" class="block text-sm font-medium text-indigo-700 mb-1">URL Suffix (Optional)</label>
                                        <input type="text" name="custom_url_suffix" id="custom_url_suffix" class="block w-full rounded-md border-indigo-200 focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm py-2" placeholder="e.g. buy-now">
                                    </div>
                                </div>

                                <!-- Hero Image -->
                                <div>
                                    <label for="hero_image" class="block text-sm font-semibold text-gray-700 mb-2">Hero Image (Optional)</label>
                                    <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-xl hover:bg-gray-50 transition-colors duration-200 cursor-pointer group" onclick="document.getElementById('hero_image').click()">
                                        <div class="space-y-1 text-center">
                                            <svg class="mx-auto h-12 w-12 text-gray-400 group-hover:text-indigo-500 transition-colors duration-200" stroke="currentColor" fill="none" viewBox="0 0 48 48" aria-hidden="true">
                                                <path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                            </svg>
                                            <div class="flex text-sm text-gray-600 justify-center">
                                                <label for="hero_image" class="relative cursor-pointer bg-white rounded-md font-medium text-indigo-600 hover:text-indigo-500 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-indigo-500">
                                                    <span>Upload a file</span>
                                                </label>
                                                <p class="pl-1">or drag and drop</p>
                                            </div>
                                            <p class="text-xs text-gray-500">PNG, JPG, GIF up to 10MB</p>
                                        </div>
                                    </div>
                                    <input type="file" name="hero_image" id="hero_image" class="hidden">
                                </div>
                            </div>
                        </div>

                        <!-- Full Width Content -->
                        <div class="mt-8">
                            <label for="content" class="block text-sm font-semibold text-gray-700 mb-2">Page Content / Description</label>
                            <div class="rounded-md shadow-sm">
                                <textarea name="content" id="content" rows="6" class="block w-full rounded-lg border-gray-300 focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm p-4 transition duration-200 ease-in-out" placeholder="Add your landing page content details here..."></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    
    <script>
        // Auto-slug generation
        document.getElementById('title').addEventListener('input', function() {
            let slug = this.value.toLowerCase().replace(/ /g, '-').replace(/[^\w-]+/g, '');
            document.getElementById('slug').value = slug;
            updatePreview();
        });

        // URL Preview Update
        function updatePreview() {
            const slug = document.getElementById('slug').value || '...';
            document.getElementById('url-preview').textContent = slug;
        }

        document.getElementById('slug').addEventListener('input', updatePreview);
    </script>
</x-admin-layout>
