<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Page Builder - {{ $landingPage->title }}</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <!-- GrapesJS CSS -->
    <link href="https://unpkg.com/grapesjs/dist/css/grapes.min.css" rel="stylesheet">
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    
    <!-- GrapesJS Preset Webpage Plugin -->
    <script src="https://unpkg.com/grapesjs"></script>
    <script src="https://unpkg.com/grapesjs-preset-webpage"></script>
    <script src="https://unpkg.com/grapesjs-blocks-basic"></script>

    <!-- CodeMirror for Syntax Highlighting -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/codemirror.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/theme/monokai.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/codemirror.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/xml/xml.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/javascript/javascript.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/css/css.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.2/mode/htmlmixed/htmlmixed.min.js"></script>
    
    <style>
        body, html {
            height: 100%;
            margin: 0;
        }
        
        .gjs-cv-canvas {
            top: 0;
            width: 100%;
            height: 100%;
        }

        .gjs-frame {
            width: 100%;
        }

        /* Custom Save Button Style if needed, but we'll use GrapesJS panels */
        .panel-top {
            padding: 5px;
            width: 100%;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        /* Center the new devices panel */
        .gjs-pn-devices-c {
            top: 5px;
            left: 50%;
            transform: translateX(-50%);
            position: fixed;
            z-index: 99999;
            background-color: #444;
            border-radius: 5px;
            padding: 2px 5px;
            border: 1px solid #222;
        }

        .gjs-pn-devices-c .gjs-pn-btn {
            margin: 0 2px;
            border-radius: 3px;
        }

        .gjs-pn-devices-c .gjs-pn-btn.gjs-pn-active {
            background-color: #3b82f6;
            color: white;
        }

        /* Hide default device selector/dropdown if present */
        .gjs-pn-options .gjs-device-label,
        .gjs-dvm {
            display: none !important;
        }
    </style>
</head>
<body>
    <div id="gjs" style="height:0px; overflow:hidden;">
        {!! $landingPage->content !!}
    </div>

    <style>
        {!! $landingPage->css !!}
    </style>

    <script type="text/javascript">
        const landingPageId = {{ $landingPage->id }};
        const updateUrl = "{{ route('admin.landing-pages.builder.update', $landingPage->id) }}";
        const backUrl = "{{ route('admin.landing-pages.edit', $landingPage->id) }}";
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

        const editor = grapesjs.init({
            container: '#gjs',
            fromElement: true,
            height: '100vh',
            width: '100%',
            storageManager: false, // We handle saving manually
            deviceManager: {
                devices: [{
                    name: 'Desktop',
                    width: '100%', // Width for the device (100% = fluid)
                }, {
                    name: 'Tablet',
                    width: '768px',
                    widthMedia: '992px',
                }, {
                    name: 'Mobile Portrait',
                    width: '320px',
                    widthMedia: '575px',
                }]
            },
            plugins: ['gjs-preset-webpage', 'gjs-blocks-basic'],
            pluginsOpts: {
                'gjs-preset-webpage': {
                    // options
                }
            },
            canvas: {
                styles: [
                    // Add Tailwind or Bootstrap here if your landing pages use them
                    'https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css',
                ]
            }
        });

        // Add Devices Panel in Center
        editor.Panels.addPanel({
            id: 'devices-c',
            buttons: [
                {
                    id: 'set-device-desktop',
                    command: function(e) { return e.setDevice('Desktop'); },
                    className: 'fa fa-desktop',
                    active: true,
                    attributes: { title: 'Desktop' }
                },
                {
                    id: 'set-device-tablet',
                    command: function(e) { return e.setDevice('Tablet'); },
                    className: 'fa fa-tablet',
                    attributes: { title: 'Tablet' }
                },
                {
                    id: 'set-device-mobile',
                    command: function(e) { return e.setDevice('Mobile Portrait'); },
                    className: 'fa fa-mobile',
                    attributes: { title: 'Mobile' }
                }
            ]
        });

        // Update active button on device change
        editor.on('change:device', () => {
            const device = editor.getDevice();
            const map = {
                'Desktop': 'set-device-desktop',
                'Tablet': 'set-device-tablet',
                'Mobile Portrait': 'set-device-mobile'
            };
            const btnId = map[device];
            if (btnId) {
                const panel = editor.Panels.getPanel('devices-c');
                panel.get('buttons').forEach(btn => btn.set('active', false));
                const btn = panel.getButton(btnId);
                if (btn) btn.set('active', true);
            }
        });

        // Add Save Button to the panel
        editor.Panels.addButton('options', {
            id: 'save-db',
            className: 'fa fa-floppy-o',
            command: 'save-db',
            attributes: { title: 'Save Changes' }
        });

        // Add Back Button
        editor.Panels.addButton('options', {
            id: 'back-db',
            className: 'fa fa-arrow-left',
            command: 'back-db',
            attributes: { title: 'Back to Edit' }
        });

        // Add Import Code Button
        editor.Panels.addButton('options', {
            id: 'import-code',
            className: 'fa fa-code',
            command: 'import-code',
            attributes: { title: 'Import/Edit Source Code' }
        });

        // Add Import Command
        editor.Commands.add('import-code', {
            run: function(editor, sender) {
                sender && sender.set('active', 0);
                const modal = editor.Modal;
                
                const container = document.createElement('div');
                const htmlLabel = document.createElement('div');
                htmlLabel.innerHTML = 'HTML Code';
                htmlLabel.style.marginBottom = '5px';
                htmlLabel.style.fontWeight = 'bold';
                htmlLabel.style.color = '#3b82f6'; // Bright blue
                htmlLabel.style.fontSize = '14px';
                htmlLabel.style.textTransform = 'uppercase';
                htmlLabel.style.letterSpacing = '1px';
                
                const htmlEditor = document.createElement('textarea');
                const cssLabel = document.createElement('div');
                cssLabel.innerHTML = 'CSS Code';
                cssLabel.style.marginTop = '15px';
                cssLabel.style.marginBottom = '5px';
                cssLabel.style.fontWeight = 'bold';
                cssLabel.style.color = '#10b981'; // Bright green
                cssLabel.style.fontSize = '14px';
                cssLabel.style.textTransform = 'uppercase';
                cssLabel.style.letterSpacing = '1px';

                const cssEditor = document.createElement('textarea');
                const btnImport = document.createElement('button');
                
                // Get current content to pre-fill
                htmlEditor.value = editor.getHtml();
                cssEditor.value = editor.getCss();

                // Style button
                btnImport.innerHTML = 'Import / Update Design';
                btnImport.className = 'gjs-btn-prim';
                btnImport.style.width = '100%';
                btnImport.style.marginTop = '20px';
                btnImport.style.padding = '12px';
                btnImport.style.fontSize = '16px';
                btnImport.style.fontWeight = 'bold';
                btnImport.style.background = 'linear-gradient(90deg, #3b82f6, #8b5cf6)'; // Blue to Purple gradient
                btnImport.style.border = 'none';
                btnImport.style.borderRadius = '5px';
                btnImport.style.cursor = 'pointer';
                btnImport.style.color = 'white';
                btnImport.style.boxShadow = '0 4px 6px rgba(0,0,0,0.1)';
                
                btnImport.onmouseover = function() {
                    btnImport.style.background = 'linear-gradient(90deg, #2563eb, #7c3aed)';
                };
                btnImport.onmouseout = function() {
                    btnImport.style.background = 'linear-gradient(90deg, #3b82f6, #8b5cf6)';
                };
                
                btnImport.onclick = function() {
                    // Use CodeMirror instances if available, else fallback to textarea value
                    const html = htmlEditor.cmInstance ? htmlEditor.cmInstance.getValue() : htmlEditor.value;
                    const css = cssEditor.cmInstance ? cssEditor.cmInstance.getValue() : cssEditor.value;
                    
                    if(confirm('This will replace the current design. Continue?')) {
                        editor.setComponents(html);
                        editor.setStyle(css);
                        modal.close();
                    }
                };
                
                container.appendChild(htmlLabel);
                container.appendChild(htmlEditor);
                container.appendChild(cssLabel);
                container.appendChild(cssEditor);
                container.appendChild(btnImport);
                
                modal.setTitle('<span style="color: #f59e0b; font-weight: bold; font-size: 18px;">Edit Source Code</span>');
                modal.setContent(container);
                modal.open();

                // Initialize CodeMirror
                setTimeout(() => {
                    htmlEditor.cmInstance = CodeMirror.fromTextArea(htmlEditor, {
                        mode: 'htmlmixed',
                        theme: 'monokai',
                        lineNumbers: true,
                        lineWrapping: true
                    });
                    htmlEditor.cmInstance.setSize('100%', '250px');

                    cssEditor.cmInstance = CodeMirror.fromTextArea(cssEditor, {
                        mode: 'css',
                        theme: 'monokai',
                        lineNumbers: true,
                        lineWrapping: true
                    });
                    cssEditor.cmInstance.setSize('100%', '250px');
                }, 100);
            }
        });

        // Add Save Command
        editor.Commands.add('save-db', {
            run: function(editor, sender) {
                sender && sender.set('active', 0); // turn off the button
                
                const html = editor.getHtml();
                const css = editor.getCss();

                fetch(updateUrl, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': csrfToken
                    },
                    body: JSON.stringify({
                        content: html,
                        css: css
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if(data.success) {
                        alert('Page saved successfully!');
                    } else {
                        alert('Error saving page.');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error saving page.');
                });
            }
        });

        // Add Back Command
        editor.Commands.add('back-db', {
            run: function(editor, sender) {
                window.location.href = backUrl;
            }
        });

        // Load existing CSS
        const cssString = `{!! $landingPage->css ?? '' !!}`;
        if(cssString) {
            editor.setStyle(cssString);
        }

        // Double-click to edit HTML
        editor.on('load', () => {
            const modal = editor.Modal;
            const body = editor.Canvas.getBody();
            
            body.addEventListener('dblclick', () => {
                const selected = editor.getSelected();
                if (selected) {
                    const content = selected.toHTML();
                    
                    const container = document.createElement('div');
                    const codeEditor = document.createElement('textarea');
                    const btnSave = document.createElement('button');
                    
                    // Style the textarea to look like a code editor
                    codeEditor.value = content;

                    // Style the save button
                    btnSave.innerHTML = 'Save Changes';
                    btnSave.className = 'gjs-btn-prim';
                    btnSave.style.width = '100%';
                    btnSave.style.padding = '12px';
                    btnSave.style.fontSize = '16px';
                    btnSave.style.fontWeight = 'bold';
                    btnSave.style.background = 'linear-gradient(90deg, #10b981, #3b82f6)'; // Green to Blue gradient
                    btnSave.style.border = 'none';
                    btnSave.style.borderRadius = '5px';
                    btnSave.style.cursor = 'pointer';
                    btnSave.style.color = 'white';
                    btnSave.style.marginTop = '15px';
                    btnSave.style.boxShadow = '0 4px 6px rgba(0,0,0,0.1)';

                    btnSave.onmouseover = function() {
                        btnSave.style.background = 'linear-gradient(90deg, #059669, #2563eb)';
                    };
                    btnSave.onmouseout = function() {
                        btnSave.style.background = 'linear-gradient(90deg, #10b981, #3b82f6)';
                    };
                    
                    btnSave.onclick = function() {
                        const newContent = codeEditor.cmInstance ? codeEditor.cmInstance.getValue() : codeEditor.value;
                        if(newContent) {
                            selected.replaceWith(newContent);
                            modal.close();
                        }
                    };
                    
                    container.appendChild(codeEditor);
                    container.appendChild(btnSave);
                    
                    modal.setTitle('<span style="color: #3b82f6; font-weight: bold; font-size: 18px;">Edit Component HTML</span>');
                    modal.setContent(container);
                    modal.open();

                    // Initialize CodeMirror
                    setTimeout(() => {
                        codeEditor.cmInstance = CodeMirror.fromTextArea(codeEditor, {
                            mode: 'htmlmixed',
                            theme: 'monokai',
                            lineNumbers: true,
                            lineWrapping: true
                        });
                        codeEditor.cmInstance.setSize('100%', '400px');
                    }, 100);
                }
            });
        });

    </script>
</body>
</html>