<x-admin-layout>
    <div class="p-6 bg-slate-50 min-h-screen">
        <div class="max-w-4xl mx-auto">
            
            <!-- Header -->
            <div class="flex items-center justify-between mb-6">
                <h2 class="text-xl font-bold text-slate-800 tracking-tight">Adjust Inventory</h2>
                <a href="{{ route('admin.inventory.index') }}" class="flex items-center gap-2 text-slate-600 hover:text-slate-900 font-medium transition-colors">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path></svg>
                    Back to Inventory
                </a>
            </div>

            <!-- Form Card -->
            <div class="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
                <form action="{{ route('admin.inventory.store') }}" method="POST" class="p-6 md:p-8 space-y-6">
                    @csrf
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        
                        <!-- Product Selection -->
                        <div class="col-span-2">
                            <label for="product_id" class="block text-sm font-semibold text-slate-700 mb-2">Product</label>
                            <select name="product_id" id="product_id" class="w-full rounded-lg border-slate-300 focus:border-blue-500 focus:ring-blue-500 shadow-sm" required>
                                <option value="">Select a product...</option>
                                @foreach($products as $product)
                                    <option value="{{ $product->id }}" {{ (old('product_id') == $product->id || (isset($selectedProductId) && $selectedProductId == $product->id)) ? 'selected' : '' }}>
                                        {{ $product->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('product_id')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Type -->
                        <div>
                            <label class="block text-sm font-semibold text-slate-700 mb-2">Adjustment Type</label>
                            <div class="flex gap-4">
                                <label class="flex-1 relative cursor-pointer group">
                                    <input type="radio" name="type" value="in" class="peer sr-only" {{ old('type') == 'in' ? 'checked' : '' }} required>
                                    <div class="p-4 rounded-xl border border-slate-200 peer-checked:border-emerald-500 peer-checked:bg-emerald-50 hover:bg-slate-50 transition-all flex items-center justify-center gap-2">
                                        <div class="w-8 h-8 rounded-full bg-emerald-100 text-emerald-600 flex items-center justify-center">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path></svg>
                                        </div>
                                        <span class="font-medium text-slate-700 peer-checked:text-emerald-700">Stock In (Add)</span>
                                    </div>
                                </label>
                                
                                <label class="flex-1 relative cursor-pointer group">
                                    <input type="radio" name="type" value="out" class="peer sr-only" {{ old('type') == 'out' ? 'checked' : '' }}>
                                    <div class="p-4 rounded-xl border border-slate-200 peer-checked:border-red-500 peer-checked:bg-red-50 hover:bg-slate-50 transition-all flex items-center justify-center gap-2">
                                        <div class="w-8 h-8 rounded-full bg-red-100 text-red-600 flex items-center justify-center">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 12H4"></path></svg>
                                        </div>
                                        <span class="font-medium text-slate-700 peer-checked:text-red-700">Stock Out (Remove)</span>
                                    </div>
                                </label>
                            </div>
                            @error('type')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Quantity -->
                        <div>
                            <label for="quantity" class="block text-sm font-semibold text-slate-700 mb-2">Quantity</label>
                            <input type="number" name="quantity" id="quantity" min="1" value="{{ old('quantity') }}" class="w-full rounded-lg border-slate-300 focus:border-blue-500 focus:ring-blue-500 shadow-sm" placeholder="Enter quantity" required>
                            @error('quantity')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Reason -->
                        <div class="col-span-2">
                            <label for="reason" class="block text-sm font-semibold text-slate-700 mb-2">Reason (Optional)</label>
                            <textarea name="reason" id="reason" rows="3" class="w-full rounded-lg border-slate-300 focus:border-blue-500 focus:ring-blue-500 shadow-sm" placeholder="e.g. Returned goods, Damage, Correction...">{{ old('reason') }}</textarea>
                            @error('reason')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                    </div>

                    <!-- Footer -->
                    <div class="pt-6 border-t border-slate-100 flex items-center justify-end gap-3">
                        <a href="{{ route('admin.inventory.index') }}" class="px-5 py-2.5 rounded-xl text-sm font-semibold text-slate-600 hover:text-slate-800 hover:bg-slate-100 transition-colors">
                            Cancel
                        </a>
                        <button type="submit" class="bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 text-white px-8 py-2.5 rounded-xl font-semibold text-sm shadow-md hover:shadow-lg transform hover:-translate-y-0.5 transition-all duration-200">
                            Save Adjustment
                        </button>
                    </div>

                </form>
            </div>
        </div>
    </div>
</x-admin-layout>