<x-admin-layout>
    <style>
        @keyframes slideInUp {
            from {
                transform: translateY(20px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
        .animate-slide-up {
            animation: slideInUp 0.5s ease-out forwards;
        }
        .delay-100 { animation-delay: 0.1s; }
        .delay-200 { animation-delay: 0.2s; }
        .delay-300 { animation-delay: 0.3s; }
        .delay-400 { animation-delay: 0.4s; }
        .delay-500 { animation-delay: 0.5s; }
        .delay-600 { animation-delay: 0.6s; }
    </style>

    <div class="py-6 bg-gradient-to-br from-gray-50 to-blue-50 min-h-screen">
        <div class="w-full mx-auto sm:px-6 lg:px-8">
            
            <!-- Date Filter & Title Section -->
            <div class="mb-4 flex flex-col sm:flex-row sm:items-center justify-between gap-4 bg-white/80 backdrop-blur-md p-4 rounded-2xl shadow-lg border border-white/50 animate-slide-up">
                <!-- Orders Overview Title -->
                <h2 class="font-bold text-2xl text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-purple-600 leading-tight">
                    {{ __('Orders Overview') }}
                </h2>

                <!-- Date Filter Form -->
                <form method="GET" action="{{ route('admin.dashboard') }}" class="flex flex-col sm:flex-row sm:items-end gap-4 w-full sm:w-auto" id="dashboard-filter-form">
                    <div class="w-full sm:w-64">
                        <label class="block text-sm font-semibold text-gray-700 mb-1">Date Range</label>
                        <x-date-range-picker 
                            startDate="{{ $startDate }}" 
                            endDate="{{ $endDate }}" 
                            formId="dashboard-filter-form"
                        />
                    </div>
                    <div class="flex gap-2 w-full sm:w-auto">
                        <a href="{{ route('admin.dashboard') }}" 
                           class="w-full sm:w-auto justify-center bg-white text-gray-700 border border-gray-300 px-5 py-2.5 rounded-lg hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500 text-sm font-semibold shadow-sm transform hover:-translate-y-0.5 transition-all duration-200 text-center flex items-center">
                            Reset
                        </a>
                    </div>
                </form>
            </div>

            <!-- Orders Overview Grid -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 mb-6">
                
                <!-- All Orders -->
                <div class="bg-gradient-to-r from-blue-500 to-blue-600 rounded-2xl shadow-lg p-5 flex items-center space-x-4 transform hover:scale-105 transition-all duration-300 hover:shadow-2xl animate-slide-up delay-100 group cursor-pointer border border-blue-400">
                    <div class="p-3 rounded-full bg-white/20 text-white backdrop-blur-sm shadow-inner">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                        </svg>
                    </div>
                    <div class="text-white">
                        <p class="text-blue-100 text-sm font-bold uppercase tracking-wide">All Orders</p>
                        <h3 class="text-2xl font-extrabold mt-1">TK {{ number_format($allOrdersValue, 2) }}</h3>
                        <div class="flex flex-wrap items-center gap-2 mt-2">
                            <p class="text-xs text-white font-bold bg-white/20 px-2 py-0.5 rounded-full inline-block shadow-sm">Qty: {{ $allOrdersCount }}</p>
                            
                            <!-- Monthly Growth Signal -->
                            <div class="flex items-center text-xs font-bold bg-white/20 px-2 py-0.5 rounded-full shadow-sm" title="Earnings vs Last Month">
                                @if($earningsPercentage >= 0)
                                    <span class="text-green-300 mr-1">▲</span>
                                    <span class="text-green-100">+{{ number_format($earningsPercentage, 1) }}%</span>
                                @else
                                    <span class="text-red-300 mr-1">▼</span>
                                    <span class="text-red-100">{{ number_format($earningsPercentage, 1) }}%</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Cancelled Order Value -->
                <div class="bg-gradient-to-r from-red-500 to-red-600 rounded-2xl shadow-lg p-5 flex items-center space-x-4 transform hover:scale-105 transition-all duration-300 hover:shadow-2xl animate-slide-up delay-200 group cursor-pointer border border-red-400">
                    <div class="p-3 rounded-full bg-white/20 text-white backdrop-blur-sm shadow-inner">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </div>
                    <div class="text-white">
                        <p class="text-red-100 text-sm font-bold uppercase tracking-wide">Cancelled</p>
                        <h3 class="text-2xl font-extrabold mt-1">TK {{ number_format($cancelledOrdersValue, 2) }}</h3>
                        <p class="text-xs text-white font-bold mt-1 bg-white/20 px-2 py-0.5 rounded-full inline-block shadow-sm">Qty: {{ $cancelledOrdersCount }}</p>
                    </div>
                </div>

                <!-- Delivered Order Value -->
                <div class="bg-gradient-to-r from-green-500 to-green-600 rounded-2xl shadow-lg p-5 flex items-center space-x-4 transform hover:scale-105 transition-all duration-300 hover:shadow-2xl animate-slide-up delay-300 group cursor-pointer border border-green-400">
                    <div class="p-3 rounded-full bg-white/20 text-white backdrop-blur-sm shadow-inner">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                    </div>
                    <div class="text-white">
                        <p class="text-green-100 text-sm font-bold uppercase tracking-wide">Delivered</p>
                        <h3 class="text-2xl font-extrabold mt-1">TK {{ number_format($deliveredOrdersValue, 2) }}</h3>
                        <p class="text-xs text-white font-bold mt-1 bg-white/20 px-2 py-0.5 rounded-full inline-block shadow-sm">Qty: {{ $deliveredOrdersCount }}</p>
                    </div>
                </div>

                <!-- Return Order Value -->
                <div class="bg-gradient-to-r from-yellow-500 to-orange-500 rounded-2xl shadow-lg p-5 flex items-center space-x-4 transform hover:scale-105 transition-all duration-300 hover:shadow-2xl animate-slide-up delay-400 group cursor-pointer border border-yellow-400">
                    <div class="p-3 rounded-full bg-white/20 text-white backdrop-blur-sm shadow-inner">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6"></path>
                        </svg>
                    </div>
                    <div class="text-white">
                        <p class="text-yellow-100 text-sm font-bold uppercase tracking-wide">Returned</p>
                        <h3 class="text-2xl font-extrabold mt-1">TK {{ number_format($returnedOrdersValue, 2) }}</h3>
                        <p class="text-xs text-white font-bold mt-1 bg-white/20 px-2 py-0.5 rounded-full inline-block shadow-sm">Qty: {{ $returnedOrdersCount }}</p>
                    </div>
                </div>

                <!-- Hold Order Value -->
                <div class="bg-gradient-to-r from-purple-500 to-purple-600 rounded-2xl shadow-lg p-5 flex items-center space-x-4 transform hover:scale-105 transition-all duration-300 hover:shadow-2xl animate-slide-up delay-500 group cursor-pointer border border-purple-400">
                    <div class="p-3 rounded-full bg-white/20 text-white backdrop-blur-sm shadow-inner">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 9v6m4-6v6m7-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div class="text-white">
                        <p class="text-purple-100 text-sm font-bold uppercase tracking-wide">On Hold</p>
                        <h3 class="text-2xl font-extrabold mt-1">TK {{ number_format($holdOrdersValue, 2) }}</h3>
                        <p class="text-xs text-white font-bold mt-1 bg-white/20 px-2 py-0.5 rounded-full inline-block shadow-sm">Qty: {{ $holdOrdersCount }}</p>
                    </div>
                </div>

                <!-- Confirmed Order Value -->
                <div class="bg-gradient-to-r from-cyan-500 to-blue-500 rounded-2xl shadow-lg p-5 flex items-center space-x-4 transform hover:scale-105 transition-all duration-300 hover:shadow-2xl animate-slide-up delay-600 group cursor-pointer border border-cyan-400">
                    <div class="p-3 rounded-full bg-white/20 text-white backdrop-blur-sm shadow-inner">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div class="text-white">
                        <p class="text-cyan-100 text-sm font-bold uppercase tracking-wide">Confirmed</p>
                        <h3 class="text-2xl font-extrabold mt-1">TK {{ number_format($confirmedOrdersValue, 2) }}</h3>
                        <p class="text-xs text-white font-bold mt-1 bg-white/20 px-2 py-0.5 rounded-full inline-block shadow-sm">Qty: {{ $confirmedOrdersCount }}</p>
                    </div>
                </div>

                <!-- Profit & Loss Section (New) -->
                <div class="col-span-1 md:col-span-2 lg:col-span-3 mt-6">
                    <h2 class="font-bold text-xl text-gray-800 mb-4 flex items-center">
                        <svg class="w-6 h-6 mr-2 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                        Profit / Loss Analysis
                    </h2>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <!-- Total Revenue -->
                        <div class="bg-white rounded-xl shadow p-4 border-l-4 border-blue-500">
                            <p class="text-gray-500 text-sm uppercase font-semibold">Total Revenue</p>
                            <h3 class="text-2xl font-bold text-gray-800">TK {{ number_format($revenue, 2) }}</h3>
                            <p class="text-xs text-gray-400 mt-1">Delivered + Confirmed + Processing</p>
                        </div>
                        
                        <!-- Product Cost -->
                        <div class="bg-white rounded-xl shadow p-4 border-l-4 border-red-500">
                            <p class="text-gray-500 text-sm uppercase font-semibold">Total Cost</p>
                            <h3 class="text-2xl font-bold text-gray-800">TK {{ number_format($productCosts, 2) }}</h3>
                            <p class="text-xs text-gray-400 mt-1">Purchase Price of Sold Items</p>
                        </div>

                        <!-- Net Profit -->
                        <div class="bg-white rounded-xl shadow p-4 border-l-4 {{ $profit >= 0 ? 'border-green-500' : 'border-red-500' }}">
                            <p class="text-gray-500 text-sm uppercase font-semibold">Net Profit</p>
                            <h3 class="text-2xl font-bold {{ $profit >= 0 ? 'text-green-600' : 'text-red-600' }}">TK {{ number_format($profit, 2) }}</h3>
                            <p class="text-xs text-gray-400 mt-1">Revenue - Cost</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Charts Section -->
            <div class="mb-10">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                    <!-- Orders Chart -->
                    <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
                        <h3 class="text-xl font-bold text-gray-800 mb-4">Last 30 Days Orders</h3>
                        <div class="relative h-64 w-full">
                            <canvas id="ordersChart"></canvas>
                        </div>
                    </div>

                    <!-- Earnings Chart -->
                    <div class="bg-white rounded-2xl shadow-lg p-6 border border-gray-100">
                        <h3 class="text-xl font-bold text-gray-800 mb-4">Last 30 Days Earnings</h3>
                        <div class="relative h-64 w-full">
                            <canvas id="earningsChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Chart.js CDN -->
            <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    const labels = @json($chartLabels);
                    const orderData = @json($chartOrderData);
                    const earningData = @json($chartEarningData);

                    // Orders Chart
                    new Chart(document.getElementById('ordersChart'), {
                        type: 'line',
                        data: {
                            labels: labels,
                            datasets: [{
                                label: 'Orders',
                                data: orderData,
                                borderColor: 'rgb(59, 130, 246)', // Blue-500
                                backgroundColor: 'rgba(59, 130, 246, 0.1)',
                                borderWidth: 2,
                                fill: true,
                                tension: 0.4
                            }]
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            plugins: {
                                legend: {
                                    display: false
                                }
                            },
                            scales: {
                                y: {
                                    beginAtZero: true,
                                    ticks: {
                                        precision: 0
                                    }
                                }
                            }
                        }
                    });

                    // Earnings Chart
                    new Chart(document.getElementById('earningsChart'), {
                        type: 'bar',
                        data: {
                            labels: labels,
                            datasets: [{
                                label: 'Earnings (TK)',
                                data: earningData,
                                backgroundColor: 'rgb(16, 185, 129)', // Green-500
                                borderRadius: 4
                            }]
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            plugins: {
                                legend: {
                                    display: false
                                }
                            },
                            scales: {
                                y: {
                                    beginAtZero: true
                                }
                            }
                        }
                    });
                });
            </script>

            <!-- Top Employees -->
            <div class="mb-10 animate-slide-up delay-400">
                <h3 class="text-2xl font-bold text-gray-800 text-center mb-6 relative">
                    Top Employees
                    <span class="block w-20 h-1 bg-gradient-to-r from-purple-500 to-pink-500 mx-auto mt-2 rounded-full"></span>
                </h3>
                <div class="bg-white rounded-2xl shadow-lg overflow-hidden border border-gray-100">
                    <div class="p-4 sm:p-6">
                        <div class="overflow-x-auto pb-2">
                            <table class="w-full text-sm text-left text-gray-500 whitespace-nowrap">
                                <thead class="text-xs text-white uppercase bg-gradient-to-r from-purple-600 to-pink-600 border-b border-gray-100">
                                    <tr>
                                        <th scope="col" class="px-6 py-4 font-bold rounded-tl-lg">EmployeeID</th>
                                        <th scope="col" class="px-6 py-4 font-bold">Name</th>
                                        <th scope="col" class="px-6 py-4 font-bold">All</th>
                                        <th scope="col" class="px-6 py-4 font-bold">Paid</th>
                                        <th scope="col" class="px-6 py-4 font-bold">Confirm</th>
                                        <th scope="col" class="px-6 py-4 font-bold">Confirmed</th>
                                        <th scope="col" class="px-6 py-4 font-bold">Ready</th>
                                        <th scope="col" class="px-6 py-4 font-bold">Cancelled</th>
                                        <th scope="col" class="px-6 py-4 font-bold">Hold</th>
                                        <th scope="col" class="px-6 py-4 font-bold">Ship Later</th>
                                        <th scope="col" class="px-6 py-4 font-bold rounded-tr-lg">On Hold</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr class="bg-white border-b border-gray-50 hover:bg-purple-50 transition-colors duration-200">
                                        <td class="px-6 py-4 font-medium">#EMP001</td>
                                        <td class="px-6 py-4 flex items-center">
                                            <div class="w-8 h-8 rounded-full bg-gradient-to-tr from-purple-500 to-pink-500 text-white flex items-center justify-center font-bold mr-3 shadow-md ring-2 ring-white">SA</div>
                                            <span class="font-semibold text-gray-800">Super Admin</span>
                                        </td>
                                        <td class="px-6 py-4 text-center"><span class="bg-purple-100 text-purple-700 px-2 py-1 rounded font-bold">0</span></td>
                                        <td class="px-6 py-4 text-center text-gray-400">-</td>
                                        <td class="px-6 py-4 text-center text-gray-400">-</td>
                                        <td class="px-6 py-4 text-center text-gray-400">-</td>
                                        <td class="px-6 py-4 text-center text-gray-400">-</td>
                                        <td class="px-6 py-4 text-center text-gray-400">-</td>
                                        <td class="px-6 py-4 text-center text-gray-400">-</td>
                                        <td class="px-6 py-4 text-center text-gray-400">-</td>
                                        <td class="px-6 py-4 text-center text-gray-400">-</td>
                                    </tr>
                                     <tr class="bg-white hover:bg-gray-50 text-center">
                                        <td colspan="11" class="px-6 py-8 text-gray-400 italic">
                                           More employees will appear here...
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Product Reports -->
            <div class="mb-10 animate-slide-up delay-500">
                <h3 class="text-2xl font-bold text-gray-800 text-center mb-6 relative">
                    Product Reports
                    <span class="block w-20 h-1 bg-gradient-to-r from-green-500 to-teal-500 mx-auto mt-2 rounded-full"></span>
                </h3>
                <div class="bg-white rounded-2xl shadow-lg overflow-hidden border border-gray-100">
                    <div class="p-4 sm:p-6">
                        <div class="overflow-x-auto pb-2">
                            <table class="w-full text-sm text-left whitespace-nowrap">
                                <thead class="text-xs text-white uppercase bg-gradient-to-r from-gray-800 to-gray-900 border-b border-gray-200">
                                <tr>
                                    <th scope="col" class="px-6 py-4 text-center font-extrabold tracking-wider rounded-tl-lg">#</th>
                                    <th scope="col" class="px-6 py-4 font-extrabold tracking-wider">Image</th>
                                    <th scope="col" class="px-6 py-4 font-extrabold tracking-wider">Name</th>
                                    <th scope="col" class="px-6 py-4 text-center font-extrabold tracking-wider">Total Order</th>
                                    <th scope="col" class="px-6 py-4 text-center font-extrabold tracking-wider">Total Value</th>
                                    <th scope="col" class="px-6 py-4 text-center font-extrabold tracking-wider">Cancelled</th>
                                    <th scope="col" class="px-6 py-4 text-center font-extrabold tracking-wider rounded-tr-lg">Pendings</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100">
                                @forelse($productReports as $product)
                                    <tr class="bg-white hover:bg-blue-50 transition-colors duration-200 group">
                                        <td class="px-6 py-4 text-center font-medium text-gray-500 group-hover:text-blue-600">{{ $loop->iteration }}</td>
                                        <td class="px-6 py-4">
                                            <div class="relative w-12 h-12 rounded-lg overflow-hidden shadow-sm group-hover:shadow-md transition-all ring-2 ring-gray-100 group-hover:ring-blue-200">
                                                @if($product->thumbnail)
                                                    <img src="{{ asset('storage/' . $product->thumbnail) }}" alt="{{ $product->name }}" class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-500">
                                                @else
                                                    <div class="w-full h-full bg-gray-100 flex items-center justify-center text-gray-400 text-xs font-bold">IMG</div>
                                                @endif
                                            </div>
                                        </td>
                                        <td class="px-6 py-4 font-medium text-gray-800 group-hover:text-blue-600 transition-colors">
                                            {{ Str::limit($product->name, 40) }}
                                        </td>
                                        <td class="px-6 py-4 text-center">
                                            <span class="bg-purple-100 text-purple-700 px-3 py-1 rounded-full font-bold shadow-sm ring-1 ring-purple-200">{{ $product->total_orders }}</span>
                                        </td>
                                        <td class="px-6 py-4 text-center">
                                            <span class="bg-green-100 text-green-700 px-3 py-1 rounded-full font-bold shadow-sm ring-1 ring-green-200">{{ number_format($product->total_order_value ?? 0, 0) }} TK</span>
                                        </td>
                                        <td class="px-6 py-4 text-center">
                                            <span class="bg-red-100 text-red-700 px-3 py-1 rounded-full font-bold shadow-sm ring-1 ring-red-200">{{ $product->cancelled_orders }}</span>
                                        </td>
                                        <td class="px-6 py-4 text-center">
                                            <span class="bg-cyan-100 text-cyan-700 px-3 py-1 rounded-full font-bold shadow-sm ring-1 ring-cyan-200">{{ $product->pending_orders }}</span>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="px-6 py-12 text-center">
                                            <div class="flex flex-col items-center justify-center text-gray-400">
                                                <svg class="w-16 h-16 mb-4 opacity-30" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path></svg>
                                                <span class="text-lg font-medium">No products found for this period</span>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</x-admin-layout>