<x-admin-layout>
    <form action="{{ route('admin.categories.update', $category->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        
        <!-- Top Action Buttons -->
        <div class="fixed top-20 right-8 z-10 flex gap-4">
            <a href="{{ route('admin.categories.index', ['type' => $type]) }}" 
               class="bg-cyan-500 hover:bg-cyan-600 text-white font-medium py-2 px-6 rounded shadow transition-colors">
                Back
            </a>
            <button type="submit" 
                    class="bg-emerald-500 hover:bg-emerald-600 text-white font-medium py-2 px-6 rounded shadow transition-colors">
                Update
            </button>
        </div>

        <div class="py-12">
            <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-8">
                    
                    <div class="space-y-8">
                        <!-- Name -->
                        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-center">
                            <label for="name" class="block text-gray-700 font-medium">
                                Name <span class="text-red-500">*</span>
                            </label>
                            <div class="md:col-span-3">
                                <input type="text" name="name" id="name" 
                                       value="{{ old('name', $category->name) }}"
                                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" 
                                       placeholder="category name" required>
                                @error('name')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <!-- Choose Parent -->
                        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-center">
                            <label for="parent_id" class="block text-gray-700 font-medium">
                                Choose Parent <span class="text-red-500">*</span>
                            </label>
                            <div class="md:col-span-3">
                                <select name="parent_id" id="parent_id" 
                                        class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                    <option value="">None</option>
                                    @foreach($parents as $parent)
                                        <option value="{{ $parent->id }}" {{ (old('parent_id', $category->parent_id) == $parent->id) ? 'selected' : '' }}>
                                            {{ $parent->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('parent_id')
                                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <!-- Category Image -->
                        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-start">
                            <label class="block text-gray-700 font-medium pt-2">
                                Category Image <span class="text-gray-400 text-sm font-normal">(size 600/600)</span>
                            </label>
                            <div class="md:col-span-3 flex items-center gap-4">
                                <div class="flex-1 relative border-2 border-dashed border-gray-300 rounded-lg p-8 text-center hover:bg-gray-50 transition-colors cursor-pointer"
                                     onclick="document.getElementById('image').click()">
                                    <input type="file" name="image" id="image" class="hidden" accept="image/*" onchange="previewImage(this, 'image-preview')">
                                    <div class="space-y-2">
                                        <svg class="mx-auto h-8 w-8 text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                                        </svg>
                                        <div class="text-orange-400 font-medium">Click or Drag & Drop Your Image Here</div>
                                    </div>
                                </div>
                                <div class="w-24 h-24 flex items-center justify-center text-gray-400 text-center text-xs border rounded bg-gray-50" id="image-preview-container">
                                    @if($category->image)
                                        <img id="image-preview" src="{{ asset('storage/' . $category->image) }}" alt="Preview" class="w-full h-full object-cover rounded">
                                        <span id="image-placeholder" class="hidden">No file uploaded</span>
                                    @else
                                        <img id="image-preview" src="#" alt="Preview" class="hidden w-full h-full object-cover rounded">
                                        <span id="image-placeholder">No file uploaded</span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- Banner Image -->
                        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-start">
                            <label class="block text-gray-700 font-medium pt-2">
                                Banner Image <span class="text-gray-400 text-sm font-normal">(size 1400/500)</span>
                            </label>
                            <div class="md:col-span-3 flex items-center gap-4">
                                <div class="flex-1 relative border-2 border-dashed border-gray-300 rounded-lg p-8 text-center hover:bg-gray-50 transition-colors cursor-pointer"
                                     onclick="document.getElementById('banner_image').click()">
                                    <input type="file" name="banner_image" id="banner_image" class="hidden" accept="image/*" onchange="previewImage(this, 'banner-preview')">
                                    <div class="space-y-2">
                                        <svg class="mx-auto h-8 w-8 text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                                        </svg>
                                        <div class="text-orange-400 font-medium">Click or Drag & Drop Your Image Here</div>
                                    </div>
                                </div>
                                <div class="w-24 h-24 flex items-center justify-center text-gray-400 text-center text-xs border rounded bg-gray-50" id="banner-preview-container">
                                    @if($category->banner_image)
                                        <img id="banner-preview" src="{{ asset('storage/' . $category->banner_image) }}" alt="Preview" class="w-full h-full object-cover rounded">
                                        <span id="banner-placeholder" class="hidden">No file uploaded</span>
                                    @else
                                        <img id="banner-preview" src="#" alt="Preview" class="hidden w-full h-full object-cover rounded">
                                        <span id="banner-placeholder">No file uploaded</span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- Banner Image For Home Page -->
                        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-start">
                            <label class="block text-gray-700 font-medium pt-2">
                                Banner Image For Home Page <span class="text-gray-400 text-sm font-normal">(size 2600/250)</span>
                            </label>
                            <div class="md:col-span-3 flex items-center gap-4">
                                <div class="flex-1 relative border-2 border-dashed border-gray-300 rounded-lg p-8 text-center hover:bg-gray-50 transition-colors cursor-pointer"
                                     onclick="document.getElementById('home_banner_image').click()">
                                    <input type="file" name="home_banner_image" id="home_banner_image" class="hidden" accept="image/*" onchange="previewImage(this, 'home-banner-preview')">
                                    <div class="space-y-2">
                                        <svg class="mx-auto h-8 w-8 text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"></path>
                                        </svg>
                                        <div class="text-orange-400 font-medium">Click or Drag & Drop Your Image Here</div>
                                    </div>
                                </div>
                                <div class="w-24 h-24 flex items-center justify-center text-gray-400 text-center text-xs border rounded bg-gray-50" id="home-banner-preview-container">
                                    @if($category->home_banner_image)
                                        <img id="home-banner-preview" src="{{ asset('storage/' . $category->home_banner_image) }}" alt="Preview" class="w-full h-full object-cover rounded">
                                        <span id="home-banner-placeholder" class="hidden">No file uploaded</span>
                                    @else
                                        <img id="home-banner-preview" src="#" alt="Preview" class="hidden w-full h-full object-cover rounded">
                                        <span id="home-banner-placeholder">No file uploaded</span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- Category Meta Title -->
                        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-center">
                            <label for="meta_title" class="block text-gray-700 font-medium">
                                Category Meta Title
                            </label>
                            <div class="md:col-span-3">
                                <input type="text" name="meta_title" id="meta_title" 
                                       value="{{ old('meta_title', $category->meta_title) }}"
                                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" 
                                       placeholder="Meta Title">
                            </div>
                        </div>

                        <!-- Category Meta Keywords -->
                        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-center">
                            <label for="meta_keywords" class="block text-gray-700 font-medium">
                                Category Meta keywords
                            </label>
                            <div class="md:col-span-3">
                                <input type="text" name="meta_keywords" id="meta_keywords" 
                                       value="{{ old('meta_keywords', $category->meta_keywords) }}"
                                       class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" 
                                       placeholder="Meta Keywords">
                            </div>
                        </div>

                        <!-- Category Meta Description -->
                        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-start">
                            <label for="meta_description" class="block text-gray-700 font-medium pt-2">
                                Category Meta Description
                            </label>
                            <div class="md:col-span-3">
                                <textarea name="meta_description" id="meta_description" rows="4" 
                                          class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" 
                                          placeholder="Meta Desc">{{ old('meta_description', $category->meta_description) }}</textarea>
                            </div>
                        </div>

                        <!-- Status -->
                        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-center">
                            <label for="status" class="block text-gray-700 font-medium">Status</label>
                            <div class="md:col-span-3">
                                <select name="status" id="status" 
                                        class="w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                    <option value="1" {{ old('status', $category->status) == 1 ? 'selected' : '' }}>Active</option>
                                    <option value="0" {{ old('status', $category->status) == 0 ? 'selected' : '' }}>Inactive</option>
                                </select>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </form>

    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            const placeholder = document.getElementById(previewId.replace('preview', 'placeholder'));
            
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                
                reader.onload = function(e) {
                    preview.src = e.target.result;
                    preview.classList.remove('hidden');
                    placeholder.classList.add('hidden');
                }
                
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>
</x-admin-layout>